/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.DensityFunctions;
import net.minecraft.world.level.levelgen.GeneratorSettingBase;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.NoiseRouter;
import net.minecraft.world.level.levelgen.Noises;
import net.minecraft.world.level.levelgen.PositionalRandomFactory;
import net.minecraft.world.level.levelgen.SurfaceSystem;
import net.minecraft.world.level.levelgen.synth.BlendedNoise;
import net.minecraft.world.level.levelgen.synth.NoiseGeneratorNormal;

public final class RandomState {
    final PositionalRandomFactory a;
    private final HolderGetter<NoiseGeneratorNormal.a> b;
    private final NoiseRouter c;
    private final Climate.Sampler d;
    private final SurfaceSystem e;
    private final PositionalRandomFactory f;
    private final PositionalRandomFactory g;
    private final Map<ResourceKey<NoiseGeneratorNormal.a>, NoiseGeneratorNormal> h;
    private final Map<MinecraftKey, PositionalRandomFactory> i;

    public static RandomState a(HolderGetter.a registryLookup, ResourceKey<GeneratorSettingBase> chunkGeneratorSettingsKey, long legacyWorldSeed) {
        return RandomState.a(registryLookup.b(Registries.aR).b(chunkGeneratorSettingsKey).a(), registryLookup.b(Registries.aS), legacyWorldSeed);
    }

    public static RandomState a(GeneratorSettingBase chunkGeneratorSettings, HolderGetter<NoiseGeneratorNormal.a> noiseParametersLookup, long legacyWorldSeed) {
        return new RandomState(chunkGeneratorSettings, noiseParametersLookup, legacyWorldSeed);
    }

    private RandomState(GeneratorSettingBase chunkGeneratorSettings, HolderGetter<NoiseGeneratorNormal.a> noiseParametersLookup, final long seed) {
        this.a = chunkGeneratorSettings.d().a(seed).e();
        this.b = noiseParametersLookup;
        this.f = this.a.a(MinecraftKey.b("aquifer")).e();
        this.g = this.a.a(MinecraftKey.b("ore")).e();
        this.h = new ConcurrentHashMap<ResourceKey<NoiseGeneratorNormal.a>, NoiseGeneratorNormal>();
        this.i = new ConcurrentHashMap<MinecraftKey, PositionalRandomFactory>();
        this.e = new SurfaceSystem(this, chunkGeneratorSettings.g(), chunkGeneratorSettings.l(), this.a);
        final boolean bl = chunkGeneratorSettings.n();
        class A
        implements DensityFunction.f {
            private final Map<DensityFunction, DensityFunction> d = new HashMap<DensityFunction, DensityFunction>();

            A() {
            }

            private RandomSource a(long seed2) {
                return new LegacyRandomSource(seed + seed2);
            }

            @Override
            @Override
            public DensityFunction.c a(DensityFunction.c noiseDensityFunction) {
                Holder<NoiseGeneratorNormal.a> holder = noiseDensityFunction.b();
                if (bl) {
                    if (holder.a(Noises.a)) {
                        NoiseGeneratorNormal normalNoise = NoiseGeneratorNormal.a(this.a(0L), new NoiseGeneratorNormal.a(-7, 1.0, 1.0));
                        return new DensityFunction.c(holder, normalNoise);
                    }
                    if (holder.a(Noises.b)) {
                        NoiseGeneratorNormal normalNoise2 = NoiseGeneratorNormal.a(this.a(1L), new NoiseGeneratorNormal.a(-7, 1.0, 1.0));
                        return new DensityFunction.c(holder, normalNoise2);
                    }
                    if (holder.a(Noises.j)) {
                        NoiseGeneratorNormal normalNoise3 = NoiseGeneratorNormal.b(RandomState.this.a.a(Noises.j.a()), new NoiseGeneratorNormal.a(0, 0.0, new double[0]));
                        return new DensityFunction.c(holder, normalNoise3);
                    }
                }
                NoiseGeneratorNormal normalNoise4 = RandomState.this.a(holder.e().orElseThrow());
                return new DensityFunction.c(holder, normalNoise4);
            }

            private DensityFunction a(DensityFunction densityFunction) {
                if (densityFunction instanceof BlendedNoise) {
                    BlendedNoise blendedNoise = (BlendedNoise)densityFunction;
                    RandomSource randomSource = bl ? this.a(0L) : RandomState.this.a.a(MinecraftKey.b("terrain"));
                    return blendedNoise.a(randomSource);
                }
                if (densityFunction instanceof DensityFunctions.i) {
                    return new DensityFunctions.i(seed);
                }
                return densityFunction;
            }

            @Override
            @Override
            public DensityFunction apply(DensityFunction densityFunction) {
                return this.d.computeIfAbsent(densityFunction, this::a);
            }
        }
        this.c = chunkGeneratorSettings.i().a(new A());
        DensityFunction.f visitor = new DensityFunction.f(this){
            private final Map<DensityFunction, DensityFunction> a = new HashMap<DensityFunction, DensityFunction>();

            private DensityFunction a(DensityFunction densityFunction) {
                if (densityFunction instanceof DensityFunctions.j) {
                    DensityFunctions.j holderHolder = (DensityFunctions.j)densityFunction;
                    return holderHolder.j().a();
                }
                if (densityFunction instanceof DensityFunctions.l) {
                    DensityFunctions.l marker = (DensityFunctions.l)densityFunction;
                    return marker.k();
                }
                return densityFunction;
            }

            @Override
            @Override
            public DensityFunction apply(DensityFunction densityFunction) {
                return this.a.computeIfAbsent(densityFunction, this::a);
            }
        };
        this.d = new Climate.Sampler(this.c.e().a(visitor), this.c.f().a(visitor), this.c.g().a(visitor), this.c.h().a(visitor), this.c.i().a(visitor), this.c.j().a(visitor), chunkGeneratorSettings.k());
    }

    public NoiseGeneratorNormal a(ResourceKey<NoiseGeneratorNormal.a> noiseParametersKey) {
        return this.h.computeIfAbsent(noiseParametersKey, key -> Noises.a(this.b, this.a, noiseParametersKey));
    }

    public PositionalRandomFactory a(MinecraftKey id) {
        return this.i.computeIfAbsent(id, id2 -> this.a.a(id).e());
    }

    public NoiseRouter a() {
        return this.c;
    }

    public Climate.Sampler b() {
        return this.d;
    }

    public SurfaceSystem c() {
        return this.e;
    }

    public PositionalRandomFactory d() {
        return this.f;
    }

    public PositionalRandomFactory e() {
        return this.g;
    }
}

