/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.NoiseChunk;
import net.minecraft.world.level.levelgen.PositionalRandomFactory;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.SurfaceSystem;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.placement.CaveSurface;
import net.minecraft.world.level.levelgen.synth.NoiseGeneratorNormal;

public class SurfaceRules {
    public static final f a = SurfaceRules.a(0, false, CaveSurface.b);
    public static final f b = SurfaceRules.a(0, true, CaveSurface.b);
    public static final f c = SurfaceRules.a(0, true, 6, CaveSurface.b);
    public static final f d = SurfaceRules.a(0, true, 30, CaveSurface.b);
    public static final f e = SurfaceRules.a(0, false, CaveSurface.a);
    public static final f f = SurfaceRules.a(0, true, CaveSurface.a);

    public static f a(int offset, boolean addSurfaceDepth, CaveSurface verticalSurfaceType) {
        return new t(offset, addSurfaceDepth, 0, verticalSurfaceType);
    }

    public static f a(int offset, boolean addSurfaceDepth, int secondaryDepthRange, CaveSurface verticalSurfaceType) {
        return new t(offset, addSurfaceDepth, secondaryDepthRange, verticalSurfaceType);
    }

    public static f a(f target) {
        return new n(target);
    }

    public static f a(VerticalAnchor anchor, int runDepthMultiplier) {
        return new aa(anchor, runDepthMultiplier, false);
    }

    public static f b(VerticalAnchor anchor, int runDepthMultiplier) {
        return new aa(anchor, runDepthMultiplier, true);
    }

    public static f a(int offset, int runDepthMultiplier) {
        return new z(offset, runDepthMultiplier, false);
    }

    public static f b(int offset, int runDepthMultiplier) {
        return new z(offset, runDepthMultiplier, true);
    }

    @SafeVarargs
    public static f a(ResourceKey<BiomeBase> ... biomes) {
        return SurfaceRules.a(List.of(biomes));
    }

    private static c a(List<ResourceKey<BiomeBase>> biomes) {
        return new c(biomes);
    }

    public static f a(ResourceKey<NoiseGeneratorNormal.a> noise, double min) {
        return SurfaceRules.a(noise, min, Double.MAX_VALUE);
    }

    public static f a(ResourceKey<NoiseGeneratorNormal.a> noise, double min, double max) {
        return new l(noise, min, max);
    }

    public static f a(String id, VerticalAnchor trueAtAndBelow, VerticalAnchor falseAtAndAbove) {
        return new y(MinecraftKey.a(id), trueAtAndBelow, falseAtAndAbove);
    }

    public static f a() {
        return s.a;
    }

    public static f b() {
        return h.a;
    }

    public static f c() {
        return net.minecraft.world.level.levelgen.SurfaceRules$a.a;
    }

    public static f d() {
        return v.a;
    }

    public static o a(f condition, o rule) {
        return new x(condition, rule);
    }

    public static o a(o ... rules) {
        if (rules.length == 0) {
            throw new IllegalArgumentException("Need at least 1 rule for a sequence");
        }
        return new q(Arrays.asList(rules));
    }

    public static o a(IBlockData state) {
        return new d(state);
    }

    public static o e() {
        return net.minecraft.world.level.levelgen.SurfaceRules$b.a;
    }

    static <A> MapCodec<? extends A> a(IRegistry<MapCodec<? extends A>> registry, String id, KeyDispatchDataCodec<? extends A> codecHolder) {
        return IRegistry.a(registry, id, codecHolder.a());
    }

    record t(int a, boolean c, int d, CaveSurface e) implements f
    {
        private final int a;
        static final KeyDispatchDataCodec<t> f = KeyDispatchDataCodec.a(RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.INT.fieldOf("offset").forGetter(t::b), (App)Codec.BOOL.fieldOf("add_surface_depth").forGetter(t::c), (App)Codec.INT.fieldOf("secondary_depth_range").forGetter(t::d), (App)CaveSurface.c.fieldOf("surface_type").forGetter(t::e)).apply((Applicative)instance, t::new)));

        @Override
        @Override
        public KeyDispatchDataCodec<? extends f> a() {
            return f;
        }

        @Override
        public e a(final g context) {
            final boolean bl = this.e == CaveSurface.a;
            class A
            extends k {
                A() {
                    super(context2);
                }

                @Override
                @Override
                protected boolean a() {
                    int i2 = bl ? this.c.D : this.c.E;
                    int j2 = t.this.c ? this.c.t : 0;
                    int k2 = t.this.d == 0 ? 0 : (int)MathHelper.b(this.c.a(), -1.0, 1.0, 0.0, (double)t.this.d);
                    return i2 <= 1 + t.this.a + j2 + k2;
                }
            }
            return new A();
        }

        @Override
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{t.class, "offset;addSurfaceDepth;secondaryDepthRange;surfaceType", "a", "c", "d", "e"}, this);
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{t.class, "offset;addSurfaceDepth;secondaryDepthRange;surfaceType", "a", "c", "d", "e"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{t.class, "offset;addSurfaceDepth;secondaryDepthRange;surfaceType", "a", "c", "d", "e"}, this, object);
        }

        public int b() {
            return this.a;
        }

        @Override
        public /* synthetic */ Object apply(Object object) {
            return this.a((g)object);
        }
    }

    record n(f a) implements f
    {
        private final f a;
        static final KeyDispatchDataCodec<n> c = KeyDispatchDataCodec.a(net.minecraft.world.level.levelgen.SurfaceRules$f.b.xmap(n::new, n::b).fieldOf("invert"));

        @Override
        @Override
        public KeyDispatchDataCodec<? extends f> a() {
            return c;
        }

        @Override
        public e a(g context) {
            return new m((e)this.a.apply(context));
        }

        @Override
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{n.class, "target", "a"}, this);
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{n.class, "target", "a"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{n.class, "target", "a"}, this, object);
        }

        public f b() {
            return this.a;
        }

        @Override
        public /* synthetic */ Object apply(Object object) {
            return this.a((g)object);
        }
    }

    public static interface f
    extends Function<g, e> {
        public static final Codec<f> b = BuiltInRegistries.ab.q().dispatch(conditionSource -> conditionSource.a().a(), Function.identity());

        public static MapCodec<? extends f> a(IRegistry<MapCodec<? extends f>> registry) {
            SurfaceRules.a(registry, "biome", net.minecraft.world.level.levelgen.SurfaceRules$c.a);
            SurfaceRules.a(registry, "noise_threshold", l.e);
            SurfaceRules.a(registry, "vertical_gradient", y.e);
            SurfaceRules.a(registry, "y_above", aa.e);
            SurfaceRules.a(registry, "water", z.e);
            SurfaceRules.a(registry, "temperature", v.c);
            SurfaceRules.a(registry, "steep", s.c);
            SurfaceRules.a(registry, "not", n.c);
            SurfaceRules.a(registry, "hole", h.c);
            SurfaceRules.a(registry, "above_preliminary_surface", net.minecraft.world.level.levelgen.SurfaceRules$a.c);
            return SurfaceRules.a(registry, "stone_depth", t.f);
        }

        public KeyDispatchDataCodec<? extends f> a();
    }

    record aa(VerticalAnchor a, int c, boolean d) implements f
    {
        private final VerticalAnchor a;
        static final KeyDispatchDataCodec<aa> e = KeyDispatchDataCodec.a(RecordCodecBuilder.mapCodec(instance -> instance.group((App)VerticalAnchor.a.fieldOf("anchor").forGetter(aa::b), (App)Codec.intRange((int)-20, (int)20).fieldOf("surface_depth_multiplier").forGetter(aa::c), (App)Codec.BOOL.fieldOf("add_stone_depth").forGetter(aa::d)).apply((Applicative)instance, aa::new)));

        @Override
        @Override
        public KeyDispatchDataCodec<? extends f> a() {
            return e;
        }

        @Override
        public e a(final g context) {
            class A
            extends k {
                A() {
                    super(context2);
                }

                @Override
                @Override
                protected boolean a() {
                    return this.c.B + (aa.this.d ? this.c.E : 0) >= aa.this.a.a(this.c.n) + this.c.t * aa.this.c;
                }
            }
            return new A();
        }

        @Override
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{aa.class, "anchor;surfaceDepthMultiplier;addStoneDepth", "a", "c", "d"}, this);
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{aa.class, "anchor;surfaceDepthMultiplier;addStoneDepth", "a", "c", "d"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{aa.class, "anchor;surfaceDepthMultiplier;addStoneDepth", "a", "c", "d"}, this, object);
        }

        public VerticalAnchor b() {
            return this.a;
        }

        @Override
        public /* synthetic */ Object apply(Object object) {
            return this.a((g)object);
        }
    }

    record z(int a, int c, boolean d) implements f
    {
        private final int a;
        static final KeyDispatchDataCodec<z> e = KeyDispatchDataCodec.a(RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.INT.fieldOf("offset").forGetter(z::b), (App)Codec.intRange((int)-20, (int)20).fieldOf("surface_depth_multiplier").forGetter(z::c), (App)Codec.BOOL.fieldOf("add_stone_depth").forGetter(z::d)).apply((Applicative)instance, z::new)));

        @Override
        @Override
        public KeyDispatchDataCodec<? extends f> a() {
            return e;
        }

        @Override
        public e a(final g context) {
            class A
            extends k {
                A() {
                    super(context2);
                }

                @Override
                @Override
                protected boolean a() {
                    return this.c.C == Integer.MIN_VALUE || this.c.B + (z.this.d ? this.c.E : 0) >= this.c.C + z.this.a + this.c.t * z.this.c;
                }
            }
            return new A();
        }

        @Override
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{z.class, "offset;surfaceDepthMultiplier;addStoneDepth", "a", "c", "d"}, this);
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{z.class, "offset;surfaceDepthMultiplier;addStoneDepth", "a", "c", "d"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{z.class, "offset;surfaceDepthMultiplier;addStoneDepth", "a", "c", "d"}, this, object);
        }

        public int b() {
            return this.a;
        }

        @Override
        public /* synthetic */ Object apply(Object object) {
            return this.a((g)object);
        }
    }

    static final class c
    implements f {
        static final KeyDispatchDataCodec<c> a = KeyDispatchDataCodec.a(ResourceKey.a(Registries.aI).listOf().fieldOf("biome_is").xmap(SurfaceRules::a, biomeConditionSource -> biomeConditionSource.c));
        private final List<ResourceKey<BiomeBase>> c;
        final Predicate<ResourceKey<BiomeBase>> d;

        c(List<ResourceKey<BiomeBase>> biomes) {
            this.c = biomes;
            this.d = Set.copyOf(biomes)::contains;
        }

        @Override
        @Override
        public KeyDispatchDataCodec<? extends f> a() {
            return a;
        }

        @Override
        public e a(final g context) {
            class A
            extends k {
                A() {
                    super(context2);
                }

                @Override
                @Override
                protected boolean a() {
                    return this.c.A.get().a(c.this.d);
                }
            }
            return new A();
        }

        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof c) {
                c biomeConditionSource = (c)object;
                return this.c.equals(biomeConditionSource.c);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return this.c.hashCode();
        }

        @Override
        public String toString() {
            return "BiomeConditionSource[biomes=" + String.valueOf(this.c) + "]";
        }

        @Override
        public /* synthetic */ Object apply(Object object) {
            return this.a((g)object);
        }
    }

    record l(ResourceKey<NoiseGeneratorNormal.a> a, double c, double d) implements f
    {
        private final ResourceKey<NoiseGeneratorNormal.a> a;
        static final KeyDispatchDataCodec<l> e = KeyDispatchDataCodec.a(RecordCodecBuilder.mapCodec(instance -> instance.group((App)ResourceKey.a(Registries.aS).fieldOf("noise").forGetter(l::b), (App)Codec.DOUBLE.fieldOf("min_threshold").forGetter(l::c), (App)Codec.DOUBLE.fieldOf("max_threshold").forGetter(l::d)).apply((Applicative)instance, l::new)));

        @Override
        @Override
        public KeyDispatchDataCodec<? extends f> a() {
            return e;
        }

        @Override
        public e a(final g context) {
            final NoiseGeneratorNormal normalNoise = context.j.a(this.a);
            class A
            extends j {
                A() {
                    super(context2);
                }

                @Override
                @Override
                protected boolean a() {
                    double d2 = normalNoise.a(this.c.r, 0.0, this.c.s);
                    return d2 >= l.this.c && d2 <= l.this.d;
                }
            }
            return new A();
        }

        @Override
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{l.class, "noise;minThreshold;maxThreshold", "a", "c", "d"}, this);
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{l.class, "noise;minThreshold;maxThreshold", "a", "c", "d"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{l.class, "noise;minThreshold;maxThreshold", "a", "c", "d"}, this, object);
        }

        public ResourceKey<NoiseGeneratorNormal.a> b() {
            return this.a;
        }

        @Override
        public /* synthetic */ Object apply(Object object) {
            return this.a((g)object);
        }
    }

    public record y(MinecraftKey a, VerticalAnchor c, VerticalAnchor d) implements f
    {
        private final MinecraftKey a;
        static final KeyDispatchDataCodec<y> e = KeyDispatchDataCodec.a(RecordCodecBuilder.mapCodec(instance -> instance.group((App)MinecraftKey.a.fieldOf("random_name").forGetter(y::b), (App)VerticalAnchor.a.fieldOf("true_at_and_below").forGetter(y::c), (App)VerticalAnchor.a.fieldOf("false_at_and_above").forGetter(y::d)).apply((Applicative)instance, y::new)));

        @Override
        @Override
        public KeyDispatchDataCodec<? extends f> a() {
            return e;
        }

        @Override
        public e a(final g context) {
            final int i2 = this.c().a(context.n);
            final int j2 = this.d().a(context.n);
            final PositionalRandomFactory positionalRandomFactory = context.j.a(this.b());
            class A
            extends k {
                A() {
                    super(context2);
                }

                @Override
                @Override
                protected boolean a() {
                    int i22 = this.c.B;
                    if (i22 <= i2) {
                        return true;
                    }
                    if (i22 >= j2) {
                        return false;
                    }
                    double d2 = MathHelper.b((double)i22, (double)i2, (double)j2, 1.0, 0.0);
                    RandomSource randomSource = positionalRandomFactory.a(this.c.r, i22, this.c.s);
                    return (double)randomSource.i() < d2;
                }
            }
            return new A();
        }

        @Override
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{y.class, "randomName;trueAtAndBelow;falseAtAndAbove", "a", "c", "d"}, this);
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{y.class, "randomName;trueAtAndBelow;falseAtAndAbove", "a", "c", "d"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{y.class, "randomName;trueAtAndBelow;falseAtAndAbove", "a", "c", "d"}, this, object);
        }

        public MinecraftKey b() {
            return this.a;
        }

        @Override
        public /* synthetic */ Object apply(Object object) {
            return this.a((g)object);
        }
    }

    static final class s
    extends Enum<s>
    implements f {
        public static final /* enum */ s a = new s();
        static final KeyDispatchDataCodec<s> c;
        private static final /* synthetic */ s[] d;

        public static s[] values() {
            return (s[])d.clone();
        }

        public static s valueOf(String string) {
            return Enum.valueOf(s.class, string);
        }

        @Override
        @Override
        public KeyDispatchDataCodec<? extends f> a() {
            return c;
        }

        @Override
        public e a(g context) {
            return context.g;
        }

        @Override
        public /* synthetic */ Object apply(Object object) {
            return this.a((g)object);
        }

        private static /* synthetic */ s[] b() {
            return new s[]{a};
        }

        static {
            d = s.b();
            c = KeyDispatchDataCodec.a(MapCodec.unit((Object)a));
        }
    }

    static final class h
    extends Enum<h>
    implements f {
        public static final /* enum */ h a = new h();
        static final KeyDispatchDataCodec<h> c;
        private static final /* synthetic */ h[] d;

        public static h[] values() {
            return (h[])d.clone();
        }

        public static h valueOf(String string) {
            return Enum.valueOf(h.class, string);
        }

        @Override
        @Override
        public KeyDispatchDataCodec<? extends f> a() {
            return c;
        }

        @Override
        public e a(g context) {
            return context.h;
        }

        @Override
        public /* synthetic */ Object apply(Object object) {
            return this.a((g)object);
        }

        private static /* synthetic */ h[] b() {
            return new h[]{a};
        }

        static {
            d = h.b();
            c = KeyDispatchDataCodec.a(MapCodec.unit((Object)a));
        }
    }

    static final class a
    extends Enum<a>
    implements f {
        public static final /* enum */ a a = new a();
        static final KeyDispatchDataCodec<a> c;
        private static final /* synthetic */ a[] d;

        public static a[] values() {
            return (a[])d.clone();
        }

        public static a valueOf(String string) {
            return Enum.valueOf(a.class, string);
        }

        @Override
        @Override
        public KeyDispatchDataCodec<? extends f> a() {
            return c;
        }

        @Override
        public e a(g context) {
            return context.i;
        }

        @Override
        public /* synthetic */ Object apply(Object object) {
            return this.a((g)object);
        }

        private static /* synthetic */ a[] b() {
            return new a[]{a};
        }

        static {
            d = net.minecraft.world.level.levelgen.SurfaceRules$a.b();
            c = KeyDispatchDataCodec.a(MapCodec.unit((Object)a));
        }
    }

    static final class v
    extends Enum<v>
    implements f {
        public static final /* enum */ v a = new v();
        static final KeyDispatchDataCodec<v> c;
        private static final /* synthetic */ v[] d;

        public static v[] values() {
            return (v[])d.clone();
        }

        public static v valueOf(String string) {
            return Enum.valueOf(v.class, string);
        }

        @Override
        @Override
        public KeyDispatchDataCodec<? extends f> a() {
            return c;
        }

        @Override
        public e a(g context) {
            return context.f;
        }

        @Override
        public /* synthetic */ Object apply(Object object) {
            return this.a((g)object);
        }

        private static /* synthetic */ v[] b() {
            return new v[]{a};
        }

        static {
            d = v.b();
            c = KeyDispatchDataCodec.a(MapCodec.unit((Object)a));
        }
    }

    record x(f a, o c) implements o
    {
        private final f a;
        static final KeyDispatchDataCodec<x> d = KeyDispatchDataCodec.a(RecordCodecBuilder.mapCodec(instance -> instance.group((App)net.minecraft.world.level.levelgen.SurfaceRules$f.b.fieldOf("if_true").forGetter(x::b), (App)o.b.fieldOf("then_run").forGetter(x::c)).apply((Applicative)instance, x::new)));

        @Override
        @Override
        public KeyDispatchDataCodec<? extends o> a() {
            return d;
        }

        @Override
        public u a(g context) {
            return new w((e)this.a.apply(context), (u)this.c.apply(context));
        }

        @Override
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{x.class, "ifTrue;thenRun", "a", "c"}, this);
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{x.class, "ifTrue;thenRun", "a", "c"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{x.class, "ifTrue;thenRun", "a", "c"}, this, object);
        }

        public f b() {
            return this.a;
        }

        @Override
        public /* synthetic */ Object apply(Object object) {
            return this.a((g)object);
        }
    }

    public static interface o
    extends Function<g, u> {
        public static final Codec<o> b = BuiltInRegistries.ac.q().dispatch(ruleSource -> ruleSource.a().a(), Function.identity());

        public static MapCodec<? extends o> a(IRegistry<MapCodec<? extends o>> registry) {
            SurfaceRules.a(registry, "bandlands", net.minecraft.world.level.levelgen.SurfaceRules$b.c);
            SurfaceRules.a(registry, "block", net.minecraft.world.level.levelgen.SurfaceRules$d.d);
            SurfaceRules.a(registry, "sequence", q.c);
            return SurfaceRules.a(registry, "condition", x.d);
        }

        public KeyDispatchDataCodec<? extends o> a();
    }

    record q(List<o> a) implements o
    {
        private final List<o> a;
        static final KeyDispatchDataCodec<q> c = KeyDispatchDataCodec.a(o.b.listOf().xmap(q::new, q::b).fieldOf("sequence"));

        @Override
        @Override
        public KeyDispatchDataCodec<? extends o> a() {
            return c;
        }

        @Override
        public u a(g context) {
            if (this.a.size() == 1) {
                return (u)this.a.get(0).apply(context);
            }
            ImmutableList.Builder builder = ImmutableList.builder();
            for (o ruleSource : this.a) {
                builder.add((Object)((u)ruleSource.apply(context)));
            }
            return new p((List<u>)builder.build());
        }

        @Override
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{q.class, "sequence", "a"}, this);
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{q.class, "sequence", "a"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{q.class, "sequence", "a"}, this, object);
        }

        public List<o> b() {
            return this.a;
        }

        @Override
        public /* synthetic */ Object apply(Object object) {
            return this.a((g)object);
        }
    }

    record d(IBlockData a, r c) implements o
    {
        private final IBlockData a;
        static final KeyDispatchDataCodec<d> d = KeyDispatchDataCodec.a(IBlockData.a.xmap(d::new, d::b).fieldOf("result_state"));

        d(IBlockData resultState) {
            this(resultState, new r(resultState));
        }

        @Override
        @Override
        public KeyDispatchDataCodec<? extends o> a() {
            return d;
        }

        @Override
        public u a(g context) {
            return this.c;
        }

        @Override
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{d.class, "resultState;rule", "a", "c"}, this);
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{d.class, "resultState;rule", "a", "c"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{d.class, "resultState;rule", "a", "c"}, this, object);
        }

        public IBlockData b() {
            return this.a;
        }

        @Override
        public /* synthetic */ Object apply(Object object) {
            return this.a((g)object);
        }
    }

    static final class b
    extends Enum<b>
    implements o {
        public static final /* enum */ b a = new b();
        static final KeyDispatchDataCodec<b> c;
        private static final /* synthetic */ b[] d;

        public static b[] values() {
            return (b[])d.clone();
        }

        public static b valueOf(String string) {
            return Enum.valueOf(b.class, string);
        }

        @Override
        @Override
        public KeyDispatchDataCodec<? extends o> a() {
            return c;
        }

        @Override
        public u a(g context) {
            return context.e::a;
        }

        @Override
        public /* synthetic */ Object apply(Object object) {
            return this.a((g)object);
        }

        private static /* synthetic */ b[] b() {
            return new b[]{a};
        }

        static {
            d = net.minecraft.world.level.levelgen.SurfaceRules$b.b();
            c = KeyDispatchDataCodec.a(MapCodec.unit((Object)a));
        }
    }

    record p(List<u> a) implements u
    {
        @Override
        @Nullable
        @Override
        public IBlockData tryApply(int x2, int y2, int z2) {
            for (u surfaceRule : this.a) {
                IBlockData blockState = surfaceRule.tryApply(x2, y2, z2);
                if (blockState == null) continue;
                return blockState;
            }
            return null;
        }

        @Override
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{p.class, "rules", "a"}, this);
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{p.class, "rules", "a"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{p.class, "rules", "a"}, this, object);
        }
    }

    record w(e a, u b) implements u
    {
        @Override
        @Nullable
        @Override
        public IBlockData tryApply(int x2, int y2, int z2) {
            if (!this.a.b()) {
                return null;
            }
            return this.b.tryApply(x2, y2, z2);
        }

        @Override
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{w.class, "condition;followup", "a", "b"}, this);
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{w.class, "condition;followup", "a", "b"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{w.class, "condition;followup", "a", "b"}, this, object);
        }
    }

    record r(IBlockData a) implements u
    {
        @Override
        @Override
        public IBlockData tryApply(int x2, int y2, int z2) {
            return this.a;
        }

        @Override
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{r.class, "state", "a"}, this);
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{r.class, "state", "a"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{r.class, "state", "a"}, this, object);
        }
    }

    public static interface u {
        @Nullable
        public IBlockData tryApply(int var1, int var2, int var3);
    }

    record m(e a) implements e
    {
        @Override
        @Override
        public boolean b() {
            return !this.a.b();
        }

        @Override
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{m.class, "target", "a"}, this);
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{m.class, "target", "a"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{m.class, "target", "a"}, this, object);
        }
    }

    public static abstract class k
    extends i {
        protected k(g context) {
            super(context);
        }

        @Override
        @Override
        protected long c() {
            return this.c.y;
        }
    }

    static abstract class j
    extends i {
        protected j(g context) {
            super(context);
        }

        @Override
        @Override
        protected long c() {
            return this.c.q;
        }
    }

    public static abstract class i
    implements e {
        protected final g c;
        private long a;
        @Nullable
        Boolean d;

        protected i(g context) {
            this.c = context;
            this.a = this.c() - 1L;
        }

        @Override
        @Override
        public boolean b() {
            long l2 = this.c();
            if (l2 == this.a) {
                if (this.d == null) {
                    throw new IllegalStateException("Update triggered but the result is null");
                }
                return this.d;
            }
            this.a = l2;
            this.d = this.a();
            return this.d;
        }

        protected abstract long c();

        protected abstract boolean a();
    }

    public static interface e {
        public boolean b();
    }

    public static final class g {
        private static final int a = 8;
        private static final int b = 4;
        private static final int c = 16;
        private static final int d = 15;
        final SurfaceSystem e;
        final e f = new d(this);
        final e g = new c(this);
        final e h = new b(this);
        final e i = new a();
        public final RandomState j;
        final IChunkAccess k;
        private final NoiseChunk l;
        private final Function<BlockPosition, Holder<BiomeBase>> m;
        public final WorldGenerationContext n;
        private long o = Long.MAX_VALUE;
        private final int[] p = new int[4];
        long q = -9223372036854775807L;
        public int r;
        public int s;
        int t;
        private long u = this.q - 1L;
        private double v;
        private long w = this.q - 1L;
        private int x;
        long y = -9223372036854775807L;
        final BlockPosition.MutableBlockPosition z = new BlockPosition.MutableBlockPosition();
        Supplier<Holder<BiomeBase>> A;
        public int B;
        int C;
        int D;
        int E;

        protected g(SurfaceSystem surfaceBuilder, RandomState noiseConfig, IChunkAccess chunk, NoiseChunk chunkNoiseSampler, Function<BlockPosition, Holder<BiomeBase>> posToBiome, IRegistry<BiomeBase> biomeRegistry, WorldGenerationContext heightContext) {
            this.e = surfaceBuilder;
            this.j = noiseConfig;
            this.k = chunk;
            this.l = chunkNoiseSampler;
            this.m = posToBiome;
            this.n = heightContext;
        }

        protected void a(int blockX, int blockZ) {
            ++this.q;
            ++this.y;
            this.r = blockX;
            this.s = blockZ;
            this.t = this.e.a(blockX, blockZ);
        }

        protected void a(int stoneDepthAbove, int stoneDepthBelow, int fluidHeight, int blockX, int blockY, int blockZ) {
            ++this.y;
            this.A = Suppliers.memoize(() -> this.m.apply(this.z.d(blockX, blockY, blockZ)));
            this.B = blockY;
            this.C = fluidHeight;
            this.D = stoneDepthBelow;
            this.E = stoneDepthAbove;
        }

        protected double a() {
            if (this.u != this.q) {
                this.u = this.q;
                this.v = this.e.b(this.r, this.s);
            }
            return this.v;
        }

        public int b() {
            return this.e.a();
        }

        private static int a(int blockCoord) {
            return blockCoord >> 4;
        }

        private static int b(int chunkCoord) {
            return chunkCoord << 4;
        }

        protected int c() {
            if (this.w != this.q) {
                int j2;
                this.w = this.q;
                int i2 = net.minecraft.world.level.levelgen.SurfaceRules$g.a(this.r);
                long l2 = ChunkCoordIntPair.c(i2, j2 = net.minecraft.world.level.levelgen.SurfaceRules$g.a(this.s));
                if (this.o != l2) {
                    this.o = l2;
                    this.p[0] = this.l.a(net.minecraft.world.level.levelgen.SurfaceRules$g.b(i2), net.minecraft.world.level.levelgen.SurfaceRules$g.b(j2));
                    this.p[1] = this.l.a(net.minecraft.world.level.levelgen.SurfaceRules$g.b(i2 + 1), net.minecraft.world.level.levelgen.SurfaceRules$g.b(j2));
                    this.p[2] = this.l.a(net.minecraft.world.level.levelgen.SurfaceRules$g.b(i2), net.minecraft.world.level.levelgen.SurfaceRules$g.b(j2 + 1));
                    this.p[3] = this.l.a(net.minecraft.world.level.levelgen.SurfaceRules$g.b(i2 + 1), net.minecraft.world.level.levelgen.SurfaceRules$g.b(j2 + 1));
                }
                int k2 = MathHelper.a(MathHelper.a((float)(this.r & 0xF) / 16.0f, (float)(this.s & 0xF) / 16.0f, this.p[0], this.p[1], this.p[2], this.p[3]));
                this.x = k2 + this.t - 8;
            }
            return this.x;
        }

        static class d
        extends k {
            d(g context) {
                super(context);
            }

            @Override
            @Override
            protected boolean a() {
                return this.c.A.get().a().b(this.c.z.d(this.c.r, this.c.B, this.c.s), this.c.b());
            }
        }

        static class c
        extends j {
            c(g context) {
                super(context);
            }

            @Override
            @Override
            protected boolean a() {
                int r2;
                int i2 = this.c.r & 0xF;
                int j2 = this.c.s & 0xF;
                int k2 = Math.max(j2 - 1, 0);
                int l2 = Math.min(j2 + 1, 15);
                IChunkAccess chunkAccess = this.c.k;
                int m2 = chunkAccess.a(HeightMap.Type.a, i2, k2);
                int n2 = chunkAccess.a(HeightMap.Type.a, i2, l2);
                if (n2 >= m2 + 4) {
                    return true;
                }
                int o2 = Math.max(i2 - 1, 0);
                int p2 = Math.min(i2 + 1, 15);
                int q2 = chunkAccess.a(HeightMap.Type.a, o2, j2);
                return q2 >= (r2 = chunkAccess.a(HeightMap.Type.a, p2, j2)) + 4;
            }
        }

        static final class b
        extends j {
            b(g context) {
                super(context);
            }

            @Override
            @Override
            protected boolean a() {
                return this.c.t <= 0;
            }
        }

        final class a
        implements e {
            a() {
            }

            @Override
            @Override
            public boolean b() {
                return g.this.B >= g.this.c();
            }
        }
    }
}

