/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import java.util.Arrays;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.BlockColumn;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.dimension.DimensionManager;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.NoiseChunk;
import net.minecraft.world.level.levelgen.Noises;
import net.minecraft.world.level.levelgen.PositionalRandomFactory;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.carver.CarvingContext;
import net.minecraft.world.level.levelgen.synth.NoiseGeneratorNormal;

public class SurfaceSystem {
    private static final IBlockData a = Blocks.hz.m();
    private static final IBlockData b = Blocks.hA.m();
    private static final IBlockData c = Blocks.iR.m();
    private static final IBlockData d = Blocks.hD.m();
    private static final IBlockData e = Blocks.hL.m();
    private static final IBlockData f = Blocks.hN.m();
    private static final IBlockData g = Blocks.hH.m();
    private static final IBlockData h = Blocks.iT.m();
    private static final IBlockData i = Blocks.ec.m();
    private final IBlockData j;
    private final int k;
    private final IBlockData[] l;
    private final NoiseGeneratorNormal m;
    private final NoiseGeneratorNormal n;
    private final NoiseGeneratorNormal o;
    private final NoiseGeneratorNormal p;
    private final NoiseGeneratorNormal q;
    private final NoiseGeneratorNormal r;
    private final NoiseGeneratorNormal s;
    private final PositionalRandomFactory t;
    private final NoiseGeneratorNormal u;
    private final NoiseGeneratorNormal v;

    public SurfaceSystem(RandomState noiseConfig, IBlockData defaultState, int seaLevel, PositionalRandomFactory randomDeriver) {
        this.j = defaultState;
        this.k = seaLevel;
        this.t = randomDeriver;
        this.m = noiseConfig.a(Noises.P);
        this.l = SurfaceSystem.a(randomDeriver.a(MinecraftKey.b("clay_bands")));
        this.u = noiseConfig.a(Noises.N);
        this.v = noiseConfig.a(Noises.O);
        this.n = noiseConfig.a(Noises.Q);
        this.o = noiseConfig.a(Noises.R);
        this.p = noiseConfig.a(Noises.S);
        this.q = noiseConfig.a(Noises.T);
        this.r = noiseConfig.a(Noises.U);
        this.s = noiseConfig.a(Noises.V);
    }

    public void a(RandomState noiseConfig, BiomeManager biomeAccess, IRegistry<BiomeBase> biomeRegistry, boolean useLegacyRandom, WorldGenerationContext heightContext, final IChunkAccess chunk, NoiseChunk chunkNoiseSampler, SurfaceRules.o materialRule) {
        final BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition();
        final ChunkCoordIntPair chunkPos = chunk.f();
        int i2 = chunkPos.d();
        int j2 = chunkPos.e();
        BlockColumn blockColumn = new BlockColumn(){

            @Override
            @Override
            public IBlockData a(int y2) {
                return chunk.a_(mutableBlockPos.q(y2));
            }

            @Override
            @Override
            public void a(int y2, IBlockData state) {
                LevelHeightAccessor levelHeightAccessor = chunk.B();
                if (levelHeightAccessor.d(y2)) {
                    chunk.a(mutableBlockPos.q(y2), state, false);
                    if (!state.y().c()) {
                        chunk.e(mutableBlockPos);
                    }
                }
            }

            @Override
            public String toString() {
                return "ChunkBlockColumn " + String.valueOf(chunkPos);
            }
        };
        SurfaceRules.g context = new SurfaceRules.g(this, noiseConfig, chunk, chunkNoiseSampler, biomeAccess::a, biomeRegistry, heightContext);
        SurfaceRules.u surfaceRule = (SurfaceRules.u)materialRule.apply(context);
        BlockPosition.MutableBlockPosition mutableBlockPos2 = new BlockPosition.MutableBlockPosition();
        for (int k2 = 0; k2 < 16; ++k2) {
            for (int l2 = 0; l2 < 16; ++l2) {
                int m2 = i2 + k2;
                int n2 = j2 + l2;
                int o2 = chunk.a(HeightMap.Type.a, k2, l2) + 1;
                mutableBlockPos.p(m2).r(n2);
                Holder<BiomeBase> holder = biomeAccess.a(mutableBlockPos2.d(m2, useLegacyRandom ? 0 : o2, n2));
                if (holder.a(Biomes.B)) {
                    this.a(blockColumn, m2, n2, o2, chunk);
                }
                int p2 = chunk.a(HeightMap.Type.a, k2, l2) + 1;
                context.a(m2, n2);
                int q2 = 0;
                int r2 = Integer.MIN_VALUE;
                int s2 = Integer.MAX_VALUE;
                int t2 = chunk.L_();
                for (int u2 = p2; u2 >= t2; --u2) {
                    IBlockData blockState3;
                    IBlockData blockState = blockColumn.a(u2);
                    if (blockState.l()) {
                        q2 = 0;
                        r2 = Integer.MIN_VALUE;
                        continue;
                    }
                    if (!blockState.y().c()) {
                        if (r2 != Integer.MIN_VALUE) continue;
                        r2 = u2 + 1;
                        continue;
                    }
                    if (s2 >= u2) {
                        s2 = DimensionManager.g;
                        for (int v2 = u2 - 1; v2 >= t2 - 1; --v2) {
                            IBlockData blockState2 = blockColumn.a(v2);
                            if (this.a(blockState2)) continue;
                            s2 = v2 + 1;
                            break;
                        }
                    }
                    int w2 = u2 - s2 + 1;
                    context.a(++q2, w2, r2, m2, u2, n2);
                    if (blockState != this.j || (blockState3 = surfaceRule.tryApply(m2, u2, n2)) == null) continue;
                    blockColumn.a(u2, blockState3);
                }
                if (!holder.a(Biomes.W) && !holder.a(Biomes.X)) continue;
                this.a(context.c(), holder.a(), blockColumn, mutableBlockPos2, m2, n2, o2);
            }
        }
    }

    protected int a(int blockX, int blockZ) {
        double d2 = this.u.a(blockX, 0.0, blockZ);
        return (int)(d2 * 2.75 + 3.0 + this.t.a(blockX, 0, blockZ).j() * 0.25);
    }

    protected double b(int blockX, int blockZ) {
        return this.v.a(blockX, 0.0, blockZ);
    }

    private boolean a(IBlockData state) {
        return !state.l() && state.y().c();
    }

    public int a() {
        return this.k;
    }

    @Deprecated
    public Optional<IBlockData> a(SurfaceRules.o rule, CarvingContext context, Function<BlockPosition, Holder<BiomeBase>> posToBiome, IChunkAccess chunk, NoiseChunk chunkNoiseSampler, BlockPosition pos, boolean hasFluid) {
        SurfaceRules.g context2 = new SurfaceRules.g(this, context.d(), chunk, chunkNoiseSampler, posToBiome, context.c().e(Registries.aI), context);
        SurfaceRules.u surfaceRule = (SurfaceRules.u)rule.apply(context2);
        int i2 = pos.u();
        int j2 = pos.v();
        int k2 = pos.w();
        context2.a(i2, k2);
        context2.a(1, 1, hasFluid ? j2 + 1 : Integer.MIN_VALUE, i2, j2, k2);
        IBlockData blockState = surfaceRule.tryApply(i2, j2, k2);
        return Optional.ofNullable(blockState);
    }

    private void a(BlockColumn column, int x2, int z2, int surfaceY, LevelHeightAccessor chunk) {
        IBlockData blockState;
        double d2 = 0.2;
        double e2 = Math.min(Math.abs(this.p.a(x2, 0.0, z2) * 8.25), this.n.a((double)x2 * 0.2, 0.0, (double)z2 * 0.2) * 15.0);
        if (e2 <= 0.0) {
            return;
        }
        double f2 = 0.75;
        double g2 = 1.5;
        double h2 = Math.abs(this.o.a((double)x2 * 0.75, 0.0, (double)z2 * 0.75) * 1.5);
        double i2 = 64.0 + Math.min(e2 * e2 * 2.5, Math.ceil(h2 * 50.0) + 24.0);
        int j2 = MathHelper.a(i2);
        if (surfaceY > j2) {
            return;
        }
        for (int k2 = j2; k2 >= chunk.L_() && !(blockState = column.a(k2)).a(this.j.b()); --k2) {
            if (!blockState.a(Blocks.J)) continue;
            return;
        }
        for (int l2 = j2; l2 >= chunk.L_() && column.a(l2).l(); --l2) {
            column.a(l2, this.j);
        }
    }

    private void a(int minY, BiomeBase biome, BlockColumn column, BlockPosition.MutableBlockPosition mutablePos, int x2, int z2, int surfaceY) {
        double k2;
        double d2 = 1.28;
        double e2 = Math.min(Math.abs(this.s.a(x2, 0.0, z2) * 8.25), this.q.a((double)x2 * 1.28, 0.0, (double)z2 * 1.28) * 15.0);
        if (e2 <= 1.8) {
            return;
        }
        double f2 = 1.17;
        double g2 = 1.5;
        double h2 = Math.abs(this.r.a((double)x2 * 1.17, 0.0, (double)z2 * 1.17) * 1.5);
        double i2 = Math.min(e2 * e2 * 1.2, Math.ceil(h2 * 40.0) + 14.0);
        if (biome.d(mutablePos.d(x2, this.k, z2), this.k)) {
            i2 -= 2.0;
        }
        if (i2 > 2.0) {
            double j2 = (double)this.k - i2 - 7.0;
            i2 += (double)this.k;
        } else {
            i2 = 0.0;
            k2 = 0.0;
        }
        double l2 = i2;
        RandomSource randomSource = this.t.a(x2, 0, z2);
        int m2 = 2 + randomSource.a(4);
        int n2 = this.k + 18 + randomSource.a(10);
        int o2 = 0;
        for (int p2 = Math.max(surfaceY, (int)l2 + 1); p2 >= minY; --p2) {
            if (!(column.a(p2).l() && p2 < (int)l2 && randomSource.j() > 0.01) && (!column.a(p2).a(Blocks.J) || p2 <= (int)k2 || p2 >= this.k || k2 == 0.0 || !(randomSource.j() > 0.15))) continue;
            if (o2 <= m2 && p2 > n2) {
                column.a(p2, i);
                ++o2;
                continue;
            }
            column.a(p2, h);
        }
    }

    private static IBlockData[] a(RandomSource random) {
        Object[] blockStates = new IBlockData[192];
        Arrays.fill(blockStates, c);
        for (int i2 = 0; i2 < blockStates.length; ++i2) {
            if ((i2 += random.a(5) + 1) >= blockStates.length) continue;
            blockStates[i2] = b;
        }
        SurfaceSystem.a(random, (IBlockData[])blockStates, 1, d);
        SurfaceSystem.a(random, (IBlockData[])blockStates, 2, e);
        SurfaceSystem.a(random, (IBlockData[])blockStates, 1, f);
        int j2 = random.a(9, 15);
        int k2 = 0;
        for (int l2 = 0; k2 < j2 && l2 < blockStates.length; ++k2, l2 += random.a(16) + 4) {
            blockStates[l2] = a;
            if (l2 - 1 > 0 && random.h()) {
                blockStates[l2 - 1] = g;
            }
            if (l2 + 1 >= blockStates.length || !random.h()) continue;
            blockStates[l2 + 1] = g;
        }
        return blockStates;
    }

    private static void a(RandomSource random, IBlockData[] terracottaBands, int minBandSize, IBlockData state) {
        int i2 = random.a(6, 15);
        for (int j2 = 0; j2 < i2; ++j2) {
            int k2 = minBandSize + random.a(3);
            int l2 = random.a(terracottaBands.length);
            for (int m2 = 0; l2 + m2 < terracottaBands.length && m2 < k2; ++m2) {
                terracottaBands[l2 + m2] = state;
            }
        }
    }

    protected IBlockData a(int x2, int y2, int z2) {
        int i2 = (int)Math.round(this.m.a(x2, 0.0, z2) * 4.0);
        return this.l[(y2 + i2 + this.l.length) % this.l.length];
    }
}

