/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.OptionalLong;
import net.minecraft.util.RandomSource;
import org.apache.commons.lang3.StringUtils;

public class WorldOptions {
    public static final MapCodec<WorldOptions> a = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.LONG.fieldOf("seed").stable().forGetter(WorldOptions::c), (App)Codec.BOOL.fieldOf("generate_features").orElse((Object)true).stable().forGetter(WorldOptions::d), (App)Codec.BOOL.fieldOf("bonus_chest").orElse((Object)false).stable().forGetter(WorldOptions::e), (App)Codec.STRING.lenientOptionalFieldOf("legacy_custom_options").stable().forGetter(generatorOptions -> generatorOptions.f)).apply((Applicative)instance, instance.stable(WorldOptions::new)));
    public static final WorldOptions b = new WorldOptions("North Carolina".hashCode(), true, true);
    private final long c;
    private final boolean d;
    private final boolean e;
    private final Optional<String> f;

    public WorldOptions(long seed, boolean generateStructures, boolean bonusChest) {
        this(seed, generateStructures, bonusChest, Optional.empty());
    }

    public static WorldOptions a() {
        return new WorldOptions(WorldOptions.g(), true, false);
    }

    public static WorldOptions b() {
        return new WorldOptions(WorldOptions.g(), false, false);
    }

    private WorldOptions(long seed, boolean generateStructures, boolean bonusChest, Optional<String> legacyCustomOptions) {
        this.c = seed;
        this.d = generateStructures;
        this.e = bonusChest;
        this.f = legacyCustomOptions;
    }

    public long c() {
        return this.c;
    }

    public boolean d() {
        return this.d;
    }

    public boolean e() {
        return this.e;
    }

    public boolean f() {
        return this.f.isPresent();
    }

    public WorldOptions a(boolean bonusChest) {
        return new WorldOptions(this.c, this.d, bonusChest, this.f);
    }

    public WorldOptions b(boolean structures) {
        return new WorldOptions(this.c, structures, this.e, this.f);
    }

    public WorldOptions a(OptionalLong seed) {
        return new WorldOptions(seed.orElse(WorldOptions.g()), this.d, this.e, this.f);
    }

    public static OptionalLong a(String seed) {
        if (StringUtils.isEmpty((CharSequence)(seed = seed.trim()))) {
            return OptionalLong.empty();
        }
        try {
            return OptionalLong.of(Long.parseLong(seed));
        }
        catch (NumberFormatException numberFormatException) {
            return OptionalLong.of(seed.hashCode());
        }
    }

    public static long g() {
        return RandomSource.a().g();
    }
}

