/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.blending;

import com.google.common.primitives.Doubles;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.doubles.DoubleArrays;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.EnumDirection8;
import net.minecraft.core.Holder;
import net.minecraft.core.QuartPos;
import net.minecraft.core.SectionPosition;
import net.minecraft.server.level.RegionLimitedWorldAccess;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.MathHelper;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.levelgen.HeightMap;

public class BlendingData {
    private static final double e = 0.1;
    protected static final int a = 4;
    protected static final int b = 8;
    protected static final int c = 2;
    private static final double f = 1.0;
    private static final double g = -1.0;
    private static final int h = 2;
    private static final int i = QuartPos.a(16);
    private static final int j = i - 1;
    private static final int k = i;
    private static final int l = 2 * j + 1;
    private static final int m = 2 * k + 1;
    static final int n = l + m;
    private final LevelHeightAccessor o;
    private static final List<Block> p = List.of(Blocks.l, Blocks.O, Blocks.i, Blocks.b, Blocks.k, Blocks.L, Blocks.N, Blocks.fz, Blocks.ec, Blocks.iR, Blocks.j);
    protected static final double d = Double.MAX_VALUE;
    private boolean q;
    private final double[] r;
    private final List<List<Holder<BiomeBase>>> s;
    private final transient double[][] t;

    private BlendingData(int oldBottomSectionY, int oldTopSectionY, Optional<double[]> heights) {
        this.r = heights.orElseGet(() -> SystemUtils.a(new double[n], (? super T ds) -> Arrays.fill(ds, Double.MAX_VALUE)));
        this.t = new double[n][];
        ObjectArrayList objectArrayList = new ObjectArrayList(n);
        objectArrayList.size(n);
        this.s = objectArrayList;
        int i2 = SectionPosition.c(oldBottomSectionY);
        int j2 = SectionPosition.c(oldTopSectionY) - i2;
        this.o = LevelHeightAccessor.e(i2, j2);
    }

    @Nullable
    public static BlendingData a(@Nullable d serialized) {
        if (serialized == null) {
            return null;
        }
        return new BlendingData(serialized.a(), serialized.b(), serialized.c());
    }

    public d a() {
        boolean bl = false;
        for (double d2 : this.r) {
            if (d2 == Double.MAX_VALUE) continue;
            bl = true;
            break;
        }
        return new d(this.o.ao(), this.o.ap() + 1, bl ? Optional.of(DoubleArrays.copy((double[])this.r)) : Optional.empty());
    }

    @Nullable
    public static BlendingData a(RegionLimitedWorldAccess chunkRegion, int chunkX, int chunkZ) {
        IChunkAccess chunkAccess = chunkRegion.a(chunkX, chunkZ);
        BlendingData blendingData = chunkAccess.v();
        if (blendingData == null || chunkAccess.o().d(ChunkStatus.f)) {
            return null;
        }
        blendingData.a(chunkAccess, BlendingData.a(chunkRegion, chunkX, chunkZ, false));
        return blendingData;
    }

    public static Set<EnumDirection8> a(GeneratorAccessSeed access, int chunkX, int chunkZ, boolean oldNoise) {
        EnumSet<EnumDirection8> set = EnumSet.noneOf(EnumDirection8.class);
        for (EnumDirection8 direction8 : EnumDirection8.values()) {
            int j2;
            int i2 = chunkX + direction8.b();
            if (access.a(i2, j2 = chunkZ + direction8.c()).u() != oldNoise) continue;
            set.add(direction8);
        }
        return set;
    }

    private void a(IChunkAccess chunk, Set<EnumDirection8> newNoiseChunkDirections) {
        if (this.q) {
            return;
        }
        if (newNoiseChunkDirections.contains((Object)EnumDirection8.a) || newNoiseChunkDirections.contains((Object)EnumDirection8.g) || newNoiseChunkDirections.contains((Object)EnumDirection8.h)) {
            this.a(BlendingData.a(0, 0), chunk, 0, 0);
        }
        if (newNoiseChunkDirections.contains((Object)EnumDirection8.a)) {
            for (int i2 = 1; i2 < i; ++i2) {
                this.a(BlendingData.a(i2, 0), chunk, 4 * i2, 0);
            }
        }
        if (newNoiseChunkDirections.contains((Object)EnumDirection8.g)) {
            for (int j2 = 1; j2 < i; ++j2) {
                this.a(BlendingData.a(0, j2), chunk, 0, 4 * j2);
            }
        }
        if (newNoiseChunkDirections.contains((Object)EnumDirection8.c)) {
            for (int k2 = 1; k2 < i; ++k2) {
                this.a(BlendingData.b(k, k2), chunk, 15, 4 * k2);
            }
        }
        if (newNoiseChunkDirections.contains((Object)EnumDirection8.e)) {
            for (int l2 = 0; l2 < i; ++l2) {
                this.a(BlendingData.b(l2, k), chunk, 4 * l2, 15);
            }
        }
        if (newNoiseChunkDirections.contains((Object)EnumDirection8.c) && newNoiseChunkDirections.contains((Object)EnumDirection8.b)) {
            this.a(BlendingData.b(k, 0), chunk, 15, 0);
        }
        if (newNoiseChunkDirections.contains((Object)EnumDirection8.c) && newNoiseChunkDirections.contains((Object)EnumDirection8.e) && newNoiseChunkDirections.contains((Object)EnumDirection8.d)) {
            this.a(BlendingData.b(k, k), chunk, 15, 15);
        }
        this.q = true;
    }

    private void a(int index, IChunkAccess chunk, int chunkBlockX, int chunkBlockZ) {
        if (this.r[index] == Double.MAX_VALUE) {
            this.r[index] = this.a(chunk, chunkBlockX, chunkBlockZ);
        }
        this.t[index] = this.a(chunk, chunkBlockX, chunkBlockZ, MathHelper.a(this.r[index]));
        this.s.set(index, this.b(chunk, chunkBlockX, chunkBlockZ));
    }

    private int a(IChunkAccess chunk, int blockX, int blockZ) {
        int j2;
        if (chunk.b(HeightMap.Type.a)) {
            int i2 = Math.min(chunk.a(HeightMap.Type.a, blockX, blockZ), this.o.am());
        } else {
            j2 = this.o.am();
        }
        int k2 = this.o.L_();
        BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition(blockX, j2, blockZ);
        while (mutableBlockPos.v() > k2) {
            if (p.contains(chunk.a_(mutableBlockPos).b())) {
                return mutableBlockPos.v();
            }
            mutableBlockPos.c(EnumDirection.a);
        }
        return k2;
    }

    private static double a(IChunkAccess chunk, BlockPosition.MutableBlockPosition mutablePos) {
        return BlendingData.a(chunk, (BlockPosition)mutablePos.c(EnumDirection.a)) ? 1.0 : -1.0;
    }

    private static double b(IChunkAccess chunk, BlockPosition.MutableBlockPosition mutablePos) {
        double d2 = 0.0;
        for (int i2 = 0; i2 < 7; ++i2) {
            d2 += BlendingData.a(chunk, mutablePos);
        }
        return d2;
    }

    private double[] a(IChunkAccess chunk, int chunkBlockX, int chunkBlockZ, int surfaceHeight) {
        double[] ds = new double[this.c()];
        Arrays.fill(ds, -1.0);
        BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition(chunkBlockX, this.o.am() + 1, chunkBlockZ);
        double d2 = BlendingData.b(chunk, mutableBlockPos);
        for (int i2 = ds.length - 2; i2 >= 0; --i2) {
            double e2 = BlendingData.a(chunk, mutableBlockPos);
            double f2 = BlendingData.b(chunk, mutableBlockPos);
            ds[i2] = (d2 + e2 + f2) / 15.0;
            d2 = f2;
        }
        int j2 = this.a(MathHelper.a(surfaceHeight, 8));
        if (j2 >= 0 && j2 < ds.length - 1) {
            double g2 = ((double)surfaceHeight + 0.5) % 8.0 / 8.0;
            double h2 = (1.0 - g2) / g2;
            double k2 = Math.max(h2, 1.0) * 0.25;
            ds[j2 + 1] = -h2 / k2;
            ds[j2] = 1.0 / k2;
        }
        return ds;
    }

    private List<Holder<BiomeBase>> b(IChunkAccess chunk, int chunkBlockX, int chunkBlockZ) {
        ObjectArrayList objectArrayList = new ObjectArrayList(this.d());
        objectArrayList.size(this.d());
        for (int i2 = 0; i2 < objectArrayList.size(); ++i2) {
            int j2 = i2 + QuartPos.a(this.o.L_());
            objectArrayList.set(i2, chunk.getNoiseBiome(QuartPos.a(chunkBlockX), j2, QuartPos.a(chunkBlockZ)));
        }
        return objectArrayList;
    }

    private static boolean a(IChunkAccess chunk, BlockPosition pos) {
        IBlockData blockState = chunk.a_(pos);
        if (blockState.l()) {
            return false;
        }
        if (blockState.a(TagsBlock.Q)) {
            return false;
        }
        if (blockState.a(TagsBlock.u)) {
            return false;
        }
        if (blockState.a(Blocks.fh) || blockState.a(Blocks.fi)) {
            return false;
        }
        return !blockState.g(chunk, pos).c();
    }

    protected double a(int biomeX, int biomeY, int biomeZ) {
        if (biomeX == k || biomeZ == k) {
            return this.r[BlendingData.b(biomeX, biomeZ)];
        }
        if (biomeX == 0 || biomeZ == 0) {
            return this.r[BlendingData.a(biomeX, biomeZ)];
        }
        return Double.MAX_VALUE;
    }

    private double a(@Nullable double[] collidableBlockDensityColumn, int halfSectionY) {
        if (collidableBlockDensityColumn == null) {
            return Double.MAX_VALUE;
        }
        int i2 = this.a(halfSectionY);
        if (i2 < 0 || i2 >= collidableBlockDensityColumn.length) {
            return Double.MAX_VALUE;
        }
        return collidableBlockDensityColumn[i2] * 0.1;
    }

    protected double b(int chunkBiomeX, int halfSectionY, int chunkBiomeZ) {
        if (halfSectionY == this.f()) {
            return 0.1;
        }
        if (chunkBiomeX == k || chunkBiomeZ == k) {
            return this.a(this.t[BlendingData.b(chunkBiomeX, chunkBiomeZ)], halfSectionY);
        }
        if (chunkBiomeX == 0 || chunkBiomeZ == 0) {
            return this.a(this.t[BlendingData.a(chunkBiomeX, chunkBiomeZ)], halfSectionY);
        }
        return Double.MAX_VALUE;
    }

    protected void a(int biomeX, int biomeY, int biomeZ, a consumer) {
        if (biomeY < QuartPos.a(this.o.L_()) || biomeY > QuartPos.a(this.o.am())) {
            return;
        }
        int i2 = biomeY - QuartPos.a(this.o.L_());
        for (int j2 = 0; j2 < this.s.size(); ++j2) {
            Holder<BiomeBase> holder;
            if (this.s.get(j2) == null || (holder = this.s.get(j2).get(i2)) == null) continue;
            consumer.consume(biomeX + BlendingData.b(j2), biomeZ + BlendingData.c(j2), holder);
        }
    }

    protected void a(int biomeX, int biomeZ, c consumer) {
        for (int i2 = 0; i2 < this.r.length; ++i2) {
            double d2 = this.r[i2];
            if (d2 == Double.MAX_VALUE) continue;
            consumer.consume(biomeX + BlendingData.b(i2), biomeZ + BlendingData.c(i2), d2);
        }
    }

    protected void a(int biomeX, int biomeZ, int minHalfSectionY, int maxHalfSectionY, b consumer) {
        int i2 = this.e();
        int j2 = Math.max(0, minHalfSectionY - i2);
        int k2 = Math.min(this.c(), maxHalfSectionY - i2);
        for (int l2 = 0; l2 < this.t.length; ++l2) {
            double[] ds = this.t[l2];
            if (ds == null) continue;
            int m2 = biomeX + BlendingData.b(l2);
            int n2 = biomeZ + BlendingData.c(l2);
            for (int o2 = j2; o2 < k2; ++o2) {
                consumer.consume(m2, o2 + i2, n2, ds[o2] * 0.1);
            }
        }
    }

    private int c() {
        return this.o.an() * 2;
    }

    private int d() {
        return QuartPos.d(this.o.an());
    }

    private int e() {
        return this.f() + 1;
    }

    private int f() {
        return this.o.ao() * 2;
    }

    private int a(int halfSectionY) {
        return halfSectionY - this.e();
    }

    private static int a(int chunkBiomeX, int chunkBiomeZ) {
        return j - chunkBiomeX + chunkBiomeZ;
    }

    private static int b(int chunkBiomeX, int chunkBiomeZ) {
        return l + chunkBiomeX + k - chunkBiomeZ;
    }

    private static int b(int index) {
        if (index < l) {
            return BlendingData.d(j - index);
        }
        int i2 = index - l;
        return k - BlendingData.d(k - i2);
    }

    private static int c(int index) {
        if (index < l) {
            return BlendingData.d(index - j);
        }
        int i2 = index - l;
        return k - BlendingData.d(i2 - k);
    }

    private static int d(int i2) {
        return i2 & ~(i2 >> 31);
    }

    public LevelHeightAccessor b() {
        return this.o;
    }

    public static final class d
    extends Record {
        private final int b;
        private final int c;
        private final Optional<double[]> d;
        private static final Codec<double[]> e = Codec.DOUBLE.listOf().xmap(Doubles::toArray, Doubles::asList);
        public static final Codec<d> a = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("min_section").forGetter(d::a), (App)Codec.INT.fieldOf("max_section").forGetter(d::b), (App)e.lenientOptionalFieldOf("heights").forGetter(d::c)).apply((Applicative)instance, d::new)).validate(d::a);

        public d(int i2, int j2, Optional<double[]> optional) {
            this.b = i2;
            this.c = j2;
            this.d = optional;
        }

        private static DataResult<d> a(d serialized) {
            if (serialized.d.isPresent() && serialized.d.get().length != n) {
                return DataResult.error(() -> "heights has to be of length " + n);
            }
            return DataResult.success((Object)serialized);
        }

        @Override
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{d.class, "minSection;maxSection;heights", "b", "c", "d"}, this);
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{d.class, "minSection;maxSection;heights", "b", "c", "d"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{d.class, "minSection;maxSection;heights", "b", "c", "d"}, this, object);
        }

        public int a() {
            return this.b;
        }

        public int b() {
            return this.c;
        }

        public Optional<double[]> c() {
            return this.d;
        }
    }

    protected static interface a {
        public void consume(int var1, int var2, Holder<BiomeBase> var3);
    }

    protected static interface c {
        public void consume(int var1, int var2, double var3);
    }

    protected static interface b {
        public void consume(int var1, int var2, int var3, double var4);
    }
}

