/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.carver;

import com.google.common.collect.ImmutableSet;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.chunk.CarvingMask;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.levelgen.Aquifer;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.carver.CanyonCarverConfiguration;
import net.minecraft.world.level.levelgen.carver.CarvingContext;
import net.minecraft.world.level.levelgen.carver.CaveCarverConfiguration;
import net.minecraft.world.level.levelgen.carver.WorldGenCanyon;
import net.minecraft.world.level.levelgen.carver.WorldGenCarverConfiguration;
import net.minecraft.world.level.levelgen.carver.WorldGenCarverWrapper;
import net.minecraft.world.level.levelgen.carver.WorldGenCaves;
import net.minecraft.world.level.levelgen.carver.WorldGenCavesHell;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.material.FluidTypes;
import org.apache.commons.lang3.mutable.MutableBoolean;

public abstract class WorldGenCarverAbstract<C extends WorldGenCarverConfiguration> {
    public static final WorldGenCarverAbstract<CaveCarverConfiguration> a = WorldGenCarverAbstract.a("cave", new WorldGenCaves(CaveCarverConfiguration.a));
    public static final WorldGenCarverAbstract<CaveCarverConfiguration> b = WorldGenCarverAbstract.a("nether_cave", new WorldGenCavesHell(CaveCarverConfiguration.a));
    public static final WorldGenCarverAbstract<CanyonCarverConfiguration> c = WorldGenCarverAbstract.a("canyon", new WorldGenCanyon(CanyonCarverConfiguration.a));
    protected static final IBlockData d = Blocks.a.m();
    protected static final IBlockData e = Blocks.nx.m();
    protected static final Fluid f = FluidTypes.c.g();
    protected static final Fluid g = FluidTypes.e.g();
    protected Set<FluidType> h = ImmutableSet.of((Object)FluidTypes.c);
    private final MapCodec<WorldGenCarverWrapper<C>> i;

    private static <C extends WorldGenCarverConfiguration, F extends WorldGenCarverAbstract<C>> F a(String name, F carver) {
        return (F)IRegistry.a(BuiltInRegistries.N, name, carver);
    }

    public WorldGenCarverAbstract(Codec<C> configCodec) {
        this.i = configCodec.fieldOf("config").xmap(this::a, WorldGenCarverWrapper::b);
    }

    public WorldGenCarverWrapper<C> a(C config) {
        return new WorldGenCarverWrapper<C>(this, config);
    }

    public MapCodec<WorldGenCarverWrapper<C>> c() {
        return this.i;
    }

    public int d() {
        return 4;
    }

    protected boolean a(CarvingContext context, C config, IChunkAccess chunk, Function<BlockPosition, Holder<BiomeBase>> posToBiome, Aquifer aquiferSampler, double x2, double y2, double z2, double width, double height, CarvingMask mask, a skipPredicate) {
        ChunkCoordIntPair chunkPos = chunk.f();
        double d2 = chunkPos.b();
        double e2 = chunkPos.c();
        double f2 = 16.0 + width * 2.0;
        if (Math.abs(x2 - d2) > f2 || Math.abs(z2 - e2) > f2) {
            return false;
        }
        int i2 = chunkPos.d();
        int j2 = chunkPos.e();
        int k2 = Math.max(MathHelper.a(x2 - width) - i2 - 1, 0);
        int l2 = Math.min(MathHelper.a(x2 + width) - i2, 15);
        int m2 = Math.max(MathHelper.a(y2 - height) - 1, context.a() + 1);
        int n2 = chunk.A() ? 0 : 7;
        int o2 = Math.min(MathHelper.a(y2 + height) + 1, context.a() + context.b() - 1 - n2);
        int p2 = Math.max(MathHelper.a(z2 - width) - j2 - 1, 0);
        int q2 = Math.min(MathHelper.a(z2 + width) - j2, 15);
        boolean bl = false;
        BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition();
        BlockPosition.MutableBlockPosition mutableBlockPos2 = new BlockPosition.MutableBlockPosition();
        for (int r2 = k2; r2 <= l2; ++r2) {
            int s2 = chunkPos.a(r2);
            double g2 = ((double)s2 + 0.5 - x2) / width;
            for (int t2 = p2; t2 <= q2; ++t2) {
                int u2 = chunkPos.b(t2);
                double h2 = ((double)u2 + 0.5 - z2) / width;
                if (g2 * g2 + h2 * h2 >= 1.0) continue;
                MutableBoolean mutableBoolean = new MutableBoolean(false);
                for (int v2 = o2; v2 > m2; --v2) {
                    double w2 = ((double)v2 - 0.5 - y2) / height;
                    if (skipPredicate.shouldSkip(context, g2, w2, h2, v2) || mask.b(r2, v2, t2) && !WorldGenCarverAbstract.b(config)) continue;
                    mask.a(r2, v2, t2);
                    mutableBlockPos.d(s2, v2, u2);
                    bl |= this.a(context, config, chunk, posToBiome, mask, mutableBlockPos, mutableBlockPos2, aquiferSampler, mutableBoolean);
                }
            }
        }
        return bl;
    }

    protected boolean a(CarvingContext context, C config, IChunkAccess chunk, Function<BlockPosition, Holder<BiomeBase>> posToBiome, CarvingMask mask, BlockPosition.MutableBlockPosition pos, BlockPosition.MutableBlockPosition tmp, Aquifer aquiferSampler, MutableBoolean replacedGrassy) {
        IBlockData blockState = chunk.a_(pos);
        if (blockState.a(Blocks.i) || blockState.a(Blocks.fz)) {
            replacedGrassy.setTrue();
        }
        if (!this.a(config, blockState) && !WorldGenCarverAbstract.b(config)) {
            return false;
        }
        IBlockData blockState2 = this.a(context, config, pos, aquiferSampler);
        if (blockState2 == null) {
            return false;
        }
        chunk.a(pos, blockState2, false);
        if (aquiferSampler.a() && !blockState2.y().c()) {
            chunk.e(pos);
        }
        if (replacedGrassy.isTrue()) {
            tmp.a((BaseBlockPosition)pos, EnumDirection.a);
            if (chunk.a_(tmp).a(Blocks.j)) {
                context.a(posToBiome, chunk, tmp, !blockState2.y().c()).ifPresent(state -> {
                    chunk.a(tmp, (IBlockData)state, false);
                    if (!state.y().c()) {
                        chunk.e(tmp);
                    }
                });
            }
        }
        return true;
    }

    @Nullable
    private IBlockData a(CarvingContext context, C config, BlockPosition pos, Aquifer sampler) {
        if (pos.v() <= ((WorldGenCarverConfiguration)config).g.a(context)) {
            return g.g();
        }
        IBlockData blockState = sampler.a(new DensityFunction.e(pos.u(), pos.v(), pos.w()), 0.0);
        if (blockState == null) {
            return WorldGenCarverAbstract.b(config) ? ((WorldGenCarverConfiguration)config).h.e() : null;
        }
        return WorldGenCarverAbstract.b(config) ? WorldGenCarverAbstract.b(config, blockState) : blockState;
    }

    private static IBlockData b(WorldGenCarverConfiguration config, IBlockData state) {
        if (state.a(Blocks.a)) {
            return config.h.b();
        }
        if (state.a(Blocks.J)) {
            IBlockData blockState = config.h.c();
            if (blockState.b(BlockProperties.D)) {
                return (IBlockData)blockState.b(BlockProperties.D, true);
            }
            return blockState;
        }
        if (state.a(Blocks.K)) {
            return config.h.d();
        }
        return state;
    }

    public abstract boolean a(CarvingContext var1, C var2, IChunkAccess var3, Function<BlockPosition, Holder<BiomeBase>> var4, RandomSource var5, Aquifer var6, ChunkCoordIntPair var7, CarvingMask var8);

    public abstract boolean a(C var1, RandomSource var2);

    protected boolean a(C config, IBlockData state) {
        return state.a(((WorldGenCarverConfiguration)config).i);
    }

    protected static boolean a(ChunkCoordIntPair pos, double x2, double z2, int branchIndex, int branchCount, float baseWidth) {
        double i2;
        double h2;
        double e2;
        double g2;
        double d2 = pos.b();
        double f2 = x2 - d2;
        return f2 * f2 + (g2 = z2 - (e2 = (double)pos.c())) * g2 - (h2 = (double)(branchCount - branchIndex)) * h2 <= (i2 = (double)(baseWidth + 2.0f + 16.0f)) * i2;
    }

    private static boolean b(WorldGenCarverConfiguration config) {
        return config.h.a();
    }

    public static interface a {
        public boolean shouldSkip(CarvingContext var1, double var2, double var4, double var6, int var8);
    }
}

