/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import java.util.function.Predicate;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.RandomSource;
import net.minecraft.world.RandomizableContainer;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityMobSpawner;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.WorldGenerator;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureEmptyConfiguration;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.storage.loot.LootTables;
import org.slf4j.Logger;

public class WorldGenDungeons
extends WorldGenerator<WorldGenFeatureEmptyConfiguration> {
    private static final Logger a = LogUtils.getLogger();
    private static final EntityTypes<?>[] b = new EntityTypes[]{EntityTypes.bf, EntityTypes.bO, EntityTypes.bO, EntityTypes.bo};
    private static final IBlockData c = Blocks.nx.m();

    public WorldGenDungeons(Codec<WorldGenFeatureEmptyConfiguration> configCodec) {
        super(configCodec);
    }

    @Override
    @Override
    public boolean a(FeaturePlaceContext<WorldGenFeatureEmptyConfiguration> context) {
        Predicate<IBlockData> predicate = WorldGenerator.a(TagsBlock.bQ);
        BlockPosition blockPos = context.e();
        RandomSource randomSource = context.d();
        GeneratorAccessSeed worldGenLevel = context.b();
        int i2 = 3;
        int j2 = randomSource.a(2) + 2;
        int k2 = -j2 - 1;
        int l2 = j2 + 1;
        int m2 = -1;
        int n2 = 4;
        int o2 = randomSource.a(2) + 2;
        int p2 = -o2 - 1;
        int q2 = o2 + 1;
        int r2 = 0;
        for (int s2 = k2; s2 <= l2; ++s2) {
            for (int t2 = -1; t2 <= 4; ++t2) {
                for (int u2 = p2; u2 <= q2; ++u2) {
                    BlockPosition blockPos2 = blockPos.b(s2, t2, u2);
                    boolean bl = worldGenLevel.a_(blockPos2).e();
                    if (t2 == -1 && !bl) {
                        return false;
                    }
                    if (t2 == 4 && !bl) {
                        return false;
                    }
                    if (s2 != k2 && s2 != l2 && u2 != p2 && u2 != q2 || t2 != 0 || !worldGenLevel.u(blockPos2) || !worldGenLevel.u(blockPos2.d())) continue;
                    ++r2;
                }
            }
        }
        if (r2 < 1 || r2 > 5) {
            return false;
        }
        for (int v2 = k2; v2 <= l2; ++v2) {
            for (int w2 = 3; w2 >= -1; --w2) {
                for (int x2 = p2; x2 <= q2; ++x2) {
                    BlockPosition blockPos3 = blockPos.b(v2, w2, x2);
                    IBlockData blockState = worldGenLevel.a_(blockPos3);
                    if (v2 == k2 || w2 == -1 || x2 == p2 || v2 == l2 || w2 == 4 || x2 == q2) {
                        if (blockPos3.v() >= worldGenLevel.L_() && !worldGenLevel.a_(blockPos3.e()).e()) {
                            worldGenLevel.a(blockPos3, c, 2);
                            continue;
                        }
                        if (!blockState.e() || blockState.a(Blocks.cD)) continue;
                        if (w2 == -1 && randomSource.a(4) != 0) {
                            this.a(worldGenLevel, blockPos3, Blocks.cu.m(), predicate);
                            continue;
                        }
                        this.a(worldGenLevel, blockPos3, Blocks.m.m(), predicate);
                        continue;
                    }
                    if (blockState.a(Blocks.cD) || blockState.a(Blocks.cA)) continue;
                    this.a(worldGenLevel, blockPos3, c, predicate);
                }
            }
        }
        block6: for (int y2 = 0; y2 < 2; ++y2) {
            for (int z2 = 0; z2 < 3; ++z2) {
                int ac;
                int ab;
                int aa2 = blockPos.u() + randomSource.a(j2 * 2 + 1) - j2;
                BlockPosition blockPos4 = new BlockPosition(aa2, ab = blockPos.v(), ac = blockPos.w() + randomSource.a(o2 * 2 + 1) - o2);
                if (!worldGenLevel.u(blockPos4)) continue;
                int ad = 0;
                for (EnumDirection direction : EnumDirection.EnumDirectionLimit.a) {
                    if (!worldGenLevel.a_(blockPos4.a(direction)).e()) continue;
                    ++ad;
                }
                if (ad != 1) continue;
                this.a(worldGenLevel, blockPos4, StructurePiece.a(worldGenLevel, blockPos4, Blocks.cD.m()), predicate);
                RandomizableContainer.a(worldGenLevel, randomSource, blockPos4, LootTables.c);
                continue block6;
            }
        }
        this.a(worldGenLevel, blockPos, Blocks.cA.m(), predicate);
        TileEntity blockEntity = worldGenLevel.c_(blockPos);
        if (blockEntity instanceof TileEntityMobSpawner) {
            TileEntityMobSpawner spawnerBlockEntity = (TileEntityMobSpawner)blockEntity;
            spawnerBlockEntity.a(this.a(randomSource), randomSource);
        } else {
            a.error("Failed to fetch mob spawner entity at ({}, {}, {})", new Object[]{blockPos.u(), blockPos.v(), blockPos.w()});
        }
        return true;
    }

    private EntityTypes<?> a(RandomSource random) {
        return SystemUtils.a(b, random);
    }
}

