/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.WorldGenerator;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureBasaltColumnsConfiguration;

public class WorldGenFeatureBasaltColumns
extends WorldGenerator<WorldGenFeatureBasaltColumnsConfiguration> {
    private static final ImmutableList<Block> a = ImmutableList.of((Object)Blocks.K, (Object)Blocks.I, (Object)Blocks.le, (Object)Blocks.ej, (Object)Blocks.fB, (Object)Blocks.fC, (Object)Blocks.fD, (Object)Blocks.fE, (Object)Blocks.cD, (Object)Blocks.cA);
    private static final int b = 5;
    private static final int c = 50;
    private static final int d = 8;
    private static final int ao = 15;

    public WorldGenFeatureBasaltColumns(Codec<WorldGenFeatureBasaltColumnsConfiguration> configCodec) {
        super(configCodec);
    }

    @Override
    @Override
    public boolean a(FeaturePlaceContext<WorldGenFeatureBasaltColumnsConfiguration> context) {
        int i2 = context.c().f();
        BlockPosition blockPos = context.e();
        GeneratorAccessSeed worldGenLevel = context.b();
        RandomSource randomSource = context.d();
        WorldGenFeatureBasaltColumnsConfiguration columnFeatureConfiguration = context.f();
        if (!WorldGenFeatureBasaltColumns.a((GeneratorAccess)worldGenLevel, i2, blockPos.k())) {
            return false;
        }
        int j2 = columnFeatureConfiguration.b().a(randomSource);
        boolean bl = randomSource.i() < 0.9f;
        int k2 = Math.min(j2, bl ? 5 : 8);
        int l2 = bl ? 50 : 15;
        boolean bl2 = false;
        for (BlockPosition blockPos2 : BlockPosition.a(randomSource, l2, blockPos.u() - k2, blockPos.v(), blockPos.w() - k2, blockPos.u() + k2, blockPos.v(), blockPos.w() + k2)) {
            int m2 = j2 - blockPos2.k(blockPos);
            if (m2 < 0) continue;
            bl2 |= this.a(worldGenLevel, i2, blockPos2, m2, columnFeatureConfiguration.a().a(randomSource));
        }
        return bl2;
    }

    private boolean a(GeneratorAccess world, int seaLevel, BlockPosition pos, int height, int reach) {
        boolean bl = false;
        block0: for (BlockPosition blockPos : BlockPosition.b(pos.u() - reach, pos.v(), pos.w() - reach, pos.u() + reach, pos.v(), pos.w() + reach)) {
            BlockPosition blockPos2;
            int i2 = blockPos.k(pos);
            BlockPosition blockPosition = blockPos2 = WorldGenFeatureBasaltColumns.a(world, seaLevel, blockPos) ? WorldGenFeatureBasaltColumns.a(world, seaLevel, blockPos.k(), i2) : WorldGenFeatureBasaltColumns.a(world, blockPos.k(), i2);
            if (blockPos2 == null) continue;
            BlockPosition.MutableBlockPosition mutableBlockPos = blockPos2.k();
            for (int j2 = height - i2 / 2; j2 >= 0; --j2) {
                if (WorldGenFeatureBasaltColumns.a(world, seaLevel, (BlockPosition)mutableBlockPos)) {
                    this.a(world, mutableBlockPos, Blocks.el.m());
                    mutableBlockPos.c(EnumDirection.b);
                    bl = true;
                    continue;
                }
                if (!world.a_(mutableBlockPos).a(Blocks.el)) continue block0;
                mutableBlockPos.c(EnumDirection.b);
            }
        }
        return bl;
    }

    @Nullable
    private static BlockPosition a(GeneratorAccess world, int seaLevel, BlockPosition.MutableBlockPosition mutablePos, int distance) {
        while (mutablePos.v() > world.L_() + 1 && distance > 0) {
            --distance;
            if (WorldGenFeatureBasaltColumns.a(world, seaLevel, mutablePos)) {
                return mutablePos;
            }
            mutablePos.c(EnumDirection.a);
        }
        return null;
    }

    private static boolean a(GeneratorAccess world, int seaLevel, BlockPosition.MutableBlockPosition mutablePos) {
        if (WorldGenFeatureBasaltColumns.a(world, seaLevel, (BlockPosition)mutablePos)) {
            IBlockData blockState = world.a_(mutablePos.c(EnumDirection.a));
            mutablePos.c(EnumDirection.b);
            return !blockState.l() && !a.contains((Object)blockState.b());
        }
        return false;
    }

    @Nullable
    private static BlockPosition a(GeneratorAccess world, BlockPosition.MutableBlockPosition mutablePos, int distance) {
        while (mutablePos.v() <= world.am() && distance > 0) {
            --distance;
            IBlockData blockState = world.a_(mutablePos);
            if (a.contains((Object)blockState.b())) {
                return null;
            }
            if (blockState.l()) {
                return mutablePos;
            }
            mutablePos.c(EnumDirection.b);
        }
        return null;
    }

    private static boolean a(GeneratorAccess world, int seaLevel, BlockPosition pos) {
        IBlockData blockState = world.a_(pos);
        return blockState.l() || blockState.a(Blocks.K) && pos.v() <= seaLevel;
    }
}

