/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.serialization.Codec;
import java.util.HashSet;
import java.util.List;
import java.util.OptionalInt;
import java.util.Set;
import java.util.function.BiConsumer;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.IWorldWriter;
import net.minecraft.world.level.VirtualLevelReadable;
import net.minecraft.world.level.block.BlockLeaves;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.WorldGenerator;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureTreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.WorldGenFoilagePlacer;
import net.minecraft.world.level.levelgen.feature.treedecorators.WorldGenFeatureTree;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructure;
import net.minecraft.world.phys.shapes.VoxelShapeBitSet;
import net.minecraft.world.phys.shapes.VoxelShapeDiscrete;

public class WorldGenTrees
extends WorldGenerator<WorldGenFeatureTreeConfiguration> {
    private static final int a = 19;

    public WorldGenTrees(Codec<WorldGenFeatureTreeConfiguration> configCodec) {
        super(configCodec);
    }

    private static boolean d(VirtualLevelReadable world, BlockPosition pos) {
        return world.a(pos, (IBlockData state) -> state.a(Blocks.ft));
    }

    public static boolean b(VirtualLevelReadable world, BlockPosition pos) {
        return world.a(pos, (IBlockData state) -> state.l() || state.a(TagsBlock.Q));
    }

    private static void b(IWorldWriter world, BlockPosition pos, IBlockData state) {
        world.a(pos, state, 19);
    }

    public static boolean c(VirtualLevelReadable world, BlockPosition pos) {
        return world.a(pos, (IBlockData state) -> state.l() || state.a(TagsBlock.cq));
    }

    private boolean a(GeneratorAccessSeed world, RandomSource random, BlockPosition pos, BiConsumer<BlockPosition, IBlockData> rootPlacerReplacer, BiConsumer<BlockPosition, IBlockData> trunkPlacerReplacer, WorldGenFoilagePlacer.b blockPlacer, WorldGenFeatureTreeConfiguration config) {
        int i2 = config.d.a(random);
        int j2 = config.f.a(random, i2, config);
        int k2 = i2 - j2;
        int l2 = config.f.a(random, k2);
        BlockPosition blockPos = config.g.map(rootPlacer -> rootPlacer.a(pos, random)).orElse(pos);
        int m2 = Math.min(pos.v(), blockPos.v());
        int n2 = Math.max(pos.v(), blockPos.v()) + i2 + 1;
        if (m2 < world.L_() + 1 || n2 > world.am() + 1) {
            return false;
        }
        OptionalInt optionalInt = config.h.c();
        int o2 = this.a((VirtualLevelReadable)world, i2, blockPos, config);
        if (o2 < i2 && (optionalInt.isEmpty() || o2 < optionalInt.getAsInt())) {
            return false;
        }
        if (config.g.isPresent() && !config.g.get().a(world, rootPlacerReplacer, random, pos, blockPos, config)) {
            return false;
        }
        List<WorldGenFoilagePlacer.a> list = config.d.a((VirtualLevelReadable)world, trunkPlacerReplacer, random, o2, blockPos, config);
        list.forEach(node -> treeConfiguration.f.a((VirtualLevelReadable)world, blockPlacer, random, config, o2, (WorldGenFoilagePlacer.a)node, j2, l2));
        return true;
    }

    private int a(VirtualLevelReadable world, int height, BlockPosition pos, WorldGenFeatureTreeConfiguration config) {
        BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition();
        for (int i2 = 0; i2 <= height + 1; ++i2) {
            int j2 = config.h.a(height, i2);
            for (int k2 = -j2; k2 <= j2; ++k2) {
                for (int l2 = -j2; l2 <= j2; ++l2) {
                    mutableBlockPos.a(pos, k2, i2, l2);
                    if (config.d.b(world, mutableBlockPos) && (config.j || !WorldGenTrees.d(world, mutableBlockPos))) continue;
                    return i2 - 2;
                }
            }
        }
        return height;
    }

    @Override
    @Override
    protected void a(IWorldWriter world, BlockPosition pos, IBlockData state) {
        WorldGenTrees.b(world, pos, state);
    }

    @Override
    @Override
    public final boolean a(FeaturePlaceContext<WorldGenFeatureTreeConfiguration> context) {
        final GeneratorAccessSeed worldGenLevel = context.b();
        RandomSource randomSource = context.d();
        BlockPosition blockPos = context.e();
        WorldGenFeatureTreeConfiguration treeConfiguration = context.f();
        HashSet set = Sets.newHashSet();
        HashSet set2 = Sets.newHashSet();
        final HashSet set3 = Sets.newHashSet();
        HashSet set4 = Sets.newHashSet();
        BiConsumer<BlockPosition, IBlockData> biConsumer = (pos, state) -> {
            set.add(pos.j());
            worldGenLevel.a((BlockPosition)pos, (IBlockData)state, 19);
        };
        BiConsumer<BlockPosition, IBlockData> biConsumer2 = (pos, state) -> {
            set2.add(pos.j());
            worldGenLevel.a((BlockPosition)pos, (IBlockData)state, 19);
        };
        WorldGenFoilagePlacer.b foliageSetter = new WorldGenFoilagePlacer.b(){

            @Override
            @Override
            public void a(BlockPosition pos, IBlockData state) {
                set3.add(pos.j());
                worldGenLevel.a(pos, state, 19);
            }

            @Override
            @Override
            public boolean a(BlockPosition pos) {
                return set3.contains(pos);
            }
        };
        BiConsumer<BlockPosition, IBlockData> biConsumer3 = (pos, state) -> {
            set4.add(pos.j());
            worldGenLevel.a((BlockPosition)pos, (IBlockData)state, 19);
        };
        boolean bl = this.a(worldGenLevel, randomSource, blockPos, biConsumer, biConsumer2, foliageSetter, treeConfiguration);
        if (!bl || set2.isEmpty() && set3.isEmpty()) {
            return false;
        }
        if (!treeConfiguration.i.isEmpty()) {
            WorldGenFeatureTree.a context2 = new WorldGenFeatureTree.a(worldGenLevel, biConsumer3, randomSource, set2, set3, set);
            treeConfiguration.i.forEach(decorator -> decorator.a(context2));
        }
        return StructureBoundingBox.a(Iterables.concat((Iterable)set, (Iterable)set2, (Iterable)set3, (Iterable)set4)).map(box -> {
            VoxelShapeDiscrete discreteVoxelShape = WorldGenTrees.a((GeneratorAccess)worldGenLevel, box, (Set<BlockPosition>)set2, (Set<BlockPosition>)set4, set);
            DefinedStructure.a(worldGenLevel, 3, discreteVoxelShape, box.h(), box.i(), box.j());
            return true;
        }).orElse(false);
    }

    /*
     * Unable to fully structure code
     */
    private static VoxelShapeDiscrete a(GeneratorAccess world, StructureBoundingBox box, Set<BlockPosition> trunkPositions, Set<BlockPosition> decorationPositions, Set<BlockPosition> rootPositions) {
        discreteVoxelShape = new VoxelShapeBitSet(box.d(), box.e(), box.f());
        i = 7;
        list = Lists.newArrayList();
        for (j = 0; j < 7; ++j) {
            list.add(Sets.newHashSet());
        }
        for (BlockPosition blockPos : Lists.newArrayList((Iterable)Sets.union(decorationPositions, rootPositions))) {
            if (!box.b(blockPos)) continue;
            discreteVoxelShape.c(blockPos.u() - box.h(), blockPos.v() - box.i(), blockPos.w() - box.j());
        }
        mutableBlockPos = new BlockPosition.MutableBlockPosition();
        k = 0;
        ((Set)list.get(0)).addAll(trunkPositions);
        block2: while (true) {
            if (k < 7 && ((Set)list.get(k)).isEmpty()) {
                ++k;
                continue;
            }
            if (k >= 7) break;
            iterator = ((Set)list.get(k)).iterator();
            blockPos2 = (BlockPosition)iterator.next();
            iterator.remove();
            if (!box.b(blockPos2)) continue;
            if (k != 0) {
                blockState = world.a_(blockPos2);
                WorldGenTrees.b(world, blockPos2, (IBlockData)blockState.b(BlockProperties.aD, k));
            }
            discreteVoxelShape.c(blockPos2.u() - box.h(), blockPos2.v() - box.i(), blockPos2.w() - box.j());
            var12_14 = EnumDirection.values();
            var13_15 = var12_14.length;
            var14_16 = 0;
            while (true) {
                if (var14_16 < var13_15) ** break;
                continue block2;
                direction = var12_14[var14_16];
                mutableBlockPos.a((BaseBlockPosition)blockPos2, direction);
                if (box.b(mutableBlockPos) && !discreteVoxelShape.b(l = mutableBlockPos.u() - box.h(), m = mutableBlockPos.v() - box.i(), n = mutableBlockPos.w() - box.j()) && !(optionalInt = BlockLeaves.q(blockState2 = world.a_(mutableBlockPos))).isEmpty() && (o = Math.min(optionalInt.getAsInt(), k + 1)) < 7) {
                    ((Set)list.get(o)).add(mutableBlockPos.j());
                    k = Math.min(k, o);
                }
                ++var14_16;
            }
            break;
        }
        return discreteVoxelShape;
    }
}

