/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.levelgen.structure.PersistentIndexed;
import net.minecraft.world.level.storage.WorldPersistentData;

public class PersistentStructureLegacy {
    private static final Map<String, String> a = SystemUtils.a(Maps.newHashMap(), (? super T hashmap) -> {
        hashmap.put("Village", "Village");
        hashmap.put("Mineshaft", "Mineshaft");
        hashmap.put("Mansion", "Mansion");
        hashmap.put("Igloo", "Temple");
        hashmap.put("Desert_Pyramid", "Temple");
        hashmap.put("Jungle_Pyramid", "Temple");
        hashmap.put("Swamp_Hut", "Temple");
        hashmap.put("Stronghold", "Stronghold");
        hashmap.put("Monument", "Monument");
        hashmap.put("Fortress", "Fortress");
        hashmap.put("EndCity", "EndCity");
    });
    private static final Map<String, String> b = SystemUtils.a(Maps.newHashMap(), (? super T hashmap) -> {
        hashmap.put("Iglu", "Igloo");
        hashmap.put("TeDP", "Desert_Pyramid");
        hashmap.put("TeJP", "Jungle_Pyramid");
        hashmap.put("TeSH", "Swamp_Hut");
    });
    private static final Set<String> c = Set.of("pillager_outpost", "mineshaft", "mansion", "jungle_pyramid", "desert_pyramid", "igloo", "ruined_portal", "shipwreck", "swamp_hut", "stronghold", "monument", "ocean_ruin", "fortress", "endcity", "buried_treasure", "village", "nether_fossil", "bastion_remnant");
    private final boolean d;
    private final Map<String, Long2ObjectMap<NBTTagCompound>> e = Maps.newHashMap();
    private final Map<String, PersistentIndexed> f = Maps.newHashMap();
    private final List<String> g;
    private final List<String> h;

    public PersistentStructureLegacy(@Nullable WorldPersistentData persistentStateManager, List<String> oldNames, List<String> newNames) {
        this.g = oldNames;
        this.h = newNames;
        this.a(persistentStateManager);
        boolean flag = false;
        for (String s2 : this.h) {
            flag |= this.e.get(s2) != null;
        }
        this.d = flag;
    }

    public void a(long chunkPos) {
        for (String s2 : this.g) {
            PersistentIndexed persistentindexed = this.f.get(s2);
            if (persistentindexed == null || !persistentindexed.c(chunkPos)) continue;
            persistentindexed.d(chunkPos);
        }
    }

    public NBTTagCompound a(NBTTagCompound nbt) {
        NBTTagCompound nbttagcompound1 = nbt.p("Level");
        ChunkCoordIntPair chunkcoordintpair = new ChunkCoordIntPair(nbttagcompound1.h("xPos"), nbttagcompound1.h("zPos"));
        if (this.a(chunkcoordintpair.h, chunkcoordintpair.i)) {
            nbt = this.a(nbt, chunkcoordintpair);
        }
        NBTTagCompound nbttagcompound2 = nbttagcompound1.p("Structures");
        NBTTagCompound nbttagcompound3 = nbttagcompound2.p("References");
        for (String s2 : this.h) {
            boolean flag = c.contains(s2.toLowerCase(Locale.ROOT));
            if (nbttagcompound3.b(s2, 12) || !flag) continue;
            boolean flag1 = true;
            LongArrayList longarraylist = new LongArrayList();
            for (int i2 = chunkcoordintpair.h - 8; i2 <= chunkcoordintpair.h + 8; ++i2) {
                for (int j2 = chunkcoordintpair.i - 8; j2 <= chunkcoordintpair.i + 8; ++j2) {
                    if (!this.a(i2, j2, s2)) continue;
                    longarraylist.add(ChunkCoordIntPair.c(i2, j2));
                }
            }
            nbttagcompound3.c(s2, (List<Long>)longarraylist);
        }
        nbttagcompound2.a("References", nbttagcompound3);
        nbttagcompound1.a("Structures", nbttagcompound2);
        nbt.a("Level", nbttagcompound1);
        return nbt;
    }

    private boolean a(int chunkX, int chunkZ, String id) {
        return !this.d ? false : this.e.get(id) != null && this.f.get(a.get(id)).b(ChunkCoordIntPair.c(chunkX, chunkZ));
    }

    private boolean a(int chunkX, int chunkZ) {
        String s2;
        if (!this.d) {
            return false;
        }
        Iterator<String> iterator = this.h.iterator();
        do {
            if (iterator.hasNext()) continue;
            return false;
        } while (this.e.get(s2 = iterator.next()) == null || !this.f.get(a.get(s2)).c(ChunkCoordIntPair.c(chunkX, chunkZ)));
        return true;
    }

    private NBTTagCompound a(NBTTagCompound nbt, ChunkCoordIntPair pos) {
        NBTTagCompound nbttagcompound1 = nbt.p("Level");
        NBTTagCompound nbttagcompound2 = nbttagcompound1.p("Structures");
        NBTTagCompound nbttagcompound3 = nbttagcompound2.p("Starts");
        for (String s2 : this.h) {
            NBTTagCompound nbttagcompound4;
            Long2ObjectMap<NBTTagCompound> long2objectmap = this.e.get(s2);
            if (long2objectmap == null) continue;
            long i2 = pos.a();
            if (!this.f.get(a.get(s2)).c(i2) || (nbttagcompound4 = (NBTTagCompound)long2objectmap.get(i2)) == null) continue;
            nbttagcompound3.a(s2, nbttagcompound4);
        }
        nbttagcompound2.a("Starts", nbttagcompound3);
        nbttagcompound1.a("Structures", nbttagcompound2);
        nbt.a("Level", nbttagcompound1);
        return nbt;
    }

    private void a(@Nullable WorldPersistentData persistentStateManager) {
        if (persistentStateManager != null) {
            for (String s2 : this.g) {
                NBTTagCompound nbttagcompound = new NBTTagCompound();
                try {
                    nbttagcompound = persistentStateManager.a(s2, DataFixTypes.o, 1493).p("data").p("Features");
                    if (nbttagcompound.g()) {
                        continue;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                for (String s1 : nbttagcompound.e()) {
                    String s22;
                    String s3;
                    NBTTagCompound nbttagcompound1 = nbttagcompound.p(s1);
                    long i2 = ChunkCoordIntPair.c(nbttagcompound1.h("ChunkX"), nbttagcompound1.h("ChunkZ"));
                    NBTTagList nbttaglist = nbttagcompound1.c("Children", 10);
                    if (!nbttaglist.isEmpty() && (s3 = b.get(s22 = nbttaglist.a(0).l("id"))) != null) {
                        nbttagcompound1.a("id", s3);
                    }
                    s22 = nbttagcompound1.l("id");
                    this.e.computeIfAbsent(s22, s4 -> new Long2ObjectOpenHashMap()).put(i2, (Object)nbttagcompound1);
                }
                String s42 = s2 + "_index";
                PersistentIndexed persistentindexed = persistentStateManager.a(PersistentIndexed.a(), s42);
                if (persistentindexed.b().isEmpty()) {
                    PersistentIndexed persistentindexed1 = new PersistentIndexed();
                    this.f.put(s2, persistentindexed1);
                    for (String s5 : nbttagcompound.e()) {
                        NBTTagCompound nbttagcompound2 = nbttagcompound.p(s5);
                        persistentindexed1.a(ChunkCoordIntPair.c(nbttagcompound2.h("ChunkX"), nbttagcompound2.h("ChunkZ")));
                    }
                    continue;
                }
                this.f.put(s2, persistentindexed);
            }
        }
    }

    public static PersistentStructureLegacy a(ResourceKey<WorldDimension> world, @Nullable WorldPersistentData persistentStateManager) {
        if (world == WorldDimension.b) {
            return new PersistentStructureLegacy(persistentStateManager, (List<String>)ImmutableList.of((Object)"Monument", (Object)"Stronghold", (Object)"Village", (Object)"Mineshaft", (Object)"Temple", (Object)"Mansion"), (List<String>)ImmutableList.of((Object)"Village", (Object)"Mineshaft", (Object)"Mansion", (Object)"Igloo", (Object)"Desert_Pyramid", (Object)"Jungle_Pyramid", (Object)"Swamp_Hut", (Object)"Stronghold", (Object)"Monument"));
        }
        if (world == WorldDimension.c) {
            ImmutableList immutablelist = ImmutableList.of((Object)"Fortress");
            return new PersistentStructureLegacy(persistentStateManager, (List<String>)immutablelist, (List<String>)immutablelist);
        }
        if (world == WorldDimension.d) {
            ImmutableList immutablelist = ImmutableList.of((Object)"EndCity");
            return new PersistentStructureLegacy(persistentStateManager, (List<String>)immutablelist, (List<String>)immutablelist);
        }
        throw new RuntimeException(String.format(Locale.ROOT, "Unknown dimension type : %s", world));
    }
}

