/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.pools;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructurePoolEmpty;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructurePoolStructure;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructurePoolTemplate;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructurePools;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructure;
import net.minecraft.world.level.levelgen.structure.templatesystem.LiquidSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;

public class WorldGenFeatureDefinedStructurePoolList
extends WorldGenFeatureDefinedStructurePoolStructure {
    public static final MapCodec<WorldGenFeatureDefinedStructurePoolList> a = RecordCodecBuilder.mapCodec(instance -> instance.group((App)WorldGenFeatureDefinedStructurePoolStructure.f.listOf().fieldOf("elements").forGetter(pool -> pool.b), WorldGenFeatureDefinedStructurePoolList.e()).apply((Applicative)instance, WorldGenFeatureDefinedStructurePoolList::new));
    private final List<WorldGenFeatureDefinedStructurePoolStructure> b;

    public WorldGenFeatureDefinedStructurePoolList(List<WorldGenFeatureDefinedStructurePoolStructure> elements, WorldGenFeatureDefinedStructurePoolTemplate.Matching projection) {
        super(projection);
        if (elements.isEmpty()) {
            throw new IllegalArgumentException("Elements are empty");
        }
        this.b = elements;
        this.b(projection);
    }

    @Override
    @Override
    public BaseBlockPosition a(StructureTemplateManager structureTemplateManager, EnumBlockRotation rotation) {
        int i2 = 0;
        int j2 = 0;
        int k2 = 0;
        for (WorldGenFeatureDefinedStructurePoolStructure structurePoolElement : this.b) {
            BaseBlockPosition vec3i = structurePoolElement.a(structureTemplateManager, rotation);
            i2 = Math.max(i2, vec3i.u());
            j2 = Math.max(j2, vec3i.v());
            k2 = Math.max(k2, vec3i.w());
        }
        return new BaseBlockPosition(i2, j2, k2);
    }

    @Override
    @Override
    public List<DefinedStructure.a> a(StructureTemplateManager structureTemplateManager, BlockPosition pos, EnumBlockRotation rotation, RandomSource random) {
        return this.b.get(0).a(structureTemplateManager, pos, rotation, random);
    }

    @Override
    @Override
    public StructureBoundingBox a(StructureTemplateManager structureTemplateManager, BlockPosition pos, EnumBlockRotation rotation) {
        Stream<StructureBoundingBox> stream = this.b.stream().filter(element -> element != WorldGenFeatureDefinedStructurePoolEmpty.b).map(element -> element.a(structureTemplateManager, pos, rotation));
        return StructureBoundingBox.b(stream::iterator).orElseThrow(() -> new IllegalStateException("Unable to calculate boundingbox for ListPoolElement"));
    }

    @Override
    @Override
    public boolean a(StructureTemplateManager structureTemplateManager, GeneratorAccessSeed world, StructureManager structureAccessor, ChunkGenerator chunkGenerator, BlockPosition pos, BlockPosition pivot, EnumBlockRotation rotation, StructureBoundingBox box, RandomSource random, LiquidSettings liquidSettings, boolean keepJigsaws) {
        for (WorldGenFeatureDefinedStructurePoolStructure structurePoolElement : this.b) {
            if (structurePoolElement.a(structureTemplateManager, world, structureAccessor, chunkGenerator, pos, pivot, rotation, box, random, liquidSettings, keepJigsaws)) continue;
            return false;
        }
        return true;
    }

    @Override
    @Override
    public WorldGenFeatureDefinedStructurePools<?> a() {
        return WorldGenFeatureDefinedStructurePools.b;
    }

    @Override
    @Override
    public WorldGenFeatureDefinedStructurePoolStructure a(WorldGenFeatureDefinedStructurePoolTemplate.Matching projection) {
        super.a(projection);
        this.b(projection);
        return this;
    }

    @Override
    public String toString() {
        return "List[" + this.b.stream().map(Object::toString).collect(Collectors.joining(", ")) + "]";
    }

    private void b(WorldGenFeatureDefinedStructurePoolTemplate.Matching projection) {
        this.b.forEach(element -> element.a(projection));
    }
}

