/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.structures;

import com.mojang.serialization.MapCodec;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.RandomSupport;
import net.minecraft.world.level.levelgen.SeededRandom;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.PiecesContainer;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.structures.OceanMonumentPieces;

public class OceanMonumentStructure
extends Structure {
    public static final MapCodec<OceanMonumentStructure> d = OceanMonumentStructure.a(OceanMonumentStructure::new);

    public OceanMonumentStructure(Structure.c config) {
        super(config);
    }

    @Override
    @Override
    public Optional<Structure.b> a(Structure.a context) {
        int i2 = context.h().a(9);
        int j2 = context.h().b(9);
        Set<Holder<BiomeBase>> set = context.c().a(i2, context.b().f(), j2, 29, context.d().b());
        for (Holder<BiomeBase> holder : set) {
            if (holder.a(BiomeTags.X)) continue;
            return Optional.empty();
        }
        return OceanMonumentStructure.a(context, HeightMap.Type.c, (StructurePiecesBuilder collector) -> OceanMonumentStructure.a(collector, context));
    }

    private static StructurePiece a(ChunkCoordIntPair pos, SeededRandom random) {
        int i2 = pos.d() - 29;
        int j2 = pos.e() - 29;
        EnumDirection direction = EnumDirection.EnumDirectionLimit.a.a(random);
        return new OceanMonumentPieces.h(random, i2, j2, direction);
    }

    private static void a(StructurePiecesBuilder collector, Structure.a context) {
        collector.a(OceanMonumentStructure.a(context.h(), context.f()));
    }

    public static PiecesContainer a(ChunkCoordIntPair pos, long worldSeed, PiecesContainer pieces) {
        if (pieces.a()) {
            return pieces;
        }
        SeededRandom worldgenRandom = new SeededRandom(new LegacyRandomSource(RandomSupport.a()));
        worldgenRandom.c(worldSeed, pos.h, pos.i);
        StructurePiece structurePiece = pieces.c().get(0);
        StructureBoundingBox boundingBox = structurePiece.f();
        int i2 = boundingBox.h();
        int j2 = boundingBox.j();
        EnumDirection direction = EnumDirection.EnumDirectionLimit.a.a(worldgenRandom);
        EnumDirection direction2 = Objects.requireNonNullElse(structurePiece.i(), direction);
        OceanMonumentPieces.h structurePiece2 = new OceanMonumentPieces.h(worldgenRandom, i2, j2, direction2);
        StructurePiecesBuilder structurePiecesBuilder = new StructurePiecesBuilder();
        structurePiecesBuilder.a(structurePiece2);
        return structurePiecesBuilder.a();
    }

    @Override
    @Override
    public StructureType<?> e() {
        return StructureType.j;
    }
}

