/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.structures;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.monster.EntityDrowned;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockChest;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.structure.DefinedStructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.WorldGenFeatureStructurePieceType;
import net.minecraft.world.level.levelgen.structure.structures.OceanRuinStructure;
import net.minecraft.world.level.levelgen.structure.templatesystem.CappedProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructure;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureInfo;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureProcessorBlockIgnore;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureProcessorPredicates;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureProcessorRotation;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureProcessorRule;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureTestBlock;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureTestTrue;
import net.minecraft.world.level.levelgen.structure.templatesystem.PosRuleTestTrue;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.level.levelgen.structure.templatesystem.rule.blockentity.AppendLoot;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTables;
import org.bukkit.craftbukkit.v1_21_R2.CraftLootTable;
import org.bukkit.craftbukkit.v1_21_R2.block.CraftBlockStates;
import org.bukkit.craftbukkit.v1_21_R2.block.CraftChest;

public class OceanRuinPieces {
    static final DefinedStructureProcessor a = OceanRuinPieces.a(Blocks.L, Blocks.M, LootTables.bb);
    static final DefinedStructureProcessor b = OceanRuinPieces.a(Blocks.O, Blocks.P, LootTables.bc);
    private static final MinecraftKey[] c = new MinecraftKey[]{MinecraftKey.b("underwater_ruin/warm_1"), MinecraftKey.b("underwater_ruin/warm_2"), MinecraftKey.b("underwater_ruin/warm_3"), MinecraftKey.b("underwater_ruin/warm_4"), MinecraftKey.b("underwater_ruin/warm_5"), MinecraftKey.b("underwater_ruin/warm_6"), MinecraftKey.b("underwater_ruin/warm_7"), MinecraftKey.b("underwater_ruin/warm_8")};
    private static final MinecraftKey[] d = new MinecraftKey[]{MinecraftKey.b("underwater_ruin/brick_1"), MinecraftKey.b("underwater_ruin/brick_2"), MinecraftKey.b("underwater_ruin/brick_3"), MinecraftKey.b("underwater_ruin/brick_4"), MinecraftKey.b("underwater_ruin/brick_5"), MinecraftKey.b("underwater_ruin/brick_6"), MinecraftKey.b("underwater_ruin/brick_7"), MinecraftKey.b("underwater_ruin/brick_8")};
    private static final MinecraftKey[] e = new MinecraftKey[]{MinecraftKey.b("underwater_ruin/cracked_1"), MinecraftKey.b("underwater_ruin/cracked_2"), MinecraftKey.b("underwater_ruin/cracked_3"), MinecraftKey.b("underwater_ruin/cracked_4"), MinecraftKey.b("underwater_ruin/cracked_5"), MinecraftKey.b("underwater_ruin/cracked_6"), MinecraftKey.b("underwater_ruin/cracked_7"), MinecraftKey.b("underwater_ruin/cracked_8")};
    private static final MinecraftKey[] f = new MinecraftKey[]{MinecraftKey.b("underwater_ruin/mossy_1"), MinecraftKey.b("underwater_ruin/mossy_2"), MinecraftKey.b("underwater_ruin/mossy_3"), MinecraftKey.b("underwater_ruin/mossy_4"), MinecraftKey.b("underwater_ruin/mossy_5"), MinecraftKey.b("underwater_ruin/mossy_6"), MinecraftKey.b("underwater_ruin/mossy_7"), MinecraftKey.b("underwater_ruin/mossy_8")};
    private static final MinecraftKey[] g = new MinecraftKey[]{MinecraftKey.b("underwater_ruin/big_brick_1"), MinecraftKey.b("underwater_ruin/big_brick_2"), MinecraftKey.b("underwater_ruin/big_brick_3"), MinecraftKey.b("underwater_ruin/big_brick_8")};
    private static final MinecraftKey[] h = new MinecraftKey[]{MinecraftKey.b("underwater_ruin/big_mossy_1"), MinecraftKey.b("underwater_ruin/big_mossy_2"), MinecraftKey.b("underwater_ruin/big_mossy_3"), MinecraftKey.b("underwater_ruin/big_mossy_8")};
    private static final MinecraftKey[] i = new MinecraftKey[]{MinecraftKey.b("underwater_ruin/big_cracked_1"), MinecraftKey.b("underwater_ruin/big_cracked_2"), MinecraftKey.b("underwater_ruin/big_cracked_3"), MinecraftKey.b("underwater_ruin/big_cracked_8")};
    private static final MinecraftKey[] j = new MinecraftKey[]{MinecraftKey.b("underwater_ruin/big_warm_4"), MinecraftKey.b("underwater_ruin/big_warm_5"), MinecraftKey.b("underwater_ruin/big_warm_6"), MinecraftKey.b("underwater_ruin/big_warm_7")};

    private static DefinedStructureProcessor a(Block baseBlock, Block suspiciousBlock, ResourceKey<LootTable> lootTable) {
        return new CappedProcessor(new DefinedStructureProcessorRule(List.of(new DefinedStructureProcessorPredicates(new DefinedStructureTestBlock(baseBlock), DefinedStructureTestTrue.b, PosRuleTestTrue.b, suspiciousBlock.m(), new AppendLoot(lootTable)))), ConstantInt.a(5));
    }

    private static MinecraftKey a(RandomSource random) {
        return (MinecraftKey)SystemUtils.a((Object[])c, random);
    }

    private static MinecraftKey b(RandomSource random) {
        return (MinecraftKey)SystemUtils.a((Object[])j, random);
    }

    public static void a(StructureTemplateManager manager, BlockPosition pos, EnumBlockRotation rotation, StructurePieceAccessor holder, RandomSource random, OceanRuinStructure structure) {
        boolean flag = random.i() <= structure.f;
        float f2 = flag ? 0.9f : 0.8f;
        OceanRuinPieces.a(manager, pos, rotation, holder, random, structure, flag, f2);
        if (flag && random.i() <= structure.g) {
            OceanRuinPieces.a(manager, random, rotation, pos, structure, holder);
        }
    }

    private static void a(StructureTemplateManager manager, RandomSource random, EnumBlockRotation rotation, BlockPosition pos, OceanRuinStructure structure, StructurePieceAccessor pieces) {
        BlockPosition blockposition1 = new BlockPosition(pos.u(), 90, pos.w());
        BlockPosition blockposition2 = DefinedStructure.a(new BlockPosition(15, 0, 15), EnumBlockMirror.a, rotation, BlockPosition.c).a(blockposition1);
        StructureBoundingBox structureboundingbox = StructureBoundingBox.a(blockposition1, blockposition2);
        BlockPosition blockposition3 = new BlockPosition(Math.min(blockposition1.u(), blockposition2.u()), blockposition1.v(), Math.min(blockposition1.w(), blockposition2.w()));
        List<BlockPosition> list = OceanRuinPieces.a(random, blockposition3);
        int i2 = MathHelper.a(random, 4, 8);
        for (int j2 = 0; j2 < i2; ++j2) {
            EnumBlockRotation enumblockrotation1;
            BlockPosition blockposition5;
            int k2;
            BlockPosition blockposition4;
            StructureBoundingBox structureboundingbox1;
            if (list.isEmpty() || (structureboundingbox1 = StructureBoundingBox.a(blockposition4 = list.remove(k2 = random.a(list.size())), blockposition5 = DefinedStructure.a(new BlockPosition(5, 0, 6), EnumBlockMirror.a, enumblockrotation1 = EnumBlockRotation.a(random), BlockPosition.c).a(blockposition4))).a(structureboundingbox)) continue;
            OceanRuinPieces.a(manager, blockposition4, enumblockrotation1, pieces, random, structure, false, 0.8f);
        }
    }

    private static List<BlockPosition> a(RandomSource random, BlockPosition pos) {
        ArrayList list = Lists.newArrayList();
        list.add(pos.b(-16 + MathHelper.a(random, 1, 8), 0, 16 + MathHelper.a(random, 1, 7)));
        list.add(pos.b(-16 + MathHelper.a(random, 1, 8), 0, MathHelper.a(random, 1, 7)));
        list.add(pos.b(-16 + MathHelper.a(random, 1, 8), 0, -16 + MathHelper.a(random, 4, 8)));
        list.add(pos.b(MathHelper.a(random, 1, 7), 0, 16 + MathHelper.a(random, 1, 7)));
        list.add(pos.b(MathHelper.a(random, 1, 7), 0, -16 + MathHelper.a(random, 4, 6)));
        list.add(pos.b(16 + MathHelper.a(random, 1, 7), 0, 16 + MathHelper.a(random, 3, 8)));
        list.add(pos.b(16 + MathHelper.a(random, 1, 7), 0, MathHelper.a(random, 1, 7)));
        list.add(pos.b(16 + MathHelper.a(random, 1, 7), 0, -16 + MathHelper.a(random, 4, 8)));
        return list;
    }

    private static void a(StructureTemplateManager manager, BlockPosition pos, EnumBlockRotation rotation, StructurePieceAccessor holder, RandomSource random, OceanRuinStructure structure, boolean large, float integrity) {
        switch (structure.e) {
            default: {
                MinecraftKey minecraftkey = large ? OceanRuinPieces.b(random) : OceanRuinPieces.a(random);
                holder.a(new a(manager, minecraftkey, pos, rotation, integrity, structure.e, large));
                break;
            }
            case b: {
                MinecraftKey[] aminecraftkey = large ? g : d;
                MinecraftKey[] aminecraftkey1 = large ? i : e;
                MinecraftKey[] aminecraftkey2 = large ? h : f;
                int i2 = random.a(aminecraftkey.length);
                holder.a(new a(manager, aminecraftkey[i2], pos, rotation, integrity, structure.e, large));
                holder.a(new a(manager, aminecraftkey1[i2], pos, rotation, 0.7f, structure.e, large));
                holder.a(new a(manager, aminecraftkey2[i2], pos, rotation, 0.5f, structure.e, large));
            }
        }
    }

    public static class a
    extends DefinedStructurePiece {
        private final OceanRuinStructure.a h;
        private final float i;
        private final boolean j;

        public a(StructureTemplateManager structureTemplateManager, MinecraftKey template, BlockPosition pos, EnumBlockRotation rotation, float integrity, OceanRuinStructure.a biomeType, boolean large) {
            super(WorldGenFeatureStructurePieceType.H, 0, structureTemplateManager, template, template.toString(), net.minecraft.world.level.levelgen.structure.structures.OceanRuinPieces$a.a(rotation, integrity, biomeType), pos);
            this.i = integrity;
            this.h = biomeType;
            this.j = large;
        }

        private a(StructureTemplateManager holder, NBTTagCompound nbt, EnumBlockRotation rotation, float integrity, OceanRuinStructure.a biomeType, boolean large) {
            super(WorldGenFeatureStructurePieceType.H, nbt, holder, minecraftkey -> net.minecraft.world.level.levelgen.structure.structures.OceanRuinPieces$a.a(rotation, integrity, biomeType));
            this.i = integrity;
            this.h = biomeType;
            this.j = large;
        }

        private static DefinedStructureInfo a(EnumBlockRotation rotation, float integrity, OceanRuinStructure.a temperature) {
            DefinedStructureProcessor definedstructureprocessor = temperature == OceanRuinStructure.a.b ? b : a;
            return new DefinedStructureInfo().a(rotation).a(EnumBlockMirror.a).a(new DefinedStructureProcessorRotation(integrity)).a(DefinedStructureProcessorBlockIgnore.d).a(definedstructureprocessor);
        }

        public static a a(StructureTemplateManager structureTemplateManager, NBTTagCompound nbt) {
            EnumBlockRotation enumblockrotation = EnumBlockRotation.valueOf(nbt.l("Rot"));
            float f2 = nbt.j("Integrity");
            OceanRuinStructure.a oceanruinstructure_a = OceanRuinStructure.a.valueOf(nbt.l("BiomeType"));
            boolean flag = nbt.q("IsLarge");
            return new a(structureTemplateManager, nbt, enumblockrotation, f2, oceanruinstructure_a, flag);
        }

        @Override
        protected void a(StructurePieceSerializationContext context, NBTTagCompound nbt) {
            super.a(context, nbt);
            nbt.a("Rot", this.c.d().name());
            nbt.a("Integrity", this.i);
            nbt.a("BiomeType", this.h.toString());
            nbt.a("IsLarge", this.j);
        }

        @Override
        protected void a(String metadata, BlockPosition pos, WorldAccess world, RandomSource random, StructureBoundingBox boundingBox) {
            EntityDrowned entitydrowned;
            if ("chest".equals(metadata)) {
                CraftChest craftChest = (CraftChest)CraftBlockStates.getBlockState((IWorldReader)world, pos, (IBlockData)Blocks.cD.m().b(BlockChest.e, world.b_(pos).a(TagsFluid.a)), null);
                craftChest.setSeed(random.g());
                craftChest.setLootTable(CraftLootTable.minecraftToBukkit(this.j ? LootTables.E : LootTables.D));
                this.placeCraftBlockEntity(world, pos, craftChest, 2);
            } else if ("drowned".equals(metadata) && (entitydrowned = EntityTypes.L.a(world.a(), EntitySpawnReason.d)) != null) {
                entitydrowned.ai();
                entitydrowned.a(pos, 0.0f, 0.0f);
                entitydrowned.a(world, world.d_(pos), EntitySpawnReason.d, (GroupDataEntity)null);
                world.a_(entitydrowned);
                if (pos.v() > world.O()) {
                    world.a(pos, Blocks.a.m(), 2);
                } else {
                    world.a(pos, Blocks.J.m(), 2);
                }
            }
        }

        @Override
        public void a(GeneratorAccessSeed world, StructureManager structureAccessor, ChunkGenerator chunkGenerator, RandomSource random, StructureBoundingBox chunkBox, ChunkCoordIntPair chunkPos, BlockPosition pivot) {
            int i2 = world.a(HeightMap.Type.c, this.d.u(), this.d.w());
            this.d = new BlockPosition(this.d.u(), i2, this.d.w());
            BlockPosition blockposition1 = DefinedStructure.a(new BlockPosition(this.b.a().u() - 1, 0, this.b.a().w() - 1), EnumBlockMirror.a, this.c.d(), BlockPosition.c).a(this.d);
            this.d = new BlockPosition(this.d.u(), this.a(this.d, world, blockposition1), this.d.w());
            super.a(world, structureAccessor, chunkGenerator, random, chunkBox, chunkPos, pivot);
        }

        private int a(BlockPosition start, IBlockAccess world, BlockPosition end) {
            int i2 = start.v();
            int j2 = 512;
            int k2 = i2 - 1;
            int l2 = 0;
            for (BlockPosition blockposition2 : BlockPosition.c(start, end)) {
                int i1 = blockposition2.u();
                int j1 = blockposition2.w();
                int k1 = start.v() - 1;
                BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition(i1, k1, j1);
                IBlockData iblockdata = world.a_(blockposition_mutableblockposition);
                Fluid fluid = world.b_(blockposition_mutableblockposition);
                while ((iblockdata.l() || fluid.a(TagsFluid.a) || iblockdata.a(TagsBlock.ap)) && k1 > world.L_() + 1) {
                    blockposition_mutableblockposition.d(i1, --k1, j1);
                    iblockdata = world.a_(blockposition_mutableblockposition);
                    fluid = world.b_(blockposition_mutableblockposition);
                }
                j2 = Math.min(j2, k1);
                if (k1 >= k2 - 2) continue;
                ++l2;
            }
            int l1 = Math.abs(start.u() - end.u());
            if (k2 - j2 > 2 && l2 > l1 - 2) {
                i2 = j2 + 1;
            }
            return i2;
        }
    }
}

