/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.templatesystem;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.RegistryBlockID;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Clearable;
import net.minecraft.world.RandomizableContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.decoration.EntityPainting;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.BlockAccessAir;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockJigsaw;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.IFluidContainer;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityJigsaw;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureInfo;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureProcessor;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShapeBitSet;
import net.minecraft.world.phys.shapes.VoxelShapeDiscrete;
import org.bukkit.craftbukkit.v1_21_R2.block.CraftBlockEntityState;
import org.bukkit.craftbukkit.v1_21_R2.block.CraftBlockState;
import org.bukkit.craftbukkit.v1_21_R2.block.CraftBlockStates;
import org.bukkit.craftbukkit.v1_21_R2.block.CraftLootable;
import org.bukkit.craftbukkit.v1_21_R2.persistence.CraftPersistentDataContainer;
import org.bukkit.craftbukkit.v1_21_R2.persistence.CraftPersistentDataTypeRegistry;
import org.bukkit.craftbukkit.v1_21_R2.util.CraftStructureTransformer;
import org.bukkit.craftbukkit.v1_21_R2.util.TransformerGeneratorAccess;

public class DefinedStructure {
    public static final String a = "palette";
    public static final String b = "palettes";
    public static final String c = "entities";
    public static final String d = "blocks";
    public static final String e = "pos";
    public static final String f = "state";
    public static final String g = "nbt";
    public static final String h = "pos";
    public static final String i = "blockPos";
    public static final String j = "nbt";
    public static final String k = "size";
    public final List<b> l = Lists.newArrayList();
    public final List<EntityInfo> m = Lists.newArrayList();
    private BaseBlockPosition n;
    private String o = "?";
    private static final CraftPersistentDataTypeRegistry DATA_TYPE_REGISTRY = new CraftPersistentDataTypeRegistry();
    public CraftPersistentDataContainer persistentDataContainer = new CraftPersistentDataContainer(DATA_TYPE_REGISTRY);

    public DefinedStructure() {
        this.n = BaseBlockPosition.h;
    }

    public BaseBlockPosition a() {
        return this.n;
    }

    public void a(String author) {
        this.o = author;
    }

    public String b() {
        return this.o;
    }

    public void a(World world, BlockPosition start, BaseBlockPosition dimensions, boolean includeEntities, @Nullable Block ignoredBlock) {
        if (dimensions.u() >= 1 && dimensions.v() >= 1 && dimensions.w() >= 1) {
            BlockPosition blockposition1 = start.a(dimensions).b(-1, -1, -1);
            ArrayList list = Lists.newArrayList();
            ArrayList list1 = Lists.newArrayList();
            ArrayList list2 = Lists.newArrayList();
            BlockPosition blockposition2 = new BlockPosition(Math.min(start.u(), blockposition1.u()), Math.min(start.v(), blockposition1.v()), Math.min(start.w(), blockposition1.w()));
            BlockPosition blockposition3 = new BlockPosition(Math.max(start.u(), blockposition1.u()), Math.max(start.v(), blockposition1.v()), Math.max(start.w(), blockposition1.w()));
            this.n = dimensions;
            for (BlockPosition blockposition4 : BlockPosition.c(blockposition2, blockposition3)) {
                BlockPosition blockposition5 = blockposition4.b(blockposition2);
                IBlockData iblockdata = world.a_(blockposition4);
                if (ignoredBlock != null && iblockdata.a(ignoredBlock)) continue;
                TileEntity tileentity = world.c_(blockposition4);
                BlockInfo definedstructure_blockinfo = tileentity != null ? new BlockInfo(blockposition5, iblockdata, tileentity.c(world.K_())) : new BlockInfo(blockposition5, iblockdata, null);
                DefinedStructure.a(definedstructure_blockinfo, list, list1, list2);
            }
            List<BlockInfo> list3 = DefinedStructure.a(list, list1, list2);
            this.l.clear();
            this.l.add(new b(list3));
            if (includeEntities) {
                this.a(world, blockposition2, blockposition3);
            } else {
                this.m.clear();
            }
        }
    }

    private static void a(BlockInfo blockInfo, List<BlockInfo> fullBlocks, List<BlockInfo> blocksWithNbt, List<BlockInfo> otherBlocks) {
        if (blockInfo.c != null) {
            blocksWithNbt.add(blockInfo);
        } else if (!blockInfo.b.b().n() && blockInfo.b.m(BlockAccessAir.a, BlockPosition.c)) {
            fullBlocks.add(blockInfo);
        } else {
            otherBlocks.add(blockInfo);
        }
    }

    private static List<BlockInfo> a(List<BlockInfo> fullBlocks, List<BlockInfo> blocksWithNbt, List<BlockInfo> otherBlocks) {
        Comparator<BlockInfo> comparator = Comparator.comparingInt(definedstructure_blockinfo -> definedstructure_blockinfo.a.v()).thenComparingInt(definedstructure_blockinfo -> definedstructure_blockinfo.a.u()).thenComparingInt(definedstructure_blockinfo -> definedstructure_blockinfo.a.w());
        fullBlocks.sort(comparator);
        otherBlocks.sort(comparator);
        blocksWithNbt.sort(comparator);
        ArrayList list3 = Lists.newArrayList();
        list3.addAll(fullBlocks);
        list3.addAll(otherBlocks);
        list3.addAll(blocksWithNbt);
        return list3;
    }

    private void a(World world, BlockPosition firstCorner, BlockPosition secondCorner) {
        List<Entity> list = world.a(Entity.class, AxisAlignedBB.a(firstCorner, secondCorner), (? super T entity) -> !(entity instanceof EntityHuman));
        this.m.clear();
        for (Entity entity2 : list) {
            Vec3D vec3d = new Vec3D(entity2.dB() - (double)firstCorner.u(), entity2.dD() - (double)firstCorner.v(), entity2.dH() - (double)firstCorner.w());
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            entity2.e(nbttagcompound);
            BlockPosition blockposition2 = entity2 instanceof EntityPainting ? ((EntityPainting)entity2).p().b(firstCorner) : BlockPosition.a(vec3d);
            this.m.add(new EntityInfo(vec3d, blockposition2, nbttagcompound.i()));
        }
    }

    public List<BlockInfo> a(BlockPosition pos, DefinedStructureInfo placementData, Block block) {
        return this.a(pos, placementData, block, true);
    }

    public List<a> a(BlockPosition pos, EnumBlockRotation rotation) {
        if (this.l.isEmpty()) {
            return new ArrayList<a>();
        }
        DefinedStructureInfo definedstructureinfo = new DefinedStructureInfo().a(rotation);
        List<a> list = definedstructureinfo.a(this.l, pos).a();
        ArrayList<a> list1 = new ArrayList<a>(list.size());
        for (a definedstructure_a : list) {
            BlockInfo definedstructure_blockinfo = definedstructure_a.a;
            list1.add(definedstructure_a.b(new BlockInfo(DefinedStructure.a(definedstructureinfo, definedstructure_blockinfo.a()).a(pos), definedstructure_blockinfo.b.a(definedstructureinfo.d()), definedstructure_blockinfo.c)));
        }
        return list1;
    }

    public ObjectArrayList<BlockInfo> a(BlockPosition pos, DefinedStructureInfo placementData, Block block, boolean transformed) {
        ObjectArrayList objectarraylist = new ObjectArrayList();
        StructureBoundingBox structureboundingbox = placementData.g();
        if (this.l.isEmpty()) {
            return objectarraylist;
        }
        for (BlockInfo definedstructure_blockinfo : placementData.a(this.l, pos).a(block)) {
            BlockPosition blockposition1;
            BlockPosition blockPosition = blockposition1 = transformed ? DefinedStructure.a(placementData, definedstructure_blockinfo.a).a(pos) : definedstructure_blockinfo.a;
            if (structureboundingbox != null && !structureboundingbox.b(blockposition1)) continue;
            objectarraylist.add((Object)new BlockInfo(blockposition1, definedstructure_blockinfo.b.a(placementData.d()), definedstructure_blockinfo.c));
        }
        return objectarraylist;
    }

    public BlockPosition a(DefinedStructureInfo placementData1, BlockPosition pos1, DefinedStructureInfo placementData2, BlockPosition pos2) {
        BlockPosition blockposition2 = DefinedStructure.a(placementData1, pos1);
        BlockPosition blockposition3 = DefinedStructure.a(placementData2, pos2);
        return blockposition2.b(blockposition3);
    }

    public static BlockPosition a(DefinedStructureInfo placementData, BlockPosition pos) {
        return DefinedStructure.a(pos, placementData.c(), placementData.d(), placementData.e());
    }

    public boolean a(WorldAccess world, BlockPosition pos, BlockPosition pivot, DefinedStructureInfo placementData, RandomSource random, int flags) {
        List<BlockInfo> list;
        if (this.l.isEmpty()) {
            return false;
        }
        WorldAccess wrappedAccess = world;
        CraftStructureTransformer structureTransformer = null;
        if (wrappedAccess instanceof TransformerGeneratorAccess) {
            TransformerGeneratorAccess transformerAccess = (TransformerGeneratorAccess)wrappedAccess;
            world = transformerAccess.getHandle();
            structureTransformer = transformerAccess.getStructureTransformer();
            if (structureTransformer != null && !structureTransformer.canTransformBlocks()) {
                structureTransformer = null;
            }
        }
        if (!((list = placementData.a(this.l, pos).b()).isEmpty() && (placementData.f() || this.m.isEmpty()) || this.n.u() < 1 || this.n.v() < 1 || this.n.w() < 1)) {
            IBlockData iblockdata1;
            TileEntity tileentity;
            StructureBoundingBox structureboundingbox = placementData.g();
            ArrayList list1 = Lists.newArrayListWithCapacity((int)(placementData.j() ? list.size() : 0));
            ArrayList list2 = Lists.newArrayListWithCapacity((int)(placementData.j() ? list.size() : 0));
            ArrayList list3 = Lists.newArrayListWithCapacity((int)list.size());
            int j2 = Integer.MAX_VALUE;
            int k2 = Integer.MAX_VALUE;
            int l2 = Integer.MAX_VALUE;
            int i1 = Integer.MIN_VALUE;
            int j1 = Integer.MIN_VALUE;
            int k1 = Integer.MIN_VALUE;
            List<BlockInfo> list4 = DefinedStructure.a(world, pos, pivot, placementData, list);
            for (BlockInfo definedstructure_blockinfo : list4) {
                BlockPosition blockposition2 = definedstructure_blockinfo.a;
                if (structureboundingbox != null && !structureboundingbox.b(blockposition2)) continue;
                Fluid fluid = placementData.j() ? world.b_(blockposition2) : null;
                IBlockData iblockdata = definedstructure_blockinfo.b.a(placementData.c()).a(placementData.d());
                if (definedstructure_blockinfo.c != null) {
                    tileentity = world.c_(blockposition2);
                    if (!(world instanceof GeneratorAccessSeed)) {
                        Clearable.a(tileentity);
                    }
                    world.a(blockposition2, Blocks.in.m(), 20);
                }
                if (structureTransformer != null) {
                    NBTTagCompound nBTTagCompound;
                    CraftBlockState craftBlockState = (CraftBlockState)CraftBlockStates.getBlockState((IWorldReader)world, blockposition2, iblockdata, null);
                    if (definedstructure_blockinfo.c != null && craftBlockState instanceof CraftBlockEntityState) {
                        CraftBlockEntityState entityState = (CraftBlockEntityState)craftBlockState;
                        entityState.loadData(definedstructure_blockinfo.c);
                        if (craftBlockState instanceof CraftLootable) {
                            CraftLootable craftLootable = (CraftLootable)craftBlockState;
                            craftLootable.setSeed(random.g());
                        }
                    }
                    craftBlockState = structureTransformer.transformCraftState(craftBlockState);
                    iblockdata = craftBlockState.getHandle();
                    if (craftBlockState instanceof CraftBlockEntityState) {
                        CraftBlockEntityState craftBlockEntityState = (CraftBlockEntityState)craftBlockState;
                        nBTTagCompound = craftBlockEntityState.getSnapshotNBT();
                    } else {
                        nBTTagCompound = null;
                    }
                    definedstructure_blockinfo = new BlockInfo(blockposition2, iblockdata, nBTTagCompound);
                }
                if (!world.a(blockposition2, iblockdata, flags)) continue;
                j2 = Math.min(j2, blockposition2.u());
                k2 = Math.min(k2, blockposition2.v());
                l2 = Math.min(l2, blockposition2.w());
                i1 = Math.max(i1, blockposition2.u());
                j1 = Math.max(j1, blockposition2.v());
                k1 = Math.max(k1, blockposition2.w());
                list3.add(Pair.of((Object)blockposition2, (Object)definedstructure_blockinfo.c));
                if (definedstructure_blockinfo.c != null && (tileentity = world.c_(blockposition2)) != null) {
                    if (structureTransformer == null && tileentity instanceof RandomizableContainer) {
                        definedstructure_blockinfo.c.a("LootTableSeed", random.g());
                    }
                    tileentity.c(definedstructure_blockinfo.c, world.K_());
                }
                if (fluid == null) continue;
                if (iblockdata.y().b()) {
                    list2.add(blockposition2);
                    continue;
                }
                if (!(iblockdata.b() instanceof IFluidContainer)) continue;
                ((IFluidContainer)((Object)iblockdata.b())).a(world, blockposition2, iblockdata, fluid);
                if (fluid.b()) continue;
                list1.add(blockposition2);
            }
            boolean flag = true;
            EnumDirection[] aenumdirection = new EnumDirection[]{EnumDirection.b, EnumDirection.c, EnumDirection.f, EnumDirection.d, EnumDirection.e};
            while (flag && !list1.isEmpty()) {
                flag = false;
                Iterator iterator1 = list1.iterator();
                while (iterator1.hasNext()) {
                    Block block;
                    BlockPosition blockposition3 = (BlockPosition)iterator1.next();
                    Fluid fluid1 = world.b_(blockposition3);
                    for (int l1 = 0; l1 < aenumdirection.length && !fluid1.b(); ++l1) {
                        BlockPosition blockposition4 = blockposition3.a(aenumdirection[l1]);
                        Fluid fluid2 = world.b_(blockposition4);
                        if (!fluid2.b() || list2.contains(blockposition4)) continue;
                        fluid1 = fluid2;
                    }
                    if (!fluid1.b() || !((block = (iblockdata1 = world.a_(blockposition3)).b()) instanceof IFluidContainer)) continue;
                    ((IFluidContainer)((Object)block)).a(world, blockposition3, iblockdata1, fluid1);
                    flag = true;
                    iterator1.remove();
                }
            }
            if (j2 <= i1) {
                if (!placementData.h()) {
                    VoxelShapeBitSet voxelshapebitset = new VoxelShapeBitSet(i1 - j2 + 1, j1 - k2 + 1, k1 - l2 + 1);
                    int i2 = j2;
                    int j22 = k2;
                    int l1 = l2;
                    for (Pair pair : list3) {
                        BlockPosition blockposition5 = (BlockPosition)pair.getFirst();
                        voxelshapebitset.c(blockposition5.u() - i2, blockposition5.v() - j22, blockposition5.w() - l1);
                    }
                    DefinedStructure.a(world, flags, voxelshapebitset, i2, j22, l1);
                }
                for (Pair pair1 : list3) {
                    BlockPosition blockposition6 = (BlockPosition)pair1.getFirst();
                    if (!placementData.h()) {
                        IBlockData iblockdata2;
                        iblockdata1 = world.a_(blockposition6);
                        if (iblockdata1 != (iblockdata2 = Block.b(iblockdata1, world, blockposition6))) {
                            world.a(blockposition6, iblockdata2, flags & 0xFFFFFFFE | 0x10);
                        }
                        world.b(blockposition6, iblockdata2.b());
                    }
                    if (pair1.getSecond() == null || (tileentity = world.c_(blockposition6)) == null || world instanceof GeneratorAccessSeed) continue;
                    tileentity.e();
                }
            }
            if (!placementData.f()) {
                this.a(wrappedAccess, pos, placementData.c(), placementData.d(), placementData.e(), structureboundingbox, placementData.k());
            }
            return true;
        }
        return false;
    }

    public static void a(GeneratorAccess world, int flags, VoxelShapeDiscrete set, BlockPosition startPos) {
        DefinedStructure.a(world, flags, set, startPos.u(), startPos.v(), startPos.w());
    }

    public static void a(GeneratorAccess world, int flags, VoxelShapeDiscrete set, int startX, int startY, int startZ) {
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition1 = new BlockPosition.MutableBlockPosition();
        set.a((EnumDirection enumdirection, int i1, int j1, int k1) -> {
            IBlockData iblockdata3;
            blockposition_mutableblockposition.d(startX + i1, startY + j1, startZ + k1);
            blockposition_mutableblockposition1.a((BaseBlockPosition)blockposition_mutableblockposition, enumdirection);
            IBlockData iblockdata = world.a_(blockposition_mutableblockposition);
            IBlockData iblockdata1 = world.a_(blockposition_mutableblockposition1);
            IBlockData iblockdata2 = iblockdata.a(world, world, blockposition_mutableblockposition, enumdirection, blockposition_mutableblockposition1, iblockdata1, world.H_());
            if (iblockdata != iblockdata2) {
                world.a((BlockPosition)blockposition_mutableblockposition, iblockdata2, flags & 0xFFFFFFFE);
            }
            if (iblockdata1 != (iblockdata3 = iblockdata1.a(world, world, blockposition_mutableblockposition1, enumdirection.g(), blockposition_mutableblockposition, iblockdata2, world.H_()))) {
                world.a((BlockPosition)blockposition_mutableblockposition1, iblockdata3, flags & 0xFFFFFFFE);
            }
        });
    }

    public static List<BlockInfo> a(WorldAccess world, BlockPosition pos, BlockPosition pivot, DefinedStructureInfo placementData, List<BlockInfo> infos) {
        ArrayList<BlockInfo> list1 = new ArrayList<BlockInfo>();
        List<BlockInfo> list2 = new ArrayList<BlockInfo>();
        for (BlockInfo definedstructure_blockinfo : infos) {
            BlockPosition blockposition2 = DefinedStructure.a(placementData, definedstructure_blockinfo.a).a(pos);
            BlockInfo definedstructure_blockinfo1 = new BlockInfo(blockposition2, definedstructure_blockinfo.b, definedstructure_blockinfo.c != null ? definedstructure_blockinfo.c.i() : null);
            Iterator<DefinedStructureProcessor> iterator1 = placementData.i().iterator();
            while (definedstructure_blockinfo1 != null && iterator1.hasNext()) {
                definedstructure_blockinfo1 = iterator1.next().a((IWorldReader)world, pos, pivot, definedstructure_blockinfo, definedstructure_blockinfo1, placementData);
            }
            if (definedstructure_blockinfo1 == null) continue;
            list2.add(definedstructure_blockinfo1);
            list1.add(definedstructure_blockinfo);
        }
        for (DefinedStructureProcessor definedstructureprocessor : placementData.i()) {
            list2 = definedstructureprocessor.a(world, pos, pivot, list1, list2, placementData);
        }
        return list2;
    }

    private void a(WorldAccess world, BlockPosition pos, EnumBlockMirror mirror, EnumBlockRotation rotation, BlockPosition pivot, @Nullable StructureBoundingBox area, boolean initializeMobs) {
        for (EntityInfo definedstructure_entityinfo : this.m) {
            BlockPosition blockposition2 = DefinedStructure.a(definedstructure_entityinfo.b, mirror, rotation, pivot).a(pos);
            if (area != null && !area.b(blockposition2)) continue;
            NBTTagCompound nbttagcompound = definedstructure_entityinfo.c.i();
            Vec3D vec3d = DefinedStructure.a(definedstructure_entityinfo.a, mirror, rotation, pivot);
            Vec3D vec3d1 = vec3d.b(pos.u(), pos.v(), pos.w());
            NBTTagList nbttaglist = new NBTTagList();
            nbttaglist.add(NBTTagDouble.a(vec3d1.d));
            nbttaglist.add(NBTTagDouble.a(vec3d1.e));
            nbttaglist.add(NBTTagDouble.a(vec3d1.f));
            nbttagcompound.a("Pos", nbttaglist);
            nbttagcompound.r("UUID");
            DefinedStructure.a(world, nbttagcompound).ifPresent(entity -> {
                float f2 = entity.a(rotation);
                entity.b(vec3d1.d, vec3d1.e, vec3d1.f, f2 += entity.a(mirror) - entity.dM(), entity.dO());
                if (initializeMobs && entity instanceof EntityInsentient) {
                    ((EntityInsentient)entity).a(world, world.d_(BlockPosition.a(vec3d1)), EntitySpawnReason.d, (GroupDataEntity)null);
                }
                world.a_((Entity)entity);
            });
        }
    }

    private static Optional<Entity> a(WorldAccess world, NBTTagCompound nbt) {
        return EntityTypes.create(nbt, world.a(), EntitySpawnReason.d, true);
    }

    public BaseBlockPosition a(EnumBlockRotation rotation) {
        switch (rotation) {
            case d: 
            case b: {
                return new BaseBlockPosition(this.n.w(), this.n.v(), this.n.u());
            }
        }
        return this.n;
    }

    public static BlockPosition a(BlockPosition pos, EnumBlockMirror mirror, EnumBlockRotation rotation, BlockPosition pivot) {
        int i2 = pos.u();
        int j2 = pos.v();
        int k2 = pos.w();
        boolean flag = true;
        switch (mirror) {
            case b: {
                k2 = -k2;
                break;
            }
            case c: {
                i2 = -i2;
                break;
            }
            default: {
                flag = false;
            }
        }
        int l2 = pivot.u();
        int i1 = pivot.w();
        switch (rotation) {
            case d: {
                return new BlockPosition(l2 - i1 + k2, j2, l2 + i1 - i2);
            }
            case b: {
                return new BlockPosition(l2 + i1 - k2, j2, i1 - l2 + i2);
            }
            case c: {
                return new BlockPosition(l2 + l2 - i2, j2, i1 + i1 - k2);
            }
        }
        return flag ? new BlockPosition(i2, j2, k2) : pos;
    }

    public static Vec3D a(Vec3D point, EnumBlockMirror mirror, EnumBlockRotation rotation, BlockPosition pivot) {
        double d0 = point.d;
        double d1 = point.e;
        double d2 = point.f;
        boolean flag = true;
        switch (mirror) {
            case b: {
                d2 = 1.0 - d2;
                break;
            }
            case c: {
                d0 = 1.0 - d0;
                break;
            }
            default: {
                flag = false;
            }
        }
        int i2 = pivot.u();
        int j2 = pivot.w();
        switch (rotation) {
            case d: {
                return new Vec3D((double)(i2 - j2) + d2, d1, (double)(i2 + j2 + 1) - d0);
            }
            case b: {
                return new Vec3D((double)(i2 + j2 + 1) - d2, d1, (double)(j2 - i2) + d0);
            }
            case c: {
                return new Vec3D((double)(i2 + i2 + 1) - d0, d1, (double)(j2 + j2 + 1) - d2);
            }
        }
        return flag ? new Vec3D(d0, d1, d2) : point;
    }

    public BlockPosition a(BlockPosition pos, EnumBlockMirror mirror, EnumBlockRotation rotation) {
        return DefinedStructure.a(pos, mirror, rotation, this.a().u(), this.a().w());
    }

    public static BlockPosition a(BlockPosition pos, EnumBlockMirror mirror, EnumBlockRotation rotation, int offsetX, int offsetZ) {
        int k2 = mirror == EnumBlockMirror.c ? --offsetX : 0;
        int l2 = mirror == EnumBlockMirror.b ? --offsetZ : 0;
        BlockPosition blockposition1 = pos;
        switch (rotation) {
            case d: {
                blockposition1 = pos.b(l2, 0, offsetX - k2);
                break;
            }
            case b: {
                blockposition1 = pos.b(offsetZ - l2, 0, k2);
                break;
            }
            case c: {
                blockposition1 = pos.b(offsetX - k2, 0, offsetZ - l2);
                break;
            }
            case a: {
                blockposition1 = pos.b(k2, 0, l2);
            }
        }
        return blockposition1;
    }

    public StructureBoundingBox b(DefinedStructureInfo placementData, BlockPosition pos) {
        return this.a(pos, placementData.d(), placementData.e(), placementData.c());
    }

    public StructureBoundingBox a(BlockPosition pos, EnumBlockRotation rotation, BlockPosition pivot, EnumBlockMirror mirror) {
        return DefinedStructure.a(pos, rotation, pivot, mirror, this.n);
    }

    @VisibleForTesting
    protected static StructureBoundingBox a(BlockPosition pos, EnumBlockRotation rotation, BlockPosition pivot, EnumBlockMirror mirror, BaseBlockPosition dimensions) {
        BaseBlockPosition baseblockposition1 = dimensions.c(-1, -1, -1);
        BlockPosition blockposition2 = DefinedStructure.a(BlockPosition.c, mirror, rotation, pivot);
        BlockPosition blockposition3 = DefinedStructure.a(BlockPosition.c.a(baseblockposition1), mirror, rotation, pivot);
        return StructureBoundingBox.a(blockposition2, blockposition3).a((BaseBlockPosition)pos);
    }

    public NBTTagCompound a(NBTTagCompound nbt) {
        if (this.l.isEmpty()) {
            nbt.a(d, new NBTTagList());
            nbt.a(a, new NBTTagList());
        } else {
            ArrayList list = Lists.newArrayList();
            c definedstructure_c = new c();
            list.add(definedstructure_c);
            for (int i2 = 1; i2 < this.l.size(); ++i2) {
                list.add(new c());
            }
            NBTTagList nbttaglist = new NBTTagList();
            List<BlockInfo> list1 = this.l.get(0).b();
            for (int j2 = 0; j2 < list1.size(); ++j2) {
                BlockInfo definedstructure_blockinfo = list1.get(j2);
                NBTTagCompound nbttagcompound1 = new NBTTagCompound();
                nbttagcompound1.a("pos", this.a(definedstructure_blockinfo.a.u(), definedstructure_blockinfo.a.v(), definedstructure_blockinfo.a.w()));
                int k2 = definedstructure_c.a(definedstructure_blockinfo.b);
                nbttagcompound1.a(f, k2);
                if (definedstructure_blockinfo.c != null) {
                    nbttagcompound1.a("nbt", definedstructure_blockinfo.c);
                }
                nbttaglist.add(nbttagcompound1);
                for (int l2 = 1; l2 < this.l.size(); ++l2) {
                    c definedstructure_c1 = (c)list.get(l2);
                    definedstructure_c1.a(this.l.get((int)l2).b().get((int)j2).b, k2);
                }
            }
            nbt.a(d, nbttaglist);
            if (list.size() == 1) {
                nbttaglist1 = new NBTTagList();
                for (IBlockData iblockdata : definedstructure_c) {
                    nbttaglist1.add(GameProfileSerializer.a(iblockdata));
                }
                nbt.a(a, nbttaglist1);
            } else {
                nbttaglist1 = new NBTTagList();
                for (c definedstructure_c2 : list) {
                    NBTTagList nbttaglist2 = new NBTTagList();
                    for (IBlockData iblockdata1 : definedstructure_c2) {
                        nbttaglist2.add(GameProfileSerializer.a(iblockdata1));
                    }
                    nbttaglist1.add(nbttaglist2);
                }
                nbt.a(b, nbttaglist1);
            }
        }
        NBTTagList nbttaglist3 = new NBTTagList();
        for (EntityInfo definedstructure_entityinfo : this.m) {
            NBTTagCompound nbttagcompound2 = new NBTTagCompound();
            nbttagcompound2.a("pos", this.a(definedstructure_entityinfo.a.d, definedstructure_entityinfo.a.e, definedstructure_entityinfo.a.f));
            nbttagcompound2.a(i, this.a(definedstructure_entityinfo.b.u(), definedstructure_entityinfo.b.v(), definedstructure_entityinfo.b.w()));
            if (definedstructure_entityinfo.c != null) {
                nbttagcompound2.a("nbt", definedstructure_entityinfo.c);
            }
            nbttaglist3.add(nbttagcompound2);
        }
        nbt.a(c, nbttaglist3);
        nbt.a(k, this.a(this.n.u(), this.n.v(), this.n.w()));
        if (!this.persistentDataContainer.isEmpty()) {
            nbt.a("BukkitValues", this.persistentDataContainer.toTagCompound());
        }
        return GameProfileSerializer.e(nbt);
    }

    public void a(HolderGetter<Block> blockLookup, NBTTagCompound nbt) {
        int i2;
        NBTTagList nbttaglist2;
        this.l.clear();
        this.m.clear();
        NBTTagList nbttaglist = nbt.c(k, 3);
        this.n = new BaseBlockPosition(nbttaglist.e(0), nbttaglist.e(1), nbttaglist.e(2));
        NBTTagList nbttaglist1 = nbt.c(d, 10);
        if (nbt.b(b, 9)) {
            nbttaglist2 = nbt.c(b, 9);
            for (i2 = 0; i2 < nbttaglist2.size(); ++i2) {
                this.a(blockLookup, nbttaglist2.b(i2), nbttaglist1);
            }
        } else {
            this.a(blockLookup, nbt.c(a, 10), nbttaglist1);
        }
        nbttaglist2 = nbt.c(c, 10);
        for (i2 = 0; i2 < nbttaglist2.size(); ++i2) {
            NBTTagCompound nbttagcompound1 = nbttaglist2.a(i2);
            NBTTagList nbttaglist3 = nbttagcompound1.c("pos", 6);
            Vec3D vec3d = new Vec3D(nbttaglist3.h(0), nbttaglist3.h(1), nbttaglist3.h(2));
            NBTTagList nbttaglist4 = nbttagcompound1.c(i, 3);
            BlockPosition blockposition = new BlockPosition(nbttaglist4.e(0), nbttaglist4.e(1), nbttaglist4.e(2));
            if (!nbttagcompound1.e("nbt")) continue;
            NBTTagCompound nbttagcompound2 = nbttagcompound1.p("nbt");
            this.m.add(new EntityInfo(vec3d, blockposition, nbttagcompound2));
        }
        NBTBase base = nbt.c("BukkitValues");
        if (base instanceof NBTTagCompound) {
            this.persistentDataContainer.putAll((NBTTagCompound)base);
        }
    }

    private void a(HolderGetter<Block> blockLookup, NBTTagList palette, NBTTagList blocks) {
        c definedstructure_c = new c();
        for (int i2 = 0; i2 < palette.size(); ++i2) {
            definedstructure_c.a(GameProfileSerializer.a(blockLookup, palette.a(i2)), i2);
        }
        ArrayList list = Lists.newArrayList();
        ArrayList list1 = Lists.newArrayList();
        ArrayList list2 = Lists.newArrayList();
        for (int j2 = 0; j2 < blocks.size(); ++j2) {
            NBTTagCompound nbttagcompound = blocks.a(j2);
            NBTTagList nbttaglist2 = nbttagcompound.c("pos", 3);
            BlockPosition blockposition = new BlockPosition(nbttaglist2.e(0), nbttaglist2.e(1), nbttaglist2.e(2));
            IBlockData iblockdata = definedstructure_c.a(nbttagcompound.h(f));
            NBTTagCompound nbttagcompound1 = nbttagcompound.e("nbt") ? nbttagcompound.p("nbt") : null;
            BlockInfo definedstructure_blockinfo = new BlockInfo(blockposition, iblockdata, nbttagcompound1);
            DefinedStructure.a(definedstructure_blockinfo, list, list1, list2);
        }
        List<BlockInfo> list3 = DefinedStructure.a(list, list1, list2);
        this.l.add(new b(list3));
    }

    private NBTTagList a(int ... ints) {
        NBTTagList nbttaglist = new NBTTagList();
        int[] aint1 = ints;
        int i2 = ints.length;
        for (int j2 = 0; j2 < i2; ++j2) {
            int k2 = aint1[j2];
            nbttaglist.add(NBTTagInt.a(k2));
        }
        return nbttaglist;
    }

    private NBTTagList a(double ... doubles) {
        NBTTagList nbttaglist = new NBTTagList();
        double[] adouble1 = doubles;
        int i2 = doubles.length;
        for (int j2 = 0; j2 < i2; ++j2) {
            double d0 = adouble1[j2];
            nbttaglist.add(NBTTagDouble.a(d0));
        }
        return nbttaglist;
    }

    public static TileEntityJigsaw.JointType a(NBTTagCompound nbt, IBlockData state) {
        return TileEntityJigsaw.JointType.c.a(nbt.l("joint"), () -> BlockJigsaw.o(state).o().d() ? TileEntityJigsaw.JointType.b : TileEntityJigsaw.JointType.a);
    }

    public record BlockInfo(BlockPosition a, IBlockData b, @Nullable NBTTagCompound c) {
        @Override
        public String toString() {
            return String.format(Locale.ROOT, "<StructureBlockInfo | %s | %s | %s>", this.a, this.b, this.c);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{BlockInfo.class, "pos;state;nbt", "a", "b", "c"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{BlockInfo.class, "pos;state;nbt", "a", "b", "c"}, this, o2);
        }
    }

    public static final class b {
        private final List<BlockInfo> a;
        private final Map<Block, List<BlockInfo>> b = Maps.newConcurrentMap();
        @Nullable
        private List<a> c;

        b(List<BlockInfo> infos) {
            this.a = infos;
        }

        public List<a> a() {
            if (this.c == null) {
                this.c = this.a(Blocks.pw).stream().map(a::a).toList();
            }
            return this.c;
        }

        public List<BlockInfo> b() {
            return this.a;
        }

        public List<BlockInfo> a(Block block) {
            return this.b.computeIfAbsent(block, block1 -> this.a.stream().filter(definedstructure_blockinfo -> definedstructure_blockinfo.b.a((Block)block1)).collect(Collectors.toList()));
        }
    }

    public static class EntityInfo {
        public final Vec3D a;
        public final BlockPosition b;
        public final NBTTagCompound c;

        public EntityInfo(Vec3D pos, BlockPosition blockPos, NBTTagCompound nbt) {
            this.a = pos;
            this.b = blockPos;
            this.c = nbt;
        }
    }

    public record a(BlockInfo a, TileEntityJigsaw.JointType b, MinecraftKey c, MinecraftKey d, MinecraftKey e, int f, int g) {
        public static a a(BlockInfo structureBlockInfo) {
            NBTTagCompound nbttagcompound = Objects.requireNonNull(structureBlockInfo.c(), () -> String.valueOf(structureBlockInfo) + " nbt was null");
            return new a(structureBlockInfo, DefinedStructure.a(nbttagcompound, structureBlockInfo.b()), MinecraftKey.a(nbttagcompound.l("name")), MinecraftKey.a(nbttagcompound.l("pool")), MinecraftKey.a(nbttagcompound.l("target")), nbttagcompound.h("placement_priority"), nbttagcompound.h("selection_priority"));
        }

        @Override
        public String toString() {
            return String.format(Locale.ROOT, "<JigsawBlockInfo | %s | %s | name: %s | pool: %s | target: %s | placement: %d | selection: %d | %s>", this.a.a, this.a.b, this.c, this.d, this.e, this.f, this.g, this.a.c);
        }

        public a b(BlockInfo structureBlockInfo) {
            return new a(structureBlockInfo, this.b, this.c, this.d, this.e, this.f, this.g);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "info;jointType;name;pool;target;placementPriority;selectionPriority", "a", "b", "c", "d", "e", "f", "g"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "info;jointType;name;pool;target;placementPriority;selectionPriority", "a", "b", "c", "d", "e", "f", "g"}, this, o2);
        }
    }

    private static class c
    implements Iterable<IBlockData> {
        public static final IBlockData a = Blocks.a.m();
        private final RegistryBlockID<IBlockData> b = new RegistryBlockID(16);
        private int c;

        c() {
        }

        public int a(IBlockData state) {
            int i2 = this.b.a(state);
            if (i2 == -1) {
                i2 = this.c++;
                this.b.a(state, i2);
            }
            return i2;
        }

        @Nullable
        public IBlockData a(int id) {
            IBlockData iblockdata = this.b.a(id);
            return iblockdata == null ? a : iblockdata;
        }

        @Override
        public Iterator<IBlockData> iterator() {
            return this.b.iterator();
        }

        public void a(IBlockData state, int id) {
            this.b.a(state, id);
        }
    }
}

