/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.templatesystem;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockStairs;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockPropertyHalf;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructure;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureInfo;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureStructureProcessorType;

public class DefinedStructureProcessorBlockAge
extends DefinedStructureProcessor {
    public static final MapCodec<DefinedStructureProcessorBlockAge> a = Codec.FLOAT.fieldOf("mossiness").xmap(DefinedStructureProcessorBlockAge::new, processor -> Float.valueOf(processor.f));
    private static final float b = 0.5f;
    private static final float c = 0.5f;
    private static final float d = 0.15f;
    private static final IBlockData[] e = new IBlockData[]{Blocks.jV.m(), Blocks.kc.m()};
    private final float f;

    public DefinedStructureProcessorBlockAge(float mossiness) {
        this.f = mossiness;
    }

    @Override
    @Nullable
    @Override
    public DefinedStructure.BlockInfo a(IWorldReader world, BlockPosition pos, BlockPosition pivot, DefinedStructure.BlockInfo originalBlockInfo, DefinedStructure.BlockInfo currentBlockInfo, DefinedStructureInfo data) {
        RandomSource randomSource = data.b(currentBlockInfo.a());
        IBlockData blockState = currentBlockInfo.b();
        BlockPosition blockPos = currentBlockInfo.a();
        IBlockData blockState2 = null;
        if (blockState.a(Blocks.eV) || blockState.a(Blocks.b) || blockState.a(Blocks.eY)) {
            blockState2 = this.a(randomSource);
        } else if (blockState.a(TagsBlock.L)) {
            blockState2 = this.a(randomSource, currentBlockInfo.b());
        } else if (blockState.a(TagsBlock.M)) {
            blockState2 = this.b(randomSource);
        } else if (blockState.a(TagsBlock.N)) {
            blockState2 = this.c(randomSource);
        } else if (blockState.a(Blocks.cv)) {
            blockState2 = this.d(randomSource);
        }
        if (blockState2 != null) {
            return new DefinedStructure.BlockInfo(blockPos, blockState2, currentBlockInfo.c());
        }
        return currentBlockInfo;
    }

    @Nullable
    private IBlockData a(RandomSource random) {
        if (random.i() >= 0.5f) {
            return null;
        }
        IBlockData[] blockStates = new IBlockData[]{Blocks.eX.m(), DefinedStructureProcessorBlockAge.a(random, Blocks.fx)};
        IBlockData[] blockStates2 = new IBlockData[]{Blocks.eW.m(), DefinedStructureProcessorBlockAge.a(random, Blocks.nB)};
        return this.a(random, blockStates, blockStates2);
    }

    @Nullable
    private IBlockData a(RandomSource random, IBlockData state) {
        EnumDirection direction = state.c(BlockStairs.b);
        BlockPropertyHalf half = state.c(BlockStairs.c);
        if (random.i() >= 0.5f) {
            return null;
        }
        IBlockData[] blockStates = new IBlockData[]{(IBlockData)((IBlockData)Blocks.nB.m().b(BlockStairs.b, direction)).b(BlockStairs.c, half), Blocks.nP.m()};
        return this.a(random, e, blockStates);
    }

    @Nullable
    private IBlockData b(RandomSource random) {
        if (random.i() < this.f) {
            return Blocks.nP.m();
        }
        return null;
    }

    @Nullable
    private IBlockData c(RandomSource random) {
        if (random.i() < this.f) {
            return Blocks.od.m();
        }
        return null;
    }

    @Nullable
    private IBlockData d(RandomSource random) {
        if (random.i() < 0.15f) {
            return Blocks.pF.m();
        }
        return null;
    }

    private static IBlockData a(RandomSource random, Block stairs) {
        return (IBlockData)((IBlockData)stairs.m().b(BlockStairs.b, EnumDirection.EnumDirectionLimit.a.a(random))).b(BlockStairs.c, SystemUtils.a(BlockPropertyHalf.values(), random));
    }

    private IBlockData a(RandomSource random, IBlockData[] regularStates, IBlockData[] mossyStates) {
        if (random.i() < this.f) {
            return DefinedStructureProcessorBlockAge.a(random, mossyStates);
        }
        return DefinedStructureProcessorBlockAge.a(random, regularStates);
    }

    private static IBlockData a(RandomSource random, IBlockData[] states) {
        return states[random.a(states.length)];
    }

    @Override
    @Override
    protected DefinedStructureStructureProcessorType<?> a() {
        return DefinedStructureStructureProcessorType.k;
    }
}

