/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.templatesystem;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.structure.templatesystem.PosRuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.PosRuleTestType;

public class PosRuleTestAxisAlignedLinear
extends PosRuleTest {
    public static final MapCodec<PosRuleTestAxisAlignedLinear> a = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.FLOAT.fieldOf("min_chance").orElse((Object)Float.valueOf(0.0f)).forGetter(ruleTest -> Float.valueOf(ruleTest.b)), (App)Codec.FLOAT.fieldOf("max_chance").orElse((Object)Float.valueOf(0.0f)).forGetter(ruleTest -> Float.valueOf(ruleTest.d)), (App)Codec.INT.fieldOf("min_dist").orElse((Object)0).forGetter(ruleTest -> ruleTest.e), (App)Codec.INT.fieldOf("max_dist").orElse((Object)0).forGetter(ruleTest -> ruleTest.f), (App)EnumDirection.EnumAxis.e.fieldOf("axis").orElse((Object)EnumDirection.EnumAxis.b).forGetter(ruleTest -> ruleTest.g)).apply((Applicative)instance, PosRuleTestAxisAlignedLinear::new));
    private final float b;
    private final float d;
    private final int e;
    private final int f;
    private final EnumDirection.EnumAxis g;

    public PosRuleTestAxisAlignedLinear(float minChance, float maxChance, int minDistance, int maxDistance, EnumDirection.EnumAxis axis) {
        if (minDistance >= maxDistance) {
            throw new IllegalArgumentException("Invalid range: [" + minDistance + "," + maxDistance + "]");
        }
        this.b = minChance;
        this.d = maxChance;
        this.e = minDistance;
        this.f = maxDistance;
        this.g = axis;
    }

    @Override
    @Override
    public boolean a(BlockPosition originalPos, BlockPosition currentPos, BlockPosition pivot, RandomSource random) {
        EnumDirection direction = EnumDirection.a(EnumDirection.EnumAxisDirection.a, this.g);
        float f2 = Math.abs((currentPos.u() - pivot.u()) * direction.j());
        float g2 = Math.abs((currentPos.v() - pivot.v()) * direction.k());
        float h2 = Math.abs((currentPos.w() - pivot.w()) * direction.l());
        int i2 = (int)(f2 + g2 + h2);
        float j2 = random.i();
        return j2 <= MathHelper.b(this.b, this.d, MathHelper.f(i2, this.e, this.f));
    }

    @Override
    @Override
    protected PosRuleTestType<?> a() {
        return PosRuleTestType.c;
    }
}

