/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.lighting;

import it.unimi.dsi.fastutil.longs.LongArrayFIFOQueue;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.util.Arrays;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.SectionPosition;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.ILightAccess;
import net.minecraft.world.level.chunk.LightChunk;
import net.minecraft.world.level.chunk.NibbleArray;
import net.minecraft.world.level.lighting.LightEngineLayerEventListener;
import net.minecraft.world.level.lighting.LightEngineStorage;
import net.minecraft.world.level.lighting.LightEngineStorageArray;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapes;

public abstract class LightEngine<M extends LightEngineStorageArray<M>, S extends LightEngineStorage<M>>
implements LightEngineLayerEventListener {
    public static final int a = 15;
    protected static final int b = 1;
    protected static final long c = net.minecraft.world.level.lighting.LightEngine$a.a(1);
    private static final int g = 512;
    protected static final EnumDirection[] d = EnumDirection.values();
    protected final ILightAccess e;
    protected final S f;
    private final LongOpenHashSet h = new LongOpenHashSet(512, 0.5f);
    private final LongArrayFIFOQueue i = new LongArrayFIFOQueue();
    private final LongArrayFIFOQueue j = new LongArrayFIFOQueue();
    private static final int k = 2;
    private final long[] l = new long[2];
    private final LightChunk[] m = new LightChunk[2];

    protected LightEngine(ILightAccess chunkProvider, S lightStorage) {
        this.e = chunkProvider;
        this.f = lightStorage;
        this.c();
    }

    public static boolean a(IBlockData oldState, IBlockData newState) {
        if (newState == oldState) {
            return false;
        }
        return newState.g() != oldState.g() || newState.k() != oldState.k() || newState.j() || oldState.j();
    }

    public static int a(IBlockData state1, IBlockData state2, EnumDirection direction, int opacity2) {
        VoxelShape voxelShape2;
        boolean bl = LightEngine.a(state1);
        boolean bl2 = LightEngine.a(state2);
        if (bl && bl2) {
            return opacity2;
        }
        VoxelShape voxelShape = bl ? VoxelShapes.a() : state1.h();
        VoxelShape voxelShape3 = voxelShape2 = bl2 ? VoxelShapes.a() : state2.h();
        if (VoxelShapes.b(voxelShape, voxelShape2, direction)) {
            return 16;
        }
        return opacity2;
    }

    public static VoxelShape a(IBlockData state, EnumDirection direction) {
        return LightEngine.a(state) ? VoxelShapes.a() : state.a(direction);
    }

    protected static boolean a(IBlockData blockState) {
        return !blockState.t() || !blockState.j();
    }

    protected IBlockData c(BlockPosition pos) {
        int j2;
        int i2 = SectionPosition.a(pos.u());
        LightChunk lightChunk = this.a(i2, j2 = SectionPosition.a(pos.w()));
        if (lightChunk == null) {
            return Blocks.I.m();
        }
        return lightChunk.a_(pos);
    }

    protected int b(IBlockData state) {
        return Math.max(1, state.g());
    }

    protected boolean a(IBlockData source, IBlockData target, EnumDirection direction) {
        VoxelShape voxelShape = LightEngine.a(source, direction);
        VoxelShape voxelShape2 = LightEngine.a(target, direction.g());
        return VoxelShapes.b(voxelShape, voxelShape2);
    }

    @Nullable
    protected LightChunk a(int chunkX, int chunkZ) {
        long l2 = ChunkCoordIntPair.c(chunkX, chunkZ);
        for (int i2 = 0; i2 < 2; ++i2) {
            if (l2 != this.l[i2]) continue;
            return this.m[i2];
        }
        LightChunk lightChunk = this.e.c(chunkX, chunkZ);
        for (int j2 = 1; j2 > 0; --j2) {
            this.l[j2] = this.l[j2 - 1];
            this.m[j2] = this.m[j2 - 1];
        }
        this.l[0] = l2;
        this.m[0] = lightChunk;
        return lightChunk;
    }

    private void c() {
        Arrays.fill(this.l, ChunkCoordIntPair.c);
        Arrays.fill(this.m, null);
    }

    @Override
    @Override
    public void a(BlockPosition pos) {
        this.h.add(pos.a());
    }

    public void a(long sectionPos, @Nullable NibbleArray lightArray) {
        ((LightEngineStorage)this.f).a(sectionPos, lightArray);
    }

    public void b(ChunkCoordIntPair pos, boolean retainData) {
        ((LightEngineStorage)this.f).c(SectionPosition.b(pos.h, pos.i), retainData);
    }

    @Override
    @Override
    public void a(SectionPosition pos, boolean notReady) {
        ((LightEngineStorage)this.f).d(pos.s(), notReady);
    }

    @Override
    @Override
    public void a(ChunkCoordIntPair pos, boolean retainData) {
        ((LightEngineStorage)this.f).b(SectionPosition.b(pos.h, pos.i), retainData);
    }

    @Override
    @Override
    public int a() {
        LongIterator longIterator = this.h.iterator();
        while (longIterator.hasNext()) {
            this.a(longIterator.nextLong());
        }
        this.h.clear();
        this.h.trim(512);
        int i2 = 0;
        i2 += this.e();
        this.c();
        ((LightEngineStorage)this.f).a(this);
        ((LightEngineStorage)this.f).b();
        return i2 += this.d();
    }

    private int d() {
        int i2 = 0;
        while (!this.j.isEmpty()) {
            long l2 = this.j.dequeueLong();
            long m2 = this.j.dequeueLong();
            int j2 = ((LightEngineStorage)this.f).e(l2);
            int k2 = net.minecraft.world.level.lighting.LightEngine$a.a(m2);
            if (net.minecraft.world.level.lighting.LightEngine$a.c(m2) && j2 < k2) {
                ((LightEngineStorage)this.f).a(l2, k2);
                j2 = k2;
            }
            if (j2 == k2) {
                this.a(l2, m2, j2);
            }
            ++i2;
        }
        return i2;
    }

    private int e() {
        int i2 = 0;
        while (!this.i.isEmpty()) {
            long l2 = this.i.dequeueLong();
            long m2 = this.i.dequeueLong();
            this.a(l2, m2);
            ++i2;
        }
        return i2;
    }

    protected void b(long blockPos, long flags) {
        this.i.enqueue(blockPos);
        this.i.enqueue(flags);
    }

    protected void c(long blockPos, long flags) {
        this.j.enqueue(blockPos);
        this.j.enqueue(flags);
    }

    @Override
    @Override
    public boolean N_() {
        return ((LightEngineStorage)this.f).a() || !this.h.isEmpty() || !this.i.isEmpty() || !this.j.isEmpty();
    }

    @Override
    @Nullable
    @Override
    public NibbleArray a(SectionPosition pos) {
        return ((LightEngineStorage)this.f).d(pos.s());
    }

    @Override
    @Override
    public int b(BlockPosition pos) {
        return ((LightEngineStorage)this.f).a(pos.a());
    }

    public String b(long sectionPos) {
        return this.c(sectionPos).a();
    }

    public LightEngineStorage.b c(long sectionPos) {
        return ((LightEngineStorage)this.f).l(sectionPos);
    }

    protected abstract void a(long var1);

    protected abstract void a(long var1, long var3, int var5);

    protected abstract void a(long var1, long var3);

    public static class a {
        private static final int a = 4;
        private static final int b = 6;
        private static final long c = 15L;
        private static final long d = 1008L;
        private static final long e = 1024L;
        private static final long f = 2048L;

        public static long a(int lightLevel, EnumDirection direction) {
            long l2 = net.minecraft.world.level.lighting.LightEngine$a.c(1008L, direction);
            return net.minecraft.world.level.lighting.LightEngine$a.a(l2, lightLevel);
        }

        public static long a(int lightLevel) {
            return net.minecraft.world.level.lighting.LightEngine$a.a(1008L, lightLevel);
        }

        public static long a(int lightLevel, boolean trivial) {
            long l2 = 1008L;
            l2 |= 0x800L;
            if (trivial) {
                l2 |= 0x400L;
            }
            return net.minecraft.world.level.lighting.LightEngine$a.a(l2, lightLevel);
        }

        public static long a(int lightLevel, boolean trivial, EnumDirection direction) {
            long l2 = net.minecraft.world.level.lighting.LightEngine$a.c(1008L, direction);
            if (trivial) {
                l2 |= 0x400L;
            }
            return net.minecraft.world.level.lighting.LightEngine$a.a(l2, lightLevel);
        }

        public static long b(int lightLevel, boolean trivial, EnumDirection direction) {
            long l2 = 0L;
            if (trivial) {
                l2 |= 0x400L;
            }
            l2 = net.minecraft.world.level.lighting.LightEngine$a.b(l2, direction);
            return net.minecraft.world.level.lighting.LightEngine$a.a(l2, lightLevel);
        }

        public static long a(boolean down, boolean north, boolean south, boolean west, boolean east) {
            long l2 = net.minecraft.world.level.lighting.LightEngine$a.a(0L, 15);
            if (down) {
                l2 = net.minecraft.world.level.lighting.LightEngine$a.b(l2, EnumDirection.a);
            }
            if (north) {
                l2 = net.minecraft.world.level.lighting.LightEngine$a.b(l2, EnumDirection.c);
            }
            if (south) {
                l2 = net.minecraft.world.level.lighting.LightEngine$a.b(l2, EnumDirection.d);
            }
            if (west) {
                l2 = net.minecraft.world.level.lighting.LightEngine$a.b(l2, EnumDirection.e);
            }
            if (east) {
                l2 = net.minecraft.world.level.lighting.LightEngine$a.b(l2, EnumDirection.f);
            }
            return l2;
        }

        public static int a(long packed) {
            return (int)(packed & 0xFL);
        }

        public static boolean b(long packed) {
            return (packed & 0x400L) != 0L;
        }

        public static boolean c(long packed) {
            return (packed & 0x800L) != 0L;
        }

        public static boolean a(long packed, EnumDirection direction) {
            return (packed & 1L << direction.ordinal() + 4) != 0L;
        }

        private static long a(long packed, int lightLevel) {
            return packed & 0xFFFFFFFFFFFFFFF0L | (long)lightLevel & 0xFL;
        }

        private static long b(long packed, EnumDirection direction) {
            return packed | 1L << direction.ordinal() + 4;
        }

        private static long c(long packed, EnumDirection direction) {
            return packed & (1L << direction.ordinal() + 4 ^ 0xFFFFFFFFFFFFFFFFL);
        }
    }
}

