/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.material;

import ca.spottedleaf.moonrise.patches.collisions.util.CollisionDirection;
import ca.spottedleaf.moonrise.patches.collisions.util.FluidOcclusionCacheKey;
import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.objects.Object2ByteLinkedOpenHashMap;
import it.unimi.dsi.fastutil.shorts.Short2BooleanMap;
import it.unimi.dsi.fastutil.shorts.Short2BooleanOpenHashMap;
import it.unimi.dsi.fastutil.shorts.Short2ObjectMap;
import it.unimi.dsi.fastutil.shorts.Short2ObjectOpenHashMap;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.EnumMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsBlock;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockDoor;
import net.minecraft.world.level.block.BlockIce;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.IFluidContainer;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.bukkit.block.BlockFace;
import org.bukkit.craftbukkit.v1_21_R2.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R2.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_21_R2.event.CraftEventFactory;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockFromToEvent;
import org.bukkit.event.block.FluidLevelChangeEvent;

public abstract class FluidTypeFlowing
extends FluidType {
    public static final BlockStateBoolean a = BlockProperties.i;
    public static final BlockStateInteger b = BlockProperties.aN;
    private static final int e = 200;
    private static final ThreadLocal<Object2ByteLinkedOpenHashMap<a>> f = ThreadLocal.withInitial(() -> {
        Object2ByteLinkedOpenHashMap<a> object2bytelinkedopenhashmap = new Object2ByteLinkedOpenHashMap<a>(200){

            protected void rehash(int i2) {
            }
        };
        object2bytelinkedopenhashmap.defaultReturnValue((byte)127);
        return object2bytelinkedopenhashmap;
    });
    private final Map<Fluid, VoxelShape> g = Maps.newIdentityHashMap();
    private Fluid sourceFalling;
    private Fluid sourceNotFalling;
    private static final int TOTAL_FLOWING_STATES = a.a().size() * b.a().size();
    private static final int MIN_LEVEL = (Integer)b.a().stream().sorted().findFirst().get();
    private Fluid[] flowingLookUp;
    private volatile boolean init;
    private static final int COLLISION_OCCLUSION_CACHE_SIZE = 2048;
    private static final ThreadLocal<FluidOcclusionCacheKey[]> COLLISION_OCCLUSION_CACHE = ThreadLocal.withInitial(() -> new FluidOcclusionCacheKey[2048]);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        FluidTypeFlowing fluidTypeFlowing = this;
        synchronized (fluidTypeFlowing) {
            if (this.init) {
                return;
            }
            this.flowingLookUp = new Fluid[TOTAL_FLOWING_STATES];
            Fluid defaultFlowState = this.d().g();
            for (int i2 = 0; i2 < TOTAL_FLOWING_STATES; ++i2) {
                int falling = i2 & 1;
                int level = (i2 >>> 1) + MIN_LEVEL;
                this.flowingLookUp[i2] = (Fluid)((Fluid)defaultFlowState.b(a, falling == 1 ? Boolean.TRUE : Boolean.FALSE)).b(b, level);
            }
            Fluid defaultFallState = this.e().g();
            this.sourceFalling = (Fluid)defaultFallState.b(a, Boolean.TRUE);
            this.sourceNotFalling = (Fluid)defaultFallState.b(a, Boolean.FALSE);
            this.init = true;
        }
    }

    @Override
    protected void a(BlockStateList.a<FluidType, Fluid> builder) {
        builder.a(new IBlockState[]{a});
    }

    @Override
    public Vec3D a(IBlockAccess world, BlockPosition pos, Fluid state) {
        double d0 = 0.0;
        double d1 = 0.0;
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
        for (EnumDirection enumdirection : EnumDirection.EnumDirectionLimit.a) {
            blockposition_mutableblockposition.a((BaseBlockPosition)pos, enumdirection);
            Fluid fluid1 = world.b_(blockposition_mutableblockposition);
            if (!this.g(fluid1)) continue;
            float f2 = fluid1.d();
            float f1 = 0.0f;
            if (f2 == 0.0f) {
                BlockPosition blockposition1;
                Fluid fluid2;
                if (!world.a_(blockposition_mutableblockposition).d() && this.g(fluid2 = world.b_(blockposition1 = blockposition_mutableblockposition.e())) && (f2 = fluid2.d()) > 0.0f) {
                    f1 = state.d() - (f2 - 0.8888889f);
                }
            } else if (f2 > 0.0f) {
                f1 = state.d() - f2;
            }
            if (f1 == 0.0f) continue;
            d0 += (double)((float)enumdirection.j() * f1);
            d1 += (double)((float)enumdirection.l() * f1);
        }
        Vec3D vec3d = new Vec3D(d0, 0.0, d1);
        if (state.c(a).booleanValue()) {
            for (EnumDirection enumdirection1 : EnumDirection.EnumDirectionLimit.a) {
                blockposition_mutableblockposition.a((BaseBlockPosition)pos, enumdirection1);
                if (!this.a(world, (BlockPosition)blockposition_mutableblockposition, enumdirection1) && !this.a(world, blockposition_mutableblockposition.d(), enumdirection1)) continue;
                vec3d = vec3d.d().b(0.0, -6.0, 0.0);
                break;
            }
        }
        return vec3d.d();
    }

    private boolean g(Fluid state) {
        return state.c() || state.a().a(this);
    }

    protected boolean a(IBlockAccess world, BlockPosition pos, EnumDirection direction) {
        IBlockData iblockdata = world.a_(pos);
        Fluid fluid = world.b_(pos);
        return fluid.a().a(this) ? false : (direction == EnumDirection.b ? true : (iblockdata.b() instanceof BlockIce ? false : iblockdata.c(world, pos, direction)));
    }

    protected void a(WorldServer world, BlockPosition fluidPos, IBlockData blockState, Fluid fluidState) {
        if (!fluidState.c()) {
            Fluid fluid2;
            FluidType fluidtype;
            Fluid fluid1;
            IBlockData iblockdata1;
            BlockPosition blockposition1 = fluidPos.e();
            if (this.a(world, fluidPos, blockState, EnumDirection.a, blockposition1, iblockdata1 = world.a_(blockposition1), fluid1 = iblockdata1.y()) && fluid1.a(world, blockposition1, fluidtype = (fluid2 = this.a(world, blockposition1, iblockdata1)).a(), EnumDirection.a) && FluidTypeFlowing.b(world, blockposition1, iblockdata1, fluidtype)) {
                CraftBlock source = CraftBlock.at(world, fluidPos);
                BlockFromToEvent event = new BlockFromToEvent((org.bukkit.block.Block)source, BlockFace.DOWN);
                world.getCraftServer().getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) {
                    return;
                }
                this.a(world, blockposition1, iblockdata1, EnumDirection.a, fluid2);
                if (this.a(world, fluidPos) >= 3) {
                    this.a(world, fluidPos, fluidState, blockState);
                }
                return;
            }
            if (fluidState.b() || !this.a((IBlockAccess)world, fluidPos, blockState, blockposition1, iblockdata1)) {
                this.a(world, fluidPos, fluidState, blockState);
            }
        }
    }

    private void a(WorldServer world, BlockPosition pos, Fluid fluidState, IBlockData blockState) {
        int i2 = fluidState.e() - this.c(world);
        if (fluidState.c(a).booleanValue()) {
            i2 = 7;
        }
        if (i2 > 0) {
            Map<EnumDirection, Fluid> map = this.b(world, pos, blockState);
            for (Map.Entry<EnumDirection, Fluid> entry : map.entrySet()) {
                EnumDirection enumdirection = entry.getKey();
                Fluid fluid1 = entry.getValue();
                BlockPosition blockposition1 = pos.a(enumdirection);
                IBlockData blockStateIfLoaded = world.getBlockStateIfLoaded(blockposition1);
                if (blockStateIfLoaded == null) continue;
                CraftBlock source = CraftBlock.at(world, pos);
                BlockFromToEvent event = new BlockFromToEvent((org.bukkit.block.Block)source, CraftBlock.notchToBlockFace(enumdirection));
                world.getCraftServer().getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) continue;
                this.a(world, blockposition1, blockStateIfLoaded, enumdirection, fluid1);
            }
        }
    }

    protected Fluid a(WorldServer world, BlockPosition pos, IBlockData state) {
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition2;
        IBlockData iblockdata3;
        Fluid fluid2;
        int i2 = 0;
        int j2 = 0;
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
        for (EnumDirection enumdirection : EnumDirection.EnumDirectionLimit.a) {
            Fluid fluid;
            BlockPosition.MutableBlockPosition blockposition_mutableblockposition1 = blockposition_mutableblockposition.a((BaseBlockPosition)pos, enumdirection);
            IBlockData iblockdata1 = world.getBlockStateIfLoaded(blockposition_mutableblockposition1);
            if (iblockdata1 == null || !(fluid = iblockdata1.y()).a().a(this) || !FluidTypeFlowing.a(enumdirection, world, pos, state, blockposition_mutableblockposition1, iblockdata1)) continue;
            if (fluid.b()) {
                ++j2;
            }
            i2 = Math.max(i2, fluid.e());
        }
        if (j2 >= 2 && this.a(world)) {
            IBlockData iblockdata2 = world.a_(blockposition_mutableblockposition.a((BaseBlockPosition)pos, EnumDirection.a));
            Fluid fluid1 = iblockdata2.y();
            if (iblockdata2.e() || this.h(fluid1)) {
                return this.a(false);
            }
        }
        if (!(fluid2 = (iblockdata3 = world.a_(blockposition_mutableblockposition2 = blockposition_mutableblockposition.a((BaseBlockPosition)pos, EnumDirection.b))).y()).c() && fluid2.a().a(this) && FluidTypeFlowing.a(EnumDirection.b, world, pos, state, blockposition_mutableblockposition2, iblockdata3)) {
            return this.a(8, true);
        }
        int k2 = i2 - this.c(world);
        return k2 <= 0 ? FluidTypes.a.g() : this.a(k2, false);
    }

    private static boolean a(EnumDirection direction, IBlockAccess level, BlockPosition fromPos, IBlockData fromState, BlockPosition toPos, IBlockData toState) {
        VoxelShape shape2;
        boolean result;
        FluidOcclusionCacheKey cached;
        if (fromState.moonrise$emptyCollisionShape() & toState.moonrise$emptyCollisionShape()) {
            return true;
        }
        if (fromState.moonrise$occludesFullBlock() | toState.moonrise$occludesFullBlock()) {
            return false;
        }
        FluidOcclusionCacheKey[] cache = fromState.moonrise$hasCache() & toState.moonrise$hasCache() ? COLLISION_OCCLUSION_CACHE.get() : null;
        int keyIndex = (fromState.moonrise$uniqueId1() ^ toState.moonrise$uniqueId2() ^ ((CollisionDirection)direction).moonrise$uniqueId()) & 0x7FF;
        if (cache != null && (cached = cache[keyIndex]) != null && cached.first() == fromState && cached.second() == toState && cached.direction() == direction) {
            return cached.result();
        }
        VoxelShape shape1 = fromState.g(level, fromPos);
        boolean bl = result = !VoxelShapes.b(shape1, shape2 = toState.g(level, toPos), direction);
        if (cache != null) {
            cache[keyIndex] = new FluidOcclusionCacheKey(fromState, toState, direction, result);
        }
        return result;
    }

    public abstract FluidType d();

    public Fluid a(int level, boolean falling) {
        int amount = level;
        if (!this.init) {
            this.init();
        }
        int index = (falling ? 1 : 0) | amount - MIN_LEVEL << 1;
        return this.flowingLookUp[index];
    }

    public abstract FluidType e();

    public Fluid a(boolean falling) {
        if (!this.init) {
            this.init();
        }
        return falling ? this.sourceFalling : this.sourceNotFalling;
    }

    protected abstract boolean a(WorldServer var1);

    protected void a(GeneratorAccess world, BlockPosition pos, IBlockData state, EnumDirection direction, Fluid fluidState) {
        Block block = state.b();
        if (block instanceof IFluidContainer) {
            IFluidContainer ifluidcontainer = (IFluidContainer)((Object)block);
            ifluidcontainer.a(world, pos, state, fluidState);
        } else {
            if (!state.l()) {
                this.beforeDestroyingBlock(world, pos, state, pos.a(direction.g()));
            }
            world.a(pos, fluidState.g(), 3);
        }
    }

    protected void beforeDestroyingBlock(GeneratorAccess world, BlockPosition pos, IBlockData state, BlockPosition source) {
        this.a(world, pos, state);
    }

    protected abstract void a(GeneratorAccess var1, BlockPosition var2, IBlockData var3);

    protected int a(IWorldReader world, BlockPosition pos, int i2, EnumDirection direction, IBlockData state, b spreadCache) {
        int j2 = 1000;
        for (EnumDirection enumdirection1 : EnumDirection.EnumDirectionLimit.a) {
            int k2;
            BlockPosition blockposition1;
            IBlockData iblockdata1;
            if (enumdirection1 == direction || (iblockdata1 = spreadCache.getBlockStateIfLoaded(blockposition1 = pos.a(enumdirection1))) == null) continue;
            Fluid fluid = iblockdata1.y();
            if (!this.a(world, this.d(), pos, state, enumdirection1, blockposition1, iblockdata1, fluid)) continue;
            if (spreadCache.b(blockposition1)) {
                return i2;
            }
            if (i2 >= this.b(world) || (k2 = this.a(world, blockposition1, i2 + 1, enumdirection1.g(), iblockdata1, spreadCache)) >= j2) continue;
            j2 = k2;
        }
        return j2;
    }

    boolean a(IBlockAccess world, BlockPosition pos, IBlockData state, BlockPosition fromPos, IBlockData fromState) {
        return !FluidTypeFlowing.a(EnumDirection.a, world, pos, state, fromPos, fromState) ? false : (fromState.y().a().a(this) ? true : FluidTypeFlowing.a(world, fromPos, fromState, this.d()));
    }

    private boolean a(IBlockAccess world, FluidType fluid, BlockPosition pos, IBlockData state, EnumDirection face, BlockPosition fromPos, IBlockData fromState, Fluid fluidState) {
        return this.a(world, pos, state, face, fromPos, fromState, fluidState) && FluidTypeFlowing.b(world, fromPos, fromState, fluid);
    }

    private boolean a(IBlockAccess world, BlockPosition pos, IBlockData state, EnumDirection face, BlockPosition fromPos, IBlockData fromState, Fluid fluidState) {
        return !this.h(fluidState) && FluidTypeFlowing.a(fromState) && FluidTypeFlowing.a(face, world, pos, state, fromPos, fromState);
    }

    private boolean h(Fluid state) {
        return state.a().a(this) && state.b();
    }

    protected abstract int b(IWorldReader var1);

    private int a(IWorldReader world, BlockPosition pos) {
        int i2 = 0;
        for (EnumDirection enumdirection : EnumDirection.EnumDirectionLimit.a) {
            BlockPosition blockposition1 = pos.a(enumdirection);
            Fluid fluid = world.b_(blockposition1);
            if (!this.h(fluid)) continue;
            ++i2;
        }
        return i2;
    }

    protected Map<EnumDirection, Fluid> b(WorldServer world, BlockPosition pos, IBlockData state) {
        int i2 = 1000;
        EnumMap map = Maps.newEnumMap(EnumDirection.class);
        b fluidtypeflowing_b = null;
        for (EnumDirection enumdirection : EnumDirection.EnumDirectionLimit.a) {
            int j2;
            Fluid fluid1;
            Fluid fluid;
            BlockPosition blockposition1 = pos.a(enumdirection);
            IBlockData iblockdata1 = world.getBlockStateIfLoaded(blockposition1);
            if (iblockdata1 == null || !this.a(world, pos, state, enumdirection, blockposition1, iblockdata1, fluid = iblockdata1.y()) || !FluidTypeFlowing.b(world, blockposition1, iblockdata1, (fluid1 = this.a(world, blockposition1, iblockdata1)).a())) continue;
            if (fluidtypeflowing_b == null) {
                fluidtypeflowing_b = new b(world, pos);
            }
            if ((j2 = fluidtypeflowing_b.b(blockposition1) ? 0 : this.a(world, blockposition1, 1, enumdirection.g(), iblockdata1, fluidtypeflowing_b)) < i2) {
                map.clear();
            }
            if (j2 > i2) continue;
            if (fluid.a(world, blockposition1, fluid1.a(), enumdirection)) {
                map.put(enumdirection, fluid1);
            }
            i2 = j2;
        }
        return map;
    }

    private static boolean a(IBlockData state) {
        Block block = state.b();
        return block instanceof IFluidContainer ? true : (state.d() ? false : !(block instanceof BlockDoor) && !state.a(TagsBlock.aA) && !state.a(Blocks.cX) && !state.a(Blocks.ef) && !state.a(Blocks.ny) && !state.a(Blocks.eq) && !state.a(Blocks.fL) && !state.a(Blocks.la) && !state.a(Blocks.li));
    }

    private static boolean a(IBlockAccess world, BlockPosition pos, IBlockData state, FluidType fluid) {
        return FluidTypeFlowing.a(state) && FluidTypeFlowing.b(world, pos, state, fluid);
    }

    private static boolean b(IBlockAccess world, BlockPosition pos, IBlockData state, FluidType fluid) {
        Block block = state.b();
        if (block instanceof IFluidContainer) {
            IFluidContainer ifluidcontainer = (IFluidContainer)((Object)block);
            return ifluidcontainer.a(null, world, pos, state, fluid);
        }
        return true;
    }

    protected abstract int c(IWorldReader var1);

    protected int a(World world, BlockPosition pos, Fluid oldState, Fluid newState) {
        return this.a(world);
    }

    @Override
    public void b(WorldServer world, BlockPosition pos, IBlockData blockState, Fluid fluidState) {
        if (!fluidState.b()) {
            Fluid fluid1 = this.a(world, pos, world.a_(pos));
            int i2 = this.a((World)world, pos, fluidState, fluid1);
            if (fluid1.c()) {
                fluidState = fluid1;
                blockState = Blocks.a.m();
                FluidLevelChangeEvent event = CraftEventFactory.callFluidLevelChangeEvent(world, pos, blockState);
                if (event.isCancelled()) {
                    return;
                }
                blockState = ((CraftBlockData)event.getNewData()).getState();
                world.a(pos, blockState, 3);
            } else if (!fluid1.equals(fluidState)) {
                fluidState = fluid1;
                blockState = fluid1.g();
                FluidLevelChangeEvent event = CraftEventFactory.callFluidLevelChangeEvent(world, pos, blockState);
                if (event.isCancelled()) {
                    return;
                }
                blockState = ((CraftBlockData)event.getNewData()).getState();
                world.a(pos, blockState, 3);
                world.a(pos, fluid1.a(), i2);
            }
        }
        this.a(world, pos, blockState, fluidState);
    }

    protected static int e(Fluid state) {
        return state.b() ? 0 : 8 - Math.min(state.e(), 8) + (state.c(a) != false ? 8 : 0);
    }

    private static boolean c(Fluid state, IBlockAccess world, BlockPosition pos) {
        return state.a().a(world.b_(pos.d()).a());
    }

    @Override
    public float a(Fluid state, IBlockAccess world, BlockPosition pos) {
        return FluidTypeFlowing.c(state, world, pos) ? 1.0f : state.d();
    }

    @Override
    public float a(Fluid state) {
        return (float)state.e() / 9.0f;
    }

    @Override
    public abstract int d(Fluid var1);

    @Override
    public VoxelShape b(Fluid state, IBlockAccess world, BlockPosition pos) {
        return state.e() == 9 && FluidTypeFlowing.c(state, world, pos) ? VoxelShapes.b() : this.g.computeIfAbsent(state, fluid1 -> VoxelShapes.a(0.0, 0.0, 0.0, 1.0, fluid1.a(world, pos), 1.0));
    }

    protected class b {
        private final IBlockAccess b;
        private final BlockPosition c;
        private final Short2ObjectMap<IBlockData> d = new Short2ObjectOpenHashMap();
        private final Short2BooleanMap e = new Short2BooleanOpenHashMap();

        b(IBlockAccess iblockaccess, BlockPosition blockposition) {
            this.b = iblockaccess;
            this.c = blockposition;
        }

        public IBlockData a(BlockPosition pos) {
            return this.a(pos, this.c(pos));
        }

        @Nullable
        public IBlockData getBlockStateIfLoaded(BlockPosition pos) {
            return this.getBlockState(pos, this.c(pos), false);
        }

        private IBlockData a(BlockPosition pos, short packed) {
            return this.getBlockState(pos, packed, true);
        }

        @Nullable
        private IBlockData getBlockState(BlockPosition pos, short packed, boolean load) {
            IBlockData blockState = (IBlockData)this.d.get(packed);
            if (blockState == null) {
                IBlockData iBlockData = blockState = load ? this.b.a_(pos) : this.b.getBlockStateIfLoaded(pos);
                if (blockState != null) {
                    this.d.put(packed, (Object)blockState);
                }
            }
            return blockState;
        }

        public boolean b(BlockPosition pos) {
            return this.e.computeIfAbsent(this.c(pos), short0 -> {
                IBlockData iblockdata = this.a(pos, short0);
                BlockPosition blockposition1 = pos.e();
                IBlockData iblockdata1 = this.b.a_(blockposition1);
                return FluidTypeFlowing.this.a(this.b, pos, iblockdata, blockposition1, iblockdata1);
            });
        }

        private short c(BlockPosition pos) {
            int i2 = pos.u() - this.c.u();
            int j2 = pos.w() - this.c.w();
            return (short)((i2 + 128 & 0xFF) << 8 | j2 + 128 & 0xFF);
        }
    }

    private record a(IBlockData a, IBlockData b, EnumDirection c) {
        @Override
        public boolean equals(Object object) {
            if (object instanceof a) {
                a fluidtypeflowing_a = (a)object;
                if (this.a == fluidtypeflowing_a.a && this.b == fluidtypeflowing_a.b && this.c == fluidtypeflowing_a.c) {
                    boolean flag = true;
                    return flag;
                }
            }
            boolean flag = false;
            return flag;
        }

        @Override
        public int hashCode() {
            int i2 = System.identityHashCode(this.a);
            i2 = 31 * i2 + System.identityHashCode(this.b);
            i2 = 31 * i2 + this.c.hashCode();
            return i2;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "first;second;direction", "a", "b", "c"}, this);
        }
    }
}

