/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.portal;

import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.BlockUtil;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.block.BlockPortal;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.apache.commons.lang3.mutable.MutableInt;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_21_R2.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R2.util.BlockStateListPopulator;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.world.PortalCreateEvent;

public class BlockPortalShape {
    private static final int c = 2;
    public static final int a = 21;
    private static final int d = 3;
    public static final int b = 21;
    private static final BlockBase.f e = (iblockdata, iblockaccess, blockposition) -> iblockdata.a(Blocks.cv);
    private static final float f = 4.0f;
    private static final double g = 1.0;
    private final EnumDirection.EnumAxis h;
    private final EnumDirection i;
    private final int j;
    private final BlockPosition k;
    private final int l;
    private final int m;
    private final BlockStateListPopulator blocks;

    private BlockPortalShape(EnumDirection.EnumAxis enumdirection_enumaxis, int i2, EnumDirection enumdirection, BlockPosition blockposition, int j2, int k2, BlockStateListPopulator blocks) {
        this.blocks = blocks;
        this.h = enumdirection_enumaxis;
        this.j = i2;
        this.i = enumdirection;
        this.k = blockposition;
        this.m = j2;
        this.l = k2;
    }

    public static Optional<BlockPortalShape> a(GeneratorAccess world, BlockPosition pos, EnumDirection.EnumAxis firstCheckedAxis) {
        return BlockPortalShape.a(world, pos, (BlockPortalShape blockportalshape) -> blockportalshape.a() && blockportalshape.j == 0, firstCheckedAxis);
    }

    public static Optional<BlockPortalShape> a(GeneratorAccess world, BlockPosition pos, Predicate<BlockPortalShape> validator, EnumDirection.EnumAxis firstCheckedAxis) {
        Optional<BlockPortalShape> optional = Optional.of(BlockPortalShape.a((IBlockAccess)world, pos, firstCheckedAxis)).filter(validator);
        if (optional.isPresent()) {
            return optional;
        }
        EnumDirection.EnumAxis enumdirection_enumaxis1 = firstCheckedAxis == EnumDirection.EnumAxis.a ? EnumDirection.EnumAxis.c : EnumDirection.EnumAxis.a;
        return Optional.of(BlockPortalShape.a((IBlockAccess)world, pos, enumdirection_enumaxis1)).filter(validator);
    }

    public static BlockPortalShape a(IBlockAccess world, BlockPosition pos, EnumDirection.EnumAxis axis) {
        BlockStateListPopulator blocks;
        EnumDirection enumdirection = axis == EnumDirection.EnumAxis.a ? EnumDirection.e : EnumDirection.d;
        BlockPosition blockposition1 = BlockPortalShape.calculateBottomLeft(world, enumdirection, pos, blocks = new BlockStateListPopulator(((GeneratorAccess)world).getMinecraftWorld()));
        if (blockposition1 == null) {
            return new BlockPortalShape(axis, 0, enumdirection, pos, 0, 0, blocks);
        }
        int i2 = BlockPortalShape.calculateWidth(world, blockposition1, enumdirection, blocks);
        if (i2 == 0) {
            return new BlockPortalShape(axis, 0, enumdirection, blockposition1, 0, 0, blocks);
        }
        MutableInt mutableint = new MutableInt();
        int j2 = BlockPortalShape.calculateHeight(world, blockposition1, enumdirection, i2, mutableint, blocks);
        return new BlockPortalShape(axis, mutableint.getValue(), enumdirection, blockposition1, i2, j2, blocks);
    }

    @Nullable
    private static BlockPosition calculateBottomLeft(IBlockAccess iblockaccess, EnumDirection enumdirection, BlockPosition blockposition, BlockStateListPopulator blocks) {
        int i2 = Math.max(iblockaccess.L_(), blockposition.v() - 21);
        while (blockposition.v() > i2 && BlockPortalShape.a(iblockaccess.a_(blockposition.e()))) {
            blockposition = blockposition.e();
        }
        EnumDirection enumdirection1 = enumdirection.g();
        int j2 = BlockPortalShape.getDistanceUntilEdgeAboveFrame(iblockaccess, blockposition, enumdirection1, blocks) - 1;
        return j2 < 0 ? null : blockposition.a(enumdirection1, j2);
    }

    private static int calculateWidth(IBlockAccess iblockaccess, BlockPosition blockposition, EnumDirection enumdirection, BlockStateListPopulator blocks) {
        int i2 = BlockPortalShape.getDistanceUntilEdgeAboveFrame(iblockaccess, blockposition, enumdirection, blocks);
        return i2 >= 2 && i2 <= 21 ? i2 : 0;
    }

    private static int getDistanceUntilEdgeAboveFrame(IBlockAccess iblockaccess, BlockPosition blockposition, EnumDirection enumdirection, BlockStateListPopulator blocks) {
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
        for (int i2 = 0; i2 <= 21; ++i2) {
            blockposition_mutableblockposition.g(blockposition).c(enumdirection, i2);
            IBlockData iblockdata = iblockaccess.a_(blockposition_mutableblockposition);
            if (!BlockPortalShape.a(iblockdata)) {
                if (!e.test(iblockdata, iblockaccess, blockposition_mutableblockposition)) break;
                blocks.a((BlockPosition)blockposition_mutableblockposition, iblockdata, 18);
                return i2;
            }
            IBlockData iblockdata1 = iblockaccess.a_(blockposition_mutableblockposition.c(EnumDirection.a));
            if (!e.test(iblockdata1, iblockaccess, blockposition_mutableblockposition)) break;
            blocks.a((BlockPosition)blockposition_mutableblockposition, iblockdata1, 18);
        }
        return 0;
    }

    private static int calculateHeight(IBlockAccess iblockaccess, BlockPosition blockposition, EnumDirection enumdirection, int i2, MutableInt mutableint, BlockStateListPopulator blocks) {
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
        int j2 = BlockPortalShape.getDistanceUntilTop(iblockaccess, blockposition, enumdirection, blockposition_mutableblockposition, i2, mutableint, blocks);
        return j2 >= 3 && j2 <= 21 && BlockPortalShape.hasTopFrame(iblockaccess, blockposition, enumdirection, blockposition_mutableblockposition, i2, j2, blocks) ? j2 : 0;
    }

    private static boolean hasTopFrame(IBlockAccess iblockaccess, BlockPosition blockposition, EnumDirection enumdirection, BlockPosition.MutableBlockPosition blockposition_mutableblockposition, int i2, int j2, BlockStateListPopulator blocks) {
        for (int k2 = 0; k2 < i2; ++k2) {
            BlockPosition.MutableBlockPosition blockposition_mutableblockposition1 = blockposition_mutableblockposition.g(blockposition).c(EnumDirection.b, j2).c(enumdirection, k2);
            if (!e.test(iblockaccess.a_(blockposition_mutableblockposition1), iblockaccess, blockposition_mutableblockposition1)) {
                return false;
            }
            blocks.a((BlockPosition)blockposition_mutableblockposition1, iblockaccess.a_(blockposition_mutableblockposition1), 18);
        }
        return true;
    }

    private static int getDistanceUntilTop(IBlockAccess iblockaccess, BlockPosition blockposition, EnumDirection enumdirection, BlockPosition.MutableBlockPosition blockposition_mutableblockposition, int i2, MutableInt mutableint, BlockStateListPopulator blocks) {
        for (int j2 = 0; j2 < 21; ++j2) {
            blockposition_mutableblockposition.g(blockposition).c(EnumDirection.b, j2).c(enumdirection, -1);
            if (!e.test(iblockaccess.a_(blockposition_mutableblockposition), iblockaccess, blockposition_mutableblockposition)) {
                return j2;
            }
            blockposition_mutableblockposition.g(blockposition).c(EnumDirection.b, j2).c(enumdirection, i2);
            if (!e.test(iblockaccess.a_(blockposition_mutableblockposition), iblockaccess, blockposition_mutableblockposition)) {
                return j2;
            }
            for (int k2 = 0; k2 < i2; ++k2) {
                blockposition_mutableblockposition.g(blockposition).c(EnumDirection.b, j2).c(enumdirection, k2);
                IBlockData iblockdata = iblockaccess.a_(blockposition_mutableblockposition);
                if (!BlockPortalShape.a(iblockdata)) {
                    return j2;
                }
                if (!iblockdata.a(Blocks.eq)) continue;
                mutableint.increment();
            }
            blocks.a((BlockPosition)blockposition_mutableblockposition.g(blockposition).c(EnumDirection.b, j2).c(enumdirection, -1), iblockaccess.a_(blockposition_mutableblockposition), 18);
            blocks.a((BlockPosition)blockposition_mutableblockposition.g(blockposition).c(EnumDirection.b, j2).c(enumdirection, i2), iblockaccess.a_(blockposition_mutableblockposition), 18);
        }
        return 21;
    }

    private static boolean a(IBlockData state) {
        return state.l() || state.a(TagsBlock.aN) || state.a(Blocks.eq);
    }

    public boolean a() {
        return this.m >= 2 && this.m <= 21 && this.l >= 3 && this.l <= 21;
    }

    public boolean createPortalBlocks(GeneratorAccess generatoraccess, net.minecraft.world.entity.Entity entity) {
        CraftWorld bworld = generatoraccess.getMinecraftWorld().getWorld();
        IBlockData iblockdata = (IBlockData)Blocks.eq.m().b(BlockPortal.b, this.h);
        BlockPosition.c(this.k, this.k.a(EnumDirection.b, this.l - 1).a(this.i, this.m - 1)).forEach(blockposition -> this.blocks.a((BlockPosition)blockposition, iblockdata, 18));
        PortalCreateEvent event = new PortalCreateEvent(this.blocks.getList(), (World)bworld, (Entity)(entity == null ? null : entity.getBukkitEntity()), PortalCreateEvent.CreateReason.FIRE);
        generatoraccess.getMinecraftWorld().p().server.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return false;
        }
        BlockPosition.c(this.k, this.k.a(EnumDirection.b, this.l - 1).a(this.i, this.m - 1)).forEach(blockposition -> generatoraccess.a((BlockPosition)blockposition, iblockdata, 18));
        return true;
    }

    public boolean b() {
        return this.a() && this.j == this.m * this.l;
    }

    public static Vec3D a(BlockUtil.Rectangle portalRect, EnumDirection.EnumAxis portalAxis, Vec3D entityPos, EntitySize entityDimensions) {
        EnumDirection.EnumAxis enumdirection_enumaxis1;
        double d3;
        double d2;
        double d0 = (double)portalRect.b - (double)entityDimensions.a();
        double d1 = (double)portalRect.c - (double)entityDimensions.b();
        BlockPosition blockposition = portalRect.a;
        if (d0 > 0.0) {
            d2 = (double)blockposition.a(portalAxis) + (double)entityDimensions.a() / 2.0;
            d3 = MathHelper.a(MathHelper.c(entityPos.a(portalAxis) - d2, 0.0, d0), 0.0, 1.0);
        } else {
            d3 = 0.5;
        }
        if (d1 > 0.0) {
            enumdirection_enumaxis1 = EnumDirection.EnumAxis.b;
            d2 = MathHelper.a(MathHelper.c(entityPos.a(enumdirection_enumaxis1) - (double)blockposition.a(enumdirection_enumaxis1), 0.0, d1), 0.0, 1.0);
        } else {
            d2 = 0.0;
        }
        enumdirection_enumaxis1 = portalAxis == EnumDirection.EnumAxis.a ? EnumDirection.EnumAxis.c : EnumDirection.EnumAxis.a;
        double d4 = entityPos.a(enumdirection_enumaxis1) - ((double)blockposition.a(enumdirection_enumaxis1) + 0.5);
        return new Vec3D(d3, d2, d4);
    }

    public static Vec3D a(Vec3D fallback, WorldServer world, net.minecraft.world.entity.Entity entity, EntitySize dimensions) {
        if (dimensions.a() <= 4.0f && dimensions.b() <= 4.0f) {
            double d0 = (double)dimensions.b() / 2.0;
            Vec3D vec3d1 = fallback.b(0.0, d0, 0.0);
            VoxelShape voxelshape = VoxelShapes.a(AxisAlignedBB.a(vec3d1, dimensions.a(), 0.0, dimensions.a()).b(0.0, 1.0, 0.0).g(1.0E-6));
            Optional<Vec3D> optional = world.a(entity, voxelshape, vec3d1, (double)dimensions.a(), (double)dimensions.b(), (double)dimensions.a());
            Optional<Vec3D> optional1 = optional.map(vec3d2 -> vec3d2.a(0.0, d0, 0.0));
            return optional1.orElse(fallback);
        }
        return fallback;
    }
}

