/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.redstone;

import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.ArrayDeque;
import java.util.Deque;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockRedstoneWire;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockPropertyRedstoneSide;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.level.redstone.RedstoneWireEvaluator;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_21_R2.block.CraftBlock;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockRedstoneEvent;

public class ExperimentalRedstoneWireEvaluator
extends RedstoneWireEvaluator {
    private final Deque<BlockPosition> b = new ArrayDeque<BlockPosition>();
    private final Deque<BlockPosition> c = new ArrayDeque<BlockPosition>();
    private final Object2IntMap<BlockPosition> d = new Object2IntLinkedOpenHashMap();

    public ExperimentalRedstoneWireEvaluator(BlockRedstoneWire wire) {
        super(wire);
    }

    @Override
    public void a(World world, BlockPosition pos, IBlockData state, @Nullable Orientation orientation, boolean blockAdded) {
        Orientation orientation1 = ExperimentalRedstoneWireEvaluator.a(world, orientation);
        this.a(world, pos, orientation1);
        ObjectIterator objectiterator = this.d.object2IntEntrySet().iterator();
        boolean flag1 = true;
        while (objectiterator.hasNext()) {
            Object2IntMap.Entry entry = (Object2IntMap.Entry)objectiterator.next();
            BlockPosition blockposition1 = (BlockPosition)entry.getKey();
            int i2 = entry.getIntValue();
            int j2 = ExperimentalRedstoneWireEvaluator.b(i2);
            IBlockData iblockdata1 = world.a_(blockposition1);
            int oldPower = iblockdata1.c(BlockRedstoneWire.f);
            if (oldPower != j2) {
                BlockRedstoneEvent event = new BlockRedstoneEvent((Block)CraftBlock.at(world, blockposition1), oldPower, j2);
                world.getCraftServer().getPluginManager().callEvent((Event)event);
                j2 = event.getNewCurrent();
            }
            if (iblockdata1.a(this.a) && oldPower != j2) {
                int k2 = 2;
                if (!blockAdded || !flag1) {
                    k2 |= 0x80;
                }
                world.a(blockposition1, (IBlockData)iblockdata1.b(BlockRedstoneWire.f, j2), k2);
            } else {
                objectiterator.remove();
            }
            flag1 = false;
        }
        this.a(world);
    }

    private void a(World world) {
        this.d.forEach((blockposition, integer) -> {
            Orientation orientation = ExperimentalRedstoneWireEvaluator.a(integer);
            IBlockData iblockdata = world.a_((BlockPosition)blockposition);
            for (EnumDirection enumdirection : orientation.f()) {
                if (!ExperimentalRedstoneWireEvaluator.a(iblockdata, enumdirection)) continue;
                BlockPosition blockposition1 = blockposition.a(enumdirection);
                IBlockData iblockdata1 = world.a_(blockposition1);
                Orientation orientation1 = orientation.c(enumdirection);
                world.a(iblockdata1, blockposition1, this.a, orientation1, false);
                if (!iblockdata1.d(world, blockposition1)) continue;
                for (EnumDirection enumdirection1 : orientation1.f()) {
                    if (enumdirection1 == enumdirection.g()) continue;
                    world.b(blockposition1.a(enumdirection1), this.a, orientation1.c(enumdirection1));
                }
            }
        });
    }

    private static boolean a(IBlockData wireState, EnumDirection direction) {
        BlockStateEnum<BlockPropertyRedstoneSide> blockstateenum = BlockRedstoneWire.g.get(direction);
        return blockstateenum == null ? direction == EnumDirection.a : wireState.c(blockstateenum).a();
    }

    private static Orientation a(World world, @Nullable Orientation orientation) {
        Orientation orientation1 = orientation != null ? orientation : Orientation.a(world.A);
        return orientation1.a(EnumDirection.b).a(Orientation.a.a);
    }

    private void a(World world, BlockPosition pos, Orientation orientation) {
        int l2;
        int k2;
        int j2;
        int i2;
        BlockPosition blockposition1;
        IBlockData iblockdata = world.a_(pos);
        if (iblockdata.a(this.a)) {
            this.a(pos, iblockdata.c(BlockRedstoneWire.f), orientation);
            this.b.add(pos);
        } else {
            this.a(world, pos, 0, orientation, true);
        }
        while (!this.b.isEmpty()) {
            int j1;
            blockposition1 = this.b.removeFirst();
            i2 = this.d.getInt((Object)blockposition1);
            Orientation orientation1 = ExperimentalRedstoneWireEvaluator.a(i2);
            j2 = ExperimentalRedstoneWireEvaluator.b(i2);
            k2 = this.a(world, blockposition1);
            int i1 = Math.max(k2, l2 = this.b(world, blockposition1));
            if (i1 < j2) {
                if (k2 > 0 && !this.c.contains(blockposition1)) {
                    this.c.add(blockposition1);
                }
                j1 = 0;
            } else {
                j1 = i1;
            }
            if (j1 != j2) {
                this.a(blockposition1, j1, orientation1);
            }
            this.a(world, blockposition1, j1, orientation1, j2 > i1);
        }
        while (!this.c.isEmpty()) {
            blockposition1 = this.c.removeFirst();
            i2 = this.d.getInt((Object)blockposition1);
            int k1 = ExperimentalRedstoneWireEvaluator.b(i2);
            j2 = this.a(world, blockposition1);
            k2 = this.b(world, blockposition1);
            l2 = Math.max(j2, k2);
            Orientation orientation2 = ExperimentalRedstoneWireEvaluator.a(i2);
            if (l2 > k1) {
                this.a(blockposition1, l2, orientation2);
            } else if (l2 < k1) {
                throw new IllegalStateException("Turning off wire while trying to turn it on. Should not happen.");
            }
            this.a(world, blockposition1, l2, orientation2, false);
        }
    }

    private static int a(Orientation orientation, int power) {
        return orientation.i() << 4 | power;
    }

    private static Orientation a(int packed) {
        return Orientation.a(packed >> 4);
    }

    private static int b(int packed) {
        return packed & 0xF;
    }

    private void a(BlockPosition pos, int power, Orientation defaultOrientation) {
        this.d.compute((Object)pos, (blockposition1, integer) -> integer == null ? ExperimentalRedstoneWireEvaluator.a(defaultOrientation, power) : ExperimentalRedstoneWireEvaluator.a(ExperimentalRedstoneWireEvaluator.a(integer), power));
    }

    private void a(World world, BlockPosition pos, int power, Orientation orientation, boolean canIncreasePower) {
        BlockPosition blockposition1;
        for (EnumDirection enumdirection : orientation.g()) {
            blockposition1 = pos.a(enumdirection);
            this.b(world, blockposition1, power, orientation.b(enumdirection), canIncreasePower);
        }
        for (EnumDirection enumdirection : orientation.h()) {
            blockposition1 = pos.a(enumdirection);
            boolean flag1 = world.a_(blockposition1).d(world, blockposition1);
            for (EnumDirection enumdirection1 : orientation.g()) {
                BlockPosition blockposition3;
                BlockPosition blockposition2 = pos.a(enumdirection1);
                if (enumdirection == EnumDirection.b && !flag1) {
                    blockposition3 = blockposition1.a(enumdirection1);
                    this.b(world, blockposition3, power, orientation.b(enumdirection1), canIncreasePower);
                    continue;
                }
                if (enumdirection != EnumDirection.a || world.a_(blockposition2).d(world, blockposition2)) continue;
                blockposition3 = blockposition1.a(enumdirection1);
                this.b(world, blockposition3, power, orientation.b(enumdirection1), canIncreasePower);
            }
        }
    }

    private void b(World world, BlockPosition neighborPos, int power, Orientation orientation, boolean canIncreasePower) {
        IBlockData iblockdata = world.a_(neighborPos);
        if (iblockdata.a(this.a)) {
            int j2 = this.a(neighborPos, iblockdata);
            if (j2 < power - 1 && !this.c.contains(neighborPos)) {
                this.c.add(neighborPos);
                this.a(neighborPos, j2, orientation);
            }
            if (canIncreasePower && j2 > power && !this.b.contains(neighborPos)) {
                this.b.add(neighborPos);
                this.a(neighborPos, j2, orientation);
            }
        }
    }

    @Override
    protected int a(BlockPosition world, IBlockData pos) {
        int i2 = this.d.getOrDefault((Object)world, -1);
        return i2 != -1 ? ExperimentalRedstoneWireEvaluator.b(i2) : super.a(world, pos);
    }
}

