/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.saveddata.maps;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import io.netty.buffer.ByteBuf;
import io.papermc.paper.adventure.PaperAdventure;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTNumber;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutMap;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.decoration.EntityItemFrame;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.MapDecorations;
import net.minecraft.world.item.component.MapItemColor;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.dimension.DimensionManager;
import net.minecraft.world.level.saveddata.PersistentBase;
import net.minecraft.world.level.saveddata.maps.MapDecorationType;
import net.minecraft.world.level.saveddata.maps.MapDecorationTypes;
import net.minecraft.world.level.saveddata.maps.MapIcon;
import net.minecraft.world.level.saveddata.maps.MapIconBanner;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.WorldMapFrame;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_21_R2.CraftServer;
import org.bukkit.craftbukkit.v1_21_R2.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R2.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R2.map.CraftMapCursor;
import org.bukkit.craftbukkit.v1_21_R2.map.CraftMapRenderer;
import org.bukkit.craftbukkit.v1_21_R2.map.CraftMapView;
import org.bukkit.craftbukkit.v1_21_R2.map.RenderData;
import org.bukkit.entity.Player;
import org.bukkit.map.MapCursor;
import org.slf4j.Logger;

public class WorldMap
extends PersistentBase {
    private static final Logger i = LogUtils.getLogger();
    private static final int j = 128;
    private static final int k = 64;
    public static final int a = 4;
    public static final int b = 256;
    private static final String l = "frame-";
    public int c;
    public int d;
    public ResourceKey<World> e;
    public boolean m;
    public boolean n;
    public byte f;
    public byte[] g = new byte[16384];
    public boolean h;
    public final List<WorldMapHumanTracker> o = Lists.newArrayList();
    public final Map<EntityHuman, WorldMapHumanTracker> p = Maps.newHashMap();
    private final Map<String, MapIconBanner> q = Maps.newHashMap();
    public final Map<String, MapIcon> r = Maps.newLinkedHashMap();
    private final Map<String, WorldMapFrame> s = Maps.newHashMap();
    private int t;
    private RenderData vanillaRender = new RenderData();
    public final CraftMapView mapView;
    private CraftServer server;
    public UUID uniqueId = null;
    public MapId id;

    public static PersistentBase.a<WorldMap> a() {
        return new PersistentBase.a<WorldMap>(() -> {
            throw new IllegalStateException("Should never create an empty map saved data");
        }, WorldMap::b, DataFixTypes.j);
    }

    private WorldMap(int centerX, int centerZ, byte scale, boolean showDecorations, boolean unlimitedTracking, boolean locked, ResourceKey<World> dimension) {
        this.f = scale;
        this.c = centerX;
        this.d = centerZ;
        this.e = dimension;
        this.m = showDecorations;
        this.n = unlimitedTracking;
        this.h = locked;
        this.mapView = new CraftMapView(this);
        this.server = (CraftServer)Bukkit.getServer();
        this.vanillaRender.buffer = this.g;
    }

    public static WorldMap a(double centerX, double centerZ, byte scale, boolean showDecorations, boolean unlimitedTracking, ResourceKey<World> dimension) {
        int i2 = 128 * (1 << scale);
        int j2 = MathHelper.a((centerX + 64.0) / (double)i2);
        int k2 = MathHelper.a((centerZ + 64.0) / (double)i2);
        int l2 = j2 * i2 + i2 / 2 - 64;
        int i1 = k2 * i2 + i2 / 2 - 64;
        return new WorldMap(l2, i1, scale, showDecorations, unlimitedTracking, false, dimension);
    }

    public static WorldMap a(byte scale, boolean locked, ResourceKey<World> dimension) {
        return new WorldMap(0, 0, scale, false, false, locked, dimension);
    }

    public static WorldMap b(NBTTagCompound nbt, HolderLookup.a registries) {
        NBTNumber numericTag;
        NBTBase dimension = nbt.c("dimension");
        if (dimension instanceof NBTNumber && (numericTag = (NBTNumber)dimension).g() >= 10) {
            UUID uuid;
            CraftWorld world;
            long least = nbt.i("UUIDLeast");
            long most = nbt.i("UUIDMost");
            dimension = least != 0L && most != 0L ? ((world = (CraftWorld)Bukkit.getWorld((UUID)(uuid = new UUID(most, least)))) != null ? NBTTagString.a("minecraft:" + world.getName().toLowerCase(Locale.ENGLISH)) : NBTTagString.a("bukkit:_invalidworld_")) : NBTTagString.a("bukkit:_invalidworld_");
        }
        DataResult<ResourceKey<World>> dataresult = DimensionManager.a(new Dynamic<NBTBase>(DynamicOpsNBT.a, dimension));
        Logger logger = i;
        Objects.requireNonNull(logger);
        ResourceKey resourcekey = dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).orElseGet(() -> {
            UUID uniqueId;
            CraftWorld world;
            long least = nbt.i("UUIDLeast");
            long most = nbt.i("UUIDMost");
            if (least != 0L && most != 0L && (world = (CraftWorld)Bukkit.getWorld((UUID)(uniqueId = new UUID(most, least)))) != null) {
                return world.getHandle().ah();
            }
            throw new IllegalArgumentException("Invalid map dimension: " + String.valueOf(nbt.c("dimension")));
        });
        int i2 = nbt.h("xCenter");
        int j2 = nbt.h("zCenter");
        byte b0 = (byte)MathHelper.a((int)nbt.f("scale"), 0, 4);
        boolean flag = !nbt.b("trackingPosition", 1) || nbt.q("trackingPosition");
        boolean flag1 = nbt.q("unlimitedTracking");
        boolean flag2 = nbt.q("locked");
        WorldMap worldmap = new WorldMap(i2, j2, b0, flag, flag1, flag2, resourcekey);
        byte[] abyte = nbt.m("colors");
        if (abyte.length == 16384) {
            worldmap.g = abyte;
        }
        worldmap.vanillaRender.buffer = abyte;
        RegistryOps<NBTBase> registryops = registries.a(DynamicOpsNBT.a);
        List list = MapIconBanner.b.parse(registryops, (Object)nbt.c("banners")).resultOrPartial(s2 -> i.warn("Failed to parse map banner: '{}'", s2)).orElse(List.of());
        for (MapIconBanner mapiconbanner : list) {
            worldmap.q.put(mapiconbanner.b(), mapiconbanner);
            worldmap.a(mapiconbanner.a(), null, mapiconbanner.b(), mapiconbanner.c().u(), mapiconbanner.c().w(), 180.0, mapiconbanner.e().orElse(null));
        }
        NBTTagList nbttaglist = nbt.c("frames", 10);
        for (int k2 = 0; k2 < nbttaglist.size(); ++k2) {
            WorldMapFrame worldmapframe = WorldMapFrame.a(nbttaglist.a(k2));
            if (worldmapframe == null) continue;
            worldmap.s.put(worldmapframe.e(), worldmapframe);
            worldmap.a(MapDecorationTypes.b, null, WorldMap.b(worldmapframe.d()), worldmapframe.b().u(), worldmapframe.b().w(), worldmapframe.c(), null);
        }
        return worldmap;
    }

    @Override
    public NBTTagCompound a(NBTTagCompound nbt, HolderLookup.a registries) {
        DataResult dataresult = MinecraftKey.a.encodeStart((DynamicOps)DynamicOpsNBT.a, (Object)this.e.a());
        Logger logger = i;
        Objects.requireNonNull(logger);
        dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).ifPresent(nbtbase -> nbt.a("dimension", (NBTBase)nbtbase));
        if (this.uniqueId == null) {
            for (org.bukkit.World world : this.server.getWorlds()) {
                CraftWorld cWorld = (CraftWorld)world;
                if (cWorld.getHandle().ah() != this.e) continue;
                this.uniqueId = cWorld.getUID();
                break;
            }
        }
        if (this.uniqueId != null) {
            nbt.a("UUIDLeast", this.uniqueId.getLeastSignificantBits());
            nbt.a("UUIDMost", this.uniqueId.getMostSignificantBits());
        }
        nbt.a("xCenter", this.c);
        nbt.a("zCenter", this.d);
        nbt.a("scale", this.f);
        nbt.a("colors", this.g);
        nbt.a("trackingPosition", this.m);
        nbt.a("unlimitedTracking", this.n);
        nbt.a("locked", this.h);
        RegistryOps<NBTBase> registryops = registries.a(DynamicOpsNBT.a);
        nbt.a("banners", (NBTBase)MapIconBanner.b.encodeStart(registryops, List.copyOf(this.q.values())).getOrThrow());
        NBTTagList nbttaglist = new NBTTagList();
        for (WorldMapFrame worldmapframe : this.s.values()) {
            nbttaglist.add(worldmapframe.a());
        }
        nbt.a("frames", nbttaglist);
        return nbt;
    }

    public WorldMap b() {
        WorldMap worldmap = new WorldMap(this.c, this.d, this.f, this.m, this.n, true, this.e);
        worldmap.q.putAll(this.q);
        worldmap.r.putAll(this.r);
        worldmap.t = this.t;
        System.arraycopy(this.g, 0, worldmap.g, 0, this.g.length);
        return worldmap;
    }

    public WorldMap e() {
        return WorldMap.a(this.c, this.d, (byte)MathHelper.a(this.f + 1, 0, 4), this.m, this.n, this.e);
    }

    private static Predicate<ItemStack> a(ItemStack stack) {
        MapId mapid = stack.a(DataComponents.L);
        return itemstack1 -> itemstack1 == stack ? true : itemstack1.a(stack.h()) && Objects.equals(mapid, itemstack1.a(DataComponents.L));
    }

    public void a(EntityHuman player, ItemStack stack) {
        if (!this.p.containsKey(player)) {
            WorldMapHumanTracker worldmap_worldmaphumantracker = new WorldMapHumanTracker(player);
            this.p.put(player, worldmap_worldmaphumantracker);
            this.o.add(worldmap_worldmaphumantracker);
        }
        Predicate<ItemStack> predicate = WorldMap.a(stack);
        if (!player.gi().b(predicate)) {
            this.a(player.al().getString());
        }
        for (int i2 = 0; i2 < this.o.size(); ++i2) {
            WorldMapHumanTracker worldmap_worldmaphumantracker1 = this.o.get(i2);
            EntityHuman entityhuman1 = worldmap_worldmaphumantracker1.a;
            String s2 = entityhuman1.al().getString();
            if (!entityhuman1.dR() && (entityhuman1.gi().b(predicate) || stack.G())) {
                if (!stack.G() && entityhuman1.dW().ah() == this.e && this.m) {
                    this.a(MapDecorationTypes.a, entityhuman1.dW(), s2, entityhuman1.dB(), entityhuman1.dH(), entityhuman1.dM(), null);
                }
            } else {
                this.p.remove(entityhuman1);
                this.o.remove(worldmap_worldmaphumantracker1);
                this.a(s2);
            }
            if (entityhuman1.equals(player) || !WorldMap.b(entityhuman1)) continue;
            this.a(s2);
        }
        if (stack.G() && this.m) {
            EntityItemFrame entityitemframe = stack.H();
            BlockPosition blockposition = entityitemframe.p();
            WorldMapFrame worldmapframe = this.s.get(WorldMapFrame.a(blockposition));
            if (worldmapframe != null && entityitemframe.ar() != worldmapframe.d() && this.s.containsKey(worldmapframe.e())) {
                this.a(WorldMap.b(worldmapframe.d()));
            }
            WorldMapFrame worldmapframe1 = new WorldMapFrame(blockposition, entityitemframe.cO().e() * 90, entityitemframe.ar());
            if (this.r.size() < player.dW().paperConfig().maps.itemFrameCursorLimit) {
                this.a(MapDecorationTypes.b, player.dW(), WorldMap.b(entityitemframe.ar()), blockposition.u(), blockposition.w(), entityitemframe.cO().e() * 90, null);
                this.s.put(worldmapframe1.e(), worldmapframe1);
            }
        }
        MapDecorations mapdecorations = stack.a(DataComponents.M, MapDecorations.a);
        if (!this.r.keySet().containsAll(mapdecorations.a().keySet())) {
            mapdecorations.a().forEach((s1, mapdecorations_a) -> {
                if (!this.r.containsKey(s1)) {
                    this.a(mapdecorations_a.a(), player.dW(), (String)s1, mapdecorations_a.b(), mapdecorations_a.c(), mapdecorations_a.d(), null);
                }
            });
        }
    }

    private static boolean b(EntityHuman player) {
        for (EnumItemSlot enumitemslot : EnumItemSlot.values()) {
            if (enumitemslot == EnumItemSlot.a || enumitemslot == EnumItemSlot.b || !player.a(enumitemslot).a(TagsItem.cn)) continue;
            return true;
        }
        return false;
    }

    private void a(String id) {
        MapIcon mapicon = this.r.remove(id);
        if (mapicon != null && mapicon.c().a().f()) {
            --this.t;
        }
        if (mapicon != null) {
            this.i();
        }
    }

    public static void a(ItemStack stack, BlockPosition pos, String id, Holder<MapDecorationType> decorationType) {
        MapDecorations.a mapdecorations_a = new MapDecorations.a(decorationType, pos.u(), pos.w(), 180.0f);
        stack.a(DataComponents.M, MapDecorations.a, mapdecorations -> mapdecorations.a(id, mapdecorations_a));
        if (decorationType.a().a()) {
            stack.b(DataComponents.K, new MapItemColor(decorationType.a().d()));
        }
    }

    private void a(Holder<MapDecorationType> type, @Nullable GeneratorAccess world, String key, double x2, double z2, double rotation, @Nullable IChatBaseComponent text) {
        int i2 = 1 << this.f;
        float f2 = (float)(x2 - (double)this.c) / (float)i2;
        float f1 = (float)(z2 - (double)this.d) / (float)i2;
        b worldmap_b = this.a(type, world, rotation, f2, f1);
        if (worldmap_b == null) {
            this.a(key);
        } else {
            MapIcon mapicon1;
            MapIcon mapicon = new MapIcon(worldmap_b.a(), worldmap_b.b(), worldmap_b.c(), worldmap_b.d(), Optional.ofNullable(text));
            if (!mapicon.equals(mapicon1 = this.r.put(key, mapicon))) {
                if (mapicon1 != null && mapicon1.c().a().f()) {
                    --this.t;
                }
                if (worldmap_b.a().a().f()) {
                    ++this.t;
                }
                this.i();
            }
        }
    }

    @Nullable
    private b a(Holder<MapDecorationType> type, @Nullable GeneratorAccess world, double rotation, float dx, float dz) {
        byte b0 = WorldMap.a(dx);
        byte b1 = WorldMap.a(dz);
        if (type.a(MapDecorationTypes.a)) {
            Pair<Holder<MapDecorationType>, Byte> pair = this.b(type, world, rotation, dx, dz);
            return pair == null ? null : new b((Holder)pair.getFirst(), b0, b1, (Byte)pair.getSecond());
        }
        return !WorldMap.a(dx, dz) && !this.n ? null : new b(type, b0, b1, this.a(world, rotation));
    }

    @Nullable
    private Pair<Holder<MapDecorationType>, Byte> b(Holder<MapDecorationType> type, @Nullable GeneratorAccess world, double rotation, float dx, float dz) {
        if (WorldMap.a(dx, dz)) {
            return Pair.of(type, (Object)this.a(world, rotation));
        }
        Holder<MapDecorationType> holder1 = this.b(dx, dz);
        return holder1 == null ? null : Pair.of(holder1, (Object)0);
    }

    private byte a(@Nullable GeneratorAccess world, double rotation) {
        if (this.e == World.j && world != null) {
            int i2 = (int)(world.D_().d() / 10L);
            return (byte)(i2 * i2 * 34187121 + i2 * 121 >> 15 & 0xF);
        }
        double d1 = rotation < 0.0 ? rotation - 8.0 : rotation + 8.0;
        return (byte)(d1 * 16.0 / 360.0);
    }

    private static boolean a(float dx, float dz) {
        boolean flag = true;
        return dx >= -63.0f && dz >= -63.0f && dx <= 63.0f && dz <= 63.0f;
    }

    @Nullable
    private Holder<MapDecorationType> b(float dx, float dz) {
        boolean flag1;
        boolean flag = true;
        boolean bl = flag1 = Math.abs(dx) < 320.0f && Math.abs(dz) < 320.0f;
        return flag1 ? MapDecorationTypes.g : (this.n ? MapDecorationTypes.h : null);
    }

    private static byte a(float d2) {
        boolean flag = true;
        return (byte)(d2 <= -63.0f ? -128 : (byte)(d2 >= 63.0f ? 127 : (byte)((double)(d2 * 2.0f) + 0.5)));
    }

    @Nullable
    public Packet<?> a(MapId mapId, EntityHuman player) {
        WorldMapHumanTracker worldmap_worldmaphumantracker = this.p.get(player);
        return worldmap_worldmaphumantracker == null ? null : worldmap_worldmaphumantracker.a(mapId);
    }

    public void a(int x2, int z2) {
        this.c();
        for (WorldMapHumanTracker worldmap_worldmaphumantracker : this.o) {
            worldmap_worldmaphumantracker.a(x2, z2);
        }
    }

    public void i() {
        this.c();
        this.o.forEach(WorldMapHumanTracker::b);
    }

    public WorldMapHumanTracker a(EntityHuman player) {
        WorldMapHumanTracker worldmap_worldmaphumantracker = this.p.get(player);
        if (worldmap_worldmaphumantracker == null) {
            worldmap_worldmaphumantracker = new WorldMapHumanTracker(player);
            this.p.put(player, worldmap_worldmaphumantracker);
            this.o.add(worldmap_worldmaphumantracker);
        }
        return worldmap_worldmaphumantracker;
    }

    public boolean a(GeneratorAccess world, BlockPosition pos) {
        double d0 = (double)pos.u() + 0.5;
        double d1 = (double)pos.w() + 0.5;
        int i2 = 1 << this.f;
        double d2 = (d0 - (double)this.c) / (double)i2;
        double d3 = (d1 - (double)this.d) / (double)i2;
        boolean flag = true;
        if (d2 >= -63.0 && d3 >= -63.0 && d2 <= 63.0 && d3 <= 63.0) {
            MapIconBanner mapiconbanner = MapIconBanner.a(world, pos);
            if (mapiconbanner == null) {
                return false;
            }
            if (this.q.remove(mapiconbanner.b(), mapiconbanner)) {
                this.a(mapiconbanner.b());
                return true;
            }
            if (!this.a(((World)world).paperConfig().maps.itemFrameCursorLimit)) {
                this.q.put(mapiconbanner.b(), mapiconbanner);
                this.a(mapiconbanner.a(), world, mapiconbanner.b(), d0, d1, 180.0, mapiconbanner.e().orElse(null));
                return true;
            }
        }
        return false;
    }

    public void a(IBlockAccess world, int x2, int z2) {
        Iterator<MapIconBanner> iterator = this.q.values().iterator();
        while (iterator.hasNext()) {
            MapIconBanner mapiconbanner1;
            MapIconBanner mapiconbanner = iterator.next();
            if (mapiconbanner.c().u() != x2 || mapiconbanner.c().w() != z2 || mapiconbanner.equals(mapiconbanner1 = MapIconBanner.a(world, mapiconbanner.c()))) continue;
            iterator.remove();
            this.a(mapiconbanner.b());
        }
    }

    public Collection<MapIconBanner> f() {
        return this.q.values();
    }

    public void a(BlockPosition pos, int id) {
        this.a(WorldMap.b(id));
        this.s.remove(WorldMapFrame.a(pos));
        this.c();
    }

    public boolean a(int x2, int z2, byte color) {
        byte b1 = this.g[x2 + z2 * 128];
        if (b1 != color) {
            this.b(x2, z2, color);
            return true;
        }
        return false;
    }

    public void b(int x2, int z2, byte color) {
        this.g[x2 + z2 * 128] = color;
        this.a(x2, z2);
    }

    public boolean g() {
        MapIcon mapicon;
        Iterator<MapIcon> iterator = this.r.values().iterator();
        do {
            if (iterator.hasNext()) continue;
            return false;
        } while (!(mapicon = iterator.next()).c().a().e());
        return true;
    }

    public void a(List<MapIcon> decorations) {
        this.r.clear();
        this.t = 0;
        for (int i2 = 0; i2 < decorations.size(); ++i2) {
            MapIcon mapicon = decorations.get(i2);
            this.r.put("icon-" + i2, mapicon);
            if (!mapicon.c().a().f()) continue;
            ++this.t;
        }
    }

    public Iterable<MapIcon> h() {
        return this.r.values();
    }

    public boolean a(int decorationCount) {
        return this.t >= decorationCount;
    }

    private static String b(int id) {
        return l + id;
    }

    public class WorldMapHumanTracker {
        public final EntityHuman a;
        private boolean d = true;
        private int e;
        private int f;
        private int g = 127;
        private int h = 127;
        private boolean i = true;
        private int j;
        public int b;

        private void addSeenPlayers(Collection<MapIcon> icons) {
            Player player = (Player)this.a.getBukkitEntity();
            WorldMap.this.r.forEach((name, mapIcon) -> {
                Player other = Bukkit.getPlayerExact((String)name);
                if (other == null || player.canSee(other)) {
                    icons.add((MapIcon)mapIcon);
                }
            });
        }

        private boolean shouldUseVanillaMap() {
            return WorldMap.this.mapView.getRenderers().size() == 1 && WorldMap.this.mapView.getRenderers().get(0).getClass() == CraftMapRenderer.class;
        }

        WorldMapHumanTracker(EntityHuman entityhuman) {
            this.a = entityhuman;
        }

        private c createPatch(byte[] buffer) {
            int i2 = this.e;
            int j2 = this.f;
            int k2 = this.g + 1 - this.e;
            int l2 = this.h + 1 - this.f;
            byte[] abyte = new byte[k2 * l2];
            for (int i1 = 0; i1 < k2; ++i1) {
                for (int j1 = 0; j1 < l2; ++j1) {
                    abyte[i1 + j1 * k2] = buffer[i2 + i1 + (j2 + j1) * 128];
                }
            }
            return new c(i2, j2, k2, l2, abyte);
        }

        @Nullable
        Packet<?> a(MapId mapId) {
            ArrayList<MapIcon> collection;
            c worldmap_c;
            RenderData render;
            if (!this.d && this.j % 5 != 0) {
                ++this.j;
                return null;
            }
            boolean vanillaMaps = this.shouldUseVanillaMap();
            RenderData renderData = render = !vanillaMaps ? WorldMap.this.mapView.render((CraftPlayer)this.a.getBukkitEntity()) : WorldMap.this.vanillaRender;
            if (this.d) {
                this.d = false;
                worldmap_c = this.createPatch(render.buffer);
            } else {
                worldmap_c = null;
            }
            if (this.j++ % 5 == 0) {
                this.i = false;
                ArrayList<MapIcon> icons = new ArrayList<MapIcon>();
                if (vanillaMaps) {
                    this.addSeenPlayers(icons);
                }
                for (MapCursor cursor : render.cursors) {
                    if (!cursor.isVisible()) continue;
                    icons.add(new MapIcon(CraftMapCursor.CraftType.bukkitToMinecraftHolder(cursor.getType()), cursor.getX(), cursor.getY(), cursor.getDirection(), Optional.ofNullable(PaperAdventure.asVanilla(cursor.caption()))));
                }
                collection = icons;
            } else {
                collection = null;
            }
            return collection == null && worldmap_c == null ? null : new PacketPlayOutMap(mapId, WorldMap.this.f, WorldMap.this.h, collection, worldmap_c);
        }

        void a(int startX, int startZ) {
            if (this.d) {
                this.e = Math.min(this.e, startX);
                this.f = Math.min(this.f, startZ);
                this.g = Math.max(this.g, startX);
                this.h = Math.max(this.h, startZ);
            } else {
                this.d = true;
                this.e = startX;
                this.f = startZ;
                this.g = startX;
                this.h = startZ;
            }
        }

        private void b() {
            this.i = true;
        }
    }

    private record b(Holder<MapDecorationType> a, byte b, byte c, byte d) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{b.class, "type;x;y;rot", "a", "b", "c", "d"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{b.class, "type;x;y;rot", "a", "b", "c", "d"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{b.class, "type;x;y;rot", "a", "b", "c", "d"}, this, o2);
        }
    }

    public static final class c
    extends Record {
        private final int b;
        private final int c;
        private final int d;
        private final int e;
        private final byte[] f;
        public static final StreamCodec<ByteBuf, Optional<c>> a = StreamCodec.a(c::a, c::a);

        public c(int startX, int startY, int width, int height, byte[] mapColors) {
            this.b = startX;
            this.c = startY;
            this.d = width;
            this.e = height;
            this.f = mapColors;
        }

        private static void a(ByteBuf buf, Optional<c> updateData) {
            if (updateData.isPresent()) {
                c worldmap_c = updateData.get();
                buf.writeByte(worldmap_c.d);
                buf.writeByte(worldmap_c.e);
                buf.writeByte(worldmap_c.b);
                buf.writeByte(worldmap_c.c);
                PacketDataSerializer.a(buf, worldmap_c.f);
            } else {
                buf.writeByte(0);
            }
        }

        private static Optional<c> a(ByteBuf buf) {
            short short0 = buf.readUnsignedByte();
            if (short0 > 0) {
                short short1 = buf.readUnsignedByte();
                short short2 = buf.readUnsignedByte();
                short short3 = buf.readUnsignedByte();
                byte[] abyte = PacketDataSerializer.a(buf);
                return Optional.of(new c(short2, short3, short0, short1, abyte));
            }
            return Optional.empty();
        }

        public void a(WorldMap mapState) {
            for (int i2 = 0; i2 < this.d; ++i2) {
                for (int j2 = 0; j2 < this.e; ++j2) {
                    mapState.b(this.b + i2, this.c + j2, this.f[i2 + j2 * this.d]);
                }
            }
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{c.class, "startX;startY;width;height;mapColors", "b", "c", "d", "e", "f"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{c.class, "startX;startY;width;height;mapColors", "b", "c", "d", "e", "f"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{c.class, "startX;startY;width;height;mapColors", "b", "c", "d", "e", "f"}, this, o2);
        }

        public int a() {
            return this.b;
        }

        public int b() {
            return this.c;
        }

        public int c() {
            return this.d;
        }

        public int d() {
            return this.e;
        }

        public byte[] e() {
            return this.f;
        }
    }
}

