/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.OptionalDynamic;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.SharedConstants;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.protocol.game.PacketPlayOutServerDifficulty;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.level.EnumGamemode;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.WorldDataConfiguration;
import net.minecraft.world.level.WorldSettings;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.dimension.end.EnderDragonBattle;
import net.minecraft.world.level.levelgen.GeneratorSettings;
import net.minecraft.world.level.levelgen.WorldDimensions;
import net.minecraft.world.level.levelgen.WorldOptions;
import net.minecraft.world.level.storage.IWorldDataServer;
import net.minecraft.world.level.storage.LevelVersion;
import net.minecraft.world.level.storage.SaveData;
import net.minecraft.world.level.timers.CustomFunctionCallbackTimerQueue;
import net.minecraft.world.level.timers.CustomFunctionCallbackTimers;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.event.Event;
import org.bukkit.event.weather.ThunderChangeEvent;
import org.bukkit.event.weather.WeatherChangeEvent;
import org.slf4j.Logger;

public class WorldDataServer
implements IWorldDataServer,
SaveData {
    private static final Logger f = LogUtils.getLogger();
    public static final String a = "LevelName";
    protected static final String b = "Player";
    protected static final String c = "WorldGenSettings";
    public WorldSettings g;
    private final WorldOptions h;
    private final a i;
    private final Lifecycle j;
    private BlockPosition k;
    private float l;
    private long m;
    private long n;
    @Nullable
    private final NBTTagCompound o;
    private final int p;
    private int q;
    private boolean r;
    private int s;
    private boolean t;
    private int u;
    private boolean v;
    private boolean w;
    private WorldBorder.c x;
    private EnderDragonBattle.a y;
    @Nullable
    private NBTTagCompound z;
    private int A;
    private int B;
    @Nullable
    private UUID C;
    private final Set<String> D;
    private boolean E;
    private final Set<String> F;
    private final CustomFunctionCallbackTimerQueue<MinecraftServer> G;
    public IRegistry<WorldDimension> customDimensions;
    private WorldServer world;
    protected NBTBase pdc;

    public void setWorld(WorldServer world) {
        if (this.world != null) {
            return;
        }
        this.world = world;
        world.getWorld().readBukkitValues(this.pdc);
        this.pdc = null;
    }

    private WorldDataServer(@Nullable NBTTagCompound playerData, boolean modded, BlockPosition spawnPos, float spawnAngle, long time, long timeOfDay, int version, int clearWeatherTime, int rainTime, boolean raining, int thunderTime, boolean thundering, boolean initialized, boolean difficultyLocked, WorldBorder.c worldBorder, int wanderingTraderSpawnDelay, int wanderingTraderSpawnChance, @Nullable UUID wanderingTraderId, Set<String> serverBrands, Set<String> removedFeatures, CustomFunctionCallbackTimerQueue<MinecraftServer> scheduledEvents, @Nullable NBTTagCompound customBossEvents, EnderDragonBattle.a dragonFight, WorldSettings levelInfo, WorldOptions generatorOptions, a specialProperty, Lifecycle lifecycle) {
        this.E = modded;
        this.k = spawnPos;
        this.l = spawnAngle;
        this.m = time;
        this.n = timeOfDay;
        this.p = version;
        this.q = clearWeatherTime;
        this.s = rainTime;
        this.r = raining;
        this.u = thunderTime;
        this.t = thundering;
        this.v = initialized;
        this.w = difficultyLocked;
        this.x = worldBorder;
        this.A = wanderingTraderSpawnDelay;
        this.B = wanderingTraderSpawnChance;
        this.C = wanderingTraderId;
        this.D = serverBrands;
        this.F = removedFeatures;
        this.o = playerData;
        this.G = scheduledEvents;
        this.z = customBossEvents;
        this.y = dragonFight;
        this.g = levelInfo;
        this.h = generatorOptions;
        this.i = specialProperty;
        this.j = lifecycle;
    }

    public WorldDataServer(WorldSettings levelInfo, WorldOptions generatorOptions, a specialProperty, Lifecycle lifecycle) {
        this(null, false, BlockPosition.c, 0.0f, 0L, 0L, 19133, 0, 0, false, 0, false, false, false, WorldBorder.d, 0, 0, null, Sets.newLinkedHashSet(), new HashSet<String>(), new CustomFunctionCallbackTimerQueue<MinecraftServer>(CustomFunctionCallbackTimers.a), null, EnderDragonBattle.a.b, levelInfo.h(), generatorOptions, specialProperty, lifecycle);
    }

    public static <T> WorldDataServer a(Dynamic<T> dynamic, WorldSettings info, a specialProperty, WorldOptions generatorOptions, Lifecycle lifecycle) {
        long i2 = dynamic.get("Time").asLong(0L);
        OptionalDynamic<T> optionaldynamic = dynamic.get(b);
        Codec<NBTTagCompound> codec = NBTTagCompound.a;
        Objects.requireNonNull(codec);
        NBTTagCompound nbttagcompound = optionaldynamic.flatMap(arg_0 -> codec.parse(arg_0)).result().orElse(null);
        boolean flag = dynamic.get("WasModded").asBoolean(false);
        BlockPosition blockposition = new BlockPosition(dynamic.get("SpawnX").asInt(0), dynamic.get("SpawnY").asInt(0), dynamic.get("SpawnZ").asInt(0));
        float f2 = dynamic.get("SpawnAngle").asFloat(0.0f);
        long j2 = dynamic.get("DayTime").asLong(i2);
        int k2 = LevelVersion.a(dynamic).a();
        int l2 = dynamic.get("clearWeatherTime").asInt(0);
        int i1 = dynamic.get("rainTime").asInt(0);
        boolean flag1 = dynamic.get("raining").asBoolean(false);
        int j1 = dynamic.get("thunderTime").asInt(0);
        boolean flag2 = dynamic.get("thundering").asBoolean(false);
        boolean flag3 = dynamic.get("initialized").asBoolean(true);
        boolean flag4 = dynamic.get("DifficultyLocked").asBoolean(false);
        WorldBorder.c worldborder_c = WorldBorder.c.a(dynamic, WorldBorder.d);
        int k1 = dynamic.get("WanderingTraderSpawnDelay").asInt(0);
        int l1 = dynamic.get("WanderingTraderSpawnChance").asInt(0);
        UUID uuid = dynamic.get("WanderingTraderId").read(UUIDUtil.a).result().orElse(null);
        Set set = dynamic.get("ServerBrands").asStream().flatMap(dynamic1 -> dynamic1.asString().result().stream()).collect(Collectors.toCollection(Sets::newLinkedHashSet));
        Set<String> set1 = dynamic.get("removed_features").asStream().flatMap(dynamic1 -> dynamic1.asString().result().stream()).collect(Collectors.toSet());
        CustomFunctionCallbackTimerQueue<MinecraftServer> customfunctioncallbacktimerqueue = new CustomFunctionCallbackTimerQueue<MinecraftServer>(CustomFunctionCallbackTimers.a, dynamic.get("ScheduledEvents").asStream());
        NBTTagCompound nbttagcompound1 = (NBTTagCompound)dynamic.get("CustomBossEvents").orElseEmptyMap().getValue();
        DataResult dataresult = dynamic.get("DragonFight").read(EnderDragonBattle.a.a);
        Logger logger = f;
        Objects.requireNonNull(logger);
        return new WorldDataServer(nbttagcompound, flag, blockposition, f2, i2, j2, k2, l2, i1, flag1, j1, flag2, flag3, flag4, worldborder_c, k1, l1, uuid, set, set1, customfunctioncallbacktimerqueue, nbttagcompound1, dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).orElse(EnderDragonBattle.a.b), info, generatorOptions, specialProperty, lifecycle);
    }

    @Override
    public NBTTagCompound a(IRegistryCustom registryManager, @Nullable NBTTagCompound playerNbt) {
        if (playerNbt == null) {
            playerNbt = this.o;
        }
        NBTTagCompound nbttagcompound1 = new NBTTagCompound();
        this.a(registryManager, nbttagcompound1, playerNbt);
        return nbttagcompound1;
    }

    private void a(IRegistryCustom registryManager, NBTTagCompound levelNbt, @Nullable NBTTagCompound playerNbt) {
        levelNbt.a("ServerBrands", WorldDataServer.a(this.D));
        levelNbt.a("WasModded", this.E);
        if (!this.F.isEmpty()) {
            levelNbt.a("removed_features", WorldDataServer.a(this.F));
        }
        NBTTagCompound nbttagcompound2 = new NBTTagCompound();
        nbttagcompound2.a("Name", SharedConstants.b().c());
        nbttagcompound2.a("Id", SharedConstants.b().d().c());
        nbttagcompound2.a("Snapshot", !SharedConstants.b().g());
        nbttagcompound2.a("Series", SharedConstants.b().d().b());
        levelNbt.a("Version", nbttagcompound2);
        GameProfileSerializer.e(levelNbt);
        RegistryOps<NBTBase> dynamicops = registryManager.a(DynamicOpsNBT.a);
        DataResult<NBTBase> dataresult = GeneratorSettings.a(dynamicops, this.h, new WorldDimensions(this.customDimensions != null ? this.customDimensions : registryManager.e(Registries.bf)));
        Logger logger = f;
        Objects.requireNonNull(logger);
        dataresult.resultOrPartial(SystemUtils.a("WorldGenSettings: ", arg_0 -> ((Logger)logger).error(arg_0))).ifPresent(nbtbase -> levelNbt.a(c, (NBTBase)nbtbase));
        levelNbt.a("GameType", this.g.b().a());
        levelNbt.a("SpawnX", this.k.u());
        levelNbt.a("SpawnY", this.k.v());
        levelNbt.a("SpawnZ", this.k.w());
        levelNbt.a("SpawnAngle", this.l);
        levelNbt.a("Time", this.m);
        levelNbt.a("DayTime", this.n);
        levelNbt.a("LastPlayed", SystemUtils.e());
        levelNbt.a(a, this.g.a());
        levelNbt.a("version", 19133);
        levelNbt.a("clearWeatherTime", this.q);
        levelNbt.a("rainTime", this.s);
        levelNbt.a("raining", this.r);
        levelNbt.a("thunderTime", this.u);
        levelNbt.a("thundering", this.t);
        levelNbt.a("hardcore", this.g.c());
        levelNbt.a("allowCommands", this.g.e());
        levelNbt.a("initialized", this.v);
        this.x.a(levelNbt);
        levelNbt.a("Difficulty", (byte)this.g.d().a());
        levelNbt.a("DifficultyLocked", this.w);
        levelNbt.a("GameRules", this.g.f().a());
        levelNbt.a("DragonFight", (NBTBase)EnderDragonBattle.a.a.encodeStart((DynamicOps)DynamicOpsNBT.a, (Object)this.y).getOrThrow());
        if (playerNbt != null) {
            levelNbt.a(b, playerNbt);
        }
        WorldDataConfiguration.b.encodeStart((DynamicOps)DynamicOpsNBT.a, (Object)this.g.g()).ifSuccess(nbtbase -> levelNbt.a((NBTTagCompound)nbtbase)).ifError(error -> f.warn("Failed to encode configuration {}", (Object)error.message()));
        if (this.z != null) {
            levelNbt.a("CustomBossEvents", this.z);
        }
        levelNbt.a("ScheduledEvents", this.G.b());
        levelNbt.a("WanderingTraderSpawnDelay", this.A);
        levelNbt.a("WanderingTraderSpawnChance", this.B);
        if (this.C != null) {
            levelNbt.a("WanderingTraderId", this.C);
        }
        levelNbt.a("Bukkit.Version", Bukkit.getName() + "/" + Bukkit.getVersion() + "/" + Bukkit.getBukkitVersion());
        this.world.getWorld().storeBukkitValues(levelNbt);
    }

    private static NBTTagList a(Set<String> strings) {
        NBTTagList nbttaglist = new NBTTagList();
        Stream<NBTTagString> stream = strings.stream().map(NBTTagString::a);
        Objects.requireNonNull(nbttaglist);
        stream.forEach(nbttaglist::add);
        return nbttaglist;
    }

    @Override
    public BlockPosition a() {
        return this.k;
    }

    @Override
    public float b() {
        return this.l;
    }

    @Override
    public long c() {
        return this.m;
    }

    @Override
    public long d() {
        return this.n;
    }

    @Override
    @Nullable
    public NBTTagCompound w() {
        return this.o;
    }

    @Override
    public void a(long time) {
        this.m = time;
    }

    @Override
    public void b(long timeOfDay) {
        this.n = timeOfDay;
    }

    @Override
    public void a(BlockPosition pos, float angle) {
        this.k = pos.j();
        this.l = angle;
    }

    @Override
    public String e() {
        return this.g.a();
    }

    @Override
    public int x() {
        return this.p;
    }

    @Override
    public int f() {
        return this.q;
    }

    @Override
    public void a(int clearWeatherTime) {
        this.q = clearWeatherTime;
    }

    @Override
    public boolean g() {
        return this.t;
    }

    @Override
    public void a(boolean thundering) {
        this.setThundering(thundering, ThunderChangeEvent.Cause.UNKNOWN);
    }

    public void setThundering(boolean thundering, ThunderChangeEvent.Cause cause) {
        if (this.t == thundering) {
            return;
        }
        World world = Bukkit.getWorld((String)this.e());
        if (world != null) {
            ThunderChangeEvent thunder = new ThunderChangeEvent(world, thundering, cause);
            Bukkit.getServer().getPluginManager().callEvent((Event)thunder);
            if (thunder.isCancelled()) {
                return;
            }
        }
        this.t = thundering;
    }

    @Override
    public int h() {
        return this.u;
    }

    @Override
    public void b(int thunderTime) {
        this.u = thunderTime;
    }

    @Override
    public boolean i() {
        return this.r;
    }

    @Override
    public void b(boolean raining) {
        this.setRaining(raining, WeatherChangeEvent.Cause.UNKNOWN);
    }

    public void setRaining(boolean raining, WeatherChangeEvent.Cause cause) {
        if (this.r == raining) {
            return;
        }
        World world = Bukkit.getWorld((String)this.e());
        if (world != null) {
            WeatherChangeEvent weather = new WeatherChangeEvent(world, raining, cause);
            Bukkit.getServer().getPluginManager().callEvent((Event)weather);
            if (weather.isCancelled()) {
                return;
            }
        }
        this.r = raining;
    }

    @Override
    public int j() {
        return this.s;
    }

    @Override
    public void c(int rainTime) {
        this.s = rainTime;
    }

    @Override
    public EnumGamemode k() {
        return this.g.b();
    }

    @Override
    public void a(EnumGamemode gameMode) {
        this.g = this.g.a(gameMode);
    }

    @Override
    public boolean l() {
        return this.g.c();
    }

    @Override
    public boolean m() {
        return this.g.e();
    }

    @Override
    public boolean n() {
        return this.v;
    }

    @Override
    public void c(boolean initialized) {
        this.v = initialized;
    }

    @Override
    public GameRules o() {
        return this.g.f();
    }

    @Override
    public WorldBorder.c p() {
        return this.x;
    }

    @Override
    public void a(WorldBorder.c worldBorder) {
        this.x = worldBorder;
    }

    @Override
    public EnumDifficulty q() {
        return this.g.d();
    }

    @Override
    public void a(EnumDifficulty difficulty) {
        this.g = this.g.a(difficulty);
        PacketPlayOutServerDifficulty packet = new PacketPlayOutServerDifficulty(this.q(), this.r());
        for (EntityPlayer player : this.world.y()) {
            player.f.b(packet);
        }
    }

    @Override
    public boolean r() {
        return this.w;
    }

    @Override
    public void d(boolean difficultyLocked) {
        this.w = difficultyLocked;
    }

    @Override
    public CustomFunctionCallbackTimerQueue<MinecraftServer> s() {
        return this.G;
    }

    @Override
    public void a(CrashReportSystemDetails reportSection, LevelHeightAccessor world) {
        IWorldDataServer.super.a(reportSection, world);
        SaveData.super.a(reportSection);
    }

    @Override
    public WorldOptions y() {
        return this.h;
    }

    @Override
    public boolean z() {
        return this.i == net.minecraft.world.level.storage.WorldDataServer$a.b;
    }

    @Override
    public boolean A() {
        return this.i == net.minecraft.world.level.storage.WorldDataServer$a.c;
    }

    @Override
    public Lifecycle B() {
        return this.j;
    }

    @Override
    public EnderDragonBattle.a C() {
        return this.y;
    }

    @Override
    public void a(EnderDragonBattle.a dragonFight) {
        this.y = dragonFight;
    }

    @Override
    public WorldDataConfiguration D() {
        return this.g.g();
    }

    @Override
    public void a(WorldDataConfiguration dataConfiguration) {
        this.g = this.g.a(dataConfiguration);
    }

    @Override
    @Nullable
    public NBTTagCompound E() {
        return this.z;
    }

    @Override
    public void a(@Nullable NBTTagCompound customBossEvents) {
        this.z = customBossEvents;
    }

    @Override
    public int t() {
        return this.A;
    }

    @Override
    public void d(int wanderingTraderSpawnDelay) {
        this.A = wanderingTraderSpawnDelay;
    }

    @Override
    public int u() {
        return this.B;
    }

    @Override
    public void e(int wanderingTraderSpawnChance) {
        this.B = wanderingTraderSpawnChance;
    }

    @Override
    @Nullable
    public UUID v() {
        return this.C;
    }

    @Override
    public void a(UUID wanderingTraderId) {
        this.C = wanderingTraderId;
    }

    @Override
    public void a(String brand, boolean modded) {
        this.D.add(brand);
        this.E |= modded;
    }

    @Override
    public boolean F() {
        return this.E;
    }

    @Override
    public Set<String> G() {
        return ImmutableSet.copyOf(this.D);
    }

    @Override
    public Set<String> H() {
        return Set.copyOf(this.F);
    }

    @Override
    public IWorldDataServer I() {
        return this;
    }

    @Override
    public WorldSettings J() {
        return this.g.h();
    }

    public void checkName(String name) {
        if (!this.g.a.equals(name)) {
            this.g.a = name;
        }
    }

    @Deprecated
    public static enum a {
        a,
        b,
        c;

    }
}

