/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage;

import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.SystemUtils;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTCompressedStreamTools;
import net.minecraft.nbt.NBTReadLimiter;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.FastBufferedInputStream;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.saveddata.PersistentBase;
import org.slf4j.Logger;

public class WorldPersistentData
implements AutoCloseable {
    private static final Logger a = LogUtils.getLogger();
    public final Map<String, Optional<PersistentBase>> b = new HashMap<String, Optional<PersistentBase>>();
    private final DataFixer c;
    private final HolderLookup.a d;
    private final Path e;
    private CompletableFuture<?> f = CompletableFuture.completedFuture(null);

    public WorldPersistentData(Path directory, DataFixer dataFixer, HolderLookup.a registries) {
        this.c = dataFixer;
        this.e = directory;
        this.d = registries;
    }

    private Path a(String id) {
        return this.e.resolve(id + ".dat");
    }

    public <T extends PersistentBase> T a(PersistentBase.a<T> type, String id) {
        T savedData = this.b(type, id);
        if (savedData != null) {
            return savedData;
        }
        PersistentBase savedData2 = (PersistentBase)type.a().get();
        this.a(id, savedData2);
        return (T)savedData2;
    }

    @Nullable
    public <T extends PersistentBase> T b(PersistentBase.a<T> type, String id) {
        Optional<PersistentBase> optional = this.b.get(id);
        if (optional == null) {
            optional = Optional.ofNullable(this.a(type.b(), type.c(), id));
            this.b.put(id, optional);
        }
        return (T)((PersistentBase)optional.orElse(null));
    }

    @Nullable
    private <T extends PersistentBase> T a(BiFunction<NBTTagCompound, HolderLookup.a, T> readFunction, DataFixTypes dataFixTypes, String id) {
        try {
            Path path = this.a(id);
            if (Files.exists(path, new LinkOption[0])) {
                NBTTagCompound compoundTag = this.a(id, dataFixTypes, SharedConstants.b().d().c());
                return (T)((PersistentBase)readFunction.apply(compoundTag.p("data"), this.d));
            }
        }
        catch (Exception var6) {
            a.error("Error loading saved data: {}", (Object)id, (Object)var6);
        }
        return null;
    }

    public void a(String id, PersistentBase state) {
        this.b.put(id, Optional.of(state));
        state.c();
    }

    public NBTTagCompound a(String id, DataFixTypes dataFixTypes, int currentSaveVersion) throws IOException {
        NBTTagCompound var8;
        try (InputStream inputStream = Files.newInputStream(this.a(id), new OpenOption[0]);
             PushbackInputStream pushbackInputStream = new PushbackInputStream(new FastBufferedInputStream(inputStream), 2);){
            NBTTagCompound compoundTag;
            if (this.a(pushbackInputStream)) {
                compoundTag = NBTCompressedStreamTools.a(pushbackInputStream, NBTReadLimiter.a());
            } else {
                try (DataInputStream dataInputStream = new DataInputStream(pushbackInputStream);){
                    compoundTag = NBTCompressedStreamTools.a(dataInputStream);
                }
            }
            int i2 = GameProfileSerializer.b(compoundTag, 1343);
            var8 = dataFixTypes.a(this.c, compoundTag, i2, currentSaveVersion);
        }
        return var8;
    }

    private boolean a(PushbackInputStream stream) throws IOException {
        int j2;
        byte[] bs = new byte[2];
        boolean bl = false;
        int i2 = stream.read(bs, 0, 2);
        if (i2 == 2 && (j2 = (bs[1] & 0xFF) << 8 | bs[0] & 0xFF) == 35615) {
            bl = true;
        }
        if (i2 != 0) {
            stream.unread(bs, 0, i2);
        }
        return bl;
    }

    public CompletableFuture<?> a() {
        Map<Path, NBTTagCompound> map = this.c();
        if (map.isEmpty()) {
            return CompletableFuture.completedFuture(null);
        }
        this.f = this.f.thenCompose(v2 -> CompletableFuture.allOf((CompletableFuture[])map.entrySet().stream().map(entry -> WorldPersistentData.a((Path)entry.getKey(), (NBTTagCompound)entry.getValue())).toArray(CompletableFuture[]::new)));
        return this.f;
    }

    private Map<Path, NBTTagCompound> c() {
        Object2ObjectArrayMap map = new Object2ObjectArrayMap();
        this.b.forEach((arg_0, arg_1) -> this.a((Map)map, arg_0, arg_1));
        return map;
    }

    private static CompletableFuture<Void> a(Path path, NBTTagCompound nbt) {
        return CompletableFuture.runAsync(() -> {
            try {
                NBTCompressedStreamTools.a(nbt, path);
            }
            catch (IOException var3) {
                a.error("Could not save data to {}", (Object)path.getFileName(), (Object)var3);
            }
        }, SystemUtils.DIMENSION_DATA_IO_POOL);
    }

    public void b() {
        this.a().join();
    }

    @Override
    public void close() {
        this.b();
    }

    private /* synthetic */ void a(Map map, String id, Optional state) {
        state.filter(PersistentBase::d).ifPresent(state2 -> map.put(this.a(id), state2.a(this.d)));
    }
}

