/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.entries;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootCollector;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.entries.LootEntries;
import net.minecraft.world.level.storage.loot.entries.LootEntryType;
import net.minecraft.world.level.storage.loot.entries.LootSelectorEntry;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class NestedLootTable
extends LootSelectorEntry {
    public static final MapCodec<NestedLootTable> a = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.either(ResourceKey.a(Registries.bg), LootTable.d).fieldOf("value").forGetter(entry -> entry.j)).and(NestedLootTable.b(instance)).apply((Applicative)instance, NestedLootTable::new));
    private final Either<ResourceKey<LootTable>, LootTable> j;

    private NestedLootTable(Either<ResourceKey<LootTable>, LootTable> value, int weight, int quality, List<LootItemCondition> conditions, List<LootItemFunction> functions) {
        super(weight, quality, conditions, functions);
        this.j = value;
    }

    @Override
    @Override
    public LootEntryType a() {
        return LootEntries.d;
    }

    @Override
    @Override
    public void a(Consumer<ItemStack> lootConsumer, LootTableInfo context) {
        this.j.map(key -> context.a().c(key).map(Holder::a).orElse(LootTable.a), table -> table).a(context, lootConsumer);
    }

    @Override
    @Override
    public void a(LootCollector reporter) {
        Optional<ResourceKey<LootTable>> optional = this.j.left();
        if (optional.isPresent()) {
            ResourceKey<LootTable> resourceKey = optional.get();
            if (!reporter.b()) {
                reporter.b("Uses reference to " + String.valueOf(resourceKey.a()) + ", but references are not allowed");
                return;
            }
            if (reporter.a(resourceKey)) {
                reporter.b("Table " + String.valueOf(resourceKey.a()) + " is recursively called");
                return;
            }
        }
        super.a(reporter);
        this.j.ifLeft(key -> reporter.a().c(key).ifPresentOrElse(entry -> ((LootTable)entry.a()).a(reporter.a("->{" + String.valueOf(key.a()) + "}", (ResourceKey<?>)key)), () -> reporter.b("Unknown loot table called " + String.valueOf(key.a())))).ifRight(table -> table.a(reporter.a("->{inline}")));
    }

    public static LootSelectorEntry.a<?> a(ResourceKey<LootTable> key) {
        return NestedLootTable.a((int weight, int quality, List<LootItemCondition> conditions, List<LootItemFunction> functions) -> new NestedLootTable(Either.left(key), weight, quality, conditions, functions));
    }

    public static LootSelectorEntry.a<?> a(LootTable table) {
        return NestedLootTable.a((int weight, int quality, List<LootItemCondition> conditions, List<LootItemFunction> functions) -> new NestedLootTable(Either.right(table), weight, quality, conditions, functions));
    }
}

