/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootCollector;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionConditional;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import org.slf4j.Logger;

public class FunctionReference
extends LootItemFunctionConditional {
    private static final Logger b = LogUtils.getLogger();
    public static final MapCodec<FunctionReference> a = RecordCodecBuilder.mapCodec(instance -> FunctionReference.a(instance).and((App)ResourceKey.a(Registries.bh).fieldOf("name").forGetter(function -> function.c)).apply((Applicative)instance, FunctionReference::new));
    private final ResourceKey<LootItemFunction> c;

    private FunctionReference(List<LootItemCondition> conditions, ResourceKey<LootItemFunction> name) {
        super(conditions);
        this.c = name;
    }

    @Override
    public LootItemFunctionType<FunctionReference> b() {
        return LootItemFunctions.H;
    }

    @Override
    @Override
    public void a(LootCollector reporter) {
        if (!reporter.b()) {
            reporter.b("Uses reference to " + String.valueOf(this.c.a()) + ", but references are not allowed");
            return;
        }
        if (reporter.a(this.c)) {
            reporter.b("Function " + String.valueOf(this.c.a()) + " is recursively called");
            return;
        }
        super.a(reporter);
        reporter.a().c(this.c).ifPresentOrElse(reference -> ((LootItemFunction)reference.a()).a(reporter.a(".{" + String.valueOf(this.c.a()) + "}", this.c)), () -> reporter.b("Unknown function table called " + String.valueOf(this.c.a())));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Override
    protected ItemStack a(ItemStack stack, LootTableInfo context) {
        LootItemFunction lootItemFunction = context.a().c(this.c).map(Holder::a).orElse(null);
        if (lootItemFunction == null) {
            b.warn("Unknown function: {}", (Object)this.c.a());
            return stack;
        }
        LootTableInfo.c<LootItemFunction> visitedEntry = LootTableInfo.a(lootItemFunction);
        if (context.b(visitedEntry)) {
            try {
                ItemStack itemStack = (ItemStack)lootItemFunction.apply(stack, context);
                return itemStack;
            }
            finally {
                context.c(visitedEntry);
            }
        }
        b.warn("Detected infinite loop in loot tables");
        return stack;
    }

    public static LootItemFunctionConditional.a<?> a(ResourceKey<LootItemFunction> name) {
        return FunctionReference.a((List<LootItemCondition> conditions) -> new FunctionReference((List<LootItemCondition>)conditions, name));
    }
}

