/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.INamable;
import org.slf4j.Logger;

public interface ListOperation {
    public static final MapCodec<ListOperation> a = ListOperation.a(Integer.MAX_VALUE);

    public static MapCodec<ListOperation> a(int maxSize) {
        return f.e.dispatchMap("mode", ListOperation::a, mode -> mode.g).validate(operation -> {
            int j2;
            d replaceSection;
            if (operation instanceof d && (replaceSection = (d)operation).c().isPresent() && (j2 = replaceSection.c().get().intValue()) > maxSize) {
                return DataResult.error(() -> "Size value too large: " + j2 + ", max size is " + maxSize);
            }
            return DataResult.success((Object)operation);
        });
    }

    public f a();

    default public <T> List<T> a(List<T> current, List<T> values) {
        return this.a(current, values, Integer.MAX_VALUE);
    }

    public <T> List<T> a(List<T> var1, List<T> var2, int var3);

    public static final class f
    extends Enum<f>
    implements INamable {
        public static final /* enum */ f a = new f("replace_all", net.minecraft.world.level.storage.loot.functions.ListOperation$c.c);
        public static final /* enum */ f b = new f("replace_section", net.minecraft.world.level.storage.loot.functions.ListOperation$d.b);
        public static final /* enum */ f c = new f("insert", net.minecraft.world.level.storage.loot.functions.ListOperation$b.b);
        public static final /* enum */ f d = new f("append", net.minecraft.world.level.storage.loot.functions.ListOperation$a.c);
        public static final Codec<f> e;
        private final String f;
        final MapCodec<? extends ListOperation> g;
        private static final /* synthetic */ f[] h;

        public static f[] values() {
            return (f[])h.clone();
        }

        public static f valueOf(String string) {
            return Enum.valueOf(f.class, string);
        }

        private f(String id, MapCodec<? extends ListOperation> codec) {
            this.f = id;
            this.g = codec;
        }

        public MapCodec<? extends ListOperation> a() {
            return this.g;
        }

        @Override
        @Override
        public String c() {
            return this.f;
        }

        private static /* synthetic */ f[] b() {
            return new f[]{a, b, c, d};
        }

        static {
            h = net.minecraft.world.level.storage.loot.functions.ListOperation$f.b();
            e = INamable.a(f::values);
        }
    }

    public static final class d
    extends Record
    implements ListOperation {
        private final int c;
        private final Optional<Integer> d;
        private static final Logger e = LogUtils.getLogger();
        public static final MapCodec<d> b = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ExtraCodecs.l.optionalFieldOf("offset", (Object)0).forGetter(d::b), (App)ExtraCodecs.l.optionalFieldOf("size").forGetter(d::c)).apply((Applicative)instance, d::new));

        public d(int offset) {
            this(offset, Optional.empty());
        }

        public d(int i2, Optional<Integer> optional) {
            this.c = i2;
            this.d = optional;
        }

        @Override
        @Override
        public f a() {
            return f.b;
        }

        @Override
        @Override
        public <T> List<T> a(List<T> current, List<T> values, int maxSize) {
            ImmutableList list;
            int i2 = current.size();
            if (this.c > i2) {
                e.error("Cannot replace when offset is out of bounds");
                return current;
            }
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.addAll(current.subList(0, this.c));
            builder.addAll(values);
            int j2 = this.c + this.d.orElse(values.size());
            if (j2 < i2) {
                builder.addAll(current.subList(j2, i2));
            }
            if ((list = builder.build()).size() > maxSize) {
                e.error("Contents overflow in section replacement");
                return current;
            }
            return list;
        }

        @Override
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{d.class, "offset;size", "c", "d"}, this);
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{d.class, "offset;size", "c", "d"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{d.class, "offset;size", "c", "d"}, this, object);
        }

        public int b() {
            return this.c;
        }

        public Optional<Integer> c() {
            return this.d;
        }
    }

    public record e<T>(List<T> a, ListOperation b) {
        public static <T> Codec<e<T>> a(Codec<T> codec, int maxSize) {
            return RecordCodecBuilder.create(instance -> instance.group((App)codec.sizeLimitedListOf(maxSize).fieldOf("values").forGetter(values -> values.a), (App)ListOperation.a(maxSize).forGetter(values -> values.b)).apply((Applicative)instance, e::new));
        }

        public List<T> a(List<T> current) {
            return this.b.a(current, this.a);
        }

        @Override
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{e.class, "value;operation", "a", "b"}, this);
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{e.class, "value;operation", "a", "b"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{e.class, "value;operation", "a", "b"}, this, object);
        }
    }

    public static class a
    implements ListOperation {
        private static final Logger d = LogUtils.getLogger();
        public static final a b = new a();
        public static final MapCodec<a> c = MapCodec.unit(() -> b);

        private a() {
        }

        @Override
        @Override
        public f a() {
            return f.d;
        }

        @Override
        @Override
        public <T> List<T> a(List<T> current, List<T> values, int maxSize) {
            if (current.size() + values.size() > maxSize) {
                d.error("Contents overflow in section append");
                return current;
            }
            return Stream.concat(current.stream(), values.stream()).toList();
        }
    }

    public static final class b
    extends Record
    implements ListOperation {
        private final int c;
        private static final Logger d = LogUtils.getLogger();
        public static final MapCodec<b> b = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ExtraCodecs.l.optionalFieldOf("offset", (Object)0).forGetter(b::b)).apply((Applicative)instance, b::new));

        public b(int i2) {
            this.c = i2;
        }

        @Override
        @Override
        public f a() {
            return f.c;
        }

        @Override
        @Override
        public <T> List<T> a(List<T> current, List<T> values, int maxSize) {
            int i2 = current.size();
            if (this.c > i2) {
                d.error("Cannot insert when offset is out of bounds");
                return current;
            }
            if (i2 + values.size() > maxSize) {
                d.error("Contents overflow in section insertion");
                return current;
            }
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.addAll(current.subList(0, this.c));
            builder.addAll(values);
            builder.addAll(current.subList(this.c, i2));
            return builder.build();
        }

        @Override
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{b.class, "offset", "c"}, this);
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{b.class, "offset", "c"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{b.class, "offset", "c"}, this, object);
        }

        public int b() {
            return this.c;
        }
    }

    public static class c
    implements ListOperation {
        public static final c b = new c();
        public static final MapCodec<c> c = MapCodec.unit(() -> b);

        private c() {
        }

        @Override
        @Override
        public f a() {
            return f.a;
        }

        @Override
        @Override
        public <T> List<T> a(List<T> current, List<T> values, int maxSize) {
            return values;
        }
    }
}

