/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Set;
import net.minecraft.util.MathHelper;
import net.minecraft.util.context.ContextKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionConditional;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.NumberProviders;
import org.slf4j.Logger;

public class LootItemFunctionSetDamage
extends LootItemFunctionConditional {
    private static final Logger b = LogUtils.getLogger();
    public static final MapCodec<LootItemFunctionSetDamage> a = RecordCodecBuilder.mapCodec(instance -> LootItemFunctionSetDamage.a(instance).and(instance.group((App)NumberProviders.a.fieldOf("damage").forGetter(function -> function.c), (App)Codec.BOOL.fieldOf("add").orElse((Object)false).forGetter(function -> function.d))).apply((Applicative)instance, LootItemFunctionSetDamage::new));
    private final NumberProvider c;
    private final boolean d;

    private LootItemFunctionSetDamage(List<LootItemCondition> conditions, NumberProvider durabilityRange, boolean add) {
        super(conditions);
        this.c = durabilityRange;
        this.d = add;
    }

    @Override
    public LootItemFunctionType<LootItemFunctionSetDamage> b() {
        return LootItemFunctions.n;
    }

    @Override
    @Override
    public Set<ContextKey<?>> a() {
        return this.c.a();
    }

    @Override
    @Override
    public ItemStack a(ItemStack stack, LootTableInfo context) {
        if (stack.m()) {
            int i2 = stack.p();
            float f2 = this.d ? 1.0f - (float)stack.o() / (float)i2 : 0.0f;
            float g2 = 1.0f - MathHelper.a(this.c.b(context) + f2, 0.0f, 1.0f);
            stack.b(MathHelper.d(g2 * (float)i2));
        } else {
            b.warn("Couldn't set damage of loot item {}", (Object)stack);
        }
        return stack;
    }

    public static LootItemFunctionConditional.a<?> a(NumberProvider durabilityRange) {
        return LootItemFunctionSetDamage.a((List<LootItemCondition> conditions) -> new LootItemFunctionSetDamage((List<LootItemCondition>)conditions, durabilityRange, false));
    }

    public static LootItemFunctionConditional.a<?> a(NumberProvider durabilityRange, boolean add) {
        return LootItemFunctionSetDamage.a((List<LootItemCondition> conditions) -> new LootItemFunctionSetDamage((List<LootItemCondition>)conditions, durabilityRange, add));
    }
}

