/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.predicates;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.server.ScoreboardServer;
import net.minecraft.util.context.ContextKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.storage.loot.IntRange;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditions;
import net.minecraft.world.scores.ReadOnlyScoreInfo;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.scores.ScoreboardObjective;

public record LootItemConditionEntityScore(Map<String, IntRange> b, LootTableInfo.EntityTarget c) implements LootItemCondition
{
    private final Map<String, IntRange> b;
    private final LootTableInfo.EntityTarget c;
    public static final MapCodec<LootItemConditionEntityScore> a = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.unboundedMap((Codec)Codec.STRING, IntRange.a).fieldOf("scores").forGetter(LootItemConditionEntityScore::c), (App)LootTableInfo.EntityTarget.e.fieldOf("entity").forGetter(LootItemConditionEntityScore::d)).apply((Applicative)instance, LootItemConditionEntityScore::new));

    @Override
    @Override
    public LootItemConditionType b() {
        return LootItemConditions.h;
    }

    @Override
    @Override
    public Set<ContextKey<?>> a() {
        return (Set)Stream.concat(Stream.of(this.c.a()), this.b.values().stream().flatMap(operator -> operator.a().stream())).collect(ImmutableSet.toImmutableSet());
    }

    @Override
    public boolean a(LootTableInfo lootContext) {
        Entity entity = lootContext.c(this.c.a());
        if (entity == null) {
            return false;
        }
        ScoreboardServer scoreboard = lootContext.d().g();
        for (Map.Entry<String, IntRange> entry : this.b.entrySet()) {
            if (this.a(lootContext, entity, scoreboard, entry.getKey(), entry.getValue())) continue;
            return false;
        }
        return true;
    }

    protected boolean a(LootTableInfo context, Entity entity, Scoreboard scoreboard, String objectiveName, IntRange range) {
        ScoreboardObjective objective = scoreboard.a(objectiveName);
        if (objective == null) {
            return false;
        }
        ReadOnlyScoreInfo readOnlyScoreInfo = scoreboard.d(entity, objective);
        if (readOnlyScoreInfo == null) {
            return false;
        }
        return range.b(context, readOnlyScoreInfo.a());
    }

    public static a a(LootTableInfo.EntityTarget target) {
        return new a(target);
    }

    @Override
    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{LootItemConditionEntityScore.class, "scores;entityTarget", "b", "c"}, this);
    }

    @Override
    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{LootItemConditionEntityScore.class, "scores;entityTarget", "b", "c"}, this);
    }

    @Override
    @Override
    public final boolean equals(Object object) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{LootItemConditionEntityScore.class, "scores;entityTarget", "b", "c"}, this, object);
    }

    public Map<String, IntRange> c() {
        return this.b;
    }

    public LootTableInfo.EntityTarget d() {
        return this.c;
    }

    @Override
    public /* synthetic */ boolean test(Object object) {
        return this.a((LootTableInfo)object);
    }

    public static class a
    implements LootItemCondition.a {
        private final ImmutableMap.Builder<String, IntRange> a = ImmutableMap.builder();
        private final LootTableInfo.EntityTarget b;

        public a(LootTableInfo.EntityTarget target) {
            this.b = target;
        }

        public a a(String name, IntRange value) {
            this.a.put((Object)name, (Object)value);
            return this;
        }

        @Override
        @Override
        public LootItemCondition build() {
            return new LootItemConditionEntityScore((Map<String, IntRange>)this.a.build(), this.b);
        }
    }
}

