/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.predicates;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.storage.loot.LootCollector;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditions;
import org.slf4j.Logger;

public record LootItemConditionReference(ResourceKey<LootItemCondition> b) implements LootItemCondition
{
    private final ResourceKey<LootItemCondition> b;
    private static final Logger c = LogUtils.getLogger();
    public static final MapCodec<LootItemConditionReference> a = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ResourceKey.a(Registries.bi).fieldOf("name").forGetter(LootItemConditionReference::c)).apply((Applicative)instance, LootItemConditionReference::new));

    @Override
    @Override
    public LootItemConditionType b() {
        return LootItemConditions.p;
    }

    @Override
    @Override
    public void a(LootCollector reporter) {
        if (!reporter.b()) {
            reporter.b("Uses reference to " + String.valueOf(this.b.a()) + ", but references are not allowed");
            return;
        }
        if (reporter.a(this.b)) {
            reporter.b("Condition " + String.valueOf(this.b.a()) + " is recursively called");
            return;
        }
        LootItemCondition.super.a(reporter);
        reporter.a().c(this.b).ifPresentOrElse(entry -> ((LootItemCondition)entry.a()).a(reporter.a(".{" + String.valueOf(this.b.a()) + "}", this.b)), () -> reporter.b("Unknown condition table called " + String.valueOf(this.b.a())));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean a(LootTableInfo lootContext) {
        LootItemCondition lootItemCondition = lootContext.a().c(this.b).map(Holder.c::a).orElse(null);
        if (lootItemCondition == null) {
            c.warn("Tried using unknown condition table called {}", (Object)this.b.a());
            return false;
        }
        LootTableInfo.c<LootItemCondition> visitedEntry = LootTableInfo.a(lootItemCondition);
        if (lootContext.b(visitedEntry)) {
            try {
                boolean bl = lootItemCondition.test(lootContext);
                return bl;
            }
            finally {
                lootContext.c(visitedEntry);
            }
        }
        c.warn("Detected infinite loop in loot tables");
        return false;
    }

    public static LootItemCondition.a a(ResourceKey<LootItemCondition> key) {
        return () -> new LootItemConditionReference(key);
    }

    @Override
    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{LootItemConditionReference.class, "name", "b"}, this);
    }

    @Override
    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{LootItemConditionReference.class, "name", "b"}, this);
    }

    @Override
    @Override
    public final boolean equals(Object object) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{LootItemConditionReference.class, "name", "b"}, this, object);
    }

    public ResourceKey<LootItemCondition> c() {
        return this.b;
    }

    @Override
    public /* synthetic */ boolean test(Object object) {
        return this.a((LootTableInfo)object);
    }
}

