/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.phys;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.SystemUtils;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.IPosition;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.phys.Vec2F;
import org.joml.Vector3f;

public class Vec3D
implements IPosition {
    public static final Codec<Vec3D> a = Codec.DOUBLE.listOf().comapFlatMap(coordinates -> SystemUtils.a(coordinates, 3).map(coords -> new Vec3D((Double)coords.get(0), (Double)coords.get(1), (Double)coords.get(2))), vec -> List.of(Double.valueOf(vec.a()), Double.valueOf(vec.b()), Double.valueOf(vec.c())));
    public static final StreamCodec<ByteBuf, Vec3D> b = new StreamCodec<ByteBuf, Vec3D>(){

        @Override
        public Vec3D a(ByteBuf byteBuf) {
            return PacketDataSerializer.f(byteBuf);
        }

        @Override
        public void a(ByteBuf byteBuf, Vec3D vec3) {
            PacketDataSerializer.a(byteBuf, vec3);
        }

        @Override
        public /* synthetic */ void encode(Object buf, Object value) {
            this.a((ByteBuf)buf, (Vec3D)value);
        }

        @Override
        public /* synthetic */ Object decode(Object buf) {
            return this.a((ByteBuf)buf);
        }
    };
    public static final Vec3D c = new Vec3D(0.0, 0.0, 0.0);
    public final double d;
    public final double e;
    public final double f;

    public static Vec3D a(int rgb) {
        double d2 = (double)(rgb >> 16 & 0xFF) / 255.0;
        double e2 = (double)(rgb >> 8 & 0xFF) / 255.0;
        double f2 = (double)(rgb & 0xFF) / 255.0;
        return new Vec3D(d2, e2, f2);
    }

    public static Vec3D a(BaseBlockPosition vec) {
        return new Vec3D(vec.u(), vec.v(), vec.w());
    }

    public static Vec3D a(BaseBlockPosition vec, double deltaX, double deltaY, double deltaZ) {
        return new Vec3D((double)vec.u() + deltaX, (double)vec.v() + deltaY, (double)vec.w() + deltaZ);
    }

    public static Vec3D b(BaseBlockPosition vec) {
        return Vec3D.a(vec, 0.5, 0.5, 0.5);
    }

    public static Vec3D c(BaseBlockPosition vec) {
        return Vec3D.a(vec, 0.5, 0.0, 0.5);
    }

    public static Vec3D a(BaseBlockPosition vec, double deltaY) {
        return Vec3D.a(vec, 0.5, deltaY, 0.5);
    }

    public Vec3D(double x2, double y2, double z2) {
        this.d = x2;
        this.e = y2;
        this.f = z2;
    }

    public Vec3D(Vector3f vec) {
        this(vec.x(), vec.y(), vec.z());
    }

    public Vec3D(BaseBlockPosition vec) {
        this(vec.u(), vec.v(), vec.w());
    }

    public Vec3D a(Vec3D vec) {
        return new Vec3D(vec.d - this.d, vec.e - this.e, vec.f - this.f);
    }

    public Vec3D d() {
        double d2 = Math.sqrt(this.d * this.d + this.e * this.e + this.f * this.f);
        if (d2 < (double)1.0E-5f) {
            return c;
        }
        return new Vec3D(this.d / d2, this.e / d2, this.f / d2);
    }

    public double b(Vec3D vec) {
        return this.d * vec.d + this.e * vec.e + this.f * vec.f;
    }

    public Vec3D c(Vec3D vec) {
        return new Vec3D(this.e * vec.f - this.f * vec.e, this.f * vec.d - this.d * vec.f, this.d * vec.e - this.e * vec.d);
    }

    public Vec3D d(Vec3D vec) {
        return this.a(vec.d, vec.e, vec.f);
    }

    public Vec3D a(double value) {
        return this.a(value, value, value);
    }

    public Vec3D a(double x2, double y2, double z2) {
        return this.b(-x2, -y2, -z2);
    }

    public Vec3D b(double value) {
        return this.b(value, value, value);
    }

    public Vec3D e(Vec3D vec) {
        return this.b(vec.d, vec.e, vec.f);
    }

    public Vec3D b(double x2, double y2, double z2) {
        return new Vec3D(this.d + x2, this.e + y2, this.f + z2);
    }

    public boolean a(IPosition pos, double radius) {
        return this.c(pos.a(), pos.b(), pos.c()) < radius * radius;
    }

    public double f(Vec3D vec) {
        double d2 = vec.d - this.d;
        double e2 = vec.e - this.e;
        double f2 = vec.f - this.f;
        return Math.sqrt(d2 * d2 + e2 * e2 + f2 * f2);
    }

    public double g(Vec3D vec) {
        double d2 = vec.d - this.d;
        double e2 = vec.e - this.e;
        double f2 = vec.f - this.f;
        return d2 * d2 + e2 * e2 + f2 * f2;
    }

    public double c(double x2, double y2, double z2) {
        double d2 = x2 - this.d;
        double e2 = y2 - this.e;
        double f2 = z2 - this.f;
        return d2 * d2 + e2 * e2 + f2 * f2;
    }

    public boolean a(Vec3D vec, double horizontalRange, double verticalRange) {
        double d2 = vec.a() - this.d;
        double e2 = vec.b() - this.e;
        double f2 = vec.c() - this.f;
        return MathHelper.e(d2, f2) < MathHelper.k(horizontalRange) && Math.abs(e2) < verticalRange;
    }

    public Vec3D c(double value) {
        return this.d(value, value, value);
    }

    public Vec3D e() {
        return this.c(-1.0);
    }

    public Vec3D h(Vec3D vec) {
        return this.d(vec.d, vec.e, vec.f);
    }

    public Vec3D d(double x2, double y2, double z2) {
        return new Vec3D(this.d * x2, this.e * y2, this.f * z2);
    }

    public Vec3D f() {
        return new Vec3D(this.d, 0.0, this.f);
    }

    public Vec3D a(RandomSource random, float multiplier) {
        return this.b((random.i() - 0.5f) * multiplier, (random.i() - 0.5f) * multiplier, (random.i() - 0.5f) * multiplier);
    }

    public double g() {
        return Math.sqrt(this.d * this.d + this.e * this.e + this.f * this.f);
    }

    public double h() {
        return this.d * this.d + this.e * this.e + this.f * this.f;
    }

    public double i() {
        return Math.sqrt(this.d * this.d + this.f * this.f);
    }

    public double j() {
        return this.d * this.d + this.f * this.f;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Vec3D)) {
            return false;
        }
        Vec3D vec3 = (Vec3D)object;
        if (Double.compare(vec3.d, this.d) != 0) {
            return false;
        }
        if (Double.compare(vec3.e, this.e) != 0) {
            return false;
        }
        return Double.compare(vec3.f, this.f) == 0;
    }

    @Override
    public int hashCode() {
        long l2 = Double.doubleToLongBits(this.d);
        int i2 = (int)(l2 ^ l2 >>> 32);
        l2 = Double.doubleToLongBits(this.e);
        i2 = 31 * i2 + (int)(l2 ^ l2 >>> 32);
        l2 = Double.doubleToLongBits(this.f);
        i2 = 31 * i2 + (int)(l2 ^ l2 >>> 32);
        return i2;
    }

    @Override
    public String toString() {
        return "(" + this.d + ", " + this.e + ", " + this.f + ")";
    }

    public Vec3D a(Vec3D to, double delta) {
        return new Vec3D(MathHelper.d(delta, this.d, to.d), MathHelper.d(delta, this.e, to.e), MathHelper.d(delta, this.f, to.f));
    }

    public Vec3D a(float angle) {
        float f2 = MathHelper.b(angle);
        float g2 = MathHelper.a(angle);
        double d2 = this.d;
        double e2 = this.e * (double)f2 + this.f * (double)g2;
        double h2 = this.f * (double)f2 - this.e * (double)g2;
        return new Vec3D(d2, e2, h2);
    }

    public Vec3D b(float angle) {
        float f2 = MathHelper.b(angle);
        float g2 = MathHelper.a(angle);
        double d2 = this.d * (double)f2 + this.f * (double)g2;
        double e2 = this.e;
        double h2 = this.f * (double)f2 - this.d * (double)g2;
        return new Vec3D(d2, e2, h2);
    }

    public Vec3D c(float angle) {
        float f2 = MathHelper.b(angle);
        float g2 = MathHelper.a(angle);
        double d2 = this.d * (double)f2 + this.e * (double)g2;
        double e2 = this.e * (double)f2 - this.d * (double)g2;
        double h2 = this.f;
        return new Vec3D(d2, e2, h2);
    }

    public static Vec3D a(Vec2F polar) {
        return Vec3D.a(polar.i, polar.j);
    }

    public static Vec3D a(float pitch, float yaw) {
        float f2 = MathHelper.b(-yaw * ((float)Math.PI / 180) - (float)Math.PI);
        float g2 = MathHelper.a(-yaw * ((float)Math.PI / 180) - (float)Math.PI);
        float h2 = -MathHelper.b(-pitch * ((float)Math.PI / 180));
        float i2 = MathHelper.a(-pitch * ((float)Math.PI / 180));
        return new Vec3D(g2 * h2, i2, f2 * h2);
    }

    public Vec3D a(EnumSet<EnumDirection.EnumAxis> axes) {
        double d2 = axes.contains(EnumDirection.EnumAxis.a) ? (double)MathHelper.a(this.d) : this.d;
        double e2 = axes.contains(EnumDirection.EnumAxis.b) ? (double)MathHelper.a(this.e) : this.e;
        double f2 = axes.contains(EnumDirection.EnumAxis.c) ? (double)MathHelper.a(this.f) : this.f;
        return new Vec3D(d2, e2, f2);
    }

    public double a(EnumDirection.EnumAxis axis) {
        return axis.a(this.d, this.e, this.f);
    }

    public Vec3D a(EnumDirection.EnumAxis axis, double value) {
        double d2 = axis == EnumDirection.EnumAxis.a ? value : this.d;
        double e2 = axis == EnumDirection.EnumAxis.b ? value : this.e;
        double f2 = axis == EnumDirection.EnumAxis.c ? value : this.f;
        return new Vec3D(d2, e2, f2);
    }

    public Vec3D a(EnumDirection direction, double value) {
        BaseBlockPosition vec3i = direction.q();
        return new Vec3D(this.d + value * (double)vec3i.u(), this.e + value * (double)vec3i.v(), this.f + value * (double)vec3i.w());
    }

    @Override
    @Override
    public final double a() {
        return this.d;
    }

    @Override
    @Override
    public final double b() {
        return this.e;
    }

    @Override
    @Override
    public final double c() {
        return this.f;
    }

    public Vector3f k() {
        return new Vector3f((float)this.d, (float)this.e, (float)this.f);
    }

    public Vec3D i(Vec3D vec) {
        if (vec.h() == 0.0) {
            return vec;
        }
        return vec.c(this.b(vec)).c(1.0 / vec.h());
    }
}

