/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.phys.shapes;

import ca.spottedleaf.moonrise.patches.collisions.shape.CachedShapeData;
import ca.spottedleaf.moonrise.patches.collisions.shape.CollisionDiscreteVoxelShape;
import java.util.Arrays;
import net.minecraft.core.EnumAxisCycle;
import net.minecraft.core.EnumDirection;
import net.minecraft.world.phys.shapes.VoxelShapeBitSet;

public abstract class VoxelShapeDiscrete
implements CollisionDiscreteVoxelShape {
    private static final EnumDirection.EnumAxis[] d = EnumDirection.EnumAxis.values();
    protected final int a;
    protected final int b;
    protected final int c;
    private CachedShapeData cachedShapeData;

    @Override
    public final CachedShapeData moonrise$getOrCreateCachedShapeData() {
        long[] voxelSet;
        if (this.cachedShapeData != null) {
            return this.cachedShapeData;
        }
        VoxelShapeDiscrete discreteVoxelShape = this;
        int sizeX = discreteVoxelShape.b();
        int sizeY = discreteVoxelShape.c();
        int sizeZ = discreteVoxelShape.d();
        int maxIndex = sizeX * sizeY * sizeZ;
        int longsRequired = maxIndex + 63 >>> 6;
        boolean isEmpty = discreteVoxelShape.a();
        if (discreteVoxelShape instanceof VoxelShapeBitSet) {
            VoxelShapeBitSet bitsetShape = (VoxelShapeBitSet)discreteVoxelShape;
            voxelSet = bitsetShape.d.toLongArray();
            if (voxelSet.length < longsRequired) {
                voxelSet = Arrays.copyOf(voxelSet, longsRequired);
            }
        } else {
            voxelSet = new long[longsRequired];
            if (!isEmpty) {
                int mulX = sizeZ * sizeY;
                for (int x2 = 0; x2 < sizeX; ++x2) {
                    for (int y2 = 0; y2 < sizeY; ++y2) {
                        for (int z2 = 0; z2 < sizeZ; ++z2) {
                            if (!discreteVoxelShape.b(x2, y2, z2)) continue;
                            int index = z2 + y2 * sizeZ + x2 * mulX;
                            int n2 = index >>> 6;
                            voxelSet[n2] = voxelSet[n2] | 1L << index;
                        }
                    }
                }
            }
        }
        boolean hasSingleAABB = sizeX == 1 && sizeY == 1 && sizeZ == 1 && !isEmpty && (voxelSet[0] & 1L) != 0L;
        int minFullX = discreteVoxelShape.a(EnumDirection.EnumAxis.a);
        int minFullY = discreteVoxelShape.a(EnumDirection.EnumAxis.b);
        int minFullZ = discreteVoxelShape.a(EnumDirection.EnumAxis.c);
        int maxFullX = discreteVoxelShape.b(EnumDirection.EnumAxis.a);
        int maxFullY = discreteVoxelShape.b(EnumDirection.EnumAxis.b);
        int maxFullZ = discreteVoxelShape.b(EnumDirection.EnumAxis.c);
        this.cachedShapeData = new CachedShapeData(sizeX, sizeY, sizeZ, voxelSet, minFullX, minFullY, minFullZ, maxFullX, maxFullY, maxFullZ, isEmpty, hasSingleAABB);
        return this.cachedShapeData;
    }

    protected VoxelShapeDiscrete(int sizeX, int sizeY, int sizeZ) {
        if (sizeX < 0 || sizeY < 0 || sizeZ < 0) {
            throw new IllegalArgumentException("Need all positive sizes: x: " + sizeX + ", y: " + sizeY + ", z: " + sizeZ);
        }
        this.a = sizeX;
        this.b = sizeY;
        this.c = sizeZ;
    }

    public boolean a(EnumAxisCycle cycle, int x2, int y2, int z2) {
        return this.e(cycle.a(x2, y2, z2, EnumDirection.EnumAxis.a), cycle.a(x2, y2, z2, EnumDirection.EnumAxis.b), cycle.a(x2, y2, z2, EnumDirection.EnumAxis.c));
    }

    public boolean e(int x2, int y2, int z2) {
        return x2 >= 0 && y2 >= 0 && z2 >= 0 && x2 < this.a && y2 < this.b && z2 < this.c && this.b(x2, y2, z2);
    }

    public boolean b(EnumAxisCycle cycle, int x2, int y2, int z2) {
        return this.b(cycle.a(x2, y2, z2, EnumDirection.EnumAxis.a), cycle.a(x2, y2, z2, EnumDirection.EnumAxis.b), cycle.a(x2, y2, z2, EnumDirection.EnumAxis.c));
    }

    public abstract boolean b(int var1, int var2, int var3);

    public abstract void c(int var1, int var2, int var3);

    public boolean a() {
        for (EnumDirection.EnumAxis axis : d) {
            if (this.a(axis) < this.b(axis)) continue;
            return true;
        }
        return false;
    }

    public abstract int a(EnumDirection.EnumAxis var1);

    public abstract int b(EnumDirection.EnumAxis var1);

    public int a(EnumDirection.EnumAxis axis, int from, int to) {
        int i2 = this.c(axis);
        if (from >= 0 && to >= 0) {
            EnumDirection.EnumAxis axis2 = EnumAxisCycle.b.a(axis);
            EnumDirection.EnumAxis axis3 = EnumAxisCycle.c.a(axis);
            if (from < this.c(axis2) && to < this.c(axis3)) {
                EnumAxisCycle axisCycle = EnumAxisCycle.a(EnumDirection.EnumAxis.a, axis);
                for (int j2 = 0; j2 < i2; ++j2) {
                    if (!this.b(axisCycle, j2, from, to)) continue;
                    return j2;
                }
                return i2;
            }
            return i2;
        }
        return i2;
    }

    public int b(EnumDirection.EnumAxis axis, int from, int to) {
        if (from >= 0 && to >= 0) {
            EnumDirection.EnumAxis axis2 = EnumAxisCycle.b.a(axis);
            EnumDirection.EnumAxis axis3 = EnumAxisCycle.c.a(axis);
            if (from < this.c(axis2) && to < this.c(axis3)) {
                int i2 = this.c(axis);
                EnumAxisCycle axisCycle = EnumAxisCycle.a(EnumDirection.EnumAxis.a, axis);
                for (int j2 = i2 - 1; j2 >= 0; --j2) {
                    if (!this.b(axisCycle, j2, from, to)) continue;
                    return j2 + 1;
                }
                return 0;
            }
            return 0;
        }
        return 0;
    }

    public int c(EnumDirection.EnumAxis axis) {
        return axis.a(this.a, this.b, this.c);
    }

    public int b() {
        return this.c(EnumDirection.EnumAxis.a);
    }

    public int c() {
        return this.c(EnumDirection.EnumAxis.b);
    }

    public int d() {
        return this.c(EnumDirection.EnumAxis.c);
    }

    public void a(b callback, boolean coalesce) {
        this.a(callback, EnumAxisCycle.a, coalesce);
        this.a(callback, EnumAxisCycle.b, coalesce);
        this.a(callback, EnumAxisCycle.c, coalesce);
    }

    private void a(b callback, EnumAxisCycle direction, boolean coalesce) {
        EnumAxisCycle axisCycle = direction.a();
        int i2 = this.c(axisCycle.a(EnumDirection.EnumAxis.a));
        int j2 = this.c(axisCycle.a(EnumDirection.EnumAxis.b));
        int k2 = this.c(axisCycle.a(EnumDirection.EnumAxis.c));
        for (int l2 = 0; l2 <= i2; ++l2) {
            for (int m2 = 0; m2 <= j2; ++m2) {
                int n2 = -1;
                for (int o2 = 0; o2 <= k2; ++o2) {
                    int p2 = 0;
                    int q2 = 0;
                    for (int r2 = 0; r2 <= 1; ++r2) {
                        for (int s2 = 0; s2 <= 1; ++s2) {
                            if (!this.a(axisCycle, l2 + r2 - 1, m2 + s2 - 1, o2)) continue;
                            ++p2;
                            q2 ^= r2 ^ s2;
                        }
                    }
                    if (p2 == 1 || p2 == 3 || p2 == 2 && !(q2 & true)) {
                        if (coalesce) {
                            if (n2 != -1) continue;
                            n2 = o2;
                            continue;
                        }
                        callback.consume(axisCycle.a(l2, m2, o2, EnumDirection.EnumAxis.a), axisCycle.a(l2, m2, o2, EnumDirection.EnumAxis.b), axisCycle.a(l2, m2, o2, EnumDirection.EnumAxis.c), axisCycle.a(l2, m2, o2 + 1, EnumDirection.EnumAxis.a), axisCycle.a(l2, m2, o2 + 1, EnumDirection.EnumAxis.b), axisCycle.a(l2, m2, o2 + 1, EnumDirection.EnumAxis.c));
                        continue;
                    }
                    if (n2 == -1) continue;
                    callback.consume(axisCycle.a(l2, m2, n2, EnumDirection.EnumAxis.a), axisCycle.a(l2, m2, n2, EnumDirection.EnumAxis.b), axisCycle.a(l2, m2, n2, EnumDirection.EnumAxis.c), axisCycle.a(l2, m2, o2, EnumDirection.EnumAxis.a), axisCycle.a(l2, m2, o2, EnumDirection.EnumAxis.b), axisCycle.a(l2, m2, o2, EnumDirection.EnumAxis.c));
                    n2 = -1;
                }
            }
        }
    }

    public void b(b consumer, boolean coalesce) {
        VoxelShapeBitSet.a(this, consumer, coalesce);
    }

    public void a(a consumer) {
        this.a(consumer, EnumAxisCycle.a);
        this.a(consumer, EnumAxisCycle.b);
        this.a(consumer, EnumAxisCycle.c);
    }

    private void a(a consumer, EnumAxisCycle direction) {
        EnumAxisCycle axisCycle = direction.a();
        EnumDirection.EnumAxis axis = axisCycle.a(EnumDirection.EnumAxis.c);
        int i2 = this.c(axisCycle.a(EnumDirection.EnumAxis.a));
        int j2 = this.c(axisCycle.a(EnumDirection.EnumAxis.b));
        int k2 = this.c(axis);
        EnumDirection direction2 = EnumDirection.a(axis, EnumDirection.EnumAxisDirection.b);
        EnumDirection direction3 = EnumDirection.a(axis, EnumDirection.EnumAxisDirection.a);
        for (int l2 = 0; l2 < i2; ++l2) {
            for (int m2 = 0; m2 < j2; ++m2) {
                boolean bl = false;
                for (int n2 = 0; n2 <= k2; ++n2) {
                    boolean bl2;
                    boolean bl3 = bl2 = n2 != k2 && this.b(axisCycle, l2, m2, n2);
                    if (!bl && bl2) {
                        consumer.consume(direction2, axisCycle.a(l2, m2, n2, EnumDirection.EnumAxis.a), axisCycle.a(l2, m2, n2, EnumDirection.EnumAxis.b), axisCycle.a(l2, m2, n2, EnumDirection.EnumAxis.c));
                    }
                    if (bl && !bl2) {
                        consumer.consume(direction3, axisCycle.a(l2, m2, n2 - 1, EnumDirection.EnumAxis.a), axisCycle.a(l2, m2, n2 - 1, EnumDirection.EnumAxis.b), axisCycle.a(l2, m2, n2 - 1, EnumDirection.EnumAxis.c));
                    }
                    bl = bl2;
                }
            }
        }
    }

    public static interface b {
        public void consume(int var1, int var2, int var3, int var4, int var5, int var6);
    }

    public static interface a {
        public void consume(EnumDirection var1, int var2, int var3, int var4);
    }
}

