/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.scores;

import com.mojang.logging.LogUtils;
import io.papermc.paper.configuration.GlobalConfiguration;
import net.minecraft.EnumChatFormat;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.chat.numbers.NumberFormat;
import net.minecraft.network.chat.numbers.NumberFormatTypes;
import net.minecraft.world.level.saveddata.PersistentBase;
import net.minecraft.world.scores.DisplaySlot;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.scores.ScoreboardObjective;
import net.minecraft.world.scores.ScoreboardTeam;
import net.minecraft.world.scores.ScoreboardTeamBase;
import net.minecraft.world.scores.criteria.IScoreboardCriteria;
import org.slf4j.Logger;

public class PersistentScoreboard
extends PersistentBase {
    private static final Logger b = LogUtils.getLogger();
    public static final String a = "scoreboard";
    private final Scoreboard c;

    public PersistentScoreboard(Scoreboard scoreboard) {
        this.c = scoreboard;
    }

    public PersistentScoreboard b(NBTTagCompound nbt, HolderLookup.a registries) {
        this.b(nbt.c("Objectives", 10), registries);
        this.c.a(nbt.c("PlayerScores", 10), registries);
        if (nbt.b("DisplaySlots", 10)) {
            this.a(nbt.p("DisplaySlots"));
        }
        if (nbt.b("Teams", 9)) {
            this.a(nbt.c("Teams", 10), registries);
        }
        return this;
    }

    private void a(NBTTagList nbt, HolderLookup.a registries) {
        for (int i2 = 0; i2 < nbt.size(); ++i2) {
            ScoreboardTeamBase.EnumTeamPush collisionRule;
            ScoreboardTeamBase.EnumNameTagVisibility visibility2;
            ScoreboardTeamBase.EnumNameTagVisibility visibility;
            IChatMutableComponent component3;
            IChatMutableComponent component2;
            NBTTagCompound compoundTag = nbt.a(i2);
            String string = compoundTag.l("Name");
            ScoreboardTeam playerTeam = this.c.c(string);
            IChatMutableComponent component = IChatBaseComponent.ChatSerializer.a(compoundTag.l("DisplayName"), registries);
            if (component != null) {
                playerTeam.a(component);
            }
            if (compoundTag.b("TeamColor", 8)) {
                playerTeam.a(EnumChatFormat.b(compoundTag.l("TeamColor")));
            }
            if (compoundTag.b("AllowFriendlyFire", 99)) {
                playerTeam.a(compoundTag.q("AllowFriendlyFire"));
            }
            if (compoundTag.b("SeeFriendlyInvisibles", 99)) {
                playerTeam.b(compoundTag.q("SeeFriendlyInvisibles"));
            }
            if (compoundTag.b("MemberNamePrefix", 8) && (component2 = IChatBaseComponent.ChatSerializer.a(compoundTag.l("MemberNamePrefix"), registries)) != null) {
                playerTeam.b(component2);
            }
            if (compoundTag.b("MemberNameSuffix", 8) && (component3 = IChatBaseComponent.ChatSerializer.a(compoundTag.l("MemberNameSuffix"), registries)) != null) {
                playerTeam.c(component3);
            }
            if (compoundTag.b("NameTagVisibility", 8) && (visibility = ScoreboardTeamBase.EnumNameTagVisibility.a(compoundTag.l("NameTagVisibility"))) != null) {
                playerTeam.a(visibility);
            }
            if (compoundTag.b("DeathMessageVisibility", 8) && (visibility2 = ScoreboardTeamBase.EnumNameTagVisibility.a(compoundTag.l("DeathMessageVisibility"))) != null) {
                playerTeam.b(visibility2);
            }
            if (compoundTag.b("CollisionRule", 8) && (collisionRule = ScoreboardTeamBase.EnumTeamPush.a(compoundTag.l("CollisionRule"))) != null) {
                playerTeam.a(collisionRule);
            }
            this.a(playerTeam, compoundTag.c("Players", 8));
        }
    }

    private void a(ScoreboardTeam team, NBTTagList nbt) {
        for (int i2 = 0; i2 < nbt.size(); ++i2) {
            this.c.a(nbt.j(i2), team);
        }
    }

    private void a(NBTTagCompound nbt) {
        for (String string : nbt.e()) {
            DisplaySlot displaySlot = DisplaySlot.t.a(string);
            if (displaySlot == null) continue;
            String string2 = nbt.l(string);
            ScoreboardObjective objective = this.c.a(string2);
            this.c.a(displaySlot, objective);
        }
    }

    private void b(NBTTagList nbt, HolderLookup.a registries) {
        for (int i2 = 0; i2 < nbt.size(); ++i2) {
            NBTTagCompound compoundTag = nbt.a(i2);
            String string = compoundTag.l("CriteriaName");
            IScoreboardCriteria objectiveCriteria = IScoreboardCriteria.a(string).orElseGet(() -> {
                b.warn("Unknown scoreboard criteria {}, replacing with {}", (Object)string, (Object)IScoreboardCriteria.b.d());
                return IScoreboardCriteria.b;
            });
            String string2 = compoundTag.l("Name");
            IChatMutableComponent component = IChatBaseComponent.ChatSerializer.a(compoundTag.l("DisplayName"), registries);
            IScoreboardCriteria.EnumScoreboardHealthDisplay renderType = IScoreboardCriteria.EnumScoreboardHealthDisplay.a(compoundTag.l("RenderType"));
            boolean bl = compoundTag.q("display_auto_update");
            NumberFormat numberFormat = NumberFormatTypes.b.parse(registries.a(DynamicOpsNBT.a), (Object)compoundTag.c("format")).result().orElse(null);
            this.c.a(string2, objectiveCriteria, component, renderType, bl, numberFormat);
        }
    }

    @Override
    public NBTTagCompound a(NBTTagCompound nbt, HolderLookup.a registries) {
        nbt.a("Objectives", this.c(registries));
        nbt.a("PlayerScores", this.c.a(registries));
        nbt.a("Teams", this.b(registries));
        this.b(nbt);
        return nbt;
    }

    private NBTTagList b(HolderLookup.a registries) {
        NBTTagList listTag = new NBTTagList();
        for (ScoreboardTeam playerTeam : this.c.g()) {
            if (!GlobalConfiguration.get().scoreboards.saveEmptyScoreboardTeams && playerTeam.g().isEmpty()) continue;
            NBTTagCompound compoundTag = new NBTTagCompound();
            compoundTag.a("Name", playerTeam.b());
            compoundTag.a("DisplayName", IChatBaseComponent.ChatSerializer.a(playerTeam.c(), registries));
            if (playerTeam.n().b() >= 0) {
                compoundTag.a("TeamColor", playerTeam.n().g());
            }
            compoundTag.a("AllowFriendlyFire", playerTeam.h());
            compoundTag.a("SeeFriendlyInvisibles", playerTeam.i());
            compoundTag.a("MemberNamePrefix", IChatBaseComponent.ChatSerializer.a(playerTeam.e(), registries));
            compoundTag.a("MemberNameSuffix", IChatBaseComponent.ChatSerializer.a(playerTeam.f(), registries));
            compoundTag.a("NameTagVisibility", playerTeam.j().e);
            compoundTag.a("DeathMessageVisibility", playerTeam.k().e);
            compoundTag.a("CollisionRule", playerTeam.l().e);
            NBTTagList listTag2 = new NBTTagList();
            for (String string : playerTeam.g()) {
                listTag2.add(NBTTagString.a(string));
            }
            compoundTag.a("Players", listTag2);
            listTag.add(compoundTag);
        }
        return listTag;
    }

    private void b(NBTTagCompound nbt) {
        NBTTagCompound compoundTag = new NBTTagCompound();
        for (DisplaySlot displaySlot : DisplaySlot.values()) {
            ScoreboardObjective objective = this.c.a(displaySlot);
            if (objective == null) continue;
            compoundTag.a(displaySlot.c(), objective.b());
        }
        if (!compoundTag.g()) {
            nbt.a("DisplaySlots", compoundTag);
        }
    }

    private NBTTagList c(HolderLookup.a registries) {
        NBTTagList listTag = new NBTTagList();
        for (ScoreboardObjective objective : this.c.c()) {
            NBTTagCompound compoundTag = new NBTTagCompound();
            compoundTag.a("Name", objective.b());
            compoundTag.a("CriteriaName", objective.c().d());
            compoundTag.a("DisplayName", IChatBaseComponent.ChatSerializer.a(objective.d(), registries));
            compoundTag.a("RenderType", objective.h().a());
            compoundTag.a("display_auto_update", objective.e());
            NumberFormat numberFormat = objective.f();
            if (numberFormat != null) {
                NumberFormatTypes.b.encodeStart(registries.a(DynamicOpsNBT.a), (Object)numberFormat).ifSuccess(tag -> compoundTag.a("format", (NBTBase)tag));
            }
            listTag.add(compoundTag);
        }
        return listTag;
    }
}

