/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.scores;

import com.google.common.collect.Lists;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.numbers.NumberFormat;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.scores.DisplaySlot;
import net.minecraft.world.scores.PlayerScoreEntry;
import net.minecraft.world.scores.PlayerScores;
import net.minecraft.world.scores.ReadOnlyScoreInfo;
import net.minecraft.world.scores.ScoreAccess;
import net.minecraft.world.scores.ScoreHolder;
import net.minecraft.world.scores.ScoreboardObjective;
import net.minecraft.world.scores.ScoreboardScore;
import net.minecraft.world.scores.ScoreboardTeam;
import net.minecraft.world.scores.criteria.IScoreboardCriteria;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.slf4j.Logger;

public class Scoreboard {
    public static final String a = "#";
    private static final Logger b = LogUtils.getLogger();
    private final Object2ObjectMap<String, ScoreboardObjective> c = new Object2ObjectOpenHashMap(16, 0.5f);
    private final Reference2ObjectMap<IScoreboardCriteria, List<ScoreboardObjective>> d = new Reference2ObjectOpenHashMap();
    private final Map<String, PlayerScores> e = new Object2ObjectOpenHashMap(16, 0.5f);
    private final Map<DisplaySlot, ScoreboardObjective> f = new EnumMap<DisplaySlot, ScoreboardObjective>(DisplaySlot.class);
    private final Object2ObjectMap<String, ScoreboardTeam> g = new Object2ObjectOpenHashMap();
    private final Object2ObjectMap<String, ScoreboardTeam> h = new Object2ObjectOpenHashMap();

    @Nullable
    public ScoreboardObjective a(@Nullable String name) {
        return (ScoreboardObjective)this.c.get((Object)name);
    }

    public ScoreboardObjective a(String name, IScoreboardCriteria criterion, IChatBaseComponent displayName, IScoreboardCriteria.EnumScoreboardHealthDisplay renderType, boolean displayAutoUpdate, @Nullable NumberFormat numberFormat) {
        if (this.c.containsKey((Object)name)) {
            throw new IllegalArgumentException("An objective with the name '" + name + "' already exists!");
        }
        ScoreboardObjective objective = new ScoreboardObjective(this, name, criterion, displayName, renderType, displayAutoUpdate, numberFormat);
        ((List)this.d.computeIfAbsent((Object)criterion, criterion2 -> Lists.newArrayList())).add(objective);
        this.c.put((Object)name, (Object)objective);
        this.a(objective);
        return objective;
    }

    public final void a(IScoreboardCriteria criterion, ScoreHolder scoreHolder, Consumer<ScoreAccess> action) {
        ((List)this.d.getOrDefault((Object)criterion, Collections.emptyList())).forEach(objective -> action.accept(this.a(scoreHolder, (ScoreboardObjective)objective, true)));
    }

    private PlayerScores f(String scoreHolderName) {
        return this.e.computeIfAbsent(scoreHolderName, name -> new PlayerScores());
    }

    public ScoreAccess c(ScoreHolder scoreHolder, ScoreboardObjective objective) {
        return this.a(scoreHolder, objective, false);
    }

    public ScoreAccess a(final ScoreHolder scoreHolder, final ScoreboardObjective objective, boolean forceWritable) {
        final boolean bl = forceWritable || !objective.c().e();
        PlayerScores playerScores = this.f(scoreHolder.cI());
        final MutableBoolean mutableBoolean = new MutableBoolean();
        final ScoreboardScore score2 = playerScores.a(objective, (ScoreboardScore score) -> mutableBoolean.setTrue());
        return new ScoreAccess(){

            @Override
            @Override
            public int a() {
                return score2.a();
            }

            @Override
            @Override
            public void a(int score) {
                IChatBaseComponent component;
                if (!bl) {
                    throw new IllegalStateException("Cannot modify read-only score");
                }
                boolean bl2 = mutableBoolean.isTrue();
                if (objective.e() && (component = scoreHolder.p_()) != null && !component.equals(score2.d())) {
                    score2.a(component);
                    bl2 = true;
                }
                if (score != score2.a()) {
                    score2.a(score);
                    bl2 = true;
                }
                if (bl2) {
                    this.h();
                }
            }

            @Override
            @Nullable
            @Override
            public IChatBaseComponent g() {
                return score2.d();
            }

            @Override
            @Override
            public void a(@Nullable IChatBaseComponent text) {
                if (mutableBoolean.isTrue() || !Objects.equals(text, score2.d())) {
                    score2.a(text);
                    this.h();
                }
            }

            @Override
            @Override
            public void a(@Nullable NumberFormat numberFormat) {
                score2.b(numberFormat);
                this.h();
            }

            @Override
            @Override
            public boolean d() {
                return score2.b();
            }

            @Override
            @Override
            public void e() {
                this.a(false);
            }

            @Override
            @Override
            public void f() {
                this.a(true);
            }

            private void a(boolean locked) {
                score2.a(locked);
                if (mutableBoolean.isTrue()) {
                    this.h();
                }
                Scoreboard.this.a(scoreHolder, objective);
            }

            private void h() {
                Scoreboard.this.a(scoreHolder, objective, score2);
                mutableBoolean.setFalse();
            }
        };
    }

    @Nullable
    public ReadOnlyScoreInfo d(ScoreHolder scoreHolder, ScoreboardObjective objective) {
        PlayerScores playerScores = this.e.get(scoreHolder.cI());
        if (playerScores != null) {
            return playerScores.a(objective);
        }
        return null;
    }

    public Collection<PlayerScoreEntry> i(ScoreboardObjective objective) {
        ArrayList<PlayerScoreEntry> list = new ArrayList<PlayerScoreEntry>();
        this.e.forEach((scoreHolderName, scores) -> {
            ScoreboardScore score = scores.a(objective);
            if (score != null) {
                list.add(new PlayerScoreEntry((String)scoreHolderName, score.a(), score.d(), score.c()));
            }
        });
        return list;
    }

    public Collection<ScoreboardObjective> c() {
        return this.c.values();
    }

    public Collection<String> d() {
        return this.c.keySet();
    }

    public Collection<ScoreHolder> e() {
        return this.e.keySet().stream().map(ScoreHolder::c).toList();
    }

    public void b(ScoreHolder scoreHolder) {
        PlayerScores playerScores = this.e.remove(scoreHolder.cI());
        if (playerScores != null) {
            this.a(scoreHolder);
        }
    }

    public void e(ScoreHolder scoreHolder, ScoreboardObjective objective) {
        PlayerScores playerScores = this.e.get(scoreHolder.cI());
        if (playerScores != null) {
            boolean bl = playerScores.b(objective);
            if (!playerScores.a()) {
                PlayerScores playerScores2 = this.e.remove(scoreHolder.cI());
                if (playerScores2 != null) {
                    this.a(scoreHolder);
                }
            } else if (bl) {
                this.b(scoreHolder, objective);
            }
        }
    }

    public Object2IntMap<ScoreboardObjective> c(ScoreHolder scoreHolder) {
        PlayerScores playerScores = this.e.get(scoreHolder.cI());
        return playerScores != null ? playerScores.b() : Object2IntMaps.emptyMap();
    }

    public void j(ScoreboardObjective objective) {
        this.c.remove((Object)objective.b());
        for (DisplaySlot displaySlot : DisplaySlot.values()) {
            if (this.a(displaySlot) != objective) continue;
            this.a(displaySlot, null);
        }
        List list = (List)this.d.get((Object)objective.c());
        if (list != null) {
            list.remove(objective);
        }
        for (PlayerScores playerScores : this.e.values()) {
            playerScores.b(objective);
        }
        this.c(objective);
    }

    public void a(DisplaySlot slot, @Nullable ScoreboardObjective objective) {
        this.f.put(slot, objective);
    }

    @Nullable
    public ScoreboardObjective a(DisplaySlot slot) {
        return this.f.get(slot);
    }

    @Nullable
    public ScoreboardTeam b(String name) {
        return (ScoreboardTeam)this.g.get((Object)name);
    }

    public ScoreboardTeam c(String name) {
        ScoreboardTeam playerTeam = this.b(name);
        if (playerTeam != null) {
            b.warn("Requested creation of existing team '{}'", (Object)name);
            return playerTeam;
        }
        playerTeam = new ScoreboardTeam(this, name);
        this.g.put((Object)name, (Object)playerTeam);
        this.a(playerTeam);
        return playerTeam;
    }

    public void d(ScoreboardTeam team) {
        this.g.remove((Object)team.b());
        for (String string : team.g()) {
            this.h.remove((Object)string);
        }
        this.c(team);
    }

    public boolean a(String scoreHolderName, ScoreboardTeam team) {
        if (this.e(scoreHolderName) != null) {
            this.d(scoreHolderName);
        }
        this.h.put((Object)scoreHolderName, (Object)team);
        return team.g().add(scoreHolderName);
    }

    public boolean d(String scoreHolderName) {
        ScoreboardTeam playerTeam = this.e(scoreHolderName);
        if (playerTeam != null) {
            this.b(scoreHolderName, playerTeam);
            return true;
        }
        return false;
    }

    public void b(String scoreHolderName, ScoreboardTeam team) {
        if (this.e(scoreHolderName) != team) {
            throw new IllegalStateException("Player is either on another team or not on any team. Cannot remove from team '" + team.b() + "'.");
        }
        this.h.remove((Object)scoreHolderName);
        team.g().remove(scoreHolderName);
    }

    public Collection<String> f() {
        return this.g.keySet();
    }

    public Collection<ScoreboardTeam> g() {
        return this.g.values();
    }

    @Nullable
    public ScoreboardTeam e(String scoreHolderName) {
        return (ScoreboardTeam)this.h.get((Object)scoreHolderName);
    }

    public void a(ScoreboardObjective objective) {
    }

    public void b(ScoreboardObjective objective) {
    }

    public void c(ScoreboardObjective objective) {
    }

    protected void a(ScoreHolder scoreHolder, ScoreboardObjective objective, ScoreboardScore score) {
    }

    protected void a(ScoreHolder scoreHolder, ScoreboardObjective objective) {
    }

    public void a(ScoreHolder scoreHolder) {
    }

    public void b(ScoreHolder scoreHolder, ScoreboardObjective objective) {
    }

    public void a(ScoreboardTeam team) {
    }

    public void b(ScoreboardTeam team) {
    }

    public void c(ScoreboardTeam team) {
    }

    public void a(Entity entity) {
        if (entity instanceof EntityHuman || entity.bL()) {
            return;
        }
        this.b(entity);
        this.d(entity.cI());
    }

    protected NBTTagList a(HolderLookup.a registries) {
        NBTTagList listTag = new NBTTagList();
        this.e.forEach((name, scores) -> scores.c().forEach((objective, score) -> {
            NBTTagCompound compoundTag = score.a(registries);
            compoundTag.a("Name", (String)name);
            compoundTag.a("Objective", objective.b());
            listTag.add(compoundTag);
        }));
        return listTag;
    }

    protected void a(NBTTagList list, HolderLookup.a registries) {
        for (int i2 = 0; i2 < list.size(); ++i2) {
            NBTTagCompound compoundTag = list.a(i2);
            ScoreboardScore score = ScoreboardScore.a(compoundTag, registries);
            String string = compoundTag.l("Name");
            String string2 = compoundTag.l("Objective");
            ScoreboardObjective objective = this.a(string2);
            if (objective == null) {
                b.error("Unknown objective {} for name {}, ignoring", (Object)string2, (Object)string);
                continue;
            }
            this.f(string).a(objective, score);
        }
    }
}

