/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R2;

import java.util.Locale;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.level.material.FluidType;
import org.bukkit.Fluid;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.craftbukkit.v1_21_R2.CraftRegistry;
import org.bukkit.craftbukkit.v1_21_R2.util.Handleable;
import org.jetbrains.annotations.NotNull;

public class CraftFluid
implements Fluid,
Handleable<FluidType> {
    private static int count = 0;
    private final NamespacedKey key;
    private final FluidType fluidType;
    private final String name;
    private final int ordinal;

    public static Fluid minecraftToBukkit(FluidType minecraft) {
        return (Fluid)CraftRegistry.minecraftToBukkit(minecraft, Registries.D, Registry.FLUID);
    }

    public static FluidType bukkitToMinecraft(Fluid bukkit) {
        return (FluidType)CraftRegistry.bukkitToMinecraft(bukkit);
    }

    public CraftFluid(NamespacedKey key, FluidType fluidType) {
        this.key = key;
        this.fluidType = fluidType;
        this.name = "minecraft".equals(key.getNamespace()) ? key.getKey().toUpperCase(Locale.ROOT) : key.toString();
        this.ordinal = count++;
    }

    @Override
    public FluidType getHandle() {
        return this.fluidType;
    }

    @NotNull
    public NamespacedKey getKey() {
        return this.key;
    }

    public int compareTo(@NotNull Fluid fluid) {
        return this.ordinal - fluid.ordinal();
    }

    @NotNull
    public String name() {
        return this.name;
    }

    public int ordinal() {
        return this.ordinal;
    }

    public String toString() {
        return this.name();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CraftFluid)) {
            return false;
        }
        CraftFluid otherFluid = (CraftFluid)other;
        return this.getKey().equals((Object)otherFluid.getKey());
    }

    public int hashCode() {
        return this.getKey().hashCode();
    }
}

