/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R2;

import com.google.common.base.Preconditions;
import io.papermc.paper.block.fluid.FluidData;
import io.papermc.paper.block.fluid.PaperFluidData;
import io.papermc.paper.world.MoonPhase;
import io.papermc.paper.world.flag.PaperFeatureFlagProviderImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.features.TreeFeatures;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.projectile.EntityPotion;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.block.BlockChorusFlower;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureConfigured;
import net.minecraft.world.level.portal.TeleportTransition;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import org.bukkit.FeatureFlag;
import org.bukkit.HeightMap;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.RegionAccessor;
import org.bukkit.TreeType;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.v1_21_R2.CraftHeightMap;
import org.bukkit.craftbukkit.v1_21_R2.block.CraftBiome;
import org.bukkit.craftbukkit.v1_21_R2.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R2.block.CraftBlockType;
import org.bukkit.craftbukkit.v1_21_R2.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_21_R2.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R2.entity.CraftEntityTypes;
import org.bukkit.craftbukkit.v1_21_R2.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R2.util.BlockStateListPopulator;
import org.bukkit.craftbukkit.v1_21_R2.util.CraftLocation;
import org.bukkit.craftbukkit.v1_21_R2.util.CraftNamespacedKey;
import org.bukkit.craftbukkit.v1_21_R2.util.RandomSourceWrapper;
import org.bukkit.entity.AbstractArrow;
import org.bukkit.entity.AbstractHorse;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Fireball;
import org.bukkit.entity.Horse;
import org.bukkit.entity.LargeFireball;
import org.bukkit.entity.LingeringPotion;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Minecart;
import org.bukkit.entity.SizedFireball;
import org.bukkit.entity.SplashPotion;
import org.bukkit.entity.ThrownPotion;
import org.bukkit.entity.TippedArrow;
import org.bukkit.entity.minecart.RideableMinecart;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionType;
import org.bukkit.util.BoundingBox;
import org.jetbrains.annotations.NotNull;

public abstract class CraftRegionAccessor
implements RegionAccessor {
    public abstract GeneratorAccessSeed getHandle();

    public boolean isNormalWorld() {
        return this.getHandle() instanceof WorldServer;
    }

    public Biome getBiome(Location location) {
        return this.getBiome(location.getBlockX(), location.getBlockY(), location.getBlockZ());
    }

    public Biome getBiome(int x2, int y2, int z2) {
        return CraftBiome.minecraftHolderToBukkit(this.getHandle().getNoiseBiome(x2 >> 2, y2 >> 2, z2 >> 2));
    }

    public Biome getComputedBiome(int x2, int y2, int z2) {
        return CraftBiome.minecraftHolderToBukkit(this.getHandle().t(new BlockPosition(x2, y2, z2)));
    }

    public void setBiome(Location location, Biome biome) {
        this.setBiome(location.getBlockX(), location.getBlockY(), location.getBlockZ(), biome);
    }

    public void setBiome(int x2, int y2, int z2, Biome biome) {
        Preconditions.checkArgument((biome != Biome.CUSTOM ? 1 : 0) != 0, (String)"Cannot set the biome to %s", (Object)biome);
        Holder<BiomeBase> biomeBase = CraftBiome.bukkitToMinecraftHolder(biome);
        this.setBiome(x2, y2, z2, biomeBase);
    }

    public abstract void setBiome(int var1, int var2, int var3, Holder<BiomeBase> var4);

    public BlockState getBlockState(Location location) {
        return this.getBlockState(location.getBlockX(), location.getBlockY(), location.getBlockZ());
    }

    public BlockState getBlockState(int x2, int y2, int z2) {
        return CraftBlock.at(this.getHandle(), new BlockPosition(x2, y2, z2)).getState();
    }

    public FluidData getFluidData(int x2, int y2, int z2) {
        return PaperFluidData.createData(this.getHandle().b_(new BlockPosition(x2, y2, z2)));
    }

    public BlockData getBlockData(Location location) {
        return this.getBlockData(location.getBlockX(), location.getBlockY(), location.getBlockZ());
    }

    public BlockData getBlockData(int x2, int y2, int z2) {
        return CraftBlockData.fromData(this.getData(x2, y2, z2));
    }

    public Material getType(Location location) {
        return this.getType(location.getBlockX(), location.getBlockY(), location.getBlockZ());
    }

    public Material getType(int x2, int y2, int z2) {
        return CraftBlockType.minecraftToBukkit(this.getData(x2, y2, z2).b());
    }

    private IBlockData getData(int x2, int y2, int z2) {
        return this.getHandle().a_(new BlockPosition(x2, y2, z2));
    }

    public void setBlockData(Location location, BlockData blockData) {
        this.setBlockData(location.getBlockX(), location.getBlockY(), location.getBlockZ(), blockData);
    }

    public void setBlockData(int x2, int y2, int z2, BlockData blockData) {
        GeneratorAccessSeed world = this.getHandle();
        BlockPosition pos = new BlockPosition(x2, y2, z2);
        IBlockData old = this.getHandle().a_(pos);
        CraftBlock.setTypeAndData(world, pos, old, ((CraftBlockData)blockData).getState(), true);
    }

    public void setType(Location location, Material material) {
        this.setType(location.getBlockX(), location.getBlockY(), location.getBlockZ(), material);
    }

    public void setType(int x2, int y2, int z2, Material material) {
        this.setBlockData(x2, y2, z2, material.createBlockData());
    }

    public int getHighestBlockYAt(int x2, int z2) {
        return this.getHighestBlockYAt(x2, z2, HeightMap.MOTION_BLOCKING);
    }

    public int getHighestBlockYAt(Location location) {
        return this.getHighestBlockYAt(location.getBlockX(), location.getBlockZ());
    }

    public int getHighestBlockYAt(int x2, int z2, HeightMap heightMap) {
        return this.getHandle().a(CraftHeightMap.toNMS(heightMap), x2, z2);
    }

    public int getHighestBlockYAt(Location location, HeightMap heightMap) {
        return this.getHighestBlockYAt(location.getBlockX(), location.getBlockZ(), heightMap);
    }

    public boolean generateTree(Location location, Random random, TreeType treeType) {
        BlockPosition pos = CraftLocation.toBlockPosition(location);
        return this.generateTree(this.getHandle(), this.getHandle().getMinecraftWorld().m().g(), pos, new RandomSourceWrapper(random), treeType);
    }

    public boolean generateTree(Location location, Random random, TreeType treeType, Consumer<? super BlockState> consumer) {
        return this.generateTree(location, random, treeType, consumer == null ? null : block -> {
            consumer.accept((BlockState)block);
            return true;
        });
    }

    public boolean generateTree(Location location, Random random, TreeType treeType, Predicate<? super BlockState> predicate) {
        BlockPosition pos = CraftLocation.toBlockPosition(location);
        BlockStateListPopulator populator = new BlockStateListPopulator(this.getHandle());
        boolean result = this.generateTree(populator, this.getHandle().getMinecraftWorld().m().g(), pos, new RandomSourceWrapper(random), treeType);
        populator.refreshTiles();
        for (BlockState blockState : populator.getList()) {
            if (predicate != null && !predicate.test((BlockState)blockState)) continue;
            blockState.update(true, true);
        }
        return result;
    }

    public boolean generateTree(GeneratorAccessSeed access, ChunkGenerator chunkGenerator, BlockPosition pos, RandomSource random, TreeType treeType) {
        ResourceKey<WorldGenFeatureConfigured<?, ?>> gen;
        switch (treeType) {
            case BIG_TREE: {
                gen = TreeFeatures.p;
                break;
            }
            case BIRCH: {
                gen = TreeFeatures.k;
                break;
            }
            case REDWOOD: {
                gen = TreeFeatures.m;
                break;
            }
            case TALL_REDWOOD: {
                gen = TreeFeatures.n;
                break;
            }
            case JUNGLE: {
                gen = TreeFeatures.r;
                break;
            }
            case SMALL_JUNGLE: {
                gen = TreeFeatures.q;
                break;
            }
            case COCOA_TREE: {
                gen = TreeFeatures.o;
                break;
            }
            case JUNGLE_BUSH: {
                gen = TreeFeatures.x;
                break;
            }
            case RED_MUSHROOM: {
                gen = TreeFeatures.f;
                break;
            }
            case BROWN_MUSHROOM: {
                gen = TreeFeatures.e;
                break;
            }
            case SWAMP: {
                gen = TreeFeatures.w;
                break;
            }
            case ACACIA: {
                gen = TreeFeatures.l;
                break;
            }
            case DARK_OAK: {
                gen = TreeFeatures.h;
                break;
            }
            case MEGA_REDWOOD: {
                gen = TreeFeatures.s;
                break;
            }
            case MEGA_PINE: {
                gen = TreeFeatures.t;
                break;
            }
            case TALL_BIRCH: {
                gen = TreeFeatures.u;
                break;
            }
            case CHORUS_PLANT: {
                BlockChorusFlower cfr_ignored_0 = (BlockChorusFlower)Blocks.kQ;
                BlockChorusFlower.a(access, pos, random, 8);
                return true;
            }
            case CRIMSON_FUNGUS: {
                gen = this.isNormalWorld() ? TreeFeatures.b : TreeFeatures.a;
                break;
            }
            case WARPED_FUNGUS: {
                gen = this.isNormalWorld() ? TreeFeatures.d : TreeFeatures.c;
                break;
            }
            case AZALEA: {
                gen = TreeFeatures.y;
                break;
            }
            case MANGROVE: {
                gen = TreeFeatures.z;
                break;
            }
            case TALL_MANGROVE: {
                gen = TreeFeatures.A;
                break;
            }
            case CHERRY: {
                gen = TreeFeatures.B;
                break;
            }
            case PALE_OAK: {
                gen = TreeFeatures.i;
                break;
            }
            case PALE_OAK_CREAKING: {
                gen = TreeFeatures.j;
                break;
            }
            default: {
                gen = TreeFeatures.g;
            }
        }
        Holder holder = access.K_().e(Registries.aL).a(gen).orElse(null);
        return holder != null ? ((WorldGenFeatureConfigured)holder.a()).a(access, chunkGenerator, random, pos) : false;
    }

    public Entity spawnEntity(Location location, EntityType entityType) {
        return this.spawn(location, entityType.getEntityClass());
    }

    public Entity spawnEntity(Location loc, EntityType type, boolean randomizeData) {
        return this.spawn(loc, type.getEntityClass(), null, CreatureSpawnEvent.SpawnReason.CUSTOM, randomizeData);
    }

    public List<Entity> getEntities() {
        ArrayList<Entity> list = new ArrayList<Entity>();
        this.getNMSEntities().forEach(entity -> {
            CraftEntity bukkitEntity = entity.getBukkitEntity();
            if (bukkitEntity != null && (!this.isNormalWorld() || bukkitEntity.isValid())) {
                list.add(bukkitEntity);
            }
        });
        return list;
    }

    public List<LivingEntity> getLivingEntities() {
        ArrayList<LivingEntity> list = new ArrayList<LivingEntity>();
        this.getNMSEntities().forEach(entity -> {
            CraftEntity bukkitEntity = entity.getBukkitEntity();
            if (bukkitEntity != null && bukkitEntity instanceof LivingEntity && (!this.isNormalWorld() || bukkitEntity.isValid())) {
                list.add((LivingEntity)bukkitEntity);
            }
        });
        return list;
    }

    public <T extends Entity> Collection<T> getEntitiesByClass(Class<T> clazz) {
        ArrayList list = new ArrayList();
        this.getNMSEntities().forEach(entity -> {
            CraftEntity bukkitEntity = entity.getBukkitEntity();
            if (bukkitEntity == null) {
                return;
            }
            Class bukkitClass = bukkitEntity.getClass();
            if (clazz.isAssignableFrom(bukkitClass) && (!this.isNormalWorld() || bukkitEntity.isValid())) {
                list.add(bukkitEntity);
            }
        });
        return list;
    }

    public Collection<Entity> getEntitiesByClasses(Class<?> ... classes) {
        ArrayList<Entity> list = new ArrayList<Entity>();
        this.getNMSEntities().forEach(entity -> {
            CraftEntity bukkitEntity = entity.getBukkitEntity();
            if (bukkitEntity == null) {
                return;
            }
            Class bukkitClass = bukkitEntity.getClass();
            for (Class clazz : classes) {
                if (!clazz.isAssignableFrom(bukkitClass)) continue;
                if (this.isNormalWorld() && !bukkitEntity.isValid()) break;
                list.add(bukkitEntity);
                break;
            }
        });
        return list;
    }

    public abstract Iterable<net.minecraft.world.entity.Entity> getNMSEntities();

    public <T extends Entity> T createEntity(Location location, Class<T> clazz) throws IllegalArgumentException {
        net.minecraft.world.entity.Entity entity = this.createEntity(location, clazz, true);
        if (!this.isNormalWorld()) {
            entity.generation = true;
        }
        return (T)entity.getBukkitEntity();
    }

    public <T extends Entity> T spawn(Location location, Class<T> clazz) throws IllegalArgumentException {
        return this.spawn(location, clazz, null, CreatureSpawnEvent.SpawnReason.CUSTOM);
    }

    public <T extends Entity> T spawn(Location location, Class<T> clazz, Consumer<? super T> function) throws IllegalArgumentException {
        return this.spawn(location, clazz, function, CreatureSpawnEvent.SpawnReason.CUSTOM);
    }

    public <T extends Entity> T spawn(Location location, Class<T> clazz, boolean randomizeData, Consumer<? super T> function) throws IllegalArgumentException {
        return this.spawn(location, clazz, function, CreatureSpawnEvent.SpawnReason.CUSTOM, randomizeData);
    }

    public <T extends Entity> T spawn(Location location, Class<T> clazz, Consumer<? super T> function, CreatureSpawnEvent.SpawnReason reason) throws IllegalArgumentException {
        return this.spawn(location, clazz, function, reason, true);
    }

    public <T extends Entity> T spawn(Location location, Class<T> clazz, Consumer<? super T> function, CreatureSpawnEvent.SpawnReason reason, boolean randomizeData) throws IllegalArgumentException {
        net.minecraft.world.entity.Entity entity = this.createEntity(location, clazz, randomizeData);
        return this.addEntity(entity, reason, function, randomizeData);
    }

    public <T extends Entity> T addEntity(T entity) {
        Preconditions.checkArgument((!entity.isInWorld() ? 1 : 0) != 0, (Object)"Entity has already been added to a world");
        net.minecraft.world.entity.Entity nmsEntity = ((CraftEntity)entity).getHandle();
        if (nmsEntity.dW() != this.getHandle().a()) {
            nmsEntity = nmsEntity.b(new TeleportTransition(this.getHandle().a(), nmsEntity, TeleportTransition.a));
        }
        this.addEntityWithPassengers(nmsEntity, CreatureSpawnEvent.SpawnReason.CUSTOM);
        return (T)nmsEntity.getBukkitEntity();
    }

    public <T extends Entity> T addEntity(net.minecraft.world.entity.Entity entity, CreatureSpawnEvent.SpawnReason reason) throws IllegalArgumentException {
        return this.addEntity(entity, reason, null, true);
    }

    public <T extends Entity> T addEntity(net.minecraft.world.entity.Entity entity, CreatureSpawnEvent.SpawnReason reason, Consumer<? super T> function, boolean randomizeData) throws IllegalArgumentException {
        Preconditions.checkArgument((entity != null ? 1 : 0) != 0, (Object)"Cannot spawn null entity");
        if (randomizeData && entity instanceof EntityInsentient) {
            ((EntityInsentient)entity).a((WorldAccess)this.getHandle(), this.getHandle().d_(entity.dw()), EntitySpawnReason.n, (GroupDataEntity)null);
        }
        if (!this.isNormalWorld()) {
            entity.generation = true;
        }
        if (function != null) {
            function.accept(entity.getBukkitEntity());
        }
        this.addEntityToWorld(entity, reason);
        return (T)entity.getBukkitEntity();
    }

    public abstract void addEntityToWorld(net.minecraft.world.entity.Entity var1, CreatureSpawnEvent.SpawnReason var2);

    public abstract void addEntityWithPassengers(net.minecraft.world.entity.Entity var1, CreatureSpawnEvent.SpawnReason var2);

    public net.minecraft.world.entity.Entity makeEntity(Location location, Class<? extends Entity> clazz) throws IllegalArgumentException {
        return this.createEntity(location, clazz, true);
    }

    public net.minecraft.world.entity.Entity createEntity(Location location, Class<? extends Entity> clazz, boolean randomizeData) throws IllegalArgumentException {
        Preconditions.checkArgument((location != null ? 1 : 0) != 0, (Object)"Location cannot be null");
        Preconditions.checkArgument((clazz != null ? 1 : 0) != 0, (Object)"Entity class cannot be null");
        Consumer<net.minecraft.world.entity.Entity> runOld = other -> {};
        if (clazz == AbstractArrow.class) {
            clazz = Arrow.class;
        } else if (clazz == AbstractHorse.class) {
            clazz = Horse.class;
        } else if (clazz == Fireball.class) {
            clazz = LargeFireball.class;
        } else if (clazz == LingeringPotion.class) {
            clazz = ThrownPotion.class;
            runOld = other -> ((EntityPotion)other).a(CraftItemStack.asNMSCopy(new ItemStack(Material.LINGERING_POTION, 1)));
        } else if (clazz == Minecart.class) {
            clazz = RideableMinecart.class;
        } else if (clazz == SizedFireball.class) {
            clazz = LargeFireball.class;
        } else if (clazz == SplashPotion.class) {
            clazz = ThrownPotion.class;
        } else if (clazz == TippedArrow.class) {
            clazz = Arrow.class;
            runOld = other -> ((Arrow)other.getBukkitEntity()).setBasePotionType(PotionType.WATER);
        }
        CraftEntityTypes.EntityTypeData entityTypeData = CraftEntityTypes.getEntityTypeData(clazz);
        if (entityTypeData == null || entityTypeData.spawnFunction() == null) {
            if (CraftEntity.class.isAssignableFrom(clazz)) {
                throw new IllegalArgumentException(String.format("Cannot spawn an entity from its CraftBukkit implementation class '%s' use the Bukkit class instead. You can get the Bukkit representation via Entity#getType()#getEntityClass()", clazz.getName()));
            }
            throw new IllegalArgumentException("Cannot spawn an entity for " + clazz.getName());
        }
        if (!entityTypeData.entityType().isEnabledByFeature((World)this.getHandle().getMinecraftWorld().getWorld())) {
            throw new IllegalArgumentException("Cannot spawn an entity for " + clazz.getName() + " because it is not an enabled feature");
        }
        net.minecraft.world.entity.Entity entity = (net.minecraft.world.entity.Entity)entityTypeData.spawnFunction().apply(new CraftEntityTypes.SpawnData(this.getHandle(), location, randomizeData, this.isNormalWorld()));
        if (entity != null) {
            runOld.accept(entity);
            return entity;
        }
        throw new IllegalArgumentException("Cannot spawn an entity for " + clazz.getName());
    }

    public MoonPhase getMoonPhase() {
        return MoonPhase.getPhase((long)(this.getHandle().ak() / 24000L));
    }

    public NamespacedKey getKey() {
        return CraftNamespacedKey.fromMinecraft(this.getHandle().a().ah().a());
    }

    public boolean lineOfSightExists(Location from, Location to) {
        Preconditions.checkArgument((from != null ? 1 : 0) != 0, (Object)"from parameter in lineOfSightExists cannot be null");
        Preconditions.checkArgument((to != null ? 1 : 0) != 0, (Object)"to parameter in lineOfSightExists cannot be null");
        if (from.getWorld() != to.getWorld()) {
            return false;
        }
        Vec3D start = new Vec3D(from.getX(), from.getY(), from.getZ());
        Vec3D end = new Vec3D(to.getX(), to.getY(), to.getZ());
        if (end.g(start) > 16384.0) {
            return false;
        }
        return this.getHandle().a(new RayTrace(start, end, RayTrace.BlockCollisionOption.a, RayTrace.FluidCollisionOption.a, VoxelShapeCollision.a())).d() == MovingObjectPosition.EnumMovingObjectType.a;
    }

    public boolean hasCollisionsIn(@NotNull BoundingBox boundingBox) {
        AxisAlignedBB aabb = new AxisAlignedBB(boundingBox.getMinX(), boundingBox.getMinY(), boundingBox.getMinZ(), boundingBox.getMaxX(), boundingBox.getMaxY(), boundingBox.getMaxZ());
        return !this.getHandle().b(aabb);
    }

    public Set<FeatureFlag> getFeatureFlags() {
        return PaperFeatureFlagProviderImpl.fromNms(this.getHandle().J());
    }
}

