/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R2;

import com.google.common.base.Preconditions;
import java.util.Locale;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.Registries;
import net.minecraft.sounds.SoundEffect;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.Sound;
import org.bukkit.craftbukkit.v1_21_R2.CraftRegistry;
import org.bukkit.craftbukkit.v1_21_R2.util.Handleable;
import org.jetbrains.annotations.NotNull;

public class CraftSound
implements Sound,
Handleable<SoundEffect> {
    private static int count = 0;
    private final NamespacedKey key;
    private final SoundEffect soundEffect;
    private final String name;
    private final int ordinal;

    public static Sound minecraftToBukkit(SoundEffect minecraft) {
        return (Sound)CraftRegistry.minecraftToBukkit(minecraft, Registries.al, Registry.SOUNDS);
    }

    public static SoundEffect bukkitToMinecraft(Sound bukkit) {
        return (SoundEffect)CraftRegistry.bukkitToMinecraft(bukkit);
    }

    public static Holder<SoundEffect> bukkitToMinecraftHolder(Sound bukkit) {
        Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
        IRegistry registry = CraftRegistry.getMinecraftRegistry(Registries.al);
        Holder<SoundEffect> holder = registry.e(CraftSound.bukkitToMinecraft(bukkit));
        if (holder instanceof Holder.c) {
            Holder.c holder2 = (Holder.c)holder;
            return holder2;
        }
        throw new IllegalArgumentException("No Reference holder found for " + String.valueOf(bukkit) + ", this can happen if a plugin creates its own sound effect with out properly registering it.");
    }

    public CraftSound(NamespacedKey key, SoundEffect soundEffect) {
        this.key = key;
        this.soundEffect = soundEffect;
        this.name = "minecraft".equals(key.getNamespace()) ? key.getKey().toUpperCase(Locale.ROOT).replace('.', '_') : key.toString();
        this.ordinal = count++;
    }

    @Override
    public SoundEffect getHandle() {
        return this.soundEffect;
    }

    @NotNull
    public NamespacedKey getKey() {
        return this.key;
    }

    public int compareTo(@NotNull Sound sound) {
        return this.ordinal - sound.ordinal();
    }

    @NotNull
    public String name() {
        return this.name;
    }

    public int ordinal() {
        return this.ordinal;
    }

    public String toString() {
        return this.name();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CraftSound)) {
            return false;
        }
        CraftSound otherSound = (CraftSound)other;
        return this.getKey().equals((Object)otherSound.getKey());
    }

    public int hashCode() {
        return this.getKey().hashCode();
    }

    public static String getSound(Sound sound) {
        return sound.getKey().getKey();
    }
}

