/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R2.block;

import java.util.Locale;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.level.biome.BiomeBase;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.block.Biome;
import org.bukkit.craftbukkit.v1_21_R2.CraftRegistry;
import org.bukkit.craftbukkit.v1_21_R2.util.Handleable;
import org.jetbrains.annotations.NotNull;

public class CraftBiome
implements Biome,
Handleable<BiomeBase> {
    private static int count = 0;
    private final NamespacedKey key;
    private final BiomeBase biomeBase;
    private final String name;
    private final int ordinal;

    public static Biome minecraftToBukkit(BiomeBase minecraft) {
        return (Biome)CraftRegistry.minecraftToBukkit(minecraft, Registries.aI, Registry.BIOME);
    }

    public static Biome minecraftHolderToBukkit(Holder<BiomeBase> minecraft) {
        return CraftBiome.minecraftToBukkit(minecraft.a());
    }

    public static BiomeBase bukkitToMinecraft(Biome bukkit) {
        if (bukkit == Biome.CUSTOM) {
            return null;
        }
        return (BiomeBase)CraftRegistry.bukkitToMinecraft(bukkit);
    }

    public static Holder<BiomeBase> bukkitToMinecraftHolder(Biome bukkit) {
        if (bukkit == Biome.CUSTOM) {
            return null;
        }
        IRegistry registry = CraftRegistry.getMinecraftRegistry(Registries.aI);
        Holder<BiomeBase> holder = registry.e(CraftBiome.bukkitToMinecraft(bukkit));
        if (holder instanceof Holder.c) {
            Holder.c holder2 = (Holder.c)holder;
            return holder2;
        }
        throw new IllegalArgumentException("No Reference holder found for " + String.valueOf(bukkit) + ", this can happen if a plugin creates its own biome base with out properly registering it.");
    }

    public CraftBiome(NamespacedKey key, BiomeBase biomeBase) {
        this.key = key;
        this.biomeBase = biomeBase;
        this.name = "minecraft".equals(key.getNamespace()) ? key.getKey().toUpperCase(Locale.ROOT) : key.toString();
        this.ordinal = count++;
    }

    @Override
    public BiomeBase getHandle() {
        return this.biomeBase;
    }

    @NotNull
    public NamespacedKey getKey() {
        return this.key;
    }

    public int compareTo(@NotNull Biome biome) {
        return this.ordinal - biome.ordinal();
    }

    @NotNull
    public String name() {
        return this.name;
    }

    public int ordinal() {
        return this.ordinal;
    }

    public String toString() {
        return this.name();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CraftBiome)) {
            return false;
        }
        CraftBiome otherBiome = (CraftBiome)other;
        return this.getKey().equals((Object)otherBiome.getKey());
    }

    public int hashCode() {
        return this.getKey().hashCode();
    }
}

