/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R2.block;

import net.minecraft.world.IInventory;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.block.BlockJukeBox;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityJukeBox;
import net.minecraft.world.level.block.state.IBlockData;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Jukebox;
import org.bukkit.craftbukkit.v1_21_R2.block.CraftBlockEntityState;
import org.bukkit.craftbukkit.v1_21_R2.inventory.CraftInventoryJukebox;
import org.bukkit.craftbukkit.v1_21_R2.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R2.inventory.CraftItemType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.JukeboxInventory;

public class CraftJukebox
extends CraftBlockEntityState<TileEntityJukeBox>
implements Jukebox {
    public CraftJukebox(World world, TileEntityJukeBox tileEntity) {
        super(world, tileEntity);
    }

    protected CraftJukebox(CraftJukebox state, Location location) {
        super(state, location);
    }

    public JukeboxInventory getSnapshotInventory() {
        return new CraftInventoryJukebox((IInventory)this.getSnapshot());
    }

    public JukeboxInventory getInventory() {
        if (!this.isPlaced()) {
            return this.getSnapshotInventory();
        }
        return new CraftInventoryJukebox((IInventory)this.getTileEntity());
    }

    @Override
    public boolean update(boolean force, boolean applyPhysics) {
        boolean result = super.update(force, applyPhysics);
        if (result && this.isPlaced() && this.getType() == Material.JUKEBOX) {
            this.getWorldHandle().a(this.getPosition(), this.data, 3);
            TileEntity tileEntity = this.getTileEntityFromWorld();
            if (tileEntity instanceof TileEntityJukeBox) {
                TileEntityJukeBox jukebox = (TileEntityJukeBox)tileEntity;
                jukebox.b(jukebox.f());
            }
        }
        return result;
    }

    public Material getPlaying() {
        return this.getRecord().getType();
    }

    public void setPlaying(Material record) {
        if (record == null || CraftItemType.bukkitToMinecraft(record) == null) {
            record = Material.AIR;
        }
        this.setRecord(new ItemStack(record));
    }

    public boolean hasRecord() {
        return this.getHandle().c(BlockJukeBox.b) != false && !this.getPlaying().isAir();
    }

    public ItemStack getRecord() {
        net.minecraft.world.item.ItemStack record = ((TileEntityJukeBox)this.getSnapshot()).f();
        return CraftItemStack.asBukkitCopy(record);
    }

    public void setRecord(ItemStack record) {
        net.minecraft.world.item.ItemStack nms = CraftItemStack.asNMSCopy(record);
        TileEntityJukeBox snapshot = (TileEntityJukeBox)this.getSnapshot();
        snapshot.setSongItemWithoutPlaying(nms, snapshot.j().c());
        this.data = (IBlockData)this.data.b(BlockJukeBox.b, !nms.f());
    }

    public boolean isPlaying() {
        TileEntityJukeBox jukebox;
        this.requirePlaced();
        TileEntity tileEntity = this.getTileEntityFromWorld();
        return tileEntity instanceof TileEntityJukeBox && (jukebox = (TileEntityJukeBox)tileEntity).j().a();
    }

    public boolean startPlaying() {
        this.requirePlaced();
        TileEntity tileEntity = this.getTileEntityFromWorld();
        if (!(tileEntity instanceof TileEntityJukeBox)) {
            return false;
        }
        TileEntityJukeBox jukebox = (TileEntityJukeBox)tileEntity;
        net.minecraft.world.item.ItemStack record = jukebox.f();
        if (record.f() || this.isPlaying()) {
            return false;
        }
        jukebox.w();
        return true;
    }

    public void stopPlaying() {
        this.requirePlaced();
        TileEntity tileEntity = this.getTileEntityFromWorld();
        if (!(tileEntity instanceof TileEntityJukeBox)) {
            return;
        }
        TileEntityJukeBox jukebox = (TileEntityJukeBox)tileEntity;
        jukebox.j().a((GeneratorAccess)tileEntity.i(), tileEntity.m());
    }

    public boolean eject() {
        this.ensureNoWorldGeneration();
        TileEntity tileEntity = this.getTileEntityFromWorld();
        if (!(tileEntity instanceof TileEntityJukeBox)) {
            return false;
        }
        TileEntityJukeBox jukebox = (TileEntityJukeBox)tileEntity;
        boolean result = !jukebox.f().f();
        jukebox.t();
        return result;
    }

    @Override
    public CraftJukebox copy() {
        return new CraftJukebox(this, null);
    }

    @Override
    public CraftJukebox copy(Location location) {
        return new CraftJukebox(this, location);
    }
}

