/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R2.command;

import com.destroystokyo.paper.event.server.AsyncTabCompleteEvent;
import com.google.common.collect.ImmutableList;
import io.papermc.paper.console.BrigadierCommandCompleter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.stream.Collectors;
import net.minecraft.server.dedicated.DedicatedServer;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.v1_21_R2.CraftServer;
import org.bukkit.craftbukkit.v1_21_R2.util.Waitable;
import org.bukkit.event.Event;
import org.bukkit.event.server.TabCompleteEvent;
import org.jline.reader.Candidate;
import org.jline.reader.Completer;
import org.jline.reader.LineReader;
import org.jline.reader.ParsedLine;

public class ConsoleCommandCompleter
implements Completer {
    private final DedicatedServer server;
    private final BrigadierCommandCompleter brigadierCompleter;

    public ConsoleCommandCompleter(DedicatedServer server) {
        this.server = server;
        this.brigadierCompleter = new BrigadierCommandCompleter(this.server);
    }

    public void complete(LineReader reader, ParsedLine line, List<Candidate> candidates) {
        Object completions;
        final CraftServer server = this.server.server;
        final String buffer = "/" + line.line();
        AsyncTabCompleteEvent event = new AsyncTabCompleteEvent((CommandSender)server.getConsoleSender(), buffer, true, null);
        event.callEvent();
        Object object = completions = event.isCancelled() ? ImmutableList.of() : event.completions();
        if (event.isCancelled() || event.isHandled()) {
            if (!event.isCancelled() && TabCompleteEvent.getHandlerList().getRegisteredListeners().length > 0) {
                final ArrayList finalCompletions = new ArrayList(completions);
                Waitable<List<String>> syncCompletions = new Waitable<List<String>>(this){

                    @Override
                    protected List<String> evaluate() {
                        TabCompleteEvent syncEvent = new TabCompleteEvent((CommandSender)server.getConsoleSender(), buffer, finalCompletions.stream().map(AsyncTabCompleteEvent.Completion::suggestion).collect(Collectors.toList()));
                        return syncEvent.callEvent() ? syncEvent.getCompletions() : ImmutableList.of();
                    }
                };
                server.getServer().processQueue.add(syncCompletions);
                try {
                    List legacyCompletions = (List)syncCompletions.get();
                    completions.removeIf(it -> !legacyCompletions.contains(it.suggestion()));
                    for (String completion : legacyCompletions) {
                        if (this.notNewSuggestion((List<AsyncTabCompleteEvent.Completion>)completions, completion)) continue;
                        completions.add(AsyncTabCompleteEvent.Completion.completion((String)completion));
                    }
                }
                catch (InterruptedException | ExecutionException e1) {
                    e1.printStackTrace();
                }
            }
            this.addCompletions(reader, line, candidates, (List<AsyncTabCompleteEvent.Completion>)completions);
            return;
        }
        Waitable<List<String>> waitable = new Waitable<List<String>>(this){

            @Override
            protected List<String> evaluate() {
                List offers = server.getCommandMap().tabComplete((CommandSender)server.getConsoleSender(), buffer);
                TabCompleteEvent tabEvent = new TabCompleteEvent((CommandSender)server.getConsoleSender(), buffer, offers == null ? Collections.EMPTY_LIST : offers);
                server.getPluginManager().callEvent((Event)tabEvent);
                return tabEvent.isCancelled() ? Collections.EMPTY_LIST : tabEvent.getCompletions();
            }
        };
        server.getServer().processQueue.add(waitable);
        try {
            List offers = (List)waitable.get();
            if (offers == null) {
                this.addCompletions(reader, line, candidates, Collections.emptyList());
                return;
            }
            this.addCompletions(reader, line, candidates, offers.stream().map(AsyncTabCompleteEvent.Completion::completion).collect(Collectors.toList()));
        }
        catch (ExecutionException e2) {
            server.getLogger().log(Level.WARNING, "Unhandled exception when tab completing", e2);
        }
        catch (InterruptedException e3) {
            Thread.currentThread().interrupt();
        }
    }

    private boolean notNewSuggestion(List<AsyncTabCompleteEvent.Completion> completions, String completion) {
        for (AsyncTabCompleteEvent.Completion it : completions) {
            if (!it.suggestion().equals(completion)) continue;
            return true;
        }
        return false;
    }

    private void addCompletions(LineReader reader, ParsedLine line, List<Candidate> candidates, List<AsyncTabCompleteEvent.Completion> existing) {
        this.brigadierCompleter.complete(reader, line, candidates, existing);
    }
}

