/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R2.entity;

import com.google.common.base.Preconditions;
import net.minecraft.core.BlockPosition;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.item.Items;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_21_R2.CraftServer;
import org.bukkit.craftbukkit.v1_21_R2.CraftSound;
import org.bukkit.craftbukkit.v1_21_R2.entity.AbstractProjectile;
import org.bukkit.craftbukkit.v1_21_R2.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R2.inventory.CraftItemStack;
import org.bukkit.entity.AbstractArrow;
import org.bukkit.inventory.ItemStack;
import org.bukkit.projectiles.ProjectileSource;

public class CraftAbstractArrow
extends AbstractProjectile
implements AbstractArrow {
    public CraftAbstractArrow(CraftServer server, EntityArrow entity) {
        super(server, entity);
    }

    public void setKnockbackStrength(int knockbackStrength) {
    }

    public int getKnockbackStrength() {
        return 0;
    }

    public double getDamage() {
        return this.getHandle().x();
    }

    public void setDamage(double damage) {
        Preconditions.checkArgument((damage >= 0.0 ? 1 : 0) != 0, (String)"Damage value (%s) must be positive", (Object)damage);
        this.getHandle().h(damage);
    }

    public int getPierceLevel() {
        return this.getHandle().z();
    }

    public void setPierceLevel(int pierceLevel) {
        Preconditions.checkArgument((0 <= pierceLevel && pierceLevel <= 127 ? 1 : 0) != 0, (String)"Pierce level (%s) out of range, expected 0 < level < 127", (int)pierceLevel);
        this.getHandle().a((byte)pierceLevel);
    }

    public boolean isCritical() {
        return this.getHandle().y();
    }

    public void setCritical(boolean critical) {
        this.getHandle().b(critical);
    }

    public boolean isInBlock() {
        return this.getHandle().l();
    }

    public Block getAttachedBlock() {
        if (!this.isInBlock()) {
            return null;
        }
        BlockPosition pos = this.getHandle().dw();
        return this.getWorld().getBlockAt(pos.u(), pos.v(), pos.w());
    }

    public AbstractArrow.PickupStatus getPickupStatus() {
        return AbstractArrow.PickupStatus.values()[this.getHandle().c.ordinal()];
    }

    public void setPickupStatus(AbstractArrow.PickupStatus status) {
        Preconditions.checkArgument((status != null ? 1 : 0) != 0, (Object)"PickupStatus cannot be null");
        this.getHandle().c = EntityArrow.PickupStatus.a(status.ordinal());
    }

    @Override
    public void setTicksLived(int value) {
        super.setTicksLived(value);
        this.getHandle().l = value;
    }

    public boolean isShotFromCrossbow() {
        net.minecraft.world.item.ItemStack firedFromWeapon = this.getHandle().ea();
        return firedFromWeapon != null && firedFromWeapon.a(Items.wL);
    }

    public void setShotFromCrossbow(boolean shotFromCrossbow) {
    }

    public ItemStack getItem() {
        return CraftItemStack.asBukkitCopy(this.getHandle().q);
    }

    public void setItem(ItemStack item) {
        Preconditions.checkArgument((item != null ? 1 : 0) != 0, (Object)"ItemStack cannot be null");
        this.getHandle().q = CraftItemStack.asNMSCopy(item);
    }

    public ItemStack getWeapon() {
        if (this.getHandle().ea() == null) {
            return null;
        }
        return CraftItemStack.asBukkitCopy(this.getHandle().ea());
    }

    public void setWeapon(ItemStack item) {
        Preconditions.checkArgument((item != null ? 1 : 0) != 0, (Object)"ItemStack cannot be null");
        this.getHandle().r = CraftItemStack.asNMSCopy(item);
    }

    @Override
    public EntityArrow getHandle() {
        return (EntityArrow)this.entity;
    }

    @Override
    public String toString() {
        return "CraftArrow";
    }

    public CraftItemStack getItemStack() {
        return CraftItemStack.asCraftMirror(this.getHandle().u());
    }

    public void setItemStack(ItemStack stack) {
        Preconditions.checkArgument((stack != null ? 1 : 0) != 0, (Object)"ItemStack cannot be null");
        this.getHandle().a(CraftItemStack.asNMSCopy(stack));
    }

    public void setLifetimeTicks(int ticks) {
        this.getHandle().l = ticks;
    }

    public int getLifetimeTicks() {
        return this.getHandle().l;
    }

    public Sound getHitSound() {
        return CraftSound.minecraftToBukkit(this.getHandle().n);
    }

    public void setHitSound(Sound sound) {
        this.getHandle().b(CraftSound.bukkitToMinecraft(sound));
    }

    public void setShooter(ProjectileSource shooter, boolean resetPickupStatus) {
        if (shooter instanceof CraftEntity) {
            CraftEntity craftEntity = (CraftEntity)shooter;
            this.getHandle().setOwner(craftEntity.getHandle(), resetPickupStatus);
        } else {
            this.getHandle().setOwner(null, resetPickupStatus);
        }
        this.getHandle().projectileSource = shooter;
    }
}

