/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R2.entity;

import com.google.common.base.Preconditions;
import io.papermc.paper.math.Rotations;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.Vector3f;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.decoration.EntityArmorStand;
import org.bukkit.craftbukkit.v1_21_R2.CraftEquipmentSlot;
import org.bukkit.craftbukkit.v1_21_R2.CraftServer;
import org.bukkit.craftbukkit.v1_21_R2.entity.CraftLivingEntity;
import org.bukkit.entity.ArmorStand;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.EulerAngle;

public class CraftArmorStand
extends CraftLivingEntity
implements ArmorStand {
    public CraftArmorStand(CraftServer server, EntityArmorStand entity) {
        super(server, entity);
    }

    @Override
    public String toString() {
        return "CraftArmorStand";
    }

    @Override
    public EntityArmorStand getHandle() {
        return (EntityArmorStand)super.getHandle();
    }

    public ItemStack getItemInHand() {
        return this.getEquipment().getItemInHand();
    }

    public void setItemInHand(ItemStack item) {
        this.getEquipment().setItemInHand(item);
    }

    public ItemStack getBoots() {
        return this.getEquipment().getBoots();
    }

    public void setBoots(ItemStack item) {
        this.getEquipment().setBoots(item);
    }

    public ItemStack getLeggings() {
        return this.getEquipment().getLeggings();
    }

    public void setLeggings(ItemStack item) {
        this.getEquipment().setLeggings(item);
    }

    public ItemStack getChestplate() {
        return this.getEquipment().getChestplate();
    }

    public void setChestplate(ItemStack item) {
        this.getEquipment().setChestplate(item);
    }

    public ItemStack getHelmet() {
        return this.getEquipment().getHelmet();
    }

    public void setHelmet(ItemStack item) {
        this.getEquipment().setHelmet(item);
    }

    public EulerAngle getBodyPose() {
        return CraftArmorStand.fromNMS(this.getHandle().ce);
    }

    public void setBodyPose(EulerAngle pose) {
        this.getHandle().b(CraftArmorStand.toNMS(pose));
    }

    public EulerAngle getLeftArmPose() {
        return CraftArmorStand.fromNMS(this.getHandle().cf);
    }

    public void setLeftArmPose(EulerAngle pose) {
        this.getHandle().c(CraftArmorStand.toNMS(pose));
    }

    public EulerAngle getRightArmPose() {
        return CraftArmorStand.fromNMS(this.getHandle().cg);
    }

    public void setRightArmPose(EulerAngle pose) {
        this.getHandle().d(CraftArmorStand.toNMS(pose));
    }

    public EulerAngle getLeftLegPose() {
        return CraftArmorStand.fromNMS(this.getHandle().ch);
    }

    public void setLeftLegPose(EulerAngle pose) {
        this.getHandle().e(CraftArmorStand.toNMS(pose));
    }

    public EulerAngle getRightLegPose() {
        return CraftArmorStand.fromNMS(this.getHandle().ci);
    }

    public void setRightLegPose(EulerAngle pose) {
        this.getHandle().f(CraftArmorStand.toNMS(pose));
    }

    public EulerAngle getHeadPose() {
        return CraftArmorStand.fromNMS(this.getHandle().cd);
    }

    public void setHeadPose(EulerAngle pose) {
        this.getHandle().a(CraftArmorStand.toNMS(pose));
    }

    public boolean hasBasePlate() {
        return this.getHandle().u();
    }

    public void setBasePlate(boolean basePlate) {
        this.getHandle().b(!basePlate);
    }

    @Override
    public void setGravity(boolean gravity) {
        super.setGravity(gravity);
        this.getHandle().ad = !gravity;
    }

    @Override
    public void setInvisible(boolean invisible) {
        this.getHandle().k(invisible);
        super.setInvisible(invisible);
    }

    public boolean isVisible() {
        return !this.getHandle().cp();
    }

    public void setVisible(boolean visible) {
        this.getHandle().k(!visible);
    }

    public boolean hasArms() {
        return this.getHandle().t();
    }

    public void setArms(boolean arms) {
        this.getHandle().a(arms);
    }

    public boolean isSmall() {
        return this.getHandle().p();
    }

    public void setSmall(boolean small) {
        this.getHandle().u(small);
    }

    private static EulerAngle fromNMS(Vector3f old) {
        return new EulerAngle(Math.toRadians(old.b()), Math.toRadians(old.c()), Math.toRadians(old.d()));
    }

    private static Vector3f toNMS(EulerAngle old) {
        return new Vector3f((float)Math.toDegrees(old.getX()), (float)Math.toDegrees(old.getY()), (float)Math.toDegrees(old.getZ()));
    }

    public boolean isMarker() {
        return this.getHandle().x();
    }

    public void setMarker(boolean marker) {
        this.getHandle().v(marker);
    }

    public void addEquipmentLock(EquipmentSlot equipmentSlot, ArmorStand.LockType lockType) {
        this.getHandle().cc |= 1 << CraftEquipmentSlot.getNMS(equipmentSlot).b(lockType.ordinal() * 8);
    }

    public void removeEquipmentLock(EquipmentSlot equipmentSlot, ArmorStand.LockType lockType) {
        this.getHandle().cc &= ~(1 << CraftEquipmentSlot.getNMS(equipmentSlot).b(lockType.ordinal() * 8));
    }

    public boolean hasEquipmentLock(EquipmentSlot equipmentSlot, ArmorStand.LockType lockType) {
        return (this.getHandle().cc & 1 << CraftEquipmentSlot.getNMS(equipmentSlot).b(lockType.ordinal() * 8)) != 0;
    }

    public boolean canMove() {
        return this.getHandle().canMove;
    }

    public void setCanMove(boolean move) {
        this.getHandle().canMove = move;
    }

    public ItemStack getItem(EquipmentSlot slot) {
        Preconditions.checkArgument((slot != null ? 1 : 0) != 0, (Object)"slot");
        Preconditions.checkArgument((slot != EquipmentSlot.BODY ? 1 : 0) != 0, (Object)"Cannot get body item");
        return this.getHandle().a(CraftEquipmentSlot.getNMS(slot)).asBukkitMirror();
    }

    public void setItem(EquipmentSlot slot, ItemStack item) {
        Preconditions.checkArgument((slot != null ? 1 : 0) != 0, (Object)"slot");
        Preconditions.checkArgument((slot != EquipmentSlot.BODY ? 1 : 0) != 0, (Object)"Cannot set body item");
        switch (slot) {
            case HAND: {
                this.getEquipment().setItemInMainHand(item);
                return;
            }
            case OFF_HAND: {
                this.getEquipment().setItemInOffHand(item);
                return;
            }
            case FEET: {
                this.setBoots(item);
                return;
            }
            case LEGS: {
                this.setLeggings(item);
                return;
            }
            case CHEST: {
                this.setChestplate(item);
                return;
            }
            case HEAD: {
                this.setHelmet(item);
                return;
            }
        }
        throw new UnsupportedOperationException(slot.name());
    }

    public Set<EquipmentSlot> getDisabledSlots() {
        HashSet<EquipmentSlot> disabled = new HashSet<EquipmentSlot>();
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            if (!this.isSlotDisabled(slot)) continue;
            disabled.add(slot);
        }
        return disabled;
    }

    public void setDisabledSlots(EquipmentSlot ... slots) {
        int disabled = 0;
        for (EquipmentSlot slot : slots) {
            if (slot == EquipmentSlot.OFF_HAND) continue;
            EnumItemSlot nmsSlot = CraftEquipmentSlot.getNMS(slot);
            disabled += (1 << nmsSlot.b(0)) + (1 << nmsSlot.b(8)) + (1 << nmsSlot.b(16));
        }
        this.getHandle().cc = disabled;
    }

    public void addDisabledSlots(EquipmentSlot ... slots) {
        Set<EquipmentSlot> disabled = this.getDisabledSlots();
        Collections.addAll(disabled, slots);
        this.setDisabledSlots(disabled.toArray(new EquipmentSlot[0]));
    }

    public void removeDisabledSlots(EquipmentSlot ... slots) {
        Set<EquipmentSlot> disabled = this.getDisabledSlots();
        for (EquipmentSlot slot : slots) {
            disabled.remove(slot);
        }
        this.setDisabledSlots(disabled.toArray(new EquipmentSlot[0]));
    }

    public boolean isSlotDisabled(EquipmentSlot slot) {
        return this.getHandle().g(CraftEquipmentSlot.getNMS(slot));
    }

    public Rotations getBodyRotations() {
        return CraftArmorStand.fromNMSRotations(this.getHandle().ce);
    }

    public void setBodyRotations(Rotations rotations) {
        this.getHandle().b(CraftArmorStand.toNMSRotations(rotations));
    }

    public Rotations getLeftArmRotations() {
        return CraftArmorStand.fromNMSRotations(this.getHandle().cf);
    }

    public void setLeftArmRotations(Rotations rotations) {
        this.getHandle().c(CraftArmorStand.toNMSRotations(rotations));
    }

    public Rotations getRightArmRotations() {
        return CraftArmorStand.fromNMSRotations(this.getHandle().cg);
    }

    public void setRightArmRotations(Rotations rotations) {
        this.getHandle().d(CraftArmorStand.toNMSRotations(rotations));
    }

    public Rotations getLeftLegRotations() {
        return CraftArmorStand.fromNMSRotations(this.getHandle().ch);
    }

    public void setLeftLegRotations(Rotations rotations) {
        this.getHandle().e(CraftArmorStand.toNMSRotations(rotations));
    }

    public Rotations getRightLegRotations() {
        return CraftArmorStand.fromNMSRotations(this.getHandle().ci);
    }

    public void setRightLegRotations(Rotations rotations) {
        this.getHandle().f(CraftArmorStand.toNMSRotations(rotations));
    }

    public Rotations getHeadRotations() {
        return CraftArmorStand.fromNMSRotations(this.getHandle().cd);
    }

    public void setHeadRotations(Rotations rotations) {
        this.getHandle().a(CraftArmorStand.toNMSRotations(rotations));
    }

    private static Rotations fromNMSRotations(Vector3f old) {
        return Rotations.ofDegrees((double)old.b(), (double)old.c(), (double)old.d());
    }

    private static Vector3f toNMSRotations(Rotations old) {
        return new Vector3f((float)old.x(), (float)old.y(), (float)old.z());
    }

    public boolean canTick() {
        return this.getHandle().canTick;
    }

    public void setCanTick(boolean tick) {
        this.getHandle().canTick = tick;
        this.getHandle().canTickSetByAPI = true;
    }
}

