/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R2.entity;

import com.google.common.base.Preconditions;
import java.util.Locale;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.entity.animal.CatVariant;
import net.minecraft.world.entity.animal.EntityCat;
import net.minecraft.world.item.EnumColor;
import org.bukkit.DyeColor;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.craftbukkit.v1_21_R2.CraftRegistry;
import org.bukkit.craftbukkit.v1_21_R2.CraftServer;
import org.bukkit.craftbukkit.v1_21_R2.entity.CraftTameableAnimal;
import org.bukkit.craftbukkit.v1_21_R2.util.Handleable;
import org.bukkit.entity.Cat;

public class CraftCat
extends CraftTameableAnimal
implements Cat {
    public CraftCat(CraftServer server, EntityCat entity) {
        super(server, entity);
    }

    @Override
    public EntityCat getHandle() {
        return (EntityCat)super.getHandle();
    }

    @Override
    public String toString() {
        return "CraftCat";
    }

    public Cat.Type getCatType() {
        return CraftType.minecraftHolderToBukkit(this.getHandle().gA());
    }

    public void setCatType(Cat.Type type) {
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"Cannot have null Type");
        this.getHandle().j(CraftType.bukkitToMinecraftHolder(type));
    }

    public DyeColor getCollarColor() {
        return DyeColor.getByWoolData((byte)((byte)this.getHandle().gC().a()));
    }

    public void setCollarColor(DyeColor color) {
        this.getHandle().a(EnumColor.a(color.getWoolData()));
    }

    public void setLyingDown(boolean lyingDown) {
        this.getHandle().A(lyingDown);
    }

    public boolean isLyingDown() {
        return this.getHandle().gB();
    }

    public void setHeadUp(boolean headUp) {
        this.getHandle().B(headUp);
    }

    public boolean isHeadUp() {
        return this.getHandle().gH();
    }

    public static class CraftType
    implements Cat.Type,
    Handleable<CatVariant> {
        private static int count = 0;
        private final NamespacedKey key;
        private final CatVariant catVariant;
        private final String name;
        private final int ordinal;

        public static Cat.Type minecraftToBukkit(CatVariant minecraft) {
            return (Cat.Type)CraftRegistry.minecraftToBukkit(minecraft, Registries.l, Registry.CAT_VARIANT);
        }

        public static Cat.Type minecraftHolderToBukkit(Holder<CatVariant> minecraft) {
            return CraftType.minecraftToBukkit(minecraft.a());
        }

        public static CatVariant bukkitToMinecraft(Cat.Type bukkit) {
            return (CatVariant)CraftRegistry.bukkitToMinecraft(bukkit);
        }

        public static Holder<CatVariant> bukkitToMinecraftHolder(Cat.Type bukkit) {
            return CraftRegistry.bukkitToMinecraftHolder(bukkit, Registries.l);
        }

        public CraftType(NamespacedKey key, CatVariant catVariant) {
            this.key = key;
            this.catVariant = catVariant;
            this.name = "minecraft".equals(key.getNamespace()) ? key.getKey().toUpperCase(Locale.ROOT) : key.toString();
            this.ordinal = count++;
        }

        @Override
        public CatVariant getHandle() {
            return this.catVariant;
        }

        public NamespacedKey getKey() {
            return this.key;
        }

        public int compareTo(Cat.Type variant) {
            return this.ordinal - variant.ordinal();
        }

        public String name() {
            return this.name;
        }

        public int ordinal() {
            return this.ordinal;
        }

        public String toString() {
            return this.name();
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CraftType)) {
                return false;
            }
            return this.getKey().equals((Object)((CraftType)other).getKey());
        }

        public int hashCode() {
            return this.getKey().hashCode();
        }
    }
}

