/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R2.entity;

import com.google.common.collect.ImmutableSet;
import io.papermc.paper.math.Position;
import io.papermc.paper.util.MCUtil;
import java.util.Set;
import net.minecraft.core.BlockPosition;
import net.minecraft.world.entity.boss.EntityComplexPart;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderDragon;
import net.minecraft.world.entity.boss.enderdragon.phases.DragonControllerPhase;
import org.apache.commons.lang.Validate;
import org.bukkit.Location;
import org.bukkit.boss.BossBar;
import org.bukkit.boss.DragonBattle;
import org.bukkit.craftbukkit.v1_21_R2.CraftServer;
import org.bukkit.craftbukkit.v1_21_R2.boss.CraftDragonBattle;
import org.bukkit.craftbukkit.v1_21_R2.entity.CraftEnemy;
import org.bukkit.craftbukkit.v1_21_R2.entity.CraftMob;
import org.bukkit.entity.ComplexEntityPart;
import org.bukkit.entity.EnderDragon;

public class CraftEnderDragon
extends CraftMob
implements EnderDragon,
CraftEnemy {
    public CraftEnderDragon(CraftServer server, EntityEnderDragon entity) {
        super(server, entity);
    }

    public Set<ComplexEntityPart> getParts() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (EntityComplexPart part : this.getHandle().ck) {
            builder.add((Object)((ComplexEntityPart)part.getBukkitEntity()));
        }
        return builder.build();
    }

    @Override
    public EntityEnderDragon getHandle() {
        return (EntityEnderDragon)this.entity;
    }

    @Override
    public String toString() {
        return "CraftEnderDragon";
    }

    public EnderDragon.Phase getPhase() {
        return EnderDragon.Phase.values()[this.getHandle().au().a(EntityEnderDragon.a)];
    }

    public void setPhase(EnderDragon.Phase phase) {
        this.getHandle().gk().a(CraftEnderDragon.getMinecraftPhase(phase));
    }

    public static EnderDragon.Phase getBukkitPhase(DragonControllerPhase phase) {
        return EnderDragon.Phase.values()[phase.b()];
    }

    public static DragonControllerPhase getMinecraftPhase(EnderDragon.Phase phase) {
        return DragonControllerPhase.a(phase.ordinal());
    }

    public BossBar getBossBar() {
        DragonBattle battle = this.getDragonBattle();
        return battle != null ? battle.getBossBar() : null;
    }

    public DragonBattle getDragonBattle() {
        return this.getHandle().gl() != null ? new CraftDragonBattle(this.getHandle().gl()) : null;
    }

    public int getDeathAnimationTicks() {
        return this.getHandle().ca;
    }

    public Location getPodium() {
        BlockPosition blockPosOrigin = this.getHandle().getPodium();
        return new Location(this.getWorld(), (double)blockPosOrigin.u(), (double)blockPosOrigin.v(), (double)blockPosOrigin.w());
    }

    public void setPodium(Location location) {
        if (location == null) {
            this.getHandle().setPodium(null);
        } else {
            Validate.isTrue((location.getWorld() == null || location.getWorld().equals((Object)this.getWorld()) ? 1 : 0) != 0, (String)"You cannot set a podium in a different world to where the dragon is");
            this.getHandle().setPodium(MCUtil.toBlockPos((Position)location));
        }
    }
}

