/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R2.entity;

import com.google.common.base.Preconditions;
import net.minecraft.world.entity.animal.EntityPanda;
import org.bukkit.craftbukkit.v1_21_R2.CraftServer;
import org.bukkit.craftbukkit.v1_21_R2.entity.CraftAnimals;
import org.bukkit.entity.Panda;

public class CraftPanda
extends CraftAnimals
implements Panda {
    public CraftPanda(CraftServer server, EntityPanda entity) {
        super(server, entity);
    }

    @Override
    public EntityPanda getHandle() {
        return (EntityPanda)super.getHandle();
    }

    @Override
    public String toString() {
        return "CraftPanda";
    }

    public Panda.Gene getMainGene() {
        return CraftPanda.fromNms(this.getHandle().gr());
    }

    public void setMainGene(Panda.Gene gene) {
        this.getHandle().a(CraftPanda.toNms(gene));
    }

    public Panda.Gene getHiddenGene() {
        return CraftPanda.fromNms(this.getHandle().gs());
    }

    public void setHiddenGene(Panda.Gene gene) {
        this.getHandle().b(CraftPanda.toNms(gene));
    }

    public void setSneezeTicks(int ticks) {
        this.getHandle().t(ticks);
    }

    public int getSneezeTicks() {
        return this.getHandle().gq();
    }

    public void setEatingTicks(int ticks) {
        this.getHandle().u(ticks);
    }

    public int getEatingTicks() {
        return this.getHandle().gL();
    }

    public void setUnhappyTicks(int ticks) {
        this.getHandle().s(ticks);
    }

    public Panda.Gene getCombinedGene() {
        return CraftPanda.fromNms(this.getHandle().gC());
    }

    public boolean isRolling() {
        return this.getHandle().gA();
    }

    public void setRolling(boolean flag) {
        this.getHandle().B(flag);
    }

    public boolean isSneezing() {
        return this.getHandle().t();
    }

    public void setSneezing(boolean flag) {
        this.getHandle().A(flag);
    }

    public boolean isSitting() {
        return this.getHandle().x();
    }

    public void setSitting(boolean flag) {
        this.getHandle().x(flag);
    }

    public boolean isOnBack() {
        return this.getHandle().go();
    }

    public void setOnBack(boolean flag) {
        this.getHandle().y(flag);
    }

    public boolean isEating() {
        return this.getHandle().gp();
    }

    public void setEating(boolean flag) {
        this.getHandle().z(flag);
    }

    public boolean isScared() {
        return this.getHandle().gI();
    }

    public int getUnhappyTicks() {
        return this.getHandle().p();
    }

    public static Panda.Gene fromNms(EntityPanda.Gene gene) {
        Preconditions.checkArgument((gene != null ? 1 : 0) != 0, (Object)"Gene may not be null");
        return Panda.Gene.values()[gene.ordinal()];
    }

    public static EntityPanda.Gene toNms(Panda.Gene gene) {
        Preconditions.checkArgument((gene != null ? 1 : 0) != 0, (Object)"Gene may not be null");
        return EntityPanda.Gene.values()[gene.ordinal()];
    }
}

