/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R2.entity;

import com.google.common.base.Preconditions;
import net.minecraft.world.entity.animal.EntityPig;
import org.bukkit.Material;
import org.bukkit.craftbukkit.v1_21_R2.CraftServer;
import org.bukkit.craftbukkit.v1_21_R2.entity.CraftAnimals;
import org.bukkit.entity.Pig;

public class CraftPig
extends CraftAnimals
implements Pig {
    public CraftPig(CraftServer server, EntityPig entity) {
        super(server, entity);
    }

    public boolean hasSaddle() {
        return this.getHandle().j();
    }

    public void setSaddle(boolean saddled) {
        this.getHandle().cb.a(saddled);
    }

    public int getBoostTicks() {
        return this.getHandle().cb.f ? this.getHandle().cb.e() : 0;
    }

    public void setBoostTicks(int ticks) {
        Preconditions.checkArgument((ticks >= 0 ? 1 : 0) != 0, (Object)"ticks must be >= 0");
        this.getHandle().cb.setBoostTicks(ticks);
    }

    public int getCurrentBoostTicks() {
        return this.getHandle().cb.f ? this.getHandle().cb.g : 0;
    }

    public void setCurrentBoostTicks(int ticks) {
        if (!this.getHandle().cb.f) {
            return;
        }
        int max = this.getHandle().cb.e();
        Preconditions.checkArgument((ticks >= 0 && ticks <= max ? 1 : 0) != 0, (String)"boost ticks must not exceed 0 or %d (inclusive)", (int)max);
        this.getHandle().cb.g = ticks;
    }

    public Material getSteerMaterial() {
        return Material.CARROT_ON_A_STICK;
    }

    @Override
    public EntityPig getHandle() {
        return (EntityPig)this.entity;
    }

    @Override
    public String toString() {
        return "CraftPig";
    }
}

