/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R2.entity;

import com.google.common.base.Preconditions;
import java.util.UUID;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.monster.EntityZombieVillager;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.craftbukkit.v1_21_R2.CraftServer;
import org.bukkit.craftbukkit.v1_21_R2.entity.CraftVillager;
import org.bukkit.craftbukkit.v1_21_R2.entity.CraftZombie;
import org.bukkit.entity.Villager;
import org.bukkit.entity.ZombieVillager;
import org.bukkit.event.entity.EntityPotionEffectEvent;

public class CraftVillagerZombie
extends CraftZombie
implements ZombieVillager {
    public CraftVillagerZombie(CraftServer server, EntityZombieVillager entity) {
        super(server, entity);
    }

    @Override
    public EntityZombieVillager getHandle() {
        return (EntityZombieVillager)super.getHandle();
    }

    @Override
    public String toString() {
        return "CraftVillagerZombie";
    }

    @Override
    public Villager.Profession getVillagerProfession() {
        return CraftVillager.CraftProfession.minecraftToBukkit(this.getHandle().gy().b());
    }

    @Override
    public void setVillagerProfession(Villager.Profession profession) {
        Preconditions.checkArgument((profession != null ? 1 : 0) != 0, (Object)"Villager.Profession cannot be null");
        this.getHandle().a(this.getHandle().gy().a(CraftVillager.CraftProfession.bukkitToMinecraft(profession)));
    }

    public Villager.Type getVillagerType() {
        return CraftVillager.CraftType.minecraftToBukkit(this.getHandle().gy().a());
    }

    public void setVillagerType(Villager.Type type) {
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"Villager.Type cannot be null");
        this.getHandle().a(this.getHandle().gy().a(CraftVillager.CraftType.bukkitToMinecraft(type)));
    }

    @Override
    public boolean isConverting() {
        return this.getHandle().gx();
    }

    @Override
    public int getConversionTime() {
        Preconditions.checkState((boolean)this.isConverting(), (Object)"Entity not converting");
        return this.getHandle().cg;
    }

    @Override
    public void setConversionTime(int time) {
        this.setConversionTime(time, true);
    }

    public void setConversionTime(int time, boolean broadcastEntityEvent) {
        if (time < 0) {
            this.getHandle().cg = -1;
            this.getHandle().au().a(EntityZombieVillager.b, false);
            this.getHandle().ch = null;
            this.getHandle().removeEffect(MobEffects.e, EntityPotionEffectEvent.Cause.CONVERSION);
        } else {
            this.getHandle().startConverting(null, time, broadcastEntityEvent);
        }
    }

    public OfflinePlayer getConversionPlayer() {
        return this.getHandle().ch == null ? null : Bukkit.getOfflinePlayer((UUID)this.getHandle().ch);
    }

    public void setConversionPlayer(OfflinePlayer conversionPlayer) {
        if (!this.isConverting()) {
            return;
        }
        this.getHandle().ch = conversionPlayer == null ? null : conversionPlayer.getUniqueId();
    }
}

