/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R2.entity;

import com.google.common.base.Preconditions;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.entity.animal.EntityWolf;
import net.minecraft.world.entity.animal.WolfVariant;
import net.minecraft.world.item.EnumColor;
import org.bukkit.DyeColor;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.craftbukkit.v1_21_R2.CraftRegistry;
import org.bukkit.craftbukkit.v1_21_R2.CraftServer;
import org.bukkit.craftbukkit.v1_21_R2.entity.CraftTameableAnimal;
import org.bukkit.craftbukkit.v1_21_R2.util.Handleable;
import org.bukkit.entity.Wolf;

public class CraftWolf
extends CraftTameableAnimal
implements Wolf {
    public CraftWolf(CraftServer server, EntityWolf wolf) {
        super(server, wolf);
    }

    public boolean isAngry() {
        return this.getHandle().ad_();
    }

    public void setAngry(boolean angry) {
        if (angry) {
            this.getHandle().c();
        } else {
            this.getHandle().af_();
        }
    }

    @Override
    public EntityWolf getHandle() {
        return (EntityWolf)this.entity;
    }

    public DyeColor getCollarColor() {
        return DyeColor.getByWoolData((byte)((byte)this.getHandle().gE().a()));
    }

    public void setCollarColor(DyeColor color) {
        this.getHandle().a(EnumColor.a(color.getWoolData()));
    }

    public boolean isWet() {
        return this.getHandle().co;
    }

    public float getTailAngle() {
        return this.getHandle().gD();
    }

    public boolean isInterested() {
        return this.getHandle().gF();
    }

    public void setInterested(boolean flag) {
        this.getHandle().A(flag);
    }

    public Wolf.Variant getVariant() {
        return CraftVariant.minecraftHolderToBukkit(this.getHandle().gB());
    }

    public void setVariant(Wolf.Variant variant) {
        Preconditions.checkArgument((variant != null ? 1 : 0) != 0, (Object)"variant");
        this.getHandle().j(CraftVariant.bukkitToMinecraftHolder(variant));
    }

    public static class CraftVariant
    implements Wolf.Variant,
    Handleable<WolfVariant> {
        private final NamespacedKey key;
        private final WolfVariant variant;

        public static Wolf.Variant minecraftToBukkit(WolfVariant minecraft) {
            return (Wolf.Variant)CraftRegistry.minecraftToBukkit(minecraft, Registries.m, Registry.WOLF_VARIANT);
        }

        public static Wolf.Variant minecraftHolderToBukkit(Holder<WolfVariant> minecraft) {
            return CraftVariant.minecraftToBukkit(minecraft.a());
        }

        public static WolfVariant bukkitToMinecraft(Wolf.Variant bukkit) {
            return (WolfVariant)CraftRegistry.bukkitToMinecraft(bukkit);
        }

        public static Holder<WolfVariant> bukkitToMinecraftHolder(Wolf.Variant bukkit) {
            Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
            IRegistry registry = CraftRegistry.getMinecraftRegistry(Registries.m);
            Holder<WolfVariant> holder = registry.e(CraftVariant.bukkitToMinecraft(bukkit));
            if (holder instanceof Holder.c) {
                Holder.c holder2 = (Holder.c)holder;
                return holder2;
            }
            throw new IllegalArgumentException("No Reference holder found for " + String.valueOf(bukkit) + ", this can happen if a plugin creates its own wolf variant with out properly registering it.");
        }

        public CraftVariant(NamespacedKey key, WolfVariant variant) {
            this.key = key;
            this.variant = variant;
        }

        @Override
        public WolfVariant getHandle() {
            return this.variant;
        }

        public NamespacedKey getKey() {
            return this.key;
        }

        public String toString() {
            return this.key.toString();
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CraftVariant)) {
                return false;
            }
            CraftVariant otherVariant = (CraftVariant)other;
            return this.getKey().equals((Object)otherVariant.getKey());
        }

        public int hashCode() {
            return this.getKey().hashCode();
        }
    }
}

