/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R2.generator;

import io.papermc.paper.world.flag.PaperFeatureFlagProviderImpl;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.DimensionManager;
import net.minecraft.world.level.levelgen.ChunkGeneratorAbstract;
import net.minecraft.world.level.levelgen.GeneratorSettingBase;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.storage.Convertable;
import net.minecraft.world.level.storage.WorldDataServer;
import org.bukkit.FeatureFlag;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.craftbukkit.v1_21_R2.block.CraftBiome;
import org.bukkit.craftbukkit.v1_21_R2.util.WorldUUID;
import org.bukkit.generator.BiomeProvider;
import org.bukkit.generator.WorldInfo;

public class CraftWorldInfo
implements WorldInfo {
    private final String name;
    private final UUID uuid;
    private final World.Environment environment;
    private final long seed;
    private final int minHeight;
    private final int maxHeight;
    private final FeatureFlagSet enabledFeatures;
    private final ChunkGenerator vanillaChunkGenerator;
    private final IRegistryCustom.Dimension registryAccess;

    public CraftWorldInfo(WorldDataServer worldDataServer, Convertable.ConversionSession session, World.Environment environment, DimensionManager dimensionManager, ChunkGenerator chunkGenerator, IRegistryCustom.Dimension registryAccess) {
        this.registryAccess = registryAccess;
        this.vanillaChunkGenerator = chunkGenerator;
        this.name = worldDataServer.e();
        this.uuid = WorldUUID.getUUID(session.c.f().toFile());
        this.environment = environment;
        this.seed = worldDataServer.y().c();
        this.minHeight = dimensionManager.n();
        this.maxHeight = dimensionManager.n() + dimensionManager.o();
        this.enabledFeatures = worldDataServer.K();
    }

    public String getName() {
        return this.name;
    }

    public UUID getUID() {
        return this.uuid;
    }

    public World.Environment getEnvironment() {
        return this.environment;
    }

    public long getSeed() {
        return this.seed;
    }

    public int getMinHeight() {
        return this.minHeight;
    }

    public int getMaxHeight() {
        return this.maxHeight;
    }

    public BiomeProvider vanillaBiomeProvider() {
        RandomState randomState;
        ChunkGenerator chunkGenerator = this.vanillaChunkGenerator;
        if (chunkGenerator instanceof ChunkGeneratorAbstract) {
            ChunkGeneratorAbstract noiseBasedChunkGenerator = (ChunkGeneratorAbstract)chunkGenerator;
            randomState = RandomState.a(noiseBasedChunkGenerator.h().a(), this.registryAccess.e(Registries.aS), this.getSeed());
        } else {
            randomState = RandomState.a(GeneratorSettingBase.e(), this.registryAccess.e(Registries.aS), this.getSeed());
        }
        final List<Biome> possibleBiomes = this.vanillaChunkGenerator.d().c().stream().map(biome -> CraftBiome.minecraftHolderToBukkit(biome)).toList();
        return new BiomeProvider(){

            public Biome getBiome(WorldInfo worldInfo, int x2, int y2, int z2) {
                return CraftBiome.minecraftHolderToBukkit(CraftWorldInfo.this.vanillaChunkGenerator.d().getNoiseBiome(x2 >> 2, y2 >> 2, z2 >> 2, randomState.b()));
            }

            public List<Biome> getBiomes(WorldInfo worldInfo) {
                return possibleBiomes;
            }
        };
    }

    public Set<FeatureFlag> getFeatureFlags() {
        return PaperFeatureFlagProviderImpl.fromNms(this.enabledFeatures);
    }
}

