/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R2.inventory;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.trading.IMerchant;
import net.minecraft.world.item.trading.MerchantRecipe;
import net.minecraft.world.item.trading.MerchantRecipeList;
import org.bukkit.craftbukkit.v1_21_R2.inventory.CraftMerchantRecipe;
import org.bukkit.entity.HumanEntity;
import org.bukkit.inventory.Merchant;

public interface CraftMerchant
extends Merchant {
    public IMerchant getMerchant();

    default public List<org.bukkit.inventory.MerchantRecipe> getRecipes() {
        return List.copyOf(Lists.transform((List)this.getMerchant().gq(), (Function)new Function<MerchantRecipe, org.bukkit.inventory.MerchantRecipe>(this){

            public org.bukkit.inventory.MerchantRecipe apply(MerchantRecipe recipe) {
                return recipe.asBukkit();
            }
        }));
    }

    default public void setRecipes(List<org.bukkit.inventory.MerchantRecipe> recipes) {
        MerchantRecipeList recipesList = this.getMerchant().gq();
        recipesList.clear();
        for (org.bukkit.inventory.MerchantRecipe recipe : recipes) {
            recipesList.add(CraftMerchantRecipe.fromBukkit(recipe).toMinecraft());
        }
    }

    default public org.bukkit.inventory.MerchantRecipe getRecipe(int i2) {
        return ((MerchantRecipe)this.getMerchant().gq().get(i2)).asBukkit();
    }

    default public void setRecipe(int i2, org.bukkit.inventory.MerchantRecipe merchantRecipe) {
        this.getMerchant().gq().set(i2, CraftMerchantRecipe.fromBukkit(merchantRecipe).toMinecraft());
    }

    default public int getRecipeCount() {
        return this.getMerchant().gq().size();
    }

    default public boolean isTrading() {
        return this.getTrader() != null;
    }

    default public HumanEntity getTrader() {
        EntityHuman eh = this.getMerchant().go();
        return eh == null ? null : eh.getBukkitEntity();
    }
}

