/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R2.inventory;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.item.component.CustomData;
import org.bukkit.configuration.serialization.DelegateDeserialization;
import org.bukkit.craftbukkit.v1_21_R2.inventory.CraftMetaItem;
import org.bukkit.craftbukkit.v1_21_R2.inventory.SerializableMeta;
import org.bukkit.entity.Axolotl;
import org.bukkit.inventory.meta.AxolotlBucketMeta;

@DelegateDeserialization(value=SerializableMeta.class)
public class CraftMetaAxolotlBucket
extends CraftMetaItem
implements AxolotlBucketMeta {
    static final CraftMetaItem.ItemMetaKey VARIANT = new CraftMetaItem.ItemMetaKey("Variant", "axolotl-variant");
    static final CraftMetaItem.ItemMetaKeyType<CustomData> ENTITY_TAG = new CraftMetaItem.ItemMetaKeyType<CustomData>(DataComponents.W, "entity-tag");
    static final CraftMetaItem.ItemMetaKeyType<CustomData> BUCKET_ENTITY_TAG = new CraftMetaItem.ItemMetaKeyType<CustomData>(DataComponents.X, "bucket-entity-tag");
    private Integer variant;
    private NBTTagCompound entityTag;
    private NBTTagCompound bucketEntityTag;

    CraftMetaAxolotlBucket(CraftMetaItem meta) {
        super(meta);
        if (!(meta instanceof CraftMetaAxolotlBucket)) {
            return;
        }
        CraftMetaAxolotlBucket bucket = (CraftMetaAxolotlBucket)meta;
        this.variant = bucket.variant;
        this.entityTag = bucket.entityTag;
        this.bucketEntityTag = bucket.bucketEntityTag;
    }

    CraftMetaAxolotlBucket(DataComponentPatch tag, Set<DataComponentType<?>> extraHandledDcts) {
        super(tag, extraHandledDcts);
        CraftMetaAxolotlBucket.getOrEmpty(tag, ENTITY_TAG).ifPresent(nbt -> {
            this.entityTag = nbt.c();
            if (this.entityTag.b(CraftMetaAxolotlBucket.VARIANT.NBT, 3)) {
                this.variant = this.entityTag.h(CraftMetaAxolotlBucket.VARIANT.NBT);
            }
        });
        CraftMetaAxolotlBucket.getOrEmpty(tag, BUCKET_ENTITY_TAG).ifPresent(nbt -> {
            this.bucketEntityTag = nbt.c();
            if (this.bucketEntityTag.b(CraftMetaAxolotlBucket.VARIANT.NBT, 3)) {
                this.variant = this.bucketEntityTag.h(CraftMetaAxolotlBucket.VARIANT.NBT);
            }
        });
    }

    CraftMetaAxolotlBucket(Map<String, Object> map) {
        super(map);
        Integer variant = SerializableMeta.getObject(Integer.class, map, CraftMetaAxolotlBucket.VARIANT.BUKKIT, true);
        if (variant != null) {
            this.variant = variant;
        }
    }

    @Override
    void deserializeInternal(NBTTagCompound tag, Object context) {
        super.deserializeInternal(tag, context);
        if (tag.e(CraftMetaAxolotlBucket.ENTITY_TAG.NBT)) {
            this.entityTag = tag.p(CraftMetaAxolotlBucket.ENTITY_TAG.NBT);
        }
        if (tag.e(CraftMetaAxolotlBucket.BUCKET_ENTITY_TAG.NBT)) {
            this.bucketEntityTag = tag.p(CraftMetaAxolotlBucket.BUCKET_ENTITY_TAG.NBT);
        }
    }

    @Override
    void serializeInternal(Map<String, NBTBase> internalTags) {
        if (this.entityTag != null && !this.entityTag.g()) {
            internalTags.put(CraftMetaAxolotlBucket.ENTITY_TAG.NBT, this.entityTag);
        }
        if (this.bucketEntityTag != null && !this.bucketEntityTag.g()) {
            internalTags.put(CraftMetaAxolotlBucket.BUCKET_ENTITY_TAG.NBT, this.bucketEntityTag);
        }
    }

    @Override
    void applyToItem(CraftMetaItem.Applicator tag) {
        NBTTagCompound bucketEntityTag;
        super.applyToItem(tag);
        if (this.entityTag != null) {
            tag.put(ENTITY_TAG, CustomData.a(this.entityTag));
        }
        NBTTagCompound nBTTagCompound = bucketEntityTag = this.bucketEntityTag != null ? this.bucketEntityTag.i() : null;
        if (this.hasVariant()) {
            if (bucketEntityTag == null) {
                bucketEntityTag = new NBTTagCompound();
            }
            bucketEntityTag.a(CraftMetaAxolotlBucket.VARIANT.NBT, this.variant);
        }
        if (bucketEntityTag != null) {
            tag.put(BUCKET_ENTITY_TAG, CustomData.a(bucketEntityTag));
        }
    }

    @Override
    boolean isEmpty() {
        return super.isEmpty() && this.isBucketEmpty();
    }

    boolean isBucketEmpty() {
        return !this.hasVariant() && this.entityTag == null && this.bucketEntityTag == null;
    }

    public Axolotl.Variant getVariant() {
        Preconditions.checkState((boolean)this.hasVariant(), (Object)"Variant is absent, check hasVariant first!");
        return Axolotl.Variant.values()[this.variant];
    }

    public void setVariant(Axolotl.Variant variant) {
        Preconditions.checkArgument((variant != null ? 1 : 0) != 0, (Object)"Variant cannot be null!");
        this.variant = variant.ordinal();
    }

    public boolean hasVariant() {
        return this.variant != null;
    }

    @Override
    boolean equalsCommon(CraftMetaItem meta) {
        if (!super.equalsCommon(meta)) {
            return false;
        }
        if (meta instanceof CraftMetaAxolotlBucket) {
            CraftMetaAxolotlBucket that = (CraftMetaAxolotlBucket)meta;
            return (this.hasVariant() ? that.hasVariant() && this.variant.equals(that.variant) : !that.hasVariant()) && (this.entityTag != null ? that.entityTag != null && this.entityTag.equals(that.entityTag) : that.entityTag == null) && (this.bucketEntityTag != null ? that.bucketEntityTag != null && this.bucketEntityTag.equals(that.bucketEntityTag) : that.bucketEntityTag == null);
        }
        return true;
    }

    @Override
    boolean notUncommon(CraftMetaItem meta) {
        return super.notUncommon(meta) && (meta instanceof CraftMetaAxolotlBucket || this.isBucketEmpty());
    }

    @Override
    int applyHash() {
        int original;
        int hash = original = super.applyHash();
        if (this.hasVariant()) {
            hash = 61 * hash + this.variant;
        }
        if (this.entityTag != null) {
            hash = 61 * hash + this.entityTag.hashCode();
        }
        if (this.bucketEntityTag != null) {
            hash = 61 * hash + this.bucketEntityTag.hashCode();
        }
        return original != hash ? CraftMetaAxolotlBucket.class.hashCode() ^ hash : hash;
    }

    @Override
    public CraftMetaAxolotlBucket clone() {
        CraftMetaAxolotlBucket clone = (CraftMetaAxolotlBucket)super.clone();
        if (this.entityTag != null) {
            clone.entityTag = this.entityTag.i();
        }
        if (this.bucketEntityTag != null) {
            clone.bucketEntityTag = this.bucketEntityTag.i();
        }
        return clone;
    }

    @Override
    ImmutableMap.Builder<String, Object> serialize(ImmutableMap.Builder<String, Object> builder) {
        super.serialize(builder);
        if (this.hasVariant()) {
            builder.put((Object)CraftMetaAxolotlBucket.VARIANT.BUKKIT, (Object)this.variant);
        }
        return builder;
    }
}

